<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xmi="http://www.omg.org/spec/XMI/20131001" queryBinding="xslt2">

    <sch:title>XÖV-Prüfanweisungen: Namens- und Entwurfsregeln</sch:title>
    <xsl:include href="xgenerator-library.xgen-core.xsl"/>
    <xsl:include href="xgenerator-library.uml-access-layer.xsl"/>
    <xsl:include href="xoev-profil.profile-access-layer.xsl"/>
    <xsl:include href="xoev-profil.helpers.xsl"/>

    <sch:ns uri="http://www.xoev.de/de/xgenerator/framework/1/library" prefix="xgen"/>
    <sch:ns uri="http://www.omg.org/spec/XMI/20131001" prefix="xmi"/>
    <sch:ns uri="http://www.eclipse.org/uml2/5.0.0/UML" prefix="uml"/>
    <sch:ns uri="http://www.xoev.de/de/xoev-profil/3_0_0" prefix="xoev"/>

    <sch:pattern>
        <sch:rule context="/">
            <sch:assert id="id1" role="error" test=".//@xmi:id">Das Dokument entspricht keiner vom XGenerator verarbeitbaren XMI-Version.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern>
        <sch:rule context="/">
            <sch:assert id="id2" role="error" test=".//uml:Model">Das Dokument enthält kein Modell in einer vom XGenerator verarbeitbaren UML-Version.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-2-HauptstrukturEinesXOEVFachmodells-GenauEinXOEVFachmodellAufObersterModellebene">
        <sch:title>NDR-2: Hauptstruktur eines XÖV-Fachmodells</sch:title>
        <sch:p>Das XÖV-Fachmodell eines XÖV-Standards muss auf oberster Ebene einer vordefinierten Struktur folgen, welche die Inhalte des eigenen Standards von externen, in den XÖV-Standard eingebundenen Inhalten unterscheidet.</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model[count(packagedElement[xoev:xsdXModel(.)]) != 1]">
            <sch:assert role="error" id="GenauEinXOEVFachmodellAufObersterModellebene" test="false()">Auf der obersten Modellebene darf nur das Modell des eigenen Standards (UML-Modell mit dem Stereotyp xsdXModel) vorliegen. Alle weiteren XÖV-Fachmodelle müssen als externe Modelle im Paket "Externe Modelle" vorliegen. Aktuell existieren <sch:value-of select="count(packagedElement[xoev:xsdXModel(.)])"/> Modelle auf der obersten Modellebene: <sch:value-of select="packagedElement[xoev:xsdXModel(.)]/@name"/></sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-2-HauptstrukturEinesXOEVFachmodells-ExterneModelleImPaketExterneModelle">
        <sch:title>NDR-2: Hauptstruktur eines XÖV-Fachmodells</sch:title>
        <sch:p>Das XÖV-Fachmodell eines XÖV-Standards muss auf oberster Ebene einer vordefinierten Struktur folgen, welche die Inhalte des eigenen Standards von externen, in den XÖV-Standard eingebundenen Inhalten unterscheidet.</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model">
            <sch:let name="models" value="//packagedElement[xoev:xsdXModel(.)]"/>
            <sch:assert role="error" id="ExterneModelleImPaketExterneModelle" test="
                    count($models) - count($models[ancestor::packagedElement/@name = 'Externe Modelle']) = 1">Externe Modelle (UML-Modelle mit dem Stereotyp xsdXModel, deren Inhalte nicht zum eigenen Standard gehören) müssen im Paket "Externe Modelle" abgelegt werden. Folgende Modelle liegen derzeit außerhalb des Pakets "Externe Modelle" vor: <sch:value-of select="//packagedElement[xoev:xsdXModel(.) and not(parent::packagedElement/@name = 'Externe Modelle')]/@name"/></sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-UnqualifizierteElementeBeiRestriktionUeberMehrereNamensraeume">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//generalization[
                xoev:xsdRestriction(.) and
                not(xoev:getNamespace(parent::*) = xoev:getNamespace(uml:resolve-general(.)))]">
            <sch:let name="elem" value="."/>
            <sch:assert role="error" id="UnqualifizierteElementeBeiRestriktionUeberMehrereNamensraeume" test="
                    not(
                    ((some $e in parent::*/xoev:elements(.)
                        satisfies
                        xoev:xsdElement($e)/@form = 'qualified' or (xoev:xsdElement($e)/@form = 'default' and
                        (ancestor::packagedElement/xoev:xsdSchema(.)/@elementFormDefault = 'qualified' or
                        (ancestor::packagedElement/xoev:xsdSchema(.)/@elementFormDefault = 'default' and
                        ancestor::packagedElement/xoev:xsdXModel(.)/@elementFormDefault = 'qualified')))) or
                    (some $e in uml:resolve-general(.)/xoev:allElements(.)
                        satisfies
                        xoev:xsdElement($e)/@form = 'qualified' or (xoev:xsdElement($e)/@form = 'default' and
                        (uml:resolve-general(.)/ancestor::packagedElement/xoev:xsdSchema(.)/@elementFormDefault = 'qualified' or
                        (uml:resolve-general(.)/ancestor::packagedElement/xoev:xsdSchema(.)/@elementFormDefault = 'default' and
                        uml:resolve-general(.)/ancestor::packagedElement/xoev:xsdXModel(.)/@elementFormDefault = 'qualified'))))))">Eine XML-Restriktion (UML-Generalisierung mit dem Stereotyp xsdRestriction) zwischen zwei in unterschiedlichen Namensräumen liegenden Bausteinen erfordert, dass alle XML-Elemente (UML-Eigenschaften mit dem Stereotyp xsdElement) der beiden Bausteine unqualifiziert sind (XML-Element-Form ist "unqualified"). Im Falle der Restriktion zwischen den beiden Bausteinen <sch:value-of select="xgen:model-path(parent::*)"/> (eingeschränkter Baustein) und <sch:value-of select="xgen:model-path(uml:resolve-general(.))"/> (Basis-Baustein) wird diese Vorgabe nicht eingehalten.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-UnionIstSimpleType">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdUnion(.) and (xoev:allElements(.) or xoev:allAttributes(.))] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdUnion(.) and (xoev:allElements(.) or xoev:allAttributes(.))]">
            <sch:assert role="error" id="UnionIstSimpleType" test="false()">Ein Datentyp, der eine XML-Union darstellt (Stereotyp xsdUnion), muss ein einfacher Typ sein. Der Union-Typ <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-UnionMemberIstSimpleType">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[
                xoev:xsdUnionMember(.) and
                (uml:resolve-supplier(.)[
                not(xoev:topmost-parent(.)/parent::packagedElement/@name = 'W3C Data Types') or xoev:allElements(.) or xoev:allAttributes(.)])]">
            <sch:assert role="error" id="UnionMemberIstSimpleType" test="false()">Ein Datentyp, der als Member einer XML-Union genutzt wird (Stereotyp xsdUnionMember), muss ein einfacher Datentyp sein. Der Typ <sch:value-of select="xgen:model-path(uml:resolve-supplier(.))"/> verletzt diese Vorgabe. Er wird als Member der Union <sch:value-of select="xgen:model-path(uml:resolve-client(.))"/> genutzt.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-UnionMemberIstBenannt">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[
                xoev:xsdUnionMember(.) and
                uml:resolve-supplier(.)[not(parent::packagedElement/@name = 'W3C Data Types' or xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.))]]">
            <sch:assert role="error" id="UnionMemberIstBenannt" test="false()">Ein Datentyp, der als Member einer XML-Union genutzt wird (Stereotyp xsdUnionMember), muss ein benannter Datentyp sein. Der Typ <sch:value-of select="xgen:model-path(uml:resolve-supplier(.))"/> verletzt diese Vorgabe. Er wird als Member der Union <sch:value-of select="xgen:model-path(uml:resolve-client(.))"/> genutzt.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-KeysKeyrefsUniquesImportsUndIncludesSchliessenSichGegenseitigAus">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Dependency(.) and
                count((xoev:xsdImport(.), xoev:xsdInclude(.), xoev:xsdKey(.), xoev:xsdKeyref(.), xoev:xsdUnique(.))) ge 2]">
            <sch:assert role="error" id="KeysKeyrefsUniquesImportsUndIncludesSchliessenSichGegenseitigAus" test="false()">Die Stereotypen xsdKey, xsdKeyref, xsdUnique, xsdInclude und xsdImport schließen sich gegenseitig aus. Die UML-Abhängigkeitsbeziehung zwischen dem Baustein <sch:value-of select="xgen:model-path(uml:resolve-client(.))"/> (abhängiger Baustein) und dem Baustein <sch:value-of select="xgen:model-path(uml:resolve-supplier(.))"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-NamedTypeGlobalElementUndGlobalElementAndNamedTypeSchliessenSichGegenseitigAus">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[
                xoev:xsdNamedType(.) and xoev:xsdGlobalElement(.) or xoev:xsdNamedType(.) and xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdGlobalElement(.) and xoev:xsdGlobalElementAndNamedType(.)] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[
                xoev:xsdNamedType(.) and xoev:xsdGlobalElement(.) or xoev:xsdNamedType(.) and xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdGlobalElement(.) and xoev:xsdGlobalElementAndNamedType(.)]">
            <sch:assert role="error" id="NamedTypeGlobalElementUndGlobalElementAndNamedTypeSchliessenSichGegenseitigAus" test="false()">Die Stereotypen xsdNamedType, xsdGlobalElement und xsdGlobalElementAndNamedType schließen sich gegenseitig aus. Der Baustein <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-XsdNamedTypeUndXsdMessageSchliessenSichGegenseitigAus">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdNamedType(.) and xoev:xsdMessage(.)] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdNamedType(.) and xoev:xsdMessage(.)]">
            <sch:assert role="error" id="XsdNamedTypeUndXsdMessageSchliessenSichGegenseitigAus" test="false()">Die Stereotypen xsdNamedType und xsdMessage schließen sich gegenseitig aus. Der Baustein <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-AttributeElementeUndLokaleStrukturenSchliessenSichGegenseitigAus">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[count((xoev:xsdLocalStructure(.), xoev:xsdElement(.), xoev:xsdAttribute(.))) ge 2]">
            <sch:assert role="error" id="AttributeElementeUndLokaleStrukturenSchliessenSichGegenseitigAus" test="false()">Die Stereotypen xsdLocalStructure, xsdAttribute und xsdElement schließen sich gegenseitig aus. Die UML-Eigenschaft <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-DefaultUndFixedWerteSchliessenSichGegenseitigAus">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:rule context="
                uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[
                xoev:xsdGlobalAttribute(.)/@defaultwert[. != ''] and xoev:xsdGlobalAttribute(.)/@fixedwert[. != '']]">
            <sch:assert role="error" id="DefaultUndFixedWerteSchliessenSichGegenseitigAus" test="false()">Ein globales Attribut darf nicht gleichzeitig einen Defaultwert und einen Fixedwert haben. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-ElementenpositionIstNatuerlicheZahlGroesserNull">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[(xoev:xsdLocalStructure(.) or xoev:is-element(.)) and
                (ancestor::packagedElement/xoev:xsdXModel(.)/@ermittlungElementreihenfolge = 'Stereotyp' or ../ownedAttribute/(xoev:xsdLocalStructure(.), xoev:xsdElement(.))/@position) and
                not(xs:integer((xoev:xsdLocalStructure(.), xoev:xsdElement(.))/@position) ge 1)]">
            <sch:assert role="error" id="ElementenpositionIstNatuerlicheZahlGroesserNull" test="false()">Die Position eines Elements (Eigenschaft position des Stereotyps xsdElement) muss eine Zahl größer null sein. Die UML-Eigenschaft <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-ElementenpositionIstEindeutig">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[(xoev:xsdElement(.) or xoev:xsdLocalStructure(.)) and
                ../(xoev:elements(.), xoev:xsdLocalStructure(.))[@xmi:id != current()/@xmi:id and (xoev:xsdElement(.), xoev:xsdLocalStructure(.))/@position = current()/(xoev:xsdElement(.), xoev:xsdLocalStructure(.))/@position]]">
            <sch:assert role="error" id="ElementenpositionIstEindeutig" test="false()">Die Position eines Elements (Eigenschaft position des Stereotyps xsdElement) muss innerhalb eines Bausteins (UML-Klasse) eindeutig sein. Die UML-Eigenschaft <sch:value-of select="xgen:model-path(.)"/> besitzt jedoch dieselbe Position wie die folgenden Eigenschaften: <sch:value-of select="../(xoev:elements(.), xoev:xsdLocalStructure(.))[@xmi:id != current()/@xmi:id and (xoev:xsdElement(.), xoev:xsdLocalStructure(.))/@position = current()/(xoev:xsdElement(.), xoev:xsdLocalStructure(.))/@position]/@name"/></sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-NamenVonTypenEindeutig">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)) and
                ancestor::packagedElement[xoev:xsdXModel(.)]//(packagedElement | nestedClassifier)[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)) and
                @xmi:id != current()/@xmi:id and xoev:getNamespace(.) = xoev:getNamespace(current()) and @name = current()/@name]] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)) and
                ancestor::packagedElement[xoev:xsdXModel(.)]//(packagedElement | nestedClassifier)[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)) and
                @xmi:id != current()/@xmi:id and xoev:getNamespace(.) = xoev:getNamespace(current()) and @name = current()/@name]]">
            <sch:assert role="error" id="NamenVonTypenEindeutig" test="false()">Im gleichen Namensraum dürfen keine benannten Datentypen (UML-Klassen mit dem Stereotyp xsdNamedType oder xsdGlobalElementAndNamedType) mit dem gleichen Namen existieren. Der Name des Typs <sch:value-of select="xgen:model-path(.)"/> ist im Namensraum "<sch:value-of select="xoev:getNamespace(.)"/>" nicht eindeutig.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-NamenVonGlobalenElementenEindeutig">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdGlobalElement(.) or xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdMessage(.)) and
                ancestor::packagedElement[xoev:xsdXModel(.)]//(packagedElement | nestedClassifier)[(xoev:xsdGlobalElement(.) or xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdMessage(.)) and
                @xmi:id != current()/@xmi:id and xoev:getNamespace(.) = xoev:getNamespace(current()) and @name = current()/@name]] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[(xoev:xsdGlobalElement(.) or xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdMessage(.)) and
                ancestor::packagedElement[xoev:xsdXModel(.)]//(packagedElement | nestedClassifier)[(xoev:xsdGlobalElement(.) or xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdMessage(.)) and
                @xmi:id != current()/@xmi:id and xoev:getNamespace(.) = xoev:getNamespace(current()) and @name = current()/@name]]">
            <sch:assert role="error" id="NamenVonGlobalenElementenEindeutig" test="false()">Im gleichen Namensraum dürfen keine globalen Elemente (UML-Klassen mit dem Stereotyp xsdGlobalElement) mit dem gleichen Namen existieren. Der Name des globalen Elements <sch:value-of select="xgen:model-path(.)"/> ist im Namensraum "<sch:value-of select="xoev:getNamespace(.)"/>" nicht eindeutig.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-SchemaDefinitionenNichtVerschachtelt">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdSchema(.) and ancestor::packagedElement[xoev:xsdSchema(.)]]">
            <sch:assert role="error" id="SchemaDefinitionenNichtVerschachtelt" test="false()">XML Schema-Definitionen (UML-Pakete mit dem Stereotyp xsdSchema) dürfen nicht verschachtelt sein. Das XML Schema-Paket <sch:value-of select="xgen:model-path(.)"/> befindet sich jedoch im XML Schema-Paket <sch:value-of select="xgen:model-path(ancestor::packagedElement[xoev:xsdSchema(.)])"/>.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-CodelistenHabenEinenNamen">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xoevCodeliste(.) and xoev:xsdNamedType(.) and @name = ''] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xoevCodeliste(.) and xoev:xsdNamedType(.) and @name = '']">
            <sch:assert role="error" id="CodelistenHabenEinenNamen" test="false()">Benannte Codelisten (UML-Enumerationen mit den Stereotypen xoevCodeliste und xsdNamedType) müssen einen Namen (Name der UML-Enumeration) besitzen. Im Paket <sch:value-of select="xgen:model-path(parent::packagedElement)"/> befindet sich jedoch eine Codeliste ohne einen solchen Namen.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-CodelistenBasistypIstSimpleType">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[
                xoev:xsdCodeList(.)/xoev:resolve-base(.)[not(xoev:topmost-parent(.)/parent::packagedElement/@name = 'W3C Data Types') or xoev:allElements(.) or xoev:allAttributes(.)]] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[
                xoev:xsdCodeList(.)/xoev:resolve-base(.)[not(xoev:topmost-parent(.)/parent::packagedElement/@name = 'W3C Data Types') or xoev:allElements(.) or xoev:allAttributes(.)]]">
            <sch:assert role="error" id="CodelistenBasistypIstSimpleType" test="false()">Der Basistyp einer Codeliste (Eigenschaft base des Stereotyps xsdCodeList) muss ein einfacher Datentyp sein. Die Codeliste <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe. Der Basistyp der Codeliste ist <sch:value-of select="xoev:xsdCodeList(.)/xoev:resolve-base(.)/xgen:model-path(.)"/>.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-CodelistenBasistypIstTokenOderAbleitungVonToken">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdCodeList(.)/xoev:resolve-base(.)[empty((., xoev:allParents(.))[@name = 'token'])]] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdCodeList(.)/xoev:resolve-base(.)[empty((., xoev:allParents(.))[@name = 'token'])]]">
            <sch:assert role="error" id="CodelistenBasistypIstTokenOderAbleitungVonToken" test="false()">Der Basistyp einer Codeliste (Eigenschaft des Stereotyps xsdCodeList) muss xs:token oder einem davon abgeleiteten Datentypen entsprechen. Die Codeliste <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe. Der Basistyp der Codeliste ist <sch:value-of select="xoev:xsdCodeList(.)/xoev:resolve-base(.)/xgen:model-path(.)"/>.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-ElementeUndAttributeSindBenannt">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
            /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[(xoev:xsdAttribute(.) or xoev:xsdElement(.)) and not(xoev:is-ref(.)) and @name = '']">
            <sch:assert role="error" id="ElementeUndAttributeSindBenannt" test="false()">XML-Elemente und XML-Attribute müssen benannt sein. Ein Element bzw. Attribut in der Klasse <sch:value-of select="xgen:model-path(parent::*)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-ElementnamenSindAufBausteinebeneEindeutig">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[ancestor::packagedElement[xoev:xsdSchema(.)] and uml:is-Class(.)] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[ancestor::packagedElement[xoev:xsdSchema(.)] and uml:is-Class(.)]">
            <sch:assert role="error" id="ElementnamenSindAufBausteinebeneEindeutig" test="count(xoev:allElementNamesIncludingRefsAndGroups(.)) = count(distinct-values(xoev:allElementNamesIncludingRefsAndGroups(.)))">Die XML-Elemente eines Bausteins (UML-Klasse) müssen eindeutig benannt sein. Hierbei sind auch die Namen referenzierter globaler Elemente und die Namen der Elemente in referenzierten Gruppen zu berücksichtigen. Im Kontext des Bausteins <sch:value-of select="xgen:model-path(.)"/> sind die folgenden Namen nicht eindeutig: <sch:value-of select="
                        if (xoev:getDuplicateStrings(xoev:allElementNamesIncludingRefsAndGroups(.)) = '') then
                            'Elemente ohne Namen'
                        else
                            xoev:getDuplicateStrings(xoev:allElementNamesIncludingRefsAndGroups(.))"/></sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-GlobaleElementeMitTypHabenKeineEigenenElementeOderAttribute">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and xoev:dependencies-by-client(.)[xoev:xsdGlobalElementType(.)] and
                (xoev:allElements(.) or xoev:allAttributes(.))] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifer[(xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and xoev:dependencies-by-client(.)[xoev:xsdGlobalElementType(.)] and
                (xoev:allElements(.) or xoev:allAttributes(.))]">
            <sch:assert role="error" id="GlobaleElementeMitTypHabenKeineEigenenElementeOderAttribute" test="false()">Typisierte globale Elemente (UML-Klassen mit dem Stereotyp xsdGlobalElement und einer UML-Abhängigkeitsbeziehung mit dem Stereotyp xsdGlobalElementType) dürfen keine eigenen XML-Elemente (UML-Eigenschaften mit dem Stereotyp xsdElement) oder XML-Attribute (UML-Eigenschaften mit dem Stereotyp xsdAttribute) besitzen. Das globale Element <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-TypisierteGlobaleElementeDuerfenKeineBenanntenTypenSein">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)) and xoev:dependencies-by-client(.)[xoev:xsdGlobalElementType(.)]] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifer[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)) and xoev:dependencies-by-client(.)[xoev:xsdGlobalElementType(.)]]">
            <sch:assert role="error" id="TypisierteGlobaleElementeDuerfenKeineBenanntenTypenSein" test="false()">Typisierte globale Elemente (UML-Abhängigkeitsbeziehung mit dem Stereotyp xsdGlobalElementType) dürfen keine benannten Typen sein (Stereotyp xsdNamedType oder xsdGlobalElementAndNamedType). Der Baustein <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-GlobaleElementeMaximalEinenTyp">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and count(xoev:dependencies-by-client(.)[xoev:xsdGlobalElementType(.)]) ge 2] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifer[(xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and count(xoev:dependencies-by-client(.)[xoev:xsdGlobalElementType(.)]) ge 2]">
            <sch:assert role="error" id="GlobaleElementeMaximalEinenTyp" test="false()">Globale Elemente (UML-Klassen mit dem Stereotyp xsdGlobalElement) dürfen nicht mehr als einen Typen zugewiesen bekommen (UML-Abhängigkeitsbeziehung mit dem Stereotyp xsdGlobalElementType). Das globale Element <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe. Ihm sind die folgenden Typen zugewiesen: <sch:value-of select="xoev:dependencies-by-client(.)[xoev:xsdGlobalElementType(.)]/uml:resolve-supplier(.)/@name"/></sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-TypisierteGlobaleElementeHabenBenanntenTyp">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and
                xoev:dependencies-by-client(.)[xoev:xsdGlobalElementType(.)]/uml:resolve-supplier(.)[not(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.) or parent::packagedElement/@name = 'W3C Data Types')]] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and
                xoev:dependencies-by-client(.)[xoev:xsdGlobalElementType(.)]/uml:resolve-supplier(.)[not(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.) or parent::packagedElement/@name = 'W3C Data Types')]]">
            <sch:assert role="error" id="TypisierteGlobaleElementeHabenBenanntenTyp" test="false()">Typisierte globale Elemente (UML-Klassen mit dem Stereotyp xsdGlobalElement und einer UML-Abhängigkeitsbeziehung mit dem Stereotyp xsdGlobalElementType) müssen einen benannten Typ haben. Das globale Element <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe. Ihm ist der folgende Baustein zugewiesen: <sch:value-of select="xoev:dependencies-by-client(.)[xoev:xsdGlobalElementType(.)]/uml:resolve-supplier(.)/@name"/></sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-ElementReferenzReferenziertGlobalesElementOderElementgruppe">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
            /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[xoev:xsdElement(.) and xoev:is-ref(.) and
                uml:resolve-type(.)[not(xoev:xsdGlobalElement(.) or xoev:xsdMessage(.) or xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdGroup(.))]]">
            <sch:assert role="error" id="ElementReferenzReferenziertGlobalesElementOderElementgruppe" test="false()">Element-Referenzen müssen auf globale Elemente oder Elementgruppen referenzieren. Das globale Element <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe. Ihm ist der folgende Baustein zugewiesen: <sch:value-of select="uml:resolve-type(.)/@name"/></sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-DateinameEinerXMLSchemaDefinitionIstAngegeben">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdSchema(.)] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdSchema(.)]">
            <sch:assert role="error" id="DateinameEinerXMLSchemaDefinitionIstAngegeben" test="xoev:xsdSchema(.)/@schemaFile[. != '']">XML Schema-Definitionen (UML-Pakete mit dem Stereotyp xsdSchema) müssen einen Dateinamen aufweisen (Eigenschaft schemaFile des Stereotyps xsdSchema). Das Schema-Paket <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-SchemaLocationEinerXMLSchemaDefinitionIstAngegeben">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[
                xoev:xsdSchema(.) and ancestor::packagedElement/xoev:xsdXModel(.)[@deployment = 'true' and not(@schemaLocationBase[. != ''])]] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[
                xoev:xsdSchema(.) and ancestor::packagedElement/xoev:xsdXModel(.)[@deployment = 'true' and not(@schemaLocationBase[. != ''])]]">
            <sch:assert role="error" id="SchemaLocationEinerXMLSchemaDefinitionIstAngegeben" test="xoev:xsdSchema(.)/@schemaLocation[. != '']">XML Schema-Definitionen (UML-Pakete mit dem Stereotyp xsdSchema) müssen eine Schema Location aufweisen (Eigenschaft schemaLocation des Stereotyps xsdSchema), sofern keine Schema Location Base für das XÖV-Fachmodell (UML-Modell mit der Eigenschaft schemaLocationBase des Stereotyps xsdXModel) vorliegt. Das Schema-Paket <sch:value-of select="xgen:model-path(.)"/> besitzt keine Schema Location. Gleichzeitig ist auch keine Schema Location Base spezifiziert.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-ImportsNurZwischenXMLSchemaDefinitionenUnterschiedlicherNamensraeume">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdImport(.)] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdImport(.)]">
            <sch:let name="client" value="uml:resolve-client(.)"/>
            <sch:let name="supplier" value="uml:resolve-supplier(.)"/>
            <sch:assert role="error" id="ImportsNurZwischenXMLSchemaDefinitionenUnterschiedlicherNamensraeume" test="
                    not($client/xoev:getNamespace(.) = $supplier/xoev:getNamespace(.)) and
                    not(($client/xoev:xsdSchema(.)/@prefix, $client/ancestor::packagedElement/xoev:xsdXModel(.)/@prefix)[1] =
                    (xoev:xsdImport(.)/@prefix, $supplier/xoev:xsdSchema(.)/@prefix, $supplier/ancestor::packagedElement/xoev:xsdXModel(.)/@prefix)[1])">Die Namensräume (spezifiziert an Schema-Paketen mittels der Eigenschaft namespace des Stereotyps xsdSchema oder am XÖV-Fachmodell mittels der Eigenschaft namespace des Stereotyps xsdXModel) und Namensraumpräfixe (spezifiziert an der Import-Beziehung mittels der Eigenschaft prefix des Stereotyps xsdImport, am Schema-Paket mittels der Eigenschaft prefix des Stereotyps xsdSchema oder am XÖV-Fachmodell mittels der Eigenschaft prefix des Stereotyps xsdXModel) zweier XML Schema-Definitionen (UML-Pakete mit dem Stereotyp xsdSchema), zwischen denen eine XML-Import-Beziehung besteht (UML-Abhängigkeitsbeziehung mit dem Stereotyp xsdImport) müssen sich unterscheiden. Die beiden Schema-Pakete <sch:value-of select="xgen:model-path(uml:resolve-client(.))"/> (importierendes Paket) und <sch:value-of select="xgen:model-path(uml:resolve-supplier(.))"/> (importiertes Paket) verletzen diese Vorgabe.<sch:value-of select="
                        if ($client/xoev:getNamespace(.) = $supplier/xoev:getNamespace(.)) then
                            concat(' Der Namensraum ist identisch: ', $client/xoev:getNamespace(.), '.')
                        else
                            ''"/>
                <sch:value-of select="
                        if (($client/xoev:xsdSchema(.)/@prefix, $client/ancestor::packagedElement/xoev:xsdXModel(.)/@prefix)[1] =
                        (xoev:xsdImport(.)/@prefix, $supplier/xoev:xsdSchema(.)/@prefix, $supplier/ancestor::packagedElement/xoev:xsdXModel(.)/@prefix)[1]) then
                            concat(' Das Präfix ist identisch: ', ($client/xoev:xsdSchema(.)/@prefix, $client/ancestor::packagedElement/xoev:xsdXModel(.)/@prefix)[1], '.')
                        else
                            ''"/></sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-ImportUndIncludeBeziehungenZyklenfrei">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdSchema(.)] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdSchema(.)]">
            <sch:assert role="error" id="ImportUndIncludeBeziehungenZyklenfrei" test="
                    empty(
                    index-of(
                    xoev:allImportedAndIncludedPackageIDs(
                    xoev:dependencies-by-client(.)[xoev:xsdImport(.) or xoev:xsdInclude(.)]/uml:resolve-supplier(.)/@xmi:id,
                    ancestor::uml:Model),
                    @xmi:id))">Eine XML Schema-Definition (UML-Paket mit dem Stereotyp xsdSchema) darf sich nicht direkt oder indirekt selbst inkludieren oder importieren. Das Schema-Paket <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-DateinamenVonXMLSchemaDefinitionenEindeutig">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]">
            <sch:assert role="error" id="DateinamenVonXMLSchemaDefinitionenEindeutig" test="
                    count(descendant::packagedElement/xoev:xsdSchema(.)/@schemaFile) =
                    count(distinct-values(descendant::packagedElement/xoev:xsdSchema(.)/@schemaFile))">XML Schema-Definition (UML-Pakete mit dem Stereotyp xsdSchema) müssen im XÖV-Fachmodell eindeutige Dateinamen aufweisen (Eigenschaft schemaFile des Sterotyps xsdSchema). Die folgenden Dateinamen werden mehrfach verwendet: <sch:value-of select="
                        distinct-values(descendant::packagedElement[xoev:xsdSchema(.) and
                        (some $s in current()/descendant::packagedElement[xoev:xsdSchema(.)]
                            satisfies $s/@xmi:id != @xmi:id and $s/xoev:xsdSchema(.)/@schemaFile = xoev:xsdSchema(.)/@schemaFile)]/xoev:xsdSchema(.)/@schemaFile)"/></sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-SchemaLocationsVonXMLSchemaDefinitionenEindeutig">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]">
            <sch:assert role="error" id="SchemaLocationsVonXMLSchemaDefinitionenEindeutig" test="
                    count(descendant::packagedElement/xoev:xsdSchema(.)/@schemaLocation) =
                    count(distinct-values(descendant::packagedElement/xoev:xsdSchema(.)/@schemaLocation))">XML Schema-Definition (UML-Pakete mit dem Stereotyp xsdSchema) müssen im XÖV-Fachmodell eindeutige Schema Locations aufweisen (Eigenschaft schemaLocation des Stereotyps xsdSchema), sofern solche explizit angegeben wurden. Die folgenden Schema Locations werden mehrfach verwendet: <sch:value-of select="
                        distinct-values(descendant::packagedElement[xoev:xsdSchema(.) and
                        (some $s in current()/descendant::packagedElement[xoev:xsdSchema(.)]
                            satisfies $s/@xmi:id != @xmi:id and $s/xoev:xsdSchema(.)/@schemaLocation = xoev:xsdSchema(.)/@schemaLocation)]/xoev:xsdSchema(.)/@schemaLocation)"/></sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-InkludierterNamensraumUndInkludiertesPraefixEntsprechenDenenDesInkludierendemSchemas">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdInclude(.)]">
            <sch:let name="client" value="uml:resolve-client(.)"/>
            <sch:let name="supplier" value="uml:resolve-supplier(.)"/>
            <sch:assert role="error" id="InkludierterNamensraumUndInkludiertesPraefixEntsprechenDenenDesInkludierendemSchemas" test="
                    $client/xoev:getNamespace(.) = $supplier/xoev:getNamespace(.) and
                    ($client/xoev:xsdSchema(.)/@prefix, $client/ancestor::packagedElement/xoev:xsdXModel(.)/@prefix)[1] =
                    ($supplier/xoev:xsdSchema(.)/@prefix, $supplier/ancestor::packagedElement/xoev:xsdXModel(.)/@prefix)[1]">Der Namensraum und das Präfix einer inkludierten XML Schema-Definition müssen denen der inkludierenden XML Schema-Definition entsprechen. Die inkludierende XML Schema-Definition <sch:value-of select="xgen:model-path($client)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-ImportsUndIncludesNurZwischenSchemaPaketen">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdInclude(.) or xoev:xsdImport(.)]">
            <sch:assert role="error" id="ImportsUndIncludesNurZwischenSchemaPaketen" test="uml:resolve-supplier(.)[xoev:xsdSchema(.)] and uml:resolve-client(.)[xoev:xsdSchema(.)]">XML-Imports (UML-Abhängigkeitsbeziehung mit dem Stereotyp xsdImport) und XML-Includes (UML-Abhängigkeitsbeziehung mit dem Stereotyp xsdInclude) müssen zwei XML Schema-Definitionen (UML-Pakete mit dem Stereotyp xsdSchema) verbinden. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-BenannteTypenMuessenNamenHaben">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)) and not(@name[. != ''])]">
            <sch:assert role="error" id="BenannteTypenMuessenNamenHaben" test="false()">Benannte Datentypen (UML-Klassen mit dem Stereotyp xsdNamedType oder xsdGlobalElementAndNamedType) müssen einen Namen besitzen. Im Paket <sch:value-of select="xgen:model-path(.)"/> liegt ein Typ ohne Namen vor.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-GruppenMuessenNamenHaben">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdGroup(.) and not(@name[. != ''])]">
            <sch:assert role="error" id="GruppenMuessenNamenHaben" test="false()">XML-Gruppen (UML-Klassen mit dem Stereotyp xsdGroup) müssen einen Namen besitzen. Im Paket <sch:value-of select="xgen:model-path(.)"/> liegt eine solche Gruppe ohne Namen vor.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-GlobaleElementeMuessenNamenHaben">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdGlobalElement(.) or xoev:xsdMessage(.) or xoev:xsdGlobalElementAndNamedType(.)) and not(@name[. != ''])]">
            <sch:assert role="error" id="GlobaleElementeMuessenNamenHaben" test="false()">Globale Elemente (UML-KLassen mit dem Stereotyp xsdGlobalElement) müssen einen Namen besitzen. Im Paket <sch:value-of select="xgen:model-path(.)"/> liegt ein solches globales Element ohne Namen vor.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-GruppenHabenMindestensEinElementOderAttribut">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdGroup(.)]">
            <sch:assert role="error" id="GruppenHabenMindestensEinElementOderAttribut" test="xoev:elements(.) or xoev:attributes(.)">XML-Gruppen (UML-Klassen mit dem Stereotyp xsdGroup) müssen mindestens ein XML-Element oder -Attribut besitzen. Die Gruppe <sch:value-of select="xgen:model-path(.)"/> versetzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-GruppenEnthaltenEntwederElementeOderAttribute">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdGroup(.) and xoev:attributes(.) and xoev:elements(.)]">
            <sch:assert role="error" id="GruppenEnthaltenEntwederElementeOderAttribute" test="false()">XML-Gruppen (UML-Klassen mit dem Stereotyp xsdGroup) besitzen entweder ausschließlich XML-Elemente oder ausschließlich XML-Attribute. Die Gruppe <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-AnnotierteKlassenInSchemaPaketen">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[
                xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdChoice(.) or xoev:xsdCode(.) or xoev:xsdGlobalElement(.) or xoev:xsdMessage(.) or xoev:xsdAnyContents(.)]">
            <sch:assert role="error" id="AnnotierteKlassenInSchemaPaketen" test="ancestor::packagedElement[xoev:xsdSchema(.)]">UML-Klassen, die mit Stereotypen annotiert sind, müssen sich direkt oder indirekt in einem Schema-Paket (UML-Paket mit dem Stereotyp xsdSchema) befinden. Die Klasse <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-AnnotierteAbhaengigkeitsbeziehungenInSchemaPaketen">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[
                xoev:xsdInclude(.) or xoev:xsdImport(.) or xoev:xsdKey(.) or xoev:xsdKeyref(.) or xoev:xsdUnique(.)]">
            <sch:assert role="error" id="AnnotierteAbhaengigkeitsbeziehungenInSchemaPaketen" test="ancestor::packagedElement[xoev:xsdSchema(.)]">UML-Abhängigkeitsbeziehungen (Dependencies), die mit Stereotypen annotiert sind, müssen sich direkt oder indirekt in einem Schema-Paket (UML-Paket mit dem Stereotyp xsdSchema) befinden. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-AnnotierteGeneralisierungenInSchemaPaketen">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//generalization[xoev:xsdRestriction(.)]">
            <sch:assert role="error" id="AnnotierteGeneralisierungenInSchemaPaketen" test="ancestor::packagedElement[xoev:xsdSchema(.)]">UML-Generalisierungsbeziehungen, die mit Stereotypen annotiert sind, müssen sich direkt oder indirekt in einem Schema-Paket (UML-Paket mit dem Stereotyp xsdSchema) befinden. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-AnnotierteElementeUndAttributeInSchemaPaketen">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[xoev:xsdElement(.) or xoev:xsdAttribute(.) or xoev:xsdLocalStructure(.)]">
            <sch:assert role="error" id="AnnotierteElementeUndAttributeInSchemaPaketen" test="ancestor::packagedElement[xoev:xsdSchema(.)]">XML-Elemente und -Attribute (UML-Eigenschaften mit dem Stereotyp xsdElement oder xsdAttribute) müssen sich direkt oder indirekt in einem Schema-Paket (UML-Paket mit dem Stereotyp xsdSchema) befinden. Das <sch:value-of select="
                        if (xoev:xsdElement(.)) then
                            'Element '
                        else
                            'Attribut '"/>
                <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-TypenUndGlobaleElementeEnthaltenElementeAttributeOderLokaleStrukturen">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)/@standardeinstellungEigenschaften = 'keine']//packagedElement[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and ownedAttribute and not(xoev:xoevVersionCodeliste(.))] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)/@standardeinstellungEigenschaften = 'keine']//nestedClassifier[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and ownedAttribute and not(xoev:xoevVersionCodeliste(.))]">
            <sch:assert role="error" id="TypenUndGlobaleElementeEnthaltenElementeAttributeOderLokaleStrukturen" test="count(ownedAttribute[xoev:xsdElement(.) or xoev:xsdAttribute(.) or xoev:xsdLocalStructure(.)]) = count(ownedAttribute)">UML-Klassen, die Typen (Stereotyp xsdNamedType) oder globale Elemente (Stereotyp xsdGlobalElement) bzw. beides (Stereotyp xsdGlobalElementAndNamedType) repräsentieren, besitzen ausschließlich Eigenschaften, die XML-Elemente (Stereotyp xsdElement), XML-Attribute (Stereotyp xsdAttribute) oder lokale XML-Strukturen (Stereotyp xsdLocalStructure) repräsentieren. Die Klasse <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-AnyContentsKlassenOhneEigenschaften">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdAnyContents(.)] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdAnyContents(.)]">
            <sch:assert role="error" id="AnyContentsKlassenOhneEigenschaften" test="empty(xoev:elements(.))">UML-Klassen, die any-Elemente repräsentieren (Stereotyp xsdAnyContents), dürfen keine XML-Elemente (UML-Eigenschaften mit dem Stereotyp xsdElement) besitzen. Die Klasse <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-EinfacheVererbung">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Class(.) and count(generalization) gt 1] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Class(.) and count(generalization) gt 1]">
            <sch:assert role="error" id="EinfacheVererbung" test="false()">Typen und globale Elemente dürfen von maximal einem Basistypen ableiten. Die Klasse <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionSchraenktEin">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//generalization[xoev:xsdRestriction(.) and
                not(uml:resolve-general(.)/ancestor::packagedElement[xoev:xoevAdapter(.)])]">
            <sch:let name="restricted" value=".."/>
            <sch:let name="base" value="uml:resolve-general(.)"/>
            <sch:assert role="error" id="XMLRestriktionSchraenktEin" test="
                    (every $p in $restricted/ownedAttribute
                        satisfies
                        $base/ownedAttribute[@name = $p/@name]/uml:resolve-type(.)[
                        
                        (if (uml:resolve-type($p)/xoev:xoevCodeTyp4(.) or uml:resolve-type($p)/xoev:usages-by-client(.)) then
                            xoev:xoevDatentyp(.)/@kennung = 'urn:xoev-de:kosit:xoev:datentyp:code' or xoev:xoevCodeTyp4(.) or xoev:usages-by-client(.)
                        else
                            @xmi:id = $p/uml:resolve-type(.)/(., xoev:allRestrictionParents(.))/@xmi:id or
                            @name = ('token', 'string', 'normalizedString') and $p/uml:resolve-type(.)[uml:is-Enumeration(.)])]
                        
                        and
                        
                        $base/ownedAttribute[@name = $p/@name and xoev:lowerBound($p) ge xoev:lowerBound(.) and
                        (xoev:upperBound(.) = -1 or xoev:upperBound($p) != -1 and xoev:upperBound($p) le xoev:upperBound(.))]) and
                    ($restricted/xoev:xsdChoice(.) or (every $p in $base/ownedAttribute
                        satisfies
                        xoev:lowerBound($p) = 0 or $restricted/ownedAttribute[@name = $p/@name]))">Eine per XML-Restriktion (UML-Generalisierung mit dem Stereotyp xsdRestriction) abgeleitete UML-Klasse darf dem Basistyp keine UML-Klasseneigenschaften mehr hinzufügen. Die Eigenschaftstypen müssen gleich den Typen der entpsrechenden Eigenschaften im Basistyp sein bzw. diese einschränken. Ebenso müssen die Multiplizitäten der Eigenschaften gleich bzw. eingeschränkt gegenüber den Multiplizitäten im Basistyp sein. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-GlobaleElementeOhneStereotypenXsdAnyContents">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdGlobalElement(.) or xoev:xsdMessage(.) or xoev:xsdGlobalElementAndNamedType(.)) and xoev:xsdAnyContents(.)] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[(xoev:xsdGlobalElement(.) or xoev:xsdMessage(.) or xoev:xsdGlobalElementAndNamedType(.)) and xoev:xsdAnyContents(.)]">
            <sch:assert role="error" id="GlobaleElementeOhneStereotypenXsdAnyContents" test="false()">Globale Elemente (UML-Klassen mit dem Stereotyp xsdGlobalElement) dürfen nicht gleichzeitig mit dem Stereotypen xsdAnyContents annotiert sein. Die Klasse <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-AnyElementeOhneStereotypenXsdGlobalElementXsdCodeUndXsdChoice">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdAnyContents(.) and
                (xoev:xsdGlobalElement(.), xoev:xsdMessage(.), xoev:xsdCode(.), xoev:xsdChoice(.))] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdAnyContents(.) and
                (xoev:xsdGlobalElement(.), xoev:xsdMessage(.), xoev:xsdCode(.), xoev:xsdChoice(.))]">
            <sch:assert role="error" id="AnyElementeOhneStereotypenXsdGlobalElementXsdCodeUndXsdChoice" test="false()">Any-Elemente (UML-Klassen mit dem Stereotyp xsdAnyContents) dürfen nicht gleichzeitig mit den Stereotypen xsdGlobalElement, xsdCode oder xsdChoice annotiert sein. Die Klasse <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-ChoiceOhneStereotypenXsdAnyContentsUndXsdCode">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdChoice(.) and
                (xoev:xsdAnyContents(.), xoev:xsdCode(.))] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdChoice(.) and
                (xoev:xsdAnyContents(.), xoev:xsdCode(.))]">
            <sch:assert role="error" id="ChoiceOhneStereotypenXsdAnyContentsUndXsdCode" test="false()">XML-Choices (UML-Klassen mit dem Stereotyp xsdChoice) dürfen nicht gleichzeitig mit den Stereotypen xsdAnyContents oder xsdCode annotiert sein. Die Klasse <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-CodeDatentypenOhneStereotypenXsdGlobalElementXsdAnyContentsUndXsdChoice">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdCode(.) and
                (xoev:xsdGlobalElement(.), xoev:xsdMessage(.), xoev:xsdAnyContents(.), xoev:xsdChoice(.))] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdCode(.) and
                (xoev:xsdGlobalElement(.), xoev:xsdMessage(.), xoev:xsdAnyContents(.), xoev:xsdChoice(.))]">
            <sch:assert role="error" id="CodeDatentypenOhneStereotypenXsdGlobalElementXsdAnyContentsUndXsdChoice" test="false()">Code-Datentypen (UML-Klassen mit dem Stereotyp xsdCode) dürfen nicht gleichzeitig mit den Stereotypen xsdGlobalElement, xsdAnyContents oder xsdChoice annotiert sein. Die Klasse <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-GlobaleElementeSindKlassenOderEnumerationen">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and not(uml:is-Class(.) or uml:is-Enumeration(.))] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[(xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and not(uml:is-Class(.) or uml:is-Enumeration(.))]">
            <sch:assert role="error" id="GlobaleElementeSindKlassenOderEnumerationen" test="false()">Globale Elemente müssen UML-Klassen oder UML-Enumerationen sein. Das UML-Element <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-KeineTypenImEntwurfGenutzt">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[(xoev:is-element(.) or xoev:xsdAttribute(.))]">
            <sch:assert role="error" id="KeineTypenImEntwurfGenutzt" test="../xoev:xsdDraft(.) or empty(uml:resolve-type(.)/xoev:xsdDraft(.))">XML-Elemente (UML-Eigenschaften mit dem Stereotyp xsdElement) und XML-Attribute (UML-Eigenschaften mit dem Stereotyp xsdAttribute) dürfen keine sich im Entwurf befindenden Typen bzw. Elemente nutzen (UML-Klassen mit dem Stereotyp xsdDraft), sofern sie nicht Teil einer Klasse sind, die sich ebenso im Entwurf befindet. Die UML-Eigenschaft <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionMitKorrekterElementenreihenfolge">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[generalization/xoev:xsdRestriction(.) and not(xoev:xsdAll(.)) and
                not(xoev:allParents(.)/ancestor::packagedElement[xoev:xoevAdapter(.)])] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[generalization/xoev:xsdRestriction(.) and not(xoev:xsdAll(.)) and
                not(xoev:allParents(.)/ancestor::packagedElement[xoev:xoevAdapter(.)])]">
            <sch:let name="class" value="."/>
            <sch:let name="basistyp" value="$class/generalization/uml:resolve-general(.)"/>
            <sch:let name="elemente-basistyp" value="
                $basistyp/xoev:allElements(.)[(if (xoev:is-ref(.)) then
                        uml:resolve-type(.)/xoev:global-element-name(.)
                    else
                    @name) = $class/xoev:elements(.)/(if (xoev:is-ref(.)) then
                        uml:resolve-type(.)/xoev:global-element-name(.)
                    else
                        @name)]"/>
            <sch:let name="elemente-rest" value="$class/xoev:elements(.)"/>
            <sch:assert role="error" id="XMLRestriktionMitKorrekterElementenreihenfolge" test="
                    every $e in $elemente-rest
                        satisfies count($elemente-rest[xoev:position(.) le xoev:position($e)]) =
                        count($elemente-basistyp[xoev:getRealPosition((if (xoev:is-ref(.)) then
                            uml:resolve-type(.)/xoev:global-element-name(.)
                        else
                        @name), $basistyp) le xoev:getRealPosition($e/(if (xoev:is-ref(.)) then
                            uml:resolve-type(.)/xoev:global-element-name(.)
                        else
                            @name), $basistyp)])">XML-Elemente müssen in einem per XML-Restriktion (UML-Generalisierung mit dem Stereotyp xsdRestriction) eingeschränkten Datentypen die gleiche Reihenfolge wie die Elemente des Basistyps aufweisen. Die UML-Klasse <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe. Elementreihenfolge des Basistyps: <sch:value-of select="xoev:sortAndConcatForXMLRestriktionMitKorrekterElementenreihenfolge($basistyp)"/> Elementreihenfolge des eingeschränkten Typs: <sch:value-of select="xoev:sortAndConcatForXMLRestriktionMitKorrekterElementenreihenfolge($class)"/>
            </sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionFacettenNurBeiSimpleContent">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)) and
                generalization/xoev:xsdRestriction(.)[@fractionDigits or @length or @totalDigits or @maxExclusive or @maxInclusive or @maxLength or
                @minInclusive or @minInclusive or @minLength or @pattern or
                @whitespace]] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)) and
                generalization/xoev:xsdRestriction(.)[@fractionDigits or @length or @totalDigits or @maxExclusive or
                @maxInclusive or @maxLength or @minInclusive or @minInclusive or @minLength or @pattern or
                @whitespace]]">
            <sch:assert role="error" id="XMLRestriktionFacettenNurBeiSimpleContent" test="
                    empty(xoev:elements(.)) and empty(generalization/uml:resolve-general(.)/xoev:allElements(.))">XML-Restriction-Facetten (Eigenschaften des Stereotyps xsdRestriction) dürfen ausschließich im Kontext von Datentypen mit einfachem Inhalt genutzt werden. Die UML-Klasse <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionFractionDigitsMitKorrektenW3CDatentypen">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[generalization/xoev:xsdRestriction(.)[@fractionDigits]] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[generalization/xoev:xsdRestriction(.)[@fractionDigits]]">
            <sch:assert role="error" id="XMLRestriktionFractionDigitsMitKorrektenW3CDatentypen" test="
                    generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = 'decimal'">Datentypen, die per XML-Restriction mit der Facette fractionDigits (Eigenschaft fractionDigits des Stereotyps xsdRestriction) ableiten, müssen den W3C-Datentyp xs:decimal als Basistyp haben. Die UML-Klasse<sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionLengthMitKorrektenW3CDatentypen">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[generalization/xoev:xsdRestriction(.)[@length]] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[generalization/xoev:xsdRestriction(.)[@length]]">
            <sch:assert role="error" id="XMLRestriktionLengthMitKorrektenW3CDatentypen" test="
                    generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name =
                    ('anyURI', 'base64Binary', 'ENTITIES', 'ENTITY', 'hexBinary', 'ID', 'IDREF', 'IDREFS', 'language', 'Name', 'NCName', 'NMTOKEN', 'NMTOKENS',
                    'normalizedString', 'NOTATION', 'QName', 'string', 'token')">Datentypen, die per XML-Restriction mit der Facette length (Eigenschaft length des Stereotyps xsdRestriction) ableiten, müssen den W3C-Datentyp xs:anyURI, base64Binary, xs:ENTITIES, xs:ENTITY, xs:hexBinary, xs:ID, xs:IDREF, xs:IDREFS, xs:language, xs:Name, xs:NCName, xs:NMTOKEN, xs:NMTOKENS, xs:normalizedString, xs:NOTATION, xs:QName, xs:string oder xs:token als Basistyp haben. Die UML-Klasse<sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionMaxExclusiveMitKorrektenW3CDatentypen">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[generalization/xoev:xsdRestriction(.)[@maxExclusive]] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[generalization/xoev:xsdRestriction(.)[@maxExclusive]]">
            <sch:assert role="error" id="XMLRestriktionMaxExclusiveMitKorrektenW3CDatentypen" test="
                    generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = ('byte', 'date', 'dateTime', 'decimal', 'double', 'duration', 'float', 'gDay', 'gMonth', 'gYear', 'gYearMonth', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'time', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')">Datentypen, die per XML-Restriction mit der Facette maxExclusive (Eigenschaft maxExclusive des Stereotyps xsdRestriction) ableiten, müssen den W3C-Datentyp xs:byte, xs:date, xs:dateTime, xs:decimal, xs:double, xs:duration, xs:float, xs:gDay, xs:gMonth, xs:gYear, xs:gYearMonth, xs:int, xs:integer, xs:long, xs:negativeInteger, xs:nonNegativeInteger, xs:nonPositiveInteger, xs:positiveInteger, xs:short, xs:time, xs:unsignedByte, xs:unsignedInt, xs:unsignedLong oder xs:unsignedShort als Basistyp haben. Die UML-Klasse<sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionMaxInclusiveMitKorrektenW3CDatentypen">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[generalization/xoev:xsdRestriction(.)[@maxInclusive]] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[generalization/xoev:xsdRestriction(.)[@maxInclusive]]">
            <sch:assert role="error" id="XMLRestriktionMaxInclusiveMitKorrektenW3CDatentypen" test="
                    generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = ('byte', 'date', 'dateTime', 'decimal', 'double', 'duration', 'float', 'gDay', 'gMonth', 'gYear', 'gYearMonth', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'time', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')">Datentypen, die per XML-Restriction mit der Facette maxInclusive (Eigenschaft maxInclusive des Stereotyps xsdRestriction) ableiten, müssen den W3C-Datentyp xs:byte, xs:date, xs:dateTime, xs:decimal, xs:double, xs:duration, xs:float, xs:gDay, xs:gMonth, xs:gYear, xs:gYearMonth, xs:int, xs:integer, xs:long, xs:negativeInteger, xs:nonNegativeInteger, xs:nonPositiveInteger, xs:positiveInteger, xs:short, xs:time, xs:unsignedByte, xs:unsignedInt, xs:unsignedLong oder xs:unsignedShort als Basistyp haben. Die UML-Klasse<sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionMaxLengthMitKorrektenW3CDatentypen">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[generalization/xoev:xsdRestriction(.)[@maxLength]] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[generalization/xoev:xsdRestriction(.)[@maxLength]]">
            <sch:assert role="error" id="XMLRestriktionMaxLengthMitKorrektenW3CDatentypen" test="
                    generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = ('anyURI', 'base64Binary', 'ENTITIES', 'ENTITY', 'hexBinary', 'ID', 'IDREF', 'IDREFS', 'language', 'Name', 'NCName', 'NMTOKEN', 'NMTOKENS', 'normalizedString', 'NOTATION', 'QName', 'string', 'token')">Datentypen, die per XML-Restriction mit der Facette maxLength (Eigenschaft maxLength des Stereotyps xsdRestriction) ableiten, müssen den W3C-Datentyp xs:anyURI, base64Binary, xs:ENTITIES, xs:ENTITY, xs:hexBinary, xs:ID, xs:IDREF, xs:IDREFS, xs:language, xs:Name, xs:NCName, xs:NMTOKEN, xs:NMTOKENS, xs:normalizedString, xs:NOTATION, xs:QName, xs:string oder xs:token als Basistyp haben. Die UML-Klasse<sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionMinExclusiveMitKorrektenW3CDatentypen">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[generalization/xoev:xsdRestriction(.)[@minExclusive]] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[generalization/xoev:xsdRestriction(.)[@minExclusive]]">
            <sch:assert role="error" id="XMLRestriktionMinExclusiveMitKorrektenW3CDatentypen" test="
                    generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = ('byte', 'date', 'dateTime', 'decimal', 'double', 'duration', 'float', 'gDay', 'gMonth', 'gYear', 'gYearMonth', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'time', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')">Datentypen, die per XML-Restriction mit der Facette minExclusive (Eigenschaft minExclusive des Stereotyps xsdRestriction) ableiten, müssen den W3C-Datentyp xs:byte, xs:date, xs:dateTime, xs:decimal, xs:double, xs:duration, xs:float, xs:gDay, xs:gMonth, xs:gYear, xs:gYearMonth, xs:int, xs:integer, xs:long, xs:negativeInteger, xs:nonNegativeInteger, xs:nonPositiveInteger, xs:positiveInteger, xs:short, xs:time, xs:unsignedByte, xs:unsignedInt, xs:unsignedLong oder xs:unsignedShort als Basistyp haben. Die UML-Klasse<sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionMinInclusiveMitKorrektenW3CDatentypen">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[generalization/xoev:xsdRestriction(.)[@minInclusive]] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[generalization/xoev:xsdRestriction(.)[@minInclusive]]">
            <sch:assert role="error" id="XMLRestriktionMinInclusiveMitKorrektenW3CDatentypen" test="
                    generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = ('byte', 'date', 'dateTime', 'decimal', 'double', 'duration', 'float', 'gDay', 'gMonth', 'gYear', 'gYearMonth', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'time', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')">Datentypen, die per XML-Restriction mit der Facette minInclusive (Eigenschaft minInclusive des Stereotyps xsdRestriction) ableiten, müssen den W3C-Datentyp xs:byte, xs:date, xs:dateTime, xs:decimal, xs:double, xs:duration, xs:float, xs:gDay, xs:gMonth, xs:gYear, xs:gYearMonth, xs:int, xs:integer, xs:long, xs:negativeInteger, xs:nonNegativeInteger, xs:nonPositiveInteger, xs:positiveInteger, xs:short, xs:time, xs:unsignedByte, xs:unsignedInt, xs:unsignedLong oder xs:unsignedShort als Basistyp haben. Die UML-Klasse<sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionMinLengthMitKorrektenW3CDatentypen">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[generalization/xoev:xsdRestriction(.)[@minLength]] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[generalization/xoev:xsdRestriction(.)[@minLength]]">
            <sch:assert role="error" id="XMLRestriktionMinLengthMitKorrektenW3CDatentypen" test="
                    generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = ('anyURI', 'base64Binary', 'ENTITIES', 'ENTITY', 'hexBinary', 'ID', 'IDREF', 'IDREFS', 'language', 'Name', 'NCName', 'NMTOKEN', 'NMTOKENS', 'normalizedString', 'NOTATION', 'QName', 'string', 'token')">Datentypen, die per XML-Restriction mit der Facette minLength (Eigenschaft minLength des Stereotyps xsdRestriction) ableiten, müssen den W3C-Datentyp xs:anyURI, base64Binary, xs:ENTITIES, xs:ENTITY, xs:hexBinary, xs:ID, xs:IDREF, xs:IDREFS, xs:language, xs:Name, xs:NCName, xs:NMTOKEN, xs:NMTOKENS, xs:normalizedString, xs:NOTATION, xs:QName, xs:string oder xs:token als Basistyp haben. Die UML-Klasse<sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionPatternMitKorrektenW3CDatentypen">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[generalization/xoev:xsdRestriction(.)[@pattern]] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[generalization/xoev:xsdRestriction(.)[@pattern]]">
            <sch:assert role="error" id="XMLRestriktionPatternMitKorrektenW3CDatentypen" test="
                    generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = ('anyURI', 'base64Binary', 'boolean', 'byte', 'date', 'dateTime', 'decimal', 'double', 'duration', 'ENTITY', 'float', 'gDay', 'gMonth', 'gYear', 'gYearMonth', 'hexBinary', 'ID', 'IDREF', 'int', 'integer', 'language', 'long', 'Name', 'NCName', 'negativeInteger', 'NMTOKEN', 'nonNegativeInteger', 'nonPositiveInteger', 'normalizedString', 'NOTATION', 'positiveInteger', 'QName', 'short', 'string', 'time', 'token', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')">Datentypen, die per XML-Restriction mit der Facette pattern (Eigenschaft pattern des Stereotyps xsdRestriction) ableiten, müssen den W3C-Datentyp xs:anyURI, xs:base64Binary, xs:boolean, xs:byte, xs:date, xs:dateTime, xs:decimal, xs:double, xs:duration, xs:ENTITY, xs:float, xs:gDay, xs:gMonth, xs:gYear, xs:gYearMonth, xs:hexBinary, xs:ID, xs:IDREF, xs:int, xs:integer, xs:language, xs:long, xs:Name, xs:NCName, xs:negativeInteger, xs:NMTOKEN, xs:nonNegativeInteger, xs:nonPositiveInteger, xs:normalizedString, xs:NOTATION, xs:positiveInteger, xs:QName, xs:short, xs:string, xs:time, xs:token, xs:unsignedByte, xs:unsignedInt, xs:unsignedLong oder xs:unsignedShort als Basistyp haben. Die UML-Klasse<sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionTotalDigitsMitKorrektenW3CDatentypen">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[generalization/xoev:xsdRestriction(.)[@totalDigits]] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[generalization/xoev:xsdRestriction(.)[@totalDigits]]">
            <sch:assert role="error" id="XMLRestriktionTotalDigitsMitKorrektenW3CDatentypen" test="
                    generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = ('byte', 'decimal', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')">Datentypen, die per XML-Restriction mit der Facette totalDigits (Eigenschaft totalDigits des Stereotyps xsdRestriction) ableiten, müssen den W3C-Datentyp xs:byte, xs:decimal, xs:int, xs:integer, xs:long, xs:negativeInteger, xs:nonNegativeInteger, xs:nonPositiveInteger, xs:positiveInteger, xs:short, xs:unsignedByte, xs:unsignedInt, xs:unsignedLong oder xs:unsignedShort als Basistyp haben. Die UML-Klasse<sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionWhitespaceMitKorrektenW3CDatentypen">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[generalization/xoev:xsdRestriction(.)[@whitespace]] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[generalization/xoev:xsdRestriction(.)[@whitespace]]">
            <sch:assert role="error" id="XMLRestriktionWhitespaceMitKorrektenW3CDatentypen" test="
                    generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = ('ENTITIES', 'ENTITY', 'ID', 'IDREF', 'IDREFS', 'Name', 'NCName', 'NMTOKEN', 'NMTOKENS', 'normalizedString', 'string', 'token')">Datentypen, die per XML-Restriction mit der Facette whitespace (Eigenschaft whitespace des Stereotyps xsdRestriction) ableiten, müssen den W3C-Datentyp xs:ENTITIES, xs:ENTITY, xs:ID, xs:IDREF, xs:IDREFS, xs:language, xs:Name, xs:NCName, xs:NMTOKEN, xs:NMTOKENS, xs:normalizedString, xs:string oder xs:token als Basistyp haben. Die UML-Klasse<sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionLengthIstPositiveGanzeZahl">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//generalization[xoev:xsdRestriction(.)[@length]]">
            <sch:assert role="error" id="XMLRestriktionLengthIstPositiveGanzeZahl" test="
                    replace(xoev:xsdRestriction(.)/@length, '[0-9]+', '') = ''">Die Eigenschaft length des Stereotyps xsdRestriction muss eine positive ganze Zahl sein. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionMaxLengthIstPositiveGanzeZahl">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//generalization[xoev:xsdRestriction(.)[@maxLength]]">
            <sch:assert role="error" id="XMLRestriktionMaxLengthIstPositiveGanzeZahl" test="
                    replace(xoev:xsdRestriction(.)/@maxLength, '[0-9]+', '') = ''">Die Eigenschaft maxLength des Stereotyps xsdRestriction muss eine positive ganze Zahl sein. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionTotalDigitsIstPositiveGanzeZahl">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//generalization[xoev:xsdRestriction(.)[@totalDigits]]">
            <sch:assert role="error" id="XMLRestriktionTotalDigitsIstPositiveGanzeZahl" test="
                    replace(xoev:xsdRestriction(.)/@totalDigits, '[0-9]+', '') = ''">Die Eigenschaft totalDigits des Stereotyps xsdRestriction muss eine positive ganze Zahl sein. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionFractionDigitsIstPositiveGanzeZahl">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//generalization[xoev:xsdRestriction(.)[@fractionDigits]]">
            <sch:assert role="error" id="XMLRestriktionFractionDigitsIstPositiveGanzeZahl" test="
                    replace(xoev:xsdRestriction(.)/@fractionDigits, '[0-9]+', '') = ''">Die Eigenschaft fractionDigits des Stereotyps xsdRestriction muss eine positive ganze Zahl sein. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionLengthSchliesstMaxLengthUndMinLengthAus">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//generalization[xoev:xsdRestriction(.)[@length]]">
            <sch:assert role="error" id="XMLRestriktionLengthSchliesstMaxLengthUndMinLengthAus" test="
                    empty(xoev:xsdRestriction(.)/@maxLength) and empty(xoev:xsdRestriction(.)/@minLength)">Die Eigenschaft length des Stereotyps xsdRestriction darf nicht zusammen mit den Eigenschaften maxLength oder minLength angegeben sein. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionMaxExclusiveUndMaxInclusiveSchliessenSichAus">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//generalization[xoev:xsdRestriction(.)[@maxExclusive and @maxInclusive]]">
            <sch:assert role="error" id="XMLRestriktionMaxExclusiveUndMaxInclusiveSchliessenSichAus" test="false()">Die Eigenschaften maxExclusive und maxInclusive des Stereotyps xsdRestriction schließen sich gegenseitig aus. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionMinExclusiveUndMinInclusiveSchliessenSichAus">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//generalization[xoev:xsdRestriction(.)[@minExclusive and @minInclusive]]">
            <sch:assert role="error" id="XMLRestriktionMinExclusiveUndMinInclusiveSchliessenSichAus" test="false()">Die Eigenschaften minExclusive und minInclusive des Stereotyps xsdRestriction schließen sich gegenseitig aus. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionWhitespaceMitKorrektenWerten">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//generalization[xoev:xsdRestriction(.)[@whitespace]]">
            <sch:assert role="error" id="XMLRestriktionWhitespaceMitKorrektenWerten" test="xoev:xsdRestriction(.)/@whitespace = ('preserve', 'replace', 'collapse')">Die Eigenschaft whitespace des Stereotyps xsdRestriction muss den Wert "preserve", "replace" oder "collapse" besitzen. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-AttributMitKorrektemTyp">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[xoev:xsdAttribute(.) and not(xoev:is-ref(.))]">
            <sch:assert role="error" id="AttributMitKorrektemTyp" test="
                    uml:resolve-type(.)/xoev:topmost-parent(.)/parent::packagedElement/@name = 'W3C Data Types' or
                    uml:resolve-type(.)/uml:is-Enumeration(.) or
                    uml:resolve-type(.)[xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)]">Der Typ eines XML-Attributs (UML-Eigenschaft mit dem Stereotyp xsdAttribute) muss ein W3C-Datentyp, die Ableitung eines W3C-Datentyps, eine Enumeration oder ein benannter Datentyp sein. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-ElementMitKorrektemTyp">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Class(.)]/ownedAttribute[xoev:is-element(.)] | /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Class(.)]/ownedAttribute[xoev:is-element(.)]">
            <sch:assert role="error" id="ElementMitKorrektemTyp" test="
                    uml:resolve-type(.)[xoev:topmost-parent(.)/parent::packagedElement/@name = 'W3C Data Types'] or
                    uml:resolve-type(.)/uml:is-Enumeration(.) or
                    uml:resolve-type(.)/ancestor::packagedElement/xoev:xsdSchema(.)">Der Typ eines XML-Elements (UML-Eigenschaft mit dem Stereotyp xsdElement) muss ein W3C-Datentyp, die Ableitung eines W3C-Datentyps, eine Enumeration oder ein benannter Datentyp sein. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-ElementUndAttributTypenSichtbar">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and $xoev:ist-zyklenfrei]//ownedAttribute[xoev:is-element(.) or xoev:xsdAttribute(.)]">
            <sch:let name="property" value="."/>
            <sch:assert role="error" id="ElementUndAttributTypenSichtbar" test="
                    not(uml:resolve-type(.)[xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)] and
                    ancestor::packagedElement[xoev:xsdSchema(.)]) or
                    uml:resolve-type(.)/ancestor::packagedElement[xoev:xsdSchema(.)]/@xmi:id =
                    (ancestor::packagedElement[xoev:xsdSchema(.)]/@xmi:id,
                    xoev:package-with-imports-and-includes(ancestor::packagedElement[xoev:xsdSchema(.)])/(import, include)/@id)">Der Typ einer UML-Eigenschaft (bzw. die XML Schema-Definition, die den Typ enthält) muss in der XML Schema-Definition, in der die Eigenschaft spezifiziert ist, sichtbar sein, d. h. direkt oder indirekt per XML-Import bzw. -Include eingebunden sein. Die Eigenschaft <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe (genutzter Typ: <sch:value-of select="uml:resolve-type(.)/xoev:qualified-type-name(., $property, false())"/>).</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-TypenGlobalerElementeUndAttributeSichtbar">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and $xoev:ist-zyklenfrei]//packagedElement[
                (xoev:xsdGlobalElement(.) or xoev:xsdGlobalAttribute(.)) and
                uml:resolve-supplier(xoev:dependencies-by-client(.)[xoev:xsdGlobalElementType(.) or xoev:xsdGlobalAttributeType(.)])/xoev:xsdNamedType(.) and
                ancestor::packagedElement[xoev:xsdSchema(.)]]">
            <sch:let name="object" value="."/>
            <sch:assert role="error" id="TypenGlobalerElementeUndAttributeSichtbar" test="
                    uml:resolve-supplier(xoev:dependencies-by-client(.)[xoev:xsdGlobalElementType(.) or xoev:xsdGlobalAttributeType(.)])/
                    ancestor::packagedElement[xoev:xsdSchema(.)]/@xmi:id =
                    (ancestor::packagedElement[xoev:xsdSchema(.)]/@xmi:id,
                    xoev:package-with-imports-and-includes(ancestor::packagedElement[xoev:xsdSchema(.)])/
                    (import, include)/@id)">Der Typ eines globalen Elements oder globalen Attributs (bzw. die XML Schema-Definition, die dieses enthält) muss in der XML Schema-Definition, in der dieses spezifiziert ist, sichtbar sein, d. h. direkt oder indirekt per XML-Import bzw. -Include eingebunden sein. Das globale Element bzw. Attribut <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe (genutzter Typ: <sch:value-of select="uml:resolve-supplier(xoev:dependencies-by-client(.)[xoev:xsdGlobalElementType(.) or xoev:xsdGlobalAttributeType(.)])/xoev:qualified-type-name(., $object, false())"/>).</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-BasistypenSichtbar">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and
                $xoev:ist-zyklenfrei]//packagedElement[uml:is-Class(.) and generalization/uml:resolve-general(.)[xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)]] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and
                $xoev:ist-zyklenfrei]//nestedClassifier[uml:is-Class(.) and generalization/uml:resolve-general(.)[xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)]]">
            <sch:assert role="error" id="BasistypenSichtbar" test="
                    generalization/uml:resolve-general(.)/ancestor::packagedElement[xoev:xsdSchema(.)]/@xmi:id =
                    (ancestor::packagedElement[xoev:xsdSchema(.)]/@xmi:id,
                    (if (ancestor::packagedElement[xoev:xsdSchema(.)]) then
                        xoev:package-with-imports-and-includes(ancestor::packagedElement[xoev:xsdSchema(.)])
                    else
                        ())/(import, include)/@id)">Der Basistyp einer UML-Klasse, von dem per UML-Generalisierung abgeleitet wird (bzw. die XML Schema-Definition, die den Typen enthält) muss in der XML Schema-Definition, in der die ableitende Klasse spezifiziert ist, sichtbar sein, d. h. direkt oder indirekt per XML-Import bzw. -Include (UML-Abhängigkeitsbeziehung mit dem Stereotyp xsdImport bzw. xsdInclude) eingebunden sein. Die ableitende Klasse <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-EigenschaftenHabenEinenTyp">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Class(.)]/ownedAttribute[xoev:is-element(.) or xoev:xsdAttribute(.)] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Class(.)]/ownedAttribute[xoev:is-element(.) or xoev:xsdAttribute(.)]">
            <sch:assert role="error" id="EigenschaftenHabenEinenTyp" test="uml:resolve-type(.)">Jede UML-Eigenschaft mit dem Stereotyp xsdAttribute oder xsdElement muss einen Typ besitzen. Die Eigenschaft <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-AttributeMitEinzelnemWert">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[xoev:xsdAttribute(.) and (xoev:upperBound(.) gt 1 or xoev:upperBound(.) = -1)]">
            <sch:assert role="error" id="AttributeMitEinzelnemWert" test="false()">XML-Attribute (UML-Eigenschaften mit dem Stereotyp xsdAttribute) müssen die Multiplizität 0..1 oder 1 besitzen. Die Eigenschaft <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-SchemaDateiEndungXsd">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdSchema(.) and
                not(ends-with(xoev:xsdSchema(.)/@schemaFile, lower-case('.xsd')))]">
            <sch:assert role="error" id="SchemaDateiEndungXsd" test="false()">Dateinamen von Schema-Paketen (Eigenschaft schemaFile des Stereotyps xsdSchema) müssen "xsd" als Dateiendung beinhalten. Das UML-Paket <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-SchemaLocationEndungXsd">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdSchema(.) and xoev:xsdSchema(.)/@schemaLocation and
                not(ends-with(xoev:xsdSchema(.)/@schemaLocation, lower-case('.xsd')))]">
            <sch:assert role="error" id="SchemaLocationEndungXsd" test="false()">Schema Locations (Eigenschaft schemaLocation des Stereotyps xsdSchema) müssen "xsd" als Dateiendung beinhalten, sofern sie im Kontext eines Schema-Pakets spezifiziert sind. Das UML-Paket <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-AssoziationImGleichenPaketWieEigenschaft">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[uml:resolve-association(.)]">
            <sch:assert role="information" id="AssoziationImGleichenPaketWieEigenschaft" test="
                    ancestor::packagedElement[uml:is-Package(.)][1] = uml:resolve-association(.)/ancestor::packagedElement[uml:is-Package(.)][1]">Es wird empfohlen, dass eine UML-Assoziation (i. d. R. eine Komposition) im selben Paket wie die über die Assoziation spezifizierte Eigenschaft vorliegt. Die Eigenschaft (Assoziationsende) <sch:value-of select="xgen:model-path(.)"/> hält diese Empfehlung nicht ein.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-KeineMehrfachenXMLIncludes">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdSchema(.) and xoev:dependencies-by-client(.)[xoev:xsdInclude(.)]]">
            <sch:assert role="error" id="KeineMehrfachenXMLIncludes" test="
                    every $d in xoev:dependencies-by-client(.)[xoev:xsdInclude(.)]
                        satisfies
                        not(xoev:dependencies-by-client(.)[xoev:xsdInclude(.) and @xmi:id != $d/@xmi:id]/uml:resolve-supplier(.)/@xmi:id =
                        $d/uml:resolve-supplier(.)/@xmi:id)">Ein Schema-Paket (UML-Paket mit dem Stereotyp xsdSchema) darf ein anderes Schema-Paket nicht mehrfach per XML-Include (UML-Abhängigkeitsbeziehung mit dem Stereotyp xsdInclude) einbinden. Das Paket <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-29-IdentifizierendeNamensraeume-XMLSchemaDefinitionenHabenNamensraum">
        <sch:title>NDR-29: Identifizierende Namensräume</sch:title>
        <sch:p>Alle im Rahmen eines XÖV-Standards definierten globalen XML-Elemente und benannten XML-Typen müssen sich in einem Namensraum befinden, der den betroffenen XÖV-Standard eindeutig identifiziert.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdSchema(.) and empty(xoev:getNamespace(.)[. != ''])]">
            <sch:assert role="error" id="XMLSchemaDefinitionenHabenNamensraum" test="false()">XML Schema-Definitionen (UML-Pakete mit dem Stereotyp xsdSchema) müssen einen Namensraum besitzen, entweder über die Eigenschaft namespace des Stereotyps xsdSchema oder die Eigenschaft namespace des Stereotyps xsdXModel. Das Paket <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-29-IdentifizierendeNamensraeume-XMLSchemaDefinitionenHabenPraefix">
        <sch:title>NDR-29: Identifizierende Namensräume</sch:title>
        <sch:p>Alle im Rahmen eines XÖV-Standards definierten globalen XML-Elemente und benannten XML-Typen müssen sich in einem Namensraum befinden, der den betroffenen XÖV-Standard eindeutig identifiziert.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[
                xoev:xsdSchema(.) and empty((xoev:xsdSchema(.)/@prefix, ancestor::packagedElement/xoev:xsdXModel(.)/@prefix)[. != ''])]">
            <sch:assert role="error" id="XMLSchemaDefinitionenHabenPraefix" test="false()">XML Schema-Definitionen (UML-Pakete mit dem Stereotyp xsdSchema) müssen ein Namensraumpräfix besitzen, entweder über die Eigenschaft prefix des Stereotyps xsdSchema oder die Eigenschaft prefix des Stereotyps xsdXModel. Das Paket <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-30-VersionierungDerXMLSchemaDefinitionen-XMLSchemaDefinitionenSindVersioniert">
        <sch:title>NDR-30: Versionierung der XML Schema-Definitionen</sch:title>
        <sch:p>Jede XML Schema-Definition eines XÖV-Standards muss versioniert sein.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdSchema(.)
                and empty((xoev:xsdSchema(.)/@version, ancestor::packagedElement/xoev:xoevVersionStandard(.)/@version)[. != ''])]">
            <sch:assert role="error" id="XMLSchemaDefinitionenSindVersioniert" test="false()">XML Schema-Definitionen (UML-Pakete mit dem Stereotyp xsdSchema) müssen eine Version besitzen, entweder über die Eigenschaft version des Stereotyps xsdSchema oder die Eigenschaft version des Stereotyps xoevVersionStandard. Das Paket <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardNameLangMussBefuelltSein">
        <sch:title>NDR-32: Dokumentation der Metadaten des Standards</sch:title>
        <sch:p>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and empty(xoev:xoevStandard(.)/@nameLang[. != ''])]">
            <sch:assert role="error" id="MetadatenelementStandardNameLangMussBefuelltSein" test="false()">Der Name (lang) eines Standards muss spezifiziert sein (Eigenschaft nameLang des Stereotyps xoevStandard).</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardNameKurzMussBefuelltSein">
        <sch:title>NDR-32: Dokumentation der Metadaten des Standards</sch:title>
        <sch:p>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and empty(xoev:xoevStandard(.)/@nameKurz[. != ''])]">
            <sch:assert role="error" id="MetadatenelementStandardNameKurzMussBefuelltSein" test="false()">Der Name (kurz) eines Standards muss spezifiziert sein (Eigenschaft nameKurz des Stereotyps xoevStandard).</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardNameTechnischMussBefuelltSein">
        <sch:title>NDR-32: Dokumentation der Metadaten des Standards</sch:title>
        <sch:p>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and empty(xoev:xoevStandard(.)/@nameTechnisch[. != ''])]">
            <sch:assert role="error" id="MetadatenelementStandardNameTechnischMussBefuelltSein" test="false()">Der Name (technisch) eines Standards muss spezifiziert sein (Eigenschaft nameTechnisch des Stereotyps xoevStandard).</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardKennungMussBefuelltSein">
        <sch:title>NDR-32: Dokumentation der Metadaten des Standards</sch:title>
        <sch:p>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and empty(xoev:xoevStandard(.)/@kennung[. != ''])]">
            <sch:assert role="error" id="MetadatenelementStandardKennungMussBefuelltSein" test="false()">Die Kennung eines Standards muss spezifiziert sein (Eigenschaft kennung des Stereotyps xoevStandard).</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardBeschreibungMussBefuelltSein">
        <sch:title>NDR-32: Dokumentation der Metadaten des Standards</sch:title>
        <sch:p>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and empty(xoev:xoevStandard(.)/@beschreibung[. != ''])]">
            <sch:assert role="error" id="MetadatenelementStandardBeschreibungMussBefuelltSein" test="false()">Die Beschreibung eines Standards muss vorliegen (Eigenschaft beschreibung des Stereotyps xoevStandard).</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementVersionStandardVersionMussBefuelltSein">
        <sch:title>NDR-32: Dokumentation der Metadaten des Standards</sch:title>
        <sch:p>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and empty(xoev:xoevVersionStandard(.)/@version[. != ''])]">
            <sch:assert role="error" id="MetadatenelementVersionStandardVersionMussBefuelltSein" test="false()">Die Version eines Standards muss spezifiziert sein (Eigenschaft version des Stereotyps xoevVersionStandard).</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementVersionStandardVersionXOEVHandbuchMussBefuelltSein">
        <sch:title>NDR-32: Dokumentation der Metadaten des Standards</sch:title>
        <sch:p>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and empty(xoev:xoevVersionStandard(.)/@versionXOEVHandbuch[. != ''])]">
            <sch:assert role="error" id="MetadatenelementVersionStandardVersionXOEVHandbuchMussBefuelltSein" test="false()">Die Version des XÖV-Handbuchs, zu dessen Regelungen die Version des Standards konform ist, muss spezifiziert sein (Eigenschaft versionXOEVHandbuch des Stereotyps xoevVersionStandard).</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementVersionStandardVersionXGeneratorMussBefuelltSein">
        <sch:title>NDR-32: Dokumentation der Metadaten des Standards</sch:title>
        <sch:p>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and empty(xoev:xoevVersionStandard(.)/@versionXGenerator[. != ''])]">
            <sch:assert role="error" id="MetadatenelementVersionStandardVersionXGeneratorMussBefuelltSein" test="false()">Die Version des XGenerators, mit dem das XÖV-Fachmodell der Version des Standards verarbeitet und die Bestandteile der Version des Standards erzeugt wurden, muss spezifiziert sein (Eigenschaft versionXGenerator des Stereotyps xoevVersionStandard).</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementVersionStandardVersionModellierungswerkzeugMussBefuelltSein">
        <sch:title>NDR-32: Dokumentation der Metadaten des Standards</sch:title>
        <sch:p>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and empty(xoev:xoevVersionStandard(.)/@versionModellierungswerkzeug[. != ''])]">
            <sch:assert role="error" id="MetadatenelementVersionStandardVersionModellierungswerkzeugMussBefuelltSein" test="false()">Die Version des Modellierungswerkzeugs, mit dem das XÖV-Fachmodell der Version des Standards erstellt wurde, muss spezifiziert sein (Eigenschaft versionModellierungswerkzeug des Stereotyps xoevVersionStandard).</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardKennungMussMitUrnXoevDeBeginnen">
        <sch:title>NDR-32: Dokumentation der Metadaten des Standards</sch:title>
        <sch:p>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and not(starts-with(xoev:xoevStandard(.)/@kennung, 'urn:xoev-de:'))]">
            <sch:assert role="error" id="MetadatenelementStandardKennungMussMitUrnXoevDeBeginnen" test="false()">Die Kennung des Standards muss mit der Zeichenfolge "urn:xoev-de:" beginnen (Eigenschaft kennung des Stereotyps xoevStandard).</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardKennungMussStandardEnthalten">
        <sch:title>NDR-32: Dokumentation der Metadaten des Standards</sch:title>
        <sch:p>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and not(contains(xoev:xoevStandard(.)/@kennung, ':standard:'))]">
            <sch:assert role="error" id="MetadatenelementStandardKennungMussStandardEnthalten" test="false()">Die Kennung des Standards muss die Zeichenfolge ":standard:" enthalten (Eigenschaft kennung des Stereotyps xoevStandard).</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardKennungMussNameTechnischEnthalten">
        <sch:title>NDR-32: Dokumentation der Metadaten des Standards</sch:title>
        <sch:p>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and
                not(contains(xoev:xoevStandard(.)/@kennung,
                lower-case(xoev:xoevStandard(.)/@nameTechnisch)))]">
            <sch:assert role="error" id="MetadatenelementStandardKennungMussNameTechnischEnthalten" test="false()">Die Kennung des Standards (Eigenschaft kennung des Stereotyps xoevStandard) muss den Namen (technisch) des Standards in Kleinschreibung enthalten (Eigenschaft nameTechnisch des Stereotyps xoevStandard).</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardKennungDarfNichtXoevEnthalten">
        <sch:title>NDR-32: Dokumentation der Metadaten des Standards</sch:title>
        <sch:p>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and contains(replace(xoev:xoevStandard(.)/@kennung, 'urn:xoev-de', ''), 'xoev')]">
            <sch:assert role="error" id="MetadatenelementStandardKennungDarfNichtXoevEnthalten" test="false()">Die Kennung des Standards muss mit der Zeichenfolge "urn:xoev-de:" beginnen, darf die Zeichenfolge "xoev" jedoch an keiner weiteren Stelle enthalten (Eigenschaft kennung des Stereotyps xoevStandard).</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardKennungDarfNurErlaubteZeichenEnthalten">
        <sch:title>NDR-32: Dokumentation der Metadaten des Standards</sch:title>
        <sch:p>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and replace(xoev:xoevStandard(.)/@kennung, '[a-z0-9\.\-,:]', '') != '']">
            <sch:assert role="error" id="MetadatenelementStandardKennungDarfNurErlaubteZeichenEnthalten" test="false()">Die Kennung des Standards darf nur die Zeichen "a-z", "0-9", "-", ":" und "." enthalten (Eigenschaft kennung des Stereotyps xoevStandard).</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardNameTechnischDarfNurErlaubteZeichenEnthalten">
        <sch:title>NDR-32: Dokumentation der Metadaten des Standards</sch:title>
        <sch:p>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and replace(xoev:xoevStandard(.)/@nameTechnisch, '[a-zA-Z0-9\.\-,]', '') != '']">
            <sch:assert role="error" id="MetadatenelementStandardNameTechnischDarfNurErlaubteZeichenEnthalten" test="false()">Der Name (technisch) des Standards darf nur die Zeichen "a-z", "A-Z", "0-9", "-" und "." enthalten (Eigenschaft nameTechnisch des Stereotyps xoevStandard).</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementVersionStandardVersionDarfNurErlaubteZeichenEnthalten">
        <sch:title>NDR-32: Dokumentation der Metadaten des Standards</sch:title>
        <sch:p>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and replace(xoev:xoevVersionStandard(.)/@version, '[a-zA-Z0-9\.\-,]', '') != '']">
            <sch:assert role="error" id="MetadatenelementVersionStandardVersionDarfNurErlaubteZeichenEnthalten" test="false()">Die Version des Standards darf nur die Zeichen "a-z", "A-Z", "0-9", "-", ":" und "." enthalten (Eigenschaft version des Stereotyps xoevVersionStandard).</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-12-ErlaubteZeichenFuerKlassifikationenInNamen-NamenBenannterTypenUndGlobalerElementeOhneAufeinanderfolgendePunkte">
        <sch:title>NDR-12: Erlaubte Zeichen für Klassifikationen in Namen</sch:title>
        <sch:p>Zur Abbildung von Klassifikationen in Namen sollen Punkte verwendet werden.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and contains(@name, '..')] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedElement[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and contains(@name, '..')]">
            <sch:assert role="warning" id="NamenBenannterTypenUndGlobalerElementeOhneAufeinanderfolgendePunkte" test="false()">Die Namen benannter Datentypen (UML-Klasse mit dem Stereotyp xsdNamedType) und globaler Elemente (UML-Klasse mit dem Stereotyp xsdGlobalElement) oder beides (xsdGlobalElementAndNamedType) sollen keine aufeinanderfolgenden Punkte enthalten. Die Klasse <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-12-ErlaubteZeichenFuerKlassifikationenInNamen-NamenVonElementenUndAttributenOhneAufeinanderfolgendePunkte">
        <sch:title>NDR-12: Erlaubte Zeichen für Klassifikationen in Namen</sch:title>
        <sch:p>Zur Abbildung von Klassifikationen in Namen sollen Punkte verwendet werden.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[(xoev:is-element(.) or xoev:xsdAttribute(.)) and contains(@name, '..')]">
            <sch:assert role="warning" id="NamenVonElementenUndAttributenOhneAufeinanderfolgendePunkte" test="false()">Die Namen von XML-Elementen (UML-Eigenschaften mit dem Stereotyp xsdElement) und XML-Attributen (UML-Eigenschaften mit dem Stereotyp xsdAttribute) sollen keine aufeinanderfolgenden Punkte enthalten. Die Eigenschaft <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-12-ErlaubteZeichenFuerKlassifikationenInNamen-NamenVonCodelistenEnumerationenAlsBenannteTypenOhneAufeinanderfolgendePunkte">
        <sch:title>NDR-12: Erlaubte Zeichen für Klassifikationen in Namen</sch:title>
        <sch:p>Zur Abbildung von Klassifikationen in Namen sollen Punkte verwendet werden.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xoevCodeliste(.) and xoev:xsdNamedType(.)) and contains(@name, '..')]">
            <sch:assert role="warning" id="NamenVonCodelistenEnumerationenAlsBenannteTypenOhneAufeinanderfolgendePunkte" test="false()">Die Namen von UML-Enumerationen, die Codelisten und benannte Typen darstellen (UML-Enumeration mit den Stereotypen xoevCodeliste und xsdNamedType) sollen keine aufeinanderfolgenden Punkte enthalten. Die Enumeration <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-4-ErlaubteEinbindungsartenFuerCodelisten-CodeDatentypEntsprichtCodeTyp1bis4">
        <sch:title>NDR-4: Erlaubte Einbindungsarten für Codelisten</sch:title>
        <sch:p>Eine Codeliste soll ausschließlich mittels der in Abschnitt 8.5: Nutzung von Codelisten beschriebenen Code-Typen 1 bis 4 in einem XÖV-Standard genutzt werden.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdCode(.) and empty(xoev:usages-by-client(.)) and empty(xoev:xoevCodeTyp4(.))] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdCode(.) and empty(xoev:usages-by-client(.)) and empty(xoev:xoevCodeTyp4(.))]">
            <sch:assert role="warning" id="CodeDatentypEntsprichtCodeTyp1bis4" test="
                    (ownedAttribute[@name = 'code' and xoev:xsdElement(.) and xoev:upperBound(.) = 1 and xoev:lowerBound(.) = 1] and
                    ownedAttribute[@name = 'listURI' and xoev:xsdAttribute(.) and xoev:upperBound(.) = 1] and
                    ownedAttribute[@name = 'listVersionID' and xoev:xsdAttribute(.) and xoev:upperBound(.) = 1]) and
                    
                    (if (ownedAttribute[@name = 'code' and uml:resolve-type(.)[uml:is-Enumeration(.)]]) then
                        ownedAttribute[@name = 'listURI' and (defaultValue/@value, defaultValue/body)[. != ''] and @isReadOnly = 'true'] and
                        ownedAttribute[@name = 'listVersionID' and (defaultValue/@value, defaultValue/body)[. != ''] and @isReadOnly = 'true']
                    else
                        (ownedAttribute[@name = 'listURI' and (defaultValue/@value, defaultValue/body)[. != ''] and @isReadOnly = 'true'] and
                        ownedAttribute[@name = 'listVersionID' and (defaultValue/@value, defaultValue/body)[. != ''] and @isReadOnly = 'true']) or
                        
                        (ownedAttribute[@name = 'listURI' and (defaultValue/@value, defaultValue/body)[. != ''] and @isReadOnly = 'true'] and
                        ownedAttribute[@name = 'listVersionID' and xoev:lowerBound(.) = 1]) or
                        
                        (ownedAttribute[@name = 'listURI' and xoev:lowerBound(.) = 1] and
                        ownedAttribute[@name = 'listVersionID' and xoev:lowerBound(.) = 1]))">Code-Datentypen (UML-Klassen mit dem Stereotyp xsdCode) sollen entsprechend den Code-Typen 1 bis 4 ausgestaltet sein. Die Klasse <sch:value-of select="xgen:model-path(.)"/> verletzt diese Regel.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-11-ErlaubteZeichenFuerNamen-NurErlaubteZeichenFuerBenannteTypenUndGlobaleElemente">
        <sch:title>NDR-11: Erlaubte Zeichen für Namen</sch:title>
        <sch:p>Namen von XML-Attributen, XML-Elementen und XML-Typen eines XÖV-Standards sollen nur Buchstaben, Ziffern, Punkte, Unterstriche und Bindestriche enthalten.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and
                replace(@name, '[a-zA-Z0-9\.\-_]', '') != ''] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and
                replace(@name, '[a-zA-Z0-9\.\-_]', '') != '']">
            <sch:assert role="warning" id="NurErlaubteZeichenFuerBenannteTypenUndGlobaleElemente" test="false()">Benannte Typen (UML-Klassen mit dem Stereotyp xsdNamedType) und globale Elemente (UML-Klassen mit dem Stereotyp xsdGlobalElement) oder beides (xsdGlobalElementAndNamedType) sollen nur die Zeichen "a-z", "A-Z", "0-9", ".", "_" und "-" enthalten. Die Klasse <sch:value-of select="xgen:model-path(.)"/> verletzt diese Regel.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-11-ErlaubteZeichenFuerNamen-KeineWhitespacesInNamenBenannterTypenUndGlobalerElemente">
        <sch:title>NDR-11: Erlaubte Zeichen für Namen</sch:title>
        <sch:p>Namen von XML-Attributen, XML-Elementen und XML-Typen eines XÖV-Standards sollen nur Buchstaben, Ziffern, Punkte, Unterstriche und Bindestriche enthalten.</sch:p>
        <sch:rule context="
            /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and
            matches(@name, '\s')] |
            /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and
            matches(@name, '\s')]">
            <sch:assert role="error" id="KeineWhitespacesInNamenBenannterTypenUndGlobalerElemente" test="false()">Benannte Typen (UML-Klassen mit dem Stereotyp xsdNamedType) und globale Elemente (UML-Klassen mit dem Stereotyp xsdGlobalElement) oder beides (xsdGlobalElementAndNamedType) dürfen keine Whitespaces enthalten. Die Klasse <sch:value-of select="xgen:model-path(.)"/> verletzt diese Regel.</sch:assert>
        </sch:rule>
    </sch:pattern>
    
    <sch:pattern id="NDR-11-ErlaubteZeichenFuerNamen-NurErlaubteZeichenFuerNamensPraefixeUndSuffixe">
        <sch:title>NDR-11: Erlaubte Zeichen für Namen</sch:title>
        <sch:p>Namen von XML-Attributen, XML-Elementen und XML-Typen eines XÖV-Standards sollen nur Buchstaben, Ziffern, Punkte, Unterstriche und Bindestriche enthalten.</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]">
            <sch:assert role="warning" id="NurErlaubteZeichenFuerNamensPraefixeUndSuffixe" test="
                    xoev:xsdXModel(.)[
                    (not(@xsdGlobalElementNamePrefix[. != '']) or replace(@xsdGlobalElementNamePrefix, '[a-zA-Z0-9\.\-_]', '') = '') and
                    (not(@xsdGlobalElementNameSuffix[. != '']) or replace(@xsdGlobalElementNameSuffix, '[a-zA-Z0-9\.\-_]', '') = '') and
                    (not(@xsdNamedTypeNamePrefix[. != '']) or replace(@xsdNamedTypeNamePrefix, '[a-zA-Z0-9\.\-_]', '') = '') and
                    (not(@xsdNamedTypeNameSuffix[. != '']) or replace(@xsdNamedTypeNameSuffix, '[a-zA-Z0-9\.\-_]', '') = '')]">Namenspräfixe und -suffixe von benannten Typen und globalen Elementen (Eigenschaften xsdGlobalElementNamePrefix, xsdGlobalElementNameSuffix, xsdNamedTypeNamePrefix, xsdNamedTypeNameSuffix des Stereotyps xsdXModel) sollen nur die Zeichen "a-z", "A-Z", "0-9", ".", "_" und "-" enthalten.</sch:assert>
        </sch:rule>
    </sch:pattern>
    
    <sch:pattern id="NDR-11-ErlaubteZeichenFuerNamen-KeineWhitespacesInNamensPraefixenUndSuffixen">
        <sch:title>NDR-11: Erlaubte Zeichen für Namen</sch:title>
        <sch:p>Namen von XML-Attributen, XML-Elementen und XML-Typen eines XÖV-Standards sollen nur Buchstaben, Ziffern, Punkte, Unterstriche und Bindestriche enthalten.</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]">
            <sch:assert role="error" id="KeineWhitespacesInNamensPraefixenUndSuffixen" test="
                xoev:xsdXModel(.)[
                not(matches(@xsdGlobalElementNamePrefix, '\s') or
                    matches(@xsdGlobalElementNameSuffix, '\s') or
                    matches(@xsdNamedTypeNamePrefix, '\s') or
                    matches(@xsdNamedTypeNameSuffix, '\s'))]">Namenspräfixe und -suffixe von benannten Typen und globalen Elementen (Eigenschaften xsdGlobalElementNamePrefix, xsdGlobalElementNameSuffix, xsdNamedTypeNamePrefix, xsdNamedTypeNameSuffix des Stereotyps xsdXModel) dürfen keine Whitespaces enthalten.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-11-ErlaubteZeichenFuerNamen-NurErlaubteZeichenFuerElementeUndAttribute">
        <sch:title>NDR-11: Erlaubte Zeichen für Namen</sch:title>
        <sch:p>Namen von XML-Attributen, XML-Elementen und XML-Typen eines XÖV-Standards sollen nur Buchstaben, Ziffern, Punkte, Unterstriche und Bindestriche enthalten.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[(xoev:is-element(.) or xoev:xsdAttribute(.)) and
                replace(@name, '[a-zA-Z0-9\.\-_]', '') != '']">
            <sch:assert role="warning" id="NurErlaubteZeichenFuerElementeUndAttribute" test="false()">XML-Elemente (UML-Eigenschaften mit dem Stereotyp xsdElement) und XML-Attribute (UML-Eigenschaften mit dem Stereotyp xsdAttribute) sollen nur die Zeichen "a-z", "A-Z", "0-9", ".", "_" und "-" enthalten. Die Eigenschaft <sch:value-of select="xgen:model-path(.)"/> verletzt diese Regel.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-11-ErlaubteZeichenFuerNamen-KeineWhitespacesInElementUndAttributnamen">
        <sch:title>NDR-11: Erlaubte Zeichen für Namen</sch:title>
        <sch:p>Namen von XML-Attributen, XML-Elementen und XML-Typen eines XÖV-Standards sollen nur Buchstaben, Ziffern, Punkte, Unterstriche und Bindestriche enthalten.</sch:p>
        <sch:rule context="
            /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[(xoev:is-element(.) or xoev:xsdAttribute(.)) and
            matches(@name, '\s')]">
            <sch:assert role="error" id="KeineWhitespacesInElementUndAttributnamen" test="false()">XML-Elemente (UML-Eigenschaften mit dem Stereotyp xsdElement) und XML-Attribute (UML-Eigenschaften mit dem Stereotyp xsdAttribute) dürfen keine Whitespaces enthalten. Die Eigenschaft <sch:value-of select="xgen:model-path(.)"/> verletzt diese Regel.</sch:assert>
        </sch:rule>
    </sch:pattern>
    
    <sch:pattern id="NDR-11-ErlaubteZeichenFuerNamen-NurErlaubteZeichenFuerNamenVonBenanntenDatentypenFuerCodelistenversionen">
        <sch:title>NDR-12: Erlaubte Zeichen für Klassifikationen in Namen</sch:title>
        <sch:p>Zur Abbildung von Klassifikationen in Namen sollen Punkte verwendet werden.</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Usage(.) and xoev:xoevCodeTyp1(.) and not(matches(xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentypName, '^[a-zA-Z0-9\.\-_]*$'))]">
            <sch:assert role="warning" id="NurErlaubteZeichenFuerNamenVonBenanntenDatentypenFuerCodelistenversionen" test="false()">Die Namen explizit benannter Datentypen für Codelistenversionen (Eigenschaft benannterCodelistenDatentypName des Stereotyps xoevCodeTyp1) sollen nur die Zeichen "a-z", "A-Z", "0-9", ".", "_" und "-" enthalten. Im Kontext der Verwendungsbeziehung zwischen dem Code-Datentyp <sch:value-of select="uml:resolve-client(.)/@name"/> und der Codelistenversion <sch:value-of select="uml:resolve-supplier(.)/@name"/> der Codeliste <sch:value-of select="uml:resolve-supplier(.)/xoev:dependencies-by-client(.)/uml:resolve-supplier(.)/@name"/> wurde der Datentypname "<sch:value-of select="xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentypName"/>" mit ungültigen Zeichen spezifiziert.</sch:assert>
        </sch:rule>
    </sch:pattern>
    
    <sch:pattern id="NDR-11-ErlaubteZeichenFuerNamen-KeineWhitespacesInNamenBenannterDatentypenFuerCodelistenversionen">
        <sch:title>NDR-12: Erlaubte Zeichen für Klassifikationen in Namen</sch:title>
        <sch:p>Zur Abbildung von Klassifikationen in Namen sollen Punkte verwendet werden.</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Usage(.) and xoev:xoevCodeTyp1(.) and matches(xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentypName, '\s')]">
            <sch:assert role="error" id="KeineWhitespacesInNamenBenannterDatentypenFuerCodelistenversionen" test="false()">Die Namen explizit benannter Datentypen für Codelistenversionen (Eigenschaft benannterCodelistenDatentypName des Stereotyps xoevCodeTyp1) dürfen keine Whitespaces enthalten. Im Kontext der Verwendungsbeziehung zwischen dem Code-Datentyp <sch:value-of select="uml:resolve-client(.)/@name"/> und der Codelistenversion <sch:value-of select="uml:resolve-supplier(.)/@name"/> der Codeliste <sch:value-of select="uml:resolve-supplier(.)/xoev:dependencies-by-client(.)/uml:resolve-supplier(.)/@name"/> wurde der Datentypname "<sch:value-of select="xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentypName"/>" mit Whitespaces spezifiziert.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-5-DetaillierteStrukturEinesXOEVFachmodells-BasisdatentypenSchemaDefiniert">
        <sch:title>NDR-5: Detaillierte Struktur eines XÖV-Fachmodells</sch:title>
        <sch:p>Für die inhaltliche Gliederung des XÖV-Fachmodells eines XÖV-Standards wird die Nutzung einer bewährten Struktur empfohlen.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and empty(packagedElement[xoev:xsdSchema(.) and @name = 'Basisdatentypen'])]">
            <sch:assert role="information" id="BasisdatentypenSchemaDefiniert" test="false()">Es wird empfohlen, auf der obersten Ebene des XÖV-Fachmodells ein Paket "Basisdatentypen" vorzusehen.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-5-DetaillierteStrukturEinesXOEVFachmodells-BaukastenSchemaDefiniert">
        <sch:title>NDR-5: Detaillierte Struktur eines XÖV-Fachmodells</sch:title>
        <sch:p>Für die inhaltliche Gliederung des XÖV-Fachmodells eines XÖV-Standards wird die Nutzung einer bewährten Struktur empfohlen.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and empty(packagedElement[xoev:xsdSchema(.) and @name = 'Baukasten'])]">
            <sch:assert role="information" id="BaukastenSchemaDefiniert" test="false()">Es wird empfohlen, auf der obersten Ebene des XÖV-Fachmodells ein Paket "Baukasten" vorzusehen.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-5-DetaillierteStrukturEinesXOEVFachmodells-NachrichtenOderFachmodulePaketDefiniert">
        <sch:title>NDR-5: Detaillierte Struktur eines XÖV-Fachmodells</sch:title>
        <sch:p>Für die inhaltliche Gliederung des XÖV-Fachmodells eines XÖV-Standards wird die Nutzung einer bewährten Struktur empfohlen.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and
                empty(packagedElement[not(xoev:xsdSchema(.)) and (@name = 'Nachrichten' or @name = 'Fachmodule')])]">
            <sch:assert role="information" id="NachrichtenOderFachmodulePaketDefiniert" test="false()">Es wird empfohlen, auf der obersten Ebene des XÖV-Fachmodells ein Paket "Nachrichten" bzw. "Fachmodule" vorzusehen.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-5-DetaillierteStrukturEinesXOEVFachmodells-MindestensEinHauptgruppenschema">
        <sch:title>NDR-5: Detaillierte Struktur eines XÖV-Fachmodells</sch:title>
        <sch:p>Für die inhaltliche Gliederung des XÖV-Fachmodells eines XÖV-Standards wird die Nutzung einer bewährten Struktur empfohlen.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]/packagedElement
                [not(xoev:xsdSchema(.)) and (@name = 'Nachrichten' or @name = 'Fachmodule')]
                [empty(packagedElement[xoev:xsdSchema(.) and not(@name = 'Nachrichtentypen')])]">
            <sch:assert role="information" id="MindestensEinHauptgruppenschema" test="false()">Es wird empfohlen, im Paket "Nachrichten" bzw. "Fachmodule" mindestens ein Nachrichtenhauptgruppen-Schema vorzusehen.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-5-DetaillierteStrukturEinesXOEVFachmodells-NachrichtenNurInHauptgruppenpaketen">
        <sch:title>NDR-5: Detaillierte Struktur eines XÖV-Fachmodells</sch:title>
        <sch:p>Für die inhaltliche Gliederung des XÖV-Fachmodells eines XÖV-Standards wird die Nutzung einer bewährten Struktur empfohlen.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdMessage(.) and
                not(ancestor::packagedElement[xoev:xsdSchema(.)]/parent::packagedElement[@name = 'Nachrichten' or @name = 'Fachmodule']/parent::packagedElement/@xmi:id =
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]/@xmi:id)] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdMessage(.) and
                not(ancestor::packagedElement[xoev:xsdSchema(.)]/parent::packagedElement[@name = 'Nachrichten' or @name = 'Fachmodule']/parent::packagedElement/@xmi:id =
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]/@xmi:id)]">
            <sch:assert role="information" id="NachrichtenNurInHauptgruppenpaketen" test="false()">Es wird empfohlen, Nachrichten (UML-Klassen mit dem Stereotyp xsdMessage) nur in den Hauptgruppenpaketen unterhalb des Pakets "Nachrichten" bzw. "Fachmodule" zu spezifizieren. Die Klasse <sch:value-of select="xgen:model-path(.)"/> entspricht der Empfehlung nicht.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-5-DetaillierteStrukturEinesXOEVFachmodells-HauptgruppenpaketeNichtOhneNachrichten">
        <sch:title>NDR-5: Detaillierte Struktur eines XÖV-Fachmodells</sch:title>
        <sch:p>Für die inhaltliche Gliederung des XÖV-Fachmodells eines XÖV-Standards wird die Nutzung einer bewährten Struktur empfohlen.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]/packagedElement[not(xoev:xsdSchema(.)) and (@name = 'Nachrichten' or @name = 'Fachmodule')]/
                packagedElement[xoev:xsdSchema(.) and not(@name = 'Nachrichtentypen')]
                [empty((descendant::packagedElement | descendant::nestedClassifier)[xoev:xsdMessage(.)])]">
            <sch:assert role="information" id="HauptgruppenpaketeNichtOhneNachrichten" test="false()">Es wird empfohlen, in einer Nachrichtenhauptgruppe mindestens eine Nachricht zu spezifieren (UML-Klasse mit dem Stereotyp xsdMessage). Das Paket <sch:value-of select="xgen:model-path(.)"/> entspricht der Empfehlung nicht.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-7-XMLWildcardElementeMitNamensraum-AnyElementeMitNamensraum">
        <sch:title>NDR-7: XML-Wildcard-Elemente mit Namensraum</sch:title>
        <sch:p>Für XML-Wildcard-Elemente wird die Angabe eines Namensraums empfohlen.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdAnyContents(.) and empty(xoev:xsdAnyContents(.)/@namespace[. != ''])] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdAnyContents(.) and empty(xoev:xsdAnyContents(.)/@namespace[. != ''])]">
            <sch:assert role="information" id="AnyElementeMitNamensraum" test="false()">Es wird empfohlen, für Any-Elemente (UML-Klassen mit dem Stereotyp xsdAnyContents) einen Namensraum zu vergeben (Eigenschaft namespace des Stereotyps xsdAnyContents). Die Klasse <sch:value-of select="xgen:model-path(.)"/> entspricht der Empfehlung nicht.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-15-GroßUndKleinschreibungVonNamen-UpperCamelCaseFuerNamenBenannterTypen">
        <sch:title>NDR-15: Groß- und Kleinschreibung von (und innerhalb zusammengesetzter) Namen</sch:title>
        <sch:p>Es wird empfohlen, in Namen von XML-Typen eines XÖV-Standards alle eigenständigen Wörter mit einem Großbuchstaben zu beginnen (Upper Camel Case). In den Namen von XML-Attributen und -Elementen wird eine analoge Schreibweise empfohlen. Hier sollte das erste Zeichen des Namens jedoch ein Kleinbuchstabe sein (Lower Camel Case). Im Falle von Namen globaler XML-Elemente, und damit auch von Nachrichten, wird ebenfalls die Lower Camel Case Schreibweise empfohlen. Nach Klassifikationsmerkmalen in Namen globaler Elemente sollte ebenfalls mit einem Kleinbuchstaben begonnen werden.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)) and
                substring(@name, 1, 1) != upper-case(substring(@name, 1, 1))] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)) and
                substring(@name, 1, 1) != upper-case(substring(@name, 1, 1))]">
            <sch:assert role="information" id="UpperCamelCaseFuerNamenBenannterTypen" test="false()">Es wird empfohlen, Namen benannter Typen (UML-Klassen mit dem Stereotyp xsdNamedType oder xsdGlobalElementAndNamedType) mit einem Großbuchstaben zu beginnen. Die Klasse <sch:value-of select="xgen:model-path(.)"/> entspricht der Empfehlung nicht.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-15-GroßUndKleinschreibungVonNamen-LowerCamelCaseFuerNamenVonElementenUndAttributen">
        <sch:title>NDR-15: Groß- und Kleinschreibung von (und innerhalb zusammengesetzter) Namen</sch:title>
        <sch:p>Es wird empfohlen, in Namen von XML-Typen eines XÖV-Standards alle eigenständigen Wörter mit einem Großbuchstaben zu beginnen (Upper Camel Case). In den Namen von XML-Attributen und -Elementen wird eine analoge Schreibweise empfohlen. Hier sollte das erste Zeichen des Namens jedoch ein Kleinbuchstabe sein (Lower Camel Case). Im Falle von Namen globaler XML-Elemente, und damit auch von Nachrichten, wird ebenfalls die Lower Camel Case Schreibweise empfohlen. Nach Klassifikationsmerkmalen in Namen globaler Elemente sollte ebenfalls mit einem Kleinbuchstaben begonnen werden.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[(xoev:is-element(.) or xoev:xsdAttribute(.)) and
                substring(@name, 1, 1) != lower-case(substring(@name, 1, 1))]">
            <sch:assert role="information" id="LowerCamelCaseFuerNamenVonElementenUndAttributen" test="false()">Es wird empfohlen, Namen von XML-Elementen (UML-Eigenschaft mit dem Stereotyp xsdElement) und XML-Attributen (UML-Eigenschaft mit dem Stereotyp xsdAttribute) mit einem Kleinbuchstaben zu beginnen. Die Eigenschaft <sch:value-of select="xgen:model-path(.)"/> entspricht der Empfehlung nicht.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-15-GroßUndKleinschreibungVonNamen-LowerCamelCaseFuerNamenGlobalerElemente">
        <sch:title>NDR-15: Groß- und Kleinschreibung von (und innerhalb zusammengesetzter) Namen</sch:title>
        <sch:p>Es wird empfohlen, in Namen von XML-Typen eines XÖV-Standards alle eigenständigen Wörter mit einem Großbuchstaben zu beginnen (Upper Camel Case). In den Namen von XML-Attributen und -Elementen wird eine analoge Schreibweise empfohlen. Hier sollte das erste Zeichen des Namens jedoch ein Kleinbuchstabe sein (Lower Camel Case). Im Falle von Namen globaler XML-Elemente, und damit auch von Nachrichten, wird ebenfalls die Lower Camel Case Schreibweise empfohlen. Nach Klassifikationsmerkmalen in Namen globaler Elemente sollte ebenfalls mit einem Kleinbuchstaben begonnen werden.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdGlobalElement(.) or xoev:xsdMessage(.) or xoev:xsdGlobalElementAndNamedType(.)) and
                substring(@name, 1, 1) != lower-case(substring(@name, 1, 1))] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[(xoev:xsdGlobalElement(.) or xoev:xsdMessage(.) or xoev:xsdGlobalElementAndNamedType(.)) and
                substring(@name, 1, 1) != lower-case(substring(@name, 1, 1))]">
            <sch:assert role="information" id="LowerCamelCaseFuerNamenGlobalerElemente" test="false()">Es wird empfohlen, Namen globaler Elemente (UML-Klassen mit dem Stereotyp xsdGlobalElement) mit einem Kleinbuchstaben zu beginnen. Die Klasse <sch:value-of select="xgen:model-path(.)"/> entspricht der Empfehlung nicht.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-16-NamensstrukturGlobalerElemente-NachrichtennamenMitPraefix">
        <sch:title>NDR-16: Namensstruktur globaler Elementen</sch:title>
        <sch:p>Für Nachrichtennamen wird empfohlen, den Namen der jeweiligen Nachrichtenhauptgruppe als Präfix voranzustellen. Das Präfix wird mit einem Punkt von dem eigentlichen Namen der Nachricht abgegrenzt.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdMessage(.) and count(tokenize(@name, '\.')) lt 2] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdMessage(.) and count(tokenize(@name, '\.')) lt 2]">
            <sch:assert role="information" id="NachrichtennamenMitPraefix" test="false()">Es wird empfohlen, Namen von Nachrichten (UML-Klassen mit dem Stereotyp xsdMessage) ein mit einem Punkt abgetrenntes Präfix voranzustelen. Die Klasse <sch:value-of select="xgen:model-path(.)"/> entspricht der Empfehlung nicht.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-16-NamensstrukturGlobalerElemente-NameNachrichtenpraefixEntsprichtNameSchemapaket">
        <sch:title>NDR-16: Namensstruktur globaler Elementen</sch:title>
        <sch:p>Für Nachrichtennamen wird empfohlen, den Namen der jeweiligen Nachrichtenhauptgruppe als Präfix voranzustellen. Das Präfix wird mit einem Punkt von dem eigentlichen Namen der Nachricht abgegrenzt.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdMessage(.)] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdMessage(.)]">
            <sch:let name="msg-prefix" value="tokenize(@name, '\.')[1]"/>
            <sch:let name="msg-prefix-norm" value="concat(lower-case(substring($msg-prefix, 1, 1)), substring($msg-prefix, 2, string-length($msg-prefix)))"/>
            <sch:let name="schema-name" value="ancestor::packagedElement[xoev:xsdSchema(.)]/@name"/>
            <sch:let name="schema-name-norm" value="concat(lower-case(substring($schema-name, 1, 1)), substring($schema-name, 2, string-length($schema-name)))"/>
            <sch:assert role="information" id="NameNachrichtenpraefixEntsprichtNameSchemapaket" test="$msg-prefix-norm = $schema-name-norm">Es wird empfohlen, Namen von Nachrichten (UML-Klassen mit dem Stereotyp xsdMessage) mit einem Präfix zu versehen, das dem Namen des zugehörigen Hauptgruppenpakets (UML-Paket mit dem Stereotyp xsdSchema) entspricht. (Hinweis: Die Anfangsbuchstaben der UML-Klasse und des UML-Pakets dürfen sich in ihrer Groß- und Kleinschreibung unterscheiden, z. B. "hamsterzuchtregister.hamstergeburtsmeldung.0101" und "Hamsterzuchtregister"). Die Klasse <sch:value-of select="xgen:model-path(.)"/> entspricht der Empfehlung nicht.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-17-VersionsuebergreifendEindeutigeNachrichtennummern-NachrichtennameMitNumerischemSuffix">
        <sch:title>NDR-17: Versionsübergreifend eindeutige Nachrichtennummern</sch:title>
        <sch:p>Es wird empfohlen, Nachrichten im Kontext eines XÖV-Standards versionsübergreifend eindeutige Nummern als Namenssuffix zuzuweisen. Das Suffix wird mit einem Punkt abgegrenzt. Darüber hinaus wird empfohlen, ungültig gewordene Nachrichtennummern nicht im Kontext neuer Nachrichten wiederzuverwenden.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdMessage(.) and replace(tokenize(@name, '\.')[last()], '[0-9]', '') != ''] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdMessage(.) and replace(tokenize(@name, '\.')[last()], '[0-9]', '') != '']">
            <sch:assert role="information" id="NachrichtennameMitNumerischemSuffix" test="false()">Es wird empfohlen, Namen von Nachrichten (UML-Klassen mit dem Stereotyp xsdMessage) mit einem Suffix zu versehen, das die Nachrichtennummer repräsentiert, also ausschließlich aus Ziffern besteht. Die Klasse <sch:value-of select="xgen:model-path(.)"/> entspricht der Empfehlung nicht.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-17-VersionsuebergreifendEindeutigeNachrichtennummern-NachrichtennummerEindeutig">
        <sch:title>NDR-17: Versionsübergreifend eindeutige Nachrichtennummern</sch:title>
        <sch:p>Es wird empfohlen, Nachrichten im Kontext eines XÖV-Standards versionsübergreifend eindeutige Nummern als Namenssuffix zuzuweisen. Das Suffix wird mit einem Punkt abgegrenzt. Darüber hinaus wird empfohlen, ungültig gewordene Nachrichtennummern nicht im Kontext neuer Nachrichten wiederzuverwenden.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdMessage(.) and
                (some $m in
                ancestor::packagedElement[xoev:xsdXModel(.)]//(packagedElement | nestedClassifier)[@xmi:id != current()/@xmi:id and
                xoev:xsdMessage(.) and xoev:getNamespace(.) = current()/xoev:getNamespace(.)]
                    satisfies tokenize($m/@name, '\.')[last()] = tokenize(@name, '\.')[last()])] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdMessage(.) and
                (some $m in
                ancestor::packagedElement[xoev:xsdXModel(.)]//(packagedElement | nestedClassifier)[@xmi:id != current()/@xmi:id and
                xoev:xsdMessage(.) and xoev:getNamespace(.) = current()/xoev:getNamespace(.)]
                    satisfies tokenize($m/@name, '\.')[last()] = tokenize(@name, '\.')[last()])]">
            <sch:assert role="information" id="NachrichtennummerEindeutig" test="false()">Es wird empfohlen, eindeutige Nachrichtennummern zu vergeben (Namenssuffix von UML-Klassen mit dem Stereotyp xsdMessage). Die Klasse <sch:value-of select="xgen:model-path(.)"/> entspricht der Empfehlung nicht.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-18-NamenVonXMLSchemaDateien-NameSchemadateiEnthaeltNameTechnisch">
        <sch:title>NDR-18: Namen von XML Schema-Dateien</sch:title>
        <sch:p>Es wird empfohlen, den Namen des betroffenen XÖV-Standards in den Namen seiner XML Schema-Dateien aufzuführen.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdSchema(.) and
                not(starts-with(lower-case(xoev:xsdSchema(.)/@schemaFile), lower-case(ancestor::packagedElement/xoev:xoevStandard(.)/@nameTechnisch)))]">
            <sch:assert role="information" id="NameSchemadateiEnthaeltNameTechnisch" test="false()">Es wird empfohlen, den Namen der XML Schema-Dateien eines Standards (Eigenschaft schemaFile des Stereotyps xsdSchema) den Namen (technisch) des Standards voranzustellen (Eigenschaft nameTechnisch des Stereotyps xoevStandard). Das Paket <sch:value-of select="xgen:model-path(.)"/> entspricht der Empfehlung nicht.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-18-NamenVonXMLSchemaDateien-SchemaLocationEnthaeltNameTechnischDesStandards">
        <sch:title>NDR-18: Namen von XML Schema-Dateien</sch:title>
        <sch:p>Es wird empfohlen, den Namen des betroffenen XÖV-Standards in den Namen seiner XML Schema-Dateien aufzuführen.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdSchema(.) and
                not(contains(
                lower-case((xoev:xsdSchema(.)/@schemaLocation[. != ''],
                concat(ancestor::packagedElement/xoev:xsdXModel(.)/@schemaLocationBase, xoev:xsdSchema(.)/@schemaFile))[1]),
                lower-case(ancestor::packagedElement/xoev:xoevStandard(.)/@nameTechnisch)))]">
            <sch:assert role="information" id="SchemaLocationEnthaeltNameTechnischDesStandards" test="false()">Es wird empfohlen, in der Schema Location (Eigenschaft schemaLocation des Stereotyps xsdSchema bzw. Eigenschaft schemaLocationBase des Stereotyps xsdXModel in Verbindung mit der Eigenschacht schemaFile des Stereotyps xsdSchema) eines Schema-Pakets (UML-Klasse mit dem Stereotyp xsdSchema) den technischen Namen des Standards aufzuführen (Eigenschaft nameTechnisch des Stereotyps xoevStandard). Das Paket <sch:value-of select="xgen:model-path(.)"/> entspricht der Empfehlung nicht.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-20-DokumentationDerRechtsgrundlagen-RechtsgrundlageFuerNachrichtenDokumentiert">
        <sch:title>NDR-20: Dokumentation der Rechtsgrundlagen</sch:title>
        <sch:p>Für die Nachrichten eines XÖV-Standards wird empfohlen, ihre rechtliche Grundlagen innerhalb des Standards zu dokumentieren.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdMessage(.) and empty(xoev:xsdMessage(.)/rechtsgrundlagen)] |
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifer[xoev:xsdMessage(.) and empty(xoev:xsdMessage(.)/rechtsgrundlagen)]">
            <sch:assert role="information" id="RechtsgrundlageFuerNachrichtenDokumentiert" test="false()">Es wird empfohlen, für Nachrichten die jeweiligen Rechtsgrundlagen zu dokumentieren (Eigenschaft rechtsgrundlagen des Stereotyps xsdMessage). Die Klasse <sch:value-of select="xgen:model-path(.)"/> entspricht der Empfehlung nicht.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-21-CodenamenFuerCodesEinerCodeliste-BeschreibungEinesCodesSpezifiziert">
        <sch:title>NDR-21: Codenamen für Codes einer Codeliste</sch:title>
        <sch:p>Es wird empfohlen, allen Codes einer Codeliste eine Beschreibung ihrer Bedeutung zuzuweisen.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedLiteral[xoev:xoevCodelisteneintrag(.) and
                empty(xoev:xoevCodelisteneintrag(.)/@wertErsteBeschreibungsspalte[. != ''])]">
            <sch:assert role="information" id="BeschreibungEinesCodesSpezifiziert" test="false()">Es wird empfohlen, zu jedem Code einer Codeliste eine Beschreibung zu spezifizieren (Eigenschaft wertErsteBeschreibungsspalte des Stereotyps xoevCodelisteneintrag). Die Klasse <sch:value-of select="xgen:model-path(.)"/> entspricht der Empfehlung nicht.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-27-VerwendungDesUrspruenglichenNamensraumpraefixesBeiXMLSchemaImporten-ImportPraefixAusImportiertemSchemaUebernommen">
        <sch:title>NDR-27: Verwendung des ursprünglichen Namensraumpräfixes bei XML Schema-Importen</sch:title>
        <sch:p>Es wird empfohlen, die Bestandteile einer importierten XML Schema-Definition über genau den Namensraumpräfix anzusprechen, der in der importierten XML Schema-Definition genutzt wird.</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdImport(.) and xoev:xsdImport(.)/@prefix]">
            <sch:assert role="information" id="ImportPraefixAusImportiertemSchemaUebernommen" test="false()">Es wird empfohlen, bei einem XML-Import (UML-Abhängigkeit mit dem Stereotyp xsdImport) das Namensraumpräfix des importierten Schemas zu nutzen und das Präfix in der Import-Beziehung (Eigenschaft prefix des Stereotyps xsdImport) nicht zu spezifizieren. <sch:value-of select="xgen:model-path(.)"/> entspricht der Empfehlung nicht.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-6-NutzungVonXMLAttributenUndXMLElementen-ElementreferenzenUnbenannt">
        <sch:title>NDR-6: Nutzung von XML-Attributen und XML-Elementen</sch:title>
        <sch:p>Es wird empfohlen, fachliche Inhalte eines XÖV-Standards mit Hilfe von XML-Elementen zu modellieren, technische bzw. erläuternde Metadaten dagegen mit der Hilfe von XML-Attributen.</sch:p>
        <sch:rule context="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[xoev:xsdElement(.) and xoev:is-ref(.) and @name[. != '']]">
            <sch:assert role="information" id="ElementreferenzenUnbenannt" test="false()">Es wird empfohlen, bei der Referenzierung eines globalen Elements der UML-Eigenschaft keinen Namen zu geben, da dieser irrelevant für die XML Schema-Definition ist. Die Eigenschaft <sch:value-of select="xgen:model-path(.)"/> entspricht der Empfehlung nicht.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-6-NutzungVonXMLAttributenUndXMLElementen-KlasseineigenschaftenMitGlobalenElementenAlsTypSindReferenzen">
        <sch:title>NDR-6: Nutzung von XML-Attributen und XML-Elementen</sch:title>
        <sch:p>Es wird empfohlen, fachliche Inhalte eines XÖV-Standards mit Hilfe von XML-Elementen zu modellieren, technische bzw. erläuternde Metadaten dagegen mit der Hilfe von XML-Attributen.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[xoev:xsdElement(.) and uml:resolve-type(.)/(xoev:xsdGlobalElement(.), xoev:xsdMessage(.)) and
                not(xoev:is-ref(.))]">
            <sch:assert role="information" id="KlasseineigenschaftenMitGlobalenElementenAlsTypSindReferenzen" test="false()">Es wird empfohlen, bei der Nutzung eines globalen Elements in einer UML-Eigenschaft, auf dieses zu referenzieren. Die Eigenschaft <sch:value-of select="xgen:model-path(.)"/> entspricht der Empfehlung nicht.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-6-NutzungVonXMLAttributenUndXMLElementen-KlasseineigenschaftenMitGruppenAlsTypSindReferenzen">
        <sch:title>NDR-6: Nutzung von XML-Attributen und XML-Elementen</sch:title>
        <sch:p>Es wird empfohlen, fachliche Inhalte eines XÖV-Standards mit Hilfe von XML-Elementen zu modellieren, technische bzw. erläuternde Metadaten dagegen mit der Hilfe von XML-Attributen.</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[xoev:xsdElement(.) and uml:resolve-type(.)/xoev:xsdGroup(.) and
                not(xoev:is-ref(.))]">
            <sch:assert role="information" id="KlasseineigenschaftenMitGruppenAlsTypSindReferenzen" test="false()">Es wird empfohlen, bei der Nutzung einer Gruppe (UML-Klasse mit dem Stereotyp xsdGroup) in einer UML-Eigenschaft, auf die Gruppe zu referenzieren. Die Eigenschaft <sch:value-of select="xgen:model-path(.)"/> entspricht der Empfehlung nicht.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern-CodelistenversionMitCodelisteVerbunden">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-Class(.) and xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))]">
            <sch:assert role="error" id="rule-CodelistenversionMitCodelisteVerbunden" test="xoev:dependencies-by-client(.)/uml:resolve-supplier(.)/xoev:xoevCodeliste(.)">Eine Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) muss mittels einer UML-Abhängigkeitsbeziehung mit einer Codeliste (UML-Klasse mit dem Stereotyp xoevCodeliste) verbunden sein. Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern-CodelistenspaltenGehoerenZuCodelistenversion">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//ownedAttribute[xoev:xoevCodelistenspalte(.) and not(xoev:xsdDraft(parent::*))]">
            <sch:assert role="error" id="rule-CodelistenspaltenGehoerenZuCodelistenversion" test="parent::*/xoev:xoevVersionCodeliste(.)">Eine UML-Eigenschaft mit dem Stereotyp xoevCodelistenspalte gehört zu einer Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste). Die Codelistenspalte <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern-EigenschaftenVonCodelistenversionenSindCodelistenspalten">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-Class(.) and xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))]">
            <sch:assert role="error" id="rule-EigenschaftenVonCodelistenversionenSindCodelistenspalten" test="
                    every $p in ownedAttribute
                        satisfies $p/xoev:xoevCodelistenspalte(.)">Die UML-Eigenschaften einer Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) sind mit dem Stereotyp xoevCodelistenspalte versehen. Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern-EmpfohleneCodeSpalteIstEineAllgemeineCodeSpalte">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//ownedAttribute[xoev:xoevCodelistenspalte(.) and not(xoev:xsdDraft(parent::*))]">
            <sch:assert role="error" id="rule-EmpfohleneCodeSpalteIstEineAllgemeineCodeSpalte" test="not(xoev:xoevCodelistenspalte(.)/@empfohleneCodeSpalte = 'true') or xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true'">Eine empfohlene Code-Spalte (UML-Eigenschaft mit dem Stereotyp xoevCodelistenspalte und der Stereotypeigenschaft empfohleneCodeSpalte = 'true') ist immer auch eine allgemeine Code-Spalte (Stereotypeigenschaft codeSpalte = 'true'). Die Codelistenspalte <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern-GenutzteCodelistenversionNichtDraft">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Class(.) and xoev:usages-by-client(.)/uml:resolve-supplier(.)/xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Class(.) and xoev:usages-by-client(.)/uml:resolve-supplier(.)/xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))]">
            <sch:assert role="error" id="rule-GenutzteCodelistenversionNichtDraft" test="
                    not(xoev:usages-by-client(.)/uml:resolve-supplier(.)/xoev:xsdDraft(.)) and
                    not(xoev:usages-by-client(.)/uml:resolve-supplier(.)/xoev:dependencies-by-client(.)/uml:resolve-supplier(.)/xoev:xsdDraft(.))">Ein produktiv eingesetzter Code-Datentyp darf keine durch den Stereotyp xsdDraft als Entwurf gekennzeichnete Codeliste oder Codelistenversion nutzen (Code-Typ 1 und 2). Der Code-Datentyp <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern-GenutzteCodelistenNichtDraft">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Class(.) and xoev:usages-by-client(.)/uml:resolve-supplier(.)/xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Class(.) and xoev:usages-by-client(.)/uml:resolve-supplier(.)/xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))]">
            <sch:assert role="error" id="rule-GenutzteCodelistenNichtDraft" test="not(xoev:usages-by-client(.)/uml:resolve-supplier(.)/xoev:xsdDraft(.))">Ein produktiv eingesetzter Code-Datentyp darf keine durch den Stereotyp xsdDraft als Entwurf gekennzeichnete Codeliste nutzen (Code-Typ 3). Der Code-Datentyp <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern-UsageBeziehungMitCodeTyp1und2EndetBeiCodelistenversion">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Usage(.) and (xoev:xoevCodeTyp1(.) or xoev:xoevCodeTyp2(.))] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Usage(.) and (xoev:xoevCodeTyp1(.) or xoev:xoevCodeTyp2(.))]">
            <sch:assert role="error" id="rule-UsageBeziehungMitCodeTyp1und2EndetBeiCodelistenversion" test="uml:resolve-supplier(.)/xoev:xoevVersionCodeliste(.)">Usage-Beziehungen mit dem Stereotyp xoevCodeTyp1 oder xoevCodeTyp2 müssen bei einer Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) enden. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern-UsageBeziehungOhneCodeTyp1und2EndetBeiCodeliste">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Usage(.) and (not(xoev:xoevCodeTyp1(.) or xoev:xoevCodeTyp2(.)))] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Usage(.) and (not(xoev:xoevCodeTyp1(.) or xoev:xoevCodeTyp2(.)))]">
            <sch:assert role="error" id="rule-UsageBeziehungOhneCodeTyp1und2EndetBeiCodeliste" test="uml:resolve-supplier(.)/xoev:xoevCodeliste(.)">Usage-Beziehungen ohne Stereotyp bzw. mit dem Stereotyp xoevCodeTyp3 müssen bei einer Codeliste (UML-Klasse mit dem Stereotyp xoevCodeliste) enden. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern-CodeDatentypHatKeineEigenschaften">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Class(.) and (xoev:xoevCodeTyp4(.) or xoev:usages-by-client(.))] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Class(.) and (xoev:xoevCodeTyp4(.) or xoev:usages-by-client(.))]">
            <sch:assert role="error" id="rule-CodeDatentypHatKeineEigenschaften" test="empty(xoev:allElements(.)) and empty(xoev:allAttributes(.))">Im XÖV-Fachmodell modellierte Code-Datentypen (UML-Klassen mit dem Stereotyp xoevCodeTyp4 oder einer ausgehenden Usage-Beziehung) haben keine Eigenschaften (XML-Attribute oder -Elemente). Die UML-Klasse <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern-CodeTyp1undCodeTyp2SchliessenSichAus">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Usage(.) and xoev:xoevCodeTyp1(.) and xoev:xoevCodeTyp2(.)] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Usage(.) and xoev:xoevCodeTyp1(.) and xoev:xoevCodeTyp2(.)]">
            <sch:assert role="error" id="rule-CodeTyp1undCodeTyp2SchliessenSichAus" test="false()">Die Stereotypen xoevCodeTyp1 und xoevCodeTyp2 schließen sich gegenseitig aus. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern-UsageBeziehungZuCodelistenversionHatStereotypXoevCodeTyp1oder2">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Usage(.) and uml:resolve-supplier(.)/xoev:xoevVersionCodeliste(.)] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Usage(.) and uml:resolve-supplier(.)/xoev:xoevVersionCodeliste(.)]">
            <sch:assert role="error" id="rule-UsageBeziehungZuCodelistenversionHatStereotypXoevCodeTyp1oder2" test="xoev:xoevCodeTyp1(.) or xoev:xoevCodeTyp2(.)">Usage-Beziehungen zu Codelistenversionen (UML-Klassen mit dem Stereotyp xoevVersionCodeliste) müssen den Stereotyp xoevCodeTyp1 oder xoevCodeTyp2 haben. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern-KeineMehrfachbeziehungenZwischenCodeDatentypUndCodelistenOderCodelistenversionen">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="
                uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Class(.) and not(xoev:xoevCodeTyp4(.)) and count(xoev:usages-by-client(.)/uml:resolve-supplier(.)[xoev:xoevCodeliste(.) or xoev:xoevVersionCodeliste(.)]) gt 1] |
                uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Class(.) and not(xoev:xoevCodeTyp4(.)) and count(xoev:usages-by-client(.)/uml:resolve-supplier(.)[xoev:xoevCodeliste(.) or xoev:xoevVersionCodeliste(.)]) gt 1]">
            <sch:assert role="error" id="rule-KeineMehrfachbeziehungenZwischenCodeDatentypUndCodelistenOderCodelistenversionen" test="false()">Von einem Code-Datentyp darf maximal eine Usage-Beziehung zur selben oder zu unterschiedlichen Codelisten bzw. Codelistenversionen ausgehen. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern-GenutzteCodeSpalteEntsprichtCodeSpalteDerGenutztenCodelistenversion">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Usage(.) and (xoev:xoevCodeTyp1(.)/@genutzteCodeSpalte or xoev:xoevCodeTyp2(.)/@genutzteCodeSpalte) and uml:resolve-supplier(.)/xoev:xoevVersionCodeliste(.)] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Usage(.) and (xoev:xoevCodeTyp1(.)/@genutzteCodeSpalte or xoev:xoevCodeTyp2(.)/@genutzteCodeSpalte) and uml:resolve-supplier(.)/xoev:xoevVersionCodeliste(.)]">
            <sch:assert role="error" id="rule-GenutzteCodeSpalteEntsprichtCodeSpalteDerGenutztenCodelistenversion" test="
                    (xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.))/@genutzteCodeSpalte = uml:resolve-supplier(.)/ownedAttribute[xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true']/@xmi:id">Die über die Eigenschaft genutzteCodeSpalte der Stereotypen xoevCodeTyp1 oder xoevCodeTyp2 bestimmte Spalte muss eine Code-Spalte (UML-Eigenschaft mit Eigenschaft xoevCodelistenspalte/codeSpalte = true) der genutzten Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) sein. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern-GenutzteBeschreibungsspalteEntsprichtSpalteDerGenutztenCodelistenversion">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Usage(.) and (xoev:xoevCodeTyp1(.)/@genutzteBeschreibungsspalte or xoev:xoevCodeTyp2(.)/@genutzteBeschreibungsspalte) and uml:resolve-supplier(.)/xoev:xoevVersionCodeliste(.)] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Usage(.) and (xoev:xoevCodeTyp1(.)/@genutzteBeschreibungsspalte or xoev:xoevCodeTyp2(.)/@genutzteBeschreibungsspalte) and uml:resolve-supplier(.)/xoev:xoevVersionCodeliste(.)]">
            <sch:assert role="error" id="rule-GenutzteBeschreibungsspalteEntsprichtSpalteDerGenutztenCodelistenversion" test="
                    (xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.))/@genutzteBeschreibungsspalte = uml:resolve-supplier(.)/ownedAttribute/@xmi:id">Die über die Eigenschaft genutzteBeschreibungsspalte der Stereotypen xoevCodeTyp1 oder xoevCodeTyp2 bestimmte Spalte muss eine Spalte (UML-Eigenschaft mit Eigenschaft xoevCodelistenspalte/codeSpalte = true) der genutzten Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) sein. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern-BlacklistUndWhitelistSchliessenSichAus">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Usage(.) and (xoev:xoevCodeTyp1(.) or xoev:xoevCodeTyp2(.))] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Usage(.) and (xoev:xoevCodeTyp1(.) or xoev:xoevCodeTyp2(.))]">
            <sch:assert role="error" id="rule-BlacklistUndWhitelistSchliessenSichAus" test="empty((xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.))/@whiteList) or empty((xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.))/@blackList)">Die Eigenschaften whiteList und blackList der Stereotypen xoevCodeTyp1 und xoevCodeTyp2 schließen sich gegenseitig aus. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern-EintraegeBlacklistOderWhiteListEntsprechenEintraegenDerGenutztenCodelistenversion">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Usage(.) and (xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.))/(@whiteList, @blackList)] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Usage(.) and (xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.))/(@whiteList, @blackList)]">
            <sch:let name="usage" value="."/>
            <sch:let name="eintraege-black-white" value="tokenize((xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.))/(@whiteList, @blackList), ' ')"/>
            <sch:let name="eintraege-codeliste" value="ancestor::packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-InstanceSpecification(.) and @classifier = $usage/uml:resolve-supplier(.)/@xmi:id]"/>
            <sch:assert role="error" id="rule-EintraegeBlacklistOderWhiteListEntsprechenEintraegenDerGenutztenCodelistenversion" test="
                    every $eintrag in $eintraege-black-white
                        satisfies $eintrag = $eintraege-codeliste/@xmi:id">Die in den Eigenschaften whiteList und blackList der Stereotypen xoevCodeTyp1 oder xoevCodeTyp2 aufgeführten Codelisteneinträge müssen Codelisteneinträge der vom Code-Datentyp genutzten Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) sein. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern-TypDesCodeElementsIstTokenOderDavonAbgeleitet">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.), xoev:xoevCodeTyp3(.), xoev:xoevCodeTyp4(.))/xoev:resolve-typDesCodeElements(.)] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[(xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.), xoev:xoevCodeTyp3(.), xoev:xoevCodeTyp4(.))/xoev:resolve-typDesCodeElements(.)]">
            <sch:let name="typ" value="xoev:resolve-typDesCodeElements((xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.), xoev:xoevCodeTyp3(.), xoev:xoevCodeTyp4(.)))"/>
            <sch:assert role="error" id="rule-TypDesCodeElementsIstTokenOderDavonAbgeleitet" test="
                    root()/descendant::packagedElement[xoev:xoevDatentyp(.)/@kennung = 'urn:xoev-de:kosit:xoev:datentyp:code']/ownedAttribute[@name = 'code']/uml:resolve-type(.)/@xmi:id = ($typ, xoev:allParents($typ))/@xmi:id">Der über die Eigenschaft typDesCodeElements der Stereotypen xoevCodeTyp1 bis xoevCodeTyp4 bestimmte Datentyp muss xs:token oder ein davon abgeleiteter Datentyp sein. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern-DeprecatedCodesNichtWiederverwenden">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-InstanceSpecification(.) and xoev:xoevCodelisteneintragDeprecated(.)] | uml:Model/packagedElement[uml:is-InstanceSpecification(.) and xoev:xoevCodelisteneintragDeprecated(.)]">
            <sch:let name="eintrag" value="."/>
            <sch:let name="eintraege" value="ancestor::packagedElement[xoev:xsdXModel(.)]//packagedElement[@xmi:id != $eintrag/@xmi:id and uml:is-InstanceSpecification(.) and @classifier = $eintrag/@classifier and not(xoev:xoevCodelisteneintragDeprecated(.))]"/>
            <sch:assert role="error" id="rule-DeprecatedCodesNichtWiederverwenden" test="
                    every $own-slot in $eintrag/slot[uml:resolve-definingFeature(.)/xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true']
                        satisfies (
                        every $other-slot in $eintraege/slot[uml:resolve-definingFeature(.)/@xmi:id = $own-slot/uml:resolve-definingFeature(.)/@xmi:id]
                            satisfies
                            not($own-slot/value/@value/normalize-space(.) = $other-slot/value/@value/normalize-space(.)))">Codes in Codelisteneinträgen, die als veraltet gekennzeichnet sind (UML-Objekte mit dem Stereotyp xoevCodelisteneintragDeprecated), dürfen nicht in anderen Codelisteneinträgen derselben Codelistenversion wiederverwendet werden. Der Codelisteneintrag mit den Codes <sch:value-of select="$eintrag/slot[uml:resolve-definingFeature(.)/xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true']/value/@value/normalize-space(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.C-CLH-1.0-R1">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-Class(.) and xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))]">
            <sch:assert role="error" id="rule.C-CLH-1.0-R1" test="ownedAttribute[xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true']">Eine Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) muss mindestens eine Code-Spalte (UML-Eigenschaft mit dem Stereotyp xoevCodelistenspalte und der Stereotypeigenschaft codeSpalte = 'true') besitzen. Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.C-CLH-1.0-R3">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//ownedAttribute[xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true']">
            <sch:assert role="error" id="rule.C-CLH-1.0-R3" test="xoev:xoevCodelistenspalte(.)/@verwendung = 'required'">Das Metadatenelement Verwendung (Eigenschaft verwendung des Stereotyps xoevCodelistenspalte) muss bei Code-Spalten (UML-Eigenschaft mit dem Stereotyp xoevVersionCodeliste und der Stereotypeigenschaft codeSpalte = true) auf "required" gesetzt werden. Die Codelistenspalte <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.C-CLH-1.0-R4">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//ownedAttribute[xoev:xoevCodelistenspalte(.)/@verwendung = 'required']">
            <sch:let name="spalte" value="."/>
            <sch:let name="instanzen" value="ancestor::packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-InstanceSpecification(.) and @classifier = $spalte/parent::*/@xmi:id and not(xoev:xoevCodelisteneintragDeprecated(.))]"/>
            <sch:assert role="error" id="rule.C-CLH-1.0-R4" test="
                    every $instanz in $instanzen
                        satisfies $instanz/slot[uml:resolve-definingFeature(.)/@xmi:id = $spalte/@xmi:id]/value/@value">Eine Spalte mit der Verwendung "required" (UML-Eigenschaft mit dem Stereotyp xoevVersionCodeliste und der Stereotypeigenschaft verwendung = 'required') muss in jedem Codelisteneintrag (UML-Objekt der UML-Klasse der Codelistenversion) mit einem Wert belegt sein. Die Codelistenspalte <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.C-CLH-1.0-R5">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))]">
            <sch:assert role="error" id="rule.C-CLH-1.0-R5" test="replace(xoev:xoevCodeliste(.)/@nameTechnisch, '[a-zA-Z0-9\.\-]', '') = ''">Der Name (technisch) einer Codeliste (UML-Klasse mit dem Stereotyp xoevCodeliste und der Stereotypeigenschaft nameTechnisch) darf nur die Zeichen "A-Z", "a-z", "0-9", "-" und "." enthalten. Die Codeliste <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern-C-XOEV-R6">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))]">
            <sch:assert role="error" id="rule-C-XOEV-R6" test="
                    if (uml:is-Class(.)) then
                        xoev:xoevVersionCodeliste(.)/@versionCodelistenHandbuch = ('1.0', '1.1', '1.2')
                    else
                        xoev:xoevVersionCodeliste(.)/@versionXOEVHandbuch = '2.1'">Die Version des Handbuchs, zu dessen Regelungen die technische Umsetzung der Version einer Codeliste konform ist, muss angegeben sein (Eigenschaft versionXOEVHandbuch bzw. versionCodelistenHandbuch des Stereotyps xoevVersionCodeliste) und einer existierenden Version entsprechen (XÖV-Handbuch 2.1 oder Codelisten-Handbuch 1.0, 1.1 bzw. 1.2). Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.C-XOEV-R8">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//ownedAttribute[xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true']">
            <sch:let name="spalte" value="."/>
            <sch:let name="instanzen" value="ancestor::packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-InstanceSpecification(.) and @classifier = $spalte/parent::*/@xmi:id and not(xoev:xoevCodelisteneintragDeprecated(.))]"/>
            <sch:assert role="error" id="rule.C-XOEV-R8" test="
                    count($instanzen/slot[uml:resolve-definingFeature(.)/@xmi:id = $spalte/@xmi:id]/value/@value) = count(distinct-values($instanzen/slot[uml:resolve-definingFeature(.)/@xmi:id = $spalte/@xmi:id]/value/@value))">Über die Werte in einer Code-Spalte (UML-Eigenschaft mit dem Stereotyp xoevCodelistenspalte und der Stereotypeigenschaft codeSpalte = true) müssen die einzelnen Einträge der Codeliste (UML-Objekte der UML-Klasse der Codelistenversion) eindeutig identifiziert werden können. Somit muss in einer Code-Spalte zu jedem Codelisteneintrag ein eindeutiger Wert vorliegen. Die Codelistenspalte <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.C-CLH-1.0-R9">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))]">
            <sch:assert role="error" id="rule.C-CLH-1.0-R9" test="count(xoev:xoevCodeliste(.)/nameLang[. != '']) = (1, count(distinct-values(xoev:xoevCodeliste(.)/nameLang/xoev:get-language(.))))">Eine Codeliste muss genau einen Namen (lang) pro Sprache besitzen (Eigenschaft nameLang des Stereotyps xoevCodeliste). Die Codeliste <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.C-CLH-1.0-R11">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))]">
            <sch:assert role="error" id="rule.C-CLH-1.0-R11" test="count(xoev:xoevCodeliste(.)/nameKurz[. != '']) = (1, count(distinct-values(xoev:xoevCodeliste(.)/nameKurz/xoev:get-language(.))))">Eine Codeliste muss genau einen Namen (kurz) pro Sprache besitzen (Eigenschaft nameKurz des Stereotyps xoevCodeliste). Die Codeliste <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.C-CLH-1.0-R12">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))]">
            <sch:assert role="error" id="rule.C-CLH-1.0-R12" test="xoev:xoevCodeliste(.)/@nameTechnisch[. != '']">Eine Codeliste muss einen Namen (technisch) besitzen (Eigenschaft nameTechnisch des Stereotyps xoevCodeliste). Die Codeliste <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.C-CLH-1.0-R13">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))]">
            <sch:assert role="error" id="rule.C-CLH-1.0-R13" test="xoev:xoevCodeliste(.)/@kennung[. != '']">Eine Codeliste muss eine Kennung besitzen (Eigenschaft kennung des Stereotyps xoevCodeliste). Die Codeliste <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.C-CLH-1.0-R14">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="
                uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.)) and not(xoev:xoevCodeliste(.)/@kennung = $bestandskennungen)]">
            <sch:assert role="error" id="rule.C-CLH-1.0-R14" test="replace(xoev:xoevCodeliste(.)/@kennung, '[a-z0-9\.\-:]', '') = ''">Die Kennung einer Codeliste darf ausschließlich die Zeichen "a-z", "0-9", ":", "-" und "." enthalten (Eigenschaft kennung des Stereotyps xoevCodeliste). Die Codeliste <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.C-CLH-1.0-R15">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.)) and not(xoev:xoevCodeliste(.)/@kennung = $bestandskennungen)]">
            <assert id="rule.C-CLH-1.0-R15" role="error" test='
                matches(., "^urn:(urn-[1-9][0-9]*|[a-zA-z0-9][a-zA-Z0-9-]{1,30}[a-z0-9]):[a-zA-Z0-9:&amp;@\-\._~!\$&apos;\(\)\*\+,;=][a-zA-Z0-9:&amp;@%\-\._~!\$&apos;\(\)\*\+,;=/]*$")'>Die Kennung einer Codeliste (/CodeList/Identification/CanonicalUri) muss in der Form eines URN notiert werden. [siehe Codelistenhandbuch 1.0, Abschnitt 1.3 "Identifikation von Codelisten"]</assert>
            <assert id="rule.C-CLH-1.0-R15-1" role="error" test="not(matches(., '^urn:urn-.*$')) or matches(., '^urn:urn-[1-9][0-9]*:.*$')">Die Kennung einer Codeliste (/CodeList/Identification/CanonicalUri) muss in der Form eines URN notiert werden: Ein informaler URN-Namespace darf nach "urn-" nur Zahlen enthalten.</assert>
            <assert id="rule.C-CLH-1.0-R15-2" role="error" test="not(matches(., '^urn:x-.*$'))">Die Kennung einer Codeliste (/CodeList/Identification/CanonicalUri) muss in der Form eines URN notiert werden: Der URN-Namespace darf nicht mit der Zeichenkette "X-" beginnen. </assert>
            <assert id="rule.C-CLH-1.0-R15-3" role="error" test="not(matches(., '^urn:..-.*$'))">Die Kennung einer Codeliste (/CodeList/Identification/CanonicalUri) muss in der Form eines URN notiert werden: Der URN-Namespace darf nicht mit zwei Zeichen, gefolgt von einem Bindestrich beginnen.</assert>
            <assert id="rule.C-CLH-1.0-R15-4" role="error" test="not(matches(., '^.*%.*$')) or matches(., '^urn:.*:.*%[0-9ABCDEF][0-9ABCDEF].*$')">Die Kennung einer Codeliste (/CodeList/Identification/CanonicalUri) muss in der Form eines URN notiert werden: Das Zeichen "%" darf nur zur Angabe von Hexadezimalzahlen verwendet werden.</assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.C-CLH-1.0-R16">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.)) and not(xoev:xoevCodeliste(.)/@kennung = $bestandskennungen)]">
            <sch:assert role="warning" id="rule.C-CLH-1.0-R16" test="starts-with(xoev:xoevCodeliste(.)/@kennung, 'urn:xoev-de:')">Es wird empfohlen, als globalen Teil der Kennung einer Codeliste (Eigenschaft kennung des Stereotyps xoevCodeliste) die Zeichenfolge "urn:xoev-de:" und die zugehörige Syntax zu verwenden. Die Codeliste <sch:value-of select="xgen:model-path(.)"/> entspricht dieser Empfehlung nicht. Hinweis: Diese Meldung erscheint ausschließlich bei Codelisten, die noch nicht im XRepository vorliegen.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.C-CLH-1.0-R17">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.)) and starts-with(xoev:xoevCodeliste(.)/@kennung, 'urn:xoev-de:') and not(xoev:xoevCodeliste(.)/@kennung = $bestandskennungen)]">
            <sch:assert role="error" id="rule.C-CLH-1.0-R17" test="contains(xoev:xoevCodeliste(.)/@kennung, ':codeliste:')">Die Kennung einer Codeliste (Eigenschaft kennung des Stereotyps xoevCodeliste) mit dem globalen Teil "urn:xoev-de:" muss die Art des Inhalts mittels der Zeichenfolge ":codeliste:" beschreiben. Die Codeliste <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.C-CLH-1.0-R18">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.)) and starts-with(xoev:xoevCodeliste(.)/@kennung, 'urn:xoev-de:') and not(xoev:xoevCodeliste(.)/@kennung = $bestandskennungen)]">
            <sch:assert role="error" id="rule.C-CLH-1.0-R18" test="ends-with(xoev:xoevCodeliste(.)/@kennung, lower-case(xoev:xoevCodeliste(.)/@nameTechnisch))">Die Kennung einer Codeliste (Eigenschaft kennung des Stereotyps xoevCodeliste) mit dem globalen Teil "urn:xoev-de:" muss mit dem Namen (technisch) der Codeliste in Kleinschreibung enden. Die Codeliste <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.C-CLH-1.0-R19">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))]">
            <sch:assert role="error" id="rule.C-CLH-1.0-R19" test="count(xoev:xoevCodeliste(.)/beschreibung[. != '']) = (1, count(distinct-values(xoev:xoevCodeliste(.)/beschreibung/xoev:get-language(.))))">Eine Codeliste muss genau eine Beschreibung pro Sprache besitzen (Eigenschaft beschreibung des Stereotyps xoevCodeliste). Die Codeliste <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.C-CLH-1.0-R20">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))]">
            <sch:assert role="error" id="rule.C-CLH-1.0-R20" test="count(xoev:xoevCodeliste(.)/herausgebernameLang[. != '']) = (1, count(distinct-values(xoev:xoevCodeliste(.)/herausgebernameLang/xoev:get-language(.))))">Eine Codeliste muss genau einen Namen (lang) ihres Herausgebers pro Sprache enthalten (Eigenschaft herausgebernameLang des Stereotyps xoevCodeliste). Die Codeliste <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.C-CLH-1.0-R21">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))]">
            <sch:assert role="error" id="rule.C-CLH-1.0-R21" test="count(xoev:xoevCodeliste(.)/herausgebernameKurz[. != '']) = (1, count(distinct-values(xoev:xoevCodeliste(.)/herausgebernameKurz/xoev:get-language(.))))">Eine Codeliste muss genau einen Namen (kurz) ihres Herausgebers pro Sprache enthalten (Eigenschaft herausgebernameKurz des Stereotyps xoevCodeliste). Die Codeliste <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.C-CLH-1.0-R23">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))]">
            <sch:assert role="error" id="rule.C-CLH-1.0-R23" test="replace(xoev:xoevVersionCodeliste(.)/@version, '[a-zA-Z0-9\.\-]', '') = ''">Die Versionsangabe in einer Codelistenversion darf ausschließlich die Zeichen 'a-z', 'A-Z', '0-9', '-' und '.' enthalten (Eigenschaft version des Stereotyps xoevVersionCodeliste). Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.C-CLH-1.0-R24">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevVersionCodeliste(.) and uml:is-Class(.) and not(xoev:xsdDraft(.))]">
            <sch:assert role="error" id="rule.C-CLH-1.0-R24" test="count(ownedAttribute[xoev:xoevCodelistenspalte(.)]) &gt;= 2">Eine Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) muss mindestens zwei Spalten enthalten (UML-Eigenschaften mit dem Stereotyp xoevCodelistenspalte). Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.C-CLH-1.0-R25">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//ownedAttribute[xoev:xoevCodelistenspalte(.) and not(xoev:xsdDraft(.))]">
            <sch:assert role="error" id="rule.C-CLH-1.0-R25" test="replace(@name, '[a-zA-Z0-9\.\-]', '') = ''">Der Name (technisch) einer Codelistenspalte (UML-Eigenschaft mit dem Stereotyp xoevCodelistenspalte und der Stereotypeigenschaft nameTechnisch) darf nur die Zeichen "a-z", "A-Z", "0-9", "-" und "." enthalten. Die Codelistenspalte <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.C-CLH-1.0-R26">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.)) and uml:is-Class(.)]">
            <sch:let name="codelistenversion" value="."/>
            <sch:assert role="warning" id="rule.C-CLH-1.0-R26" test="count(ancestor::packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-InstanceSpecification(.) and @classifier = $codelistenversion/@xmi:id]) &gt;= 1">Eine Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) sollte mindestens einen Eintrag (UML-Objekt der UML-Klasse der Codelistenversion) besitzen. Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.C-CLH-1.0-R28">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevVersionCodeliste(.) and uml:is-Class(.) and not(xoev:xsdDraft(.))]">
            <sch:assert role="error" id="rule.C-CLH-1.0-R28" test="count(ownedAttribute[xoev:xoevCodelistenspalte(.)/@empfohleneCodeSpalte = 'true']) &lt;= 1">Eine Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) darf höchstens eine empfohlene Code-Spalte (UML-Eigenschaft mit dem Stereotyp xoevCodelistenspalte und der Eigenschaft empfohleneCodeSpalte = true) besitzen. Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.C-CLH-1.0-R29">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.)) and xoev:xoevVersionCodeliste(.)/@datumGueltigkeitAb]">
            <sch:assert role="error" id="rule.C-CLH-1.0-R29" test="matches(xoev:xoevVersionCodeliste(.)/@datumGueltigkeitAb, '\d\d\d\d\-\d\d\-\d\d')">Das Datum "Gültigkeit ab" einer Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste und der Eigenschaft datumGueltigkeitAb) darf nur Datumsangaben im Format JJJJ-MM-TT enthalten. Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.C-CLH-1.0-R30">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))]">
            <sch:assert role="error" id="rule.C-CLH-1.0-R30" test="xoev:xoevVersionCodeliste(.)/@version[. != '']">Die Versionangabe einer Codelistenversion muss spezifiziert sein (UML-Klasse mit dem Stereotyp xoevVersionCodeliste und der Eigenschaft version). Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>
    
    <sch:pattern id="pattern.C-CLH-1.2-R31-A">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))]">
            <sch:assert role="error" id="rule.C-CLH-1.2-R31-A" test="count(xoev:xoevVersionCodeliste(.)/beschreibung[. != '']) = (0, 1, count(distinct-values(xoev:xoevVersionCodeliste(.)/beschreibung/xoev:get-language(.))))">Eine Codelistenversion darf höchstens eine Beschreibung pro Sprache besitzen (Eigenschaft beschreibung des Stereotyps xoevVersionCodeliste). Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>
    
    <sch:pattern id="pattern.C-CLH-1.2-R32-A">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))]">
            <sch:assert role="error" id="rule.C-CLH-1.2-R32-A" test="count(xoev:xoevVersionCodeliste(.)/aenderungZurVorversion[. != '']) = (0, 1, count(distinct-values(xoev:xoevVersionCodeliste(.)/aenderungZurVorversion/xoev:get-language(.))))">Eine Codelistenversion darf höchstens eine Beschreibung der Änderungen zur Vorversion pro Sprache besitzen (Eigenschaft aenderungZurVorversion des Stereotyps xoevVersionCodeliste). Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>
        
    <sch:pattern id="pattern.C-XOEV-R33">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-Class(.) and xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))]">
            <sch:assert role="error" id="rule.C-CLH-1.0-R33" test="
                    xoev:xoevVersionCodeliste(.)/@versionCodelistenHandbuch and
                    empty(xoev:xoevVersionCodeliste(.)/@versionXOEVHandbuch)">Im Kontext einer Codelistenversion, die der im Codelisten-Handbuch 1.0 dokumentierten Methodik entsprechend modelliert ist (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) muss die Version des Codelisten-Handbuchs angeben sein (Eigenschaft versionCodelistenHandbuch des Stereotyps xoevVersionCodeliste). Die Eigenschaft versionXOEVHandbuch des Stereotyps xoevVersionCodeliste darf nicht befüllt sein. Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern-C-XOEV-2.2-R34">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-Enumeration(.) and xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))]">
            <sch:assert role="error" id="rule-C-XOEV-2.2-R34" test="
                    xoev:xoevVersionCodeliste(.)/@versionXOEVHandbuch and
                    empty(xoev:xoevVersionCodeliste(.)/@versionCodelistenHandbuch)">Im Kontext einer Codelistenversion, die der im XÖV-Handbuch 2.1 dokumentierten Methodik entsprechend modelliert ist (UML-Enumeration mit dem Stereotyp xoevVersionCodeliste) muss die Version des XÖV-Handbuchs angeben sein (Eigenschaft versionXOEVHandbuch des Stereotyps xoevVersionCodeliste). Die Eigenschaft versionCodelistenHandbuch des Stereotyps xoevVersionCodeliste darf nicht befüllt sein. Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern-CodelisteImUMLPaketMitKennungAlsNamen">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevCodeliste(.) and uml:is-Class(.) and not(xoev:xsdDraft(.))]">
            <sch:assert role="information" id="rule-CodelisteImUMLPaketMitKennungAlsNamen" test="parent::packagedElement/@name = xoev:xoevCodeliste(.)/@kennung">Es wird empfohlen, für jede Codeliste (UML-Klasse mit dem Stereotyp xoevCodeliste) ein eigenes UML-Paket zu erstellen, dessen Name der Kennung der Codeliste entspricht. Die Codeliste <sch:value-of select="xgen:model-path(.)"/> entspricht dieser Empfehlung nicht.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern-CodelistenversionImUMLPaketMitVersionAlsNamen">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevVersionCodeliste(.) and uml:is-Class(.) and not(xoev:xsdDraft(.))]">
            <sch:let name="codelistenversion" value="."/>
            <sch:assert role="information" id="rule-CodelistenversionImUMLPaketMitVersionAlsNamen" test="parent::packagedElement[@name = $codelistenversion/xoev:xoevVersionCodeliste(.)/@version and parent::packagedElement/packagedElement/@xmi:id = $codelistenversion/xoev:dependencies-by-client(.)/uml:resolve-supplier(.)/@xmi:id]">Es wird empfohlen, für jede Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) ein eigenes UML-Paket unterhalb des Pakets der Codeliste zu erstellen und dem Paket die Versionsangabe als Namen zu geben. Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> entspricht dieser Empfehlung nicht.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern-CodelisteneinträgeImUMLPaketDerCodelistenversion">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-InstanceSpecification(.) and not(xoev:xoevCodelisteneintragDeprecated(.)) and uml:resolve-classifier(.)/xoev:xoevVersionCodeliste(.)]">
            <sch:let name="codelistenversion" value="uml:resolve-classifier(.)"/>
            <sch:assert role="information" id="rule-CodelisteneinträgeImUMLPaketDerCodelistenversion" test="parent::packagedElement/packagedElement/@xmi:id = $codelistenversion/@xmi:id">Es wird empfohlen, die Codelisteneinträge (UML-Objekte der UML-Klasse der Codelistenversion) im UML-Paket der Codelistenversion abzulegen. Der Codelisteneintrag mit den Werten <sch:value-of select="slot/value/@value"/> der Codelistenversion <sch:value-of select="xgen:model-path($codelistenversion)"/> entspricht dieser Empfehlung nicht.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern-CodelistenNachCodelistenHandbuchModelliert">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[xoev:xsdXModel(.)]">
            <sch:assert role="warning" id="rule-CodelistenNachCodelistenHandbuchModelliert" test="empty((descendant::packagedElement, descendant::nestedClassifier)[uml:is-Enumeration(.) and xoev:xoevCodeliste(.)])">Codelisten sollen der im Codelisten-Handbuch (Version 1.0) dokumentierten Methodik entsprechend modelliert werden. Im XÖV-Fachmodell des Standards liegt mindestens eine Codeliste vor, die einer älteren Methodik entspricht.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.C-CLH-1.0-R35">
        <sch:rule context="
                uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-InstanceSpecification(.) and not(xoev:xoevCodelisteneintragDeprecated(.)) and uml:resolve-classifier(.)/xoev:xoevVersionCodeliste(.) and
                not(uml:resolve-classifier(.)/xoev:dependencies-by-client(.)/uml:resolve-supplier(.)/xoev:xoevCodeliste(.)/@kennung = $bestandskennungen)]">
            <sch:assert id="rule.C-CLH-1.0-R35" role="warning" test="
                    every $value in slot[uml:resolve-definingFeature(.)/xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true']/value/@value
                        satisfies string-length($value) > 0 and not(matches($value, '^\p{Z}*$'))">Codes sollen nicht leer sein oder ausschließlich aus Unicode-Seperatoren (z. B. Leerzeichen oder Zeilenumbrüchen) bestehen, da dies Probleme bzgl. Lesbarkeit und automatischer Weiterverarbeitung verursachen kann. Ein Code im Codelisteneintrag <sch:value-of select="xgen:model-path(.)"/> verletzt diese Regel.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern-NDR-34-Modellierung-von-Codelistenversionen-als-benannte-Typen">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="
                uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Class(.) and xoev:usages-by-client(.)[xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentyp = 'false'] and not(xoev:xsdDraft(.))] |
                uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Class(.) and xoev:usages-by-client(.)[xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentyp = 'false'] and not(xoev:xsdDraft(.))]">
            <sch:assert role="information" id="rule-NDR-34-Modellierung-von-Codelistenversionen-als-benannte-Typen" test="false()">Es wird empfohlen, Codelistenversionen als benannte Typen zu modellieren. Im Kontext des Code-Datentyps <sch:value-of select="xgen:model-path(.)"/> wird diese Empfehlung nicht eingehalten.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern-Korrekte-Codelisten-Ablage">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="/xmi:XMI/uml:Model//packagedElement[(xoev:xoevCodeliste(.) or xoev:xoevVersionCodeliste(.)) and uml:is-Class(.) and not(xoev:xsdDraft(.))]">
            <sch:assert role="error" id="rule-Korrekte-Codelisten-Ablage" test="ancestor::packagedElement[@name = ('eigene Codelisten', 'externe Codelisten')]/parent::packagedElement[@name = 'Codelisten']/parent::uml:Model/@xmi:id = $uml:root-model/@xmi:id or ancestor::packagedElement[@name = 'Externe Modelle']/parent::uml:Model/@xmi:id = $uml:root-model/@xmi:id">Alle eigenen und externen Codelisten (gemäß Abschnitt 8.1 "Codelisten im XÖV-Fachmodell" des XÖV-Handbuchs) müssen, im XÖV-Fachmodell auf oberster Ebene unterhalb eines UML-Pakets "Codelisten" (konkret "Codelisten/eigene Codelisten" oder "Codelisten/externe Codelisten") abgelegt werden. Die Codeliste <sch:value-of select="xgen:model-path(.)"/> entspricht dieser Vorgabe nicht.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern-Keine-Namenskollisionen-bei-benannten-Codelistentypen">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="
                /xmi:XMI/uml:Model//packagedElement[
                xoev:xoevVersionCodeliste(.) and uml:is-Class(.) and not(xoev:xsdDraft(.)) and
                count(
                xoev:usages-by-supplier(.)[xoev:xoevCodeTyp1(.)[not(@benannterCodelistenDatentyp = 'false')]]/
                uml:resolve-client(.)[ancestor::packagedElement/@xmi:id = $xoev:my-xmodel/@xmi:id])
                gt 1]">
            <sch:let name="usages" value="
                    xoev:usages-by-supplier(.)[xoev:xoevCodeTyp1(.)[not(@benannterCodelistenDatentyp = 'false')] and
                    uml:resolve-client(.)[ancestor::packagedElement/@xmi:id = $xoev:my-xmodel/@xmi:id]]"/>
            <sch:assert role="error" id="rule-Keine-Namenskollisionen-bei-benannten-Codelistentypen" test="
                    every $usage1 in $usages
                        satisfies (every $usage2 in $usages[@xmi:id != $usage1/@xmi:id]
                            satisfies
                            not($usage1/(xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentypXSD, uml:resolve-client(.)/ancestor::packagedElement[xoev:xsdSchema(.)]/@xmi:id)[1] =
                            $usage2/(xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentypXSD, uml:resolve-client(.)/ancestor::packagedElement[xoev:xsdSchema(.)]/@xmi:id)[1])
                            or
                            not($usage1/(xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentypName,
                            uml:resolve-supplier(.)/xoev:dependencies-by-client(.)/uml:resolve-supplier(.)/xoev:xoevCodeliste(.)/@nameTechnisch)[1] =
                            $usage2/(xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentypName,
                            uml:resolve-supplier(.)/xoev:dependencies-by-client(.)/uml:resolve-supplier(.)/xoev:xoevCodeliste(.)/@nameTechnisch)[1])
                            or (
                            $usage1/(xoev:xoevCodeTyp1(.)/@genutzteCodeSpalte/xoev:ids-to-elements(., root()),
                            uml:resolve-supplier(.)/ownedAttribute[xoev:xoevCodelistenspalte(.)/@empfohleneCodeSpalte = 'true'],
                            uml:resolve-supplier(.)/ownedAttribute[xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true'])[1]/@xmi:id =
                            $usage2/(xoev:xoevCodeTyp1(.)/@genutzteCodeSpalte/xoev:ids-to-elements(., root()),
                            uml:resolve-supplier(.)/ownedAttribute[xoev:xoevCodelistenspalte(.)/@empfohleneCodeSpalte = 'true'],
                            uml:resolve-supplier(.)/ownedAttribute[xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true'])[1]/@xmi:id
                            and
                            ($usage1/xoev:xoevCodeTyp1(.)/xoev:resolve-typDesCodeElements(.)[@name != 'token']/@xmi:id, 'xs:token')[1] =
                            ($usage2/xoev:xoevCodeTyp1(.)/xoev:resolve-typDesCodeElements(.)[@name != 'token']/@xmi:id, 'xs:token')[1]
                            )
                        )">Wenn für eine Codelistenversion aufgrund der Nutzung in verschiedenen Code-Datentypen mit unterschiedlichen Nutzungseinstellungen mehrere benannte Datentypen in derselben XML Schema-Definition angelegt werden, muss sich der Name dieser Codelisten-Datentypen unterscheiden. Die Code-Datentypen <sch:value-of select="$usages/uml:resolve-client(.)/@name"/> nutzen die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> als benannter Datentyp mit demselben Namen, nutzen jedoch verschiedene Code-Spalten oder legen verschiedene Typen des Code-Elements fest.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern-xoevVersionCodeliste-und-NamedType-schliessen-sich-aus">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevVersionCodeliste(.) and uml:is-Class(.) and not(xoev:xsdDraft(.))]">
            <sch:assert role="error" id="rule-xoevVersionCodeliste-und-xsdNamedType-schliessen-sich-aus" test="not(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.))">Eine Codelistenversion darf nicht mit dem Stereotypen xsdNamedType oder xsdGlobalElementAndNamedType annotiert sein. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe. Hinweis: Ob für eine Codelistenversion ein benannter Datentyp erstellt wird, wird an der Nutzungsbeziehung konfiguriert (Stereotyp xoevCodeTyp1).</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern-benannterCodelistenDatentypXSD-verweist-auf-internes-Schema-Paket">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="
                uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Class(.) and xoev:usages-by-client(.)[xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentypXSD] and not(xoev:xsdDraft(.))] |
                uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Class(.) and xoev:usages-by-client(.)[xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentypXSD] and not(xoev:xsdDraft(.))]">
            <sch:assert role="error" id="rule-benannterCodelistenDatentypXSD-verweist-auf-internes-Schema-Paket" test="xoev:ids-to-elements(xoev:usages-by-client(.)/xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentypXSD, root())[xoev:xsdSchema(.)]/ancestor::packagedElement[xoev:xoevStandard(.)]/@xmi:id = $xoev:my-xmodel/@xmi:id">Das in der Eigenschaft benannterCodelistenDatentypXSD des Stereotyps xoevCodeTyp1 angegebene Paket muss ein zum Standard gehörendes Schema-Paket (xsdSchema) sein. Im Kontext des Code-Datentyps <sch:value-of select="xgen:model-path(.)"/> wird diese Vorgabe nicht eingehalten.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="NDR-28-ValideW3CXMLSchemaDefinitionen-ValideStandardkonfiguration">
        <sch:title>NDR-28: Valide W3C XML Schema-Definitionen</sch:title>
        <sch:p>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</sch:p>
        <sch:rule context="
                /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)/@ermittlungElementreihenfolge = 'Stereotyp' and not(xoev:xsdXModel(.)/@standardeinstellungEigenschaften = 'keine')]">
            <sch:assert role="error" id="ValideStandardkonfiguration" test="false()">Die Standardeinstellung für Eigenschaften mit dem Wert "Stereotyp" und die Ermittlung der Elementreihenfolge mit dem Wert "Element" (Eigenschaften standardeinstellungEigenschaften und ermittlungElementreihenfolge des Stereotyps xsdXModel) schließen sich gegenseitig aus.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.C-CLH-1.2-R42-KorrekteAngabenZurMehrsprachigkeit">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-Class(.) and (xoev:xoevCodeliste(.) or xoev:xoevVersionCodeliste(.)) and not(xoev:xsdDraft(.))]">
            <sch:let name="cl-vcl" value="."/>
            <sch:assert role="error" id="rule.C-CLH-1.2-R42-KorrekteAngabenZurMehrsprachigkeit" test="
                    every $m in (xoev:xoevCodeliste(.)/nameLang[count($cl-vcl/xoev:xoevCodeliste(.)/nameLang) gt 1],
                    xoev:xoevCodeliste(.)/nameKurz[count($cl-vcl/xoev:xoevCodeliste(.)/nameKurz) gt 1],
                    xoev:xoevCodeliste(.)/beschreibung[count($cl-vcl/xoev:xoevCodeliste(.)/beschreibung) gt 1],
                    xoev:xoevCodeliste(.)/herausgebernameLang[count($cl-vcl/xoev:xoevCodeliste(.)/herausgebernameLang) gt 1],
                    xoev:xoevCodeliste(.)/herausgebernameKurz[count($cl-vcl/xoev:xoevCodeliste(.)/herausgebernameKurz) gt 1],
                    xoev:xoevVersionCodeliste(.)/beschreibung[count($cl-vcl/xoev:xoevVersionCodeliste(.)/beschreibung) gt 1],
                    xoev:xoevVersionCodeliste(.)/aenderungZurVorversion[count($cl-vcl/xoev:xoevVersionCodeliste(.)/aenderungZurVorversion) gt 1])
                        satisfies xoev:get-language($m)">Wenn ein mehrsprachiges Metadatenelement mehr als einen Wert besitzt, muss jeder Wert mit einer Sprachangabe in der Form "[xx-XX]" beginnen, wobei "xx-XX" eine Codierung auf der Basis von RFC-5646 darstellen muss, siehe Konformitätskriterien K-11 und K-13 im Codelistenhandbuch. Die Codeliste(nversion) <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.C-CLH-1.2-R40-VollstaendigeSprachauszeichnungFuerCodeliste">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-Class(.) and xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))]">
            <sch:let name="cl" value="."/>
            <sch:assert role="error" id="rule.C-CLH-1.2-R40-VollstaendigeSprachauszeichnungFuerCodeliste" test="
                    every $l in xoev:xoevCodeliste(.)/(nameLang, nameKurz, beschreibung, herausgebernameLang, herausgebernameKurz)/xoev:get-language(.)
                        satisfies
                        (xoev:xoevCodeliste(.)/nameLang[starts-with(., concat('[', $l, ']'))] and
                        xoev:xoevCodeliste(.)/nameKurz[starts-with(., concat('[', $l, ']'))] and
                        xoev:xoevCodeliste(.)/beschreibung[starts-with(., concat('[', $l, ']'))] and
                        xoev:xoevCodeliste(.)/herausgebernameLang[starts-with(., concat('[', $l, ']'))] and
                        xoev:xoevCodeliste(.)/herausgebernameKurz[starts-with(., concat('[', $l, ']'))])">Jede für ein Metadatenelement genutzte Sprache muss ebenso als Sprache für die weiteren mehrsprachigen Metadatenelemente genutzt werden, außer für ein optionales Metadatenelement ist kein Wert angegeben, siehe Konformitätskriterium K-12 im Codelistenhandbuch. Die Codeliste <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.C-CLH-1.2-R40-VollstaendigeSprachauszeichnungFuerVersionCodeliste">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-Class(.) and xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))]">
            <sch:let name="vcl" value="."/>
            <sch:assert role="error" id="rule.C-CLH-1.2-R40-VollstaendigeSprachauszeichnungFuerVersionCodeliste" test="
                    every $l in xoev:xoevVersionCodeliste(.)/(beschreibung, aenderungZurVorversion)/xoev:get-language(.)
                        satisfies
                        ((empty(xoev:xoevVersionCodeliste(.)/beschreibung) or xoev:xoevVersionCodeliste(.)/beschreibung[starts-with(., concat('[', $l, ']'))]) and
                        (empty(xoev:xoevVersionCodeliste(.)/aenderungZurVorversion) or xoev:xoevVersionCodeliste(.)/aenderungZurVorversion[starts-with(., concat('[', $l, ']'))]))">Jede für ein Metadatenelement genutzte Sprache muss ebenso als Sprache für die weiteren mehrsprachigen Metadatenelemente genutzt werden, außer für ein optionales Metadatenelement ist kein Wert angegeben, siehe Konformitätskriterium K-12 im Codelistenhandbuch. Die Codelistenversion <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.C-CLH-1.2-R39-KorrekteAngabeInDeutscherSprache">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-Class(.) and (xoev:xoevCodeliste(.) or xoev:xoevVersionCodeliste(.)) and not(xoev:xsdDraft(.))]">
            <sch:assert role="error" id="rule.C-CLH-1.2-R39-KorrekteAngabeInDeutscherSprache" test="
                    (empty(xoev:xoevCodeliste(.)/nameLang[xoev:get-language(.) != 'de-DE']) or
                    xoev:xoevCodeliste(.)/nameLang[xoev:get-language(.) = 'de-DE']) and
                    (empty(xoev:xoevCodeliste(.)/nameKurz[xoev:get-language(.) != 'de-DE']) or
                    xoev:xoevCodeliste(.)/nameKurz[xoev:get-language(.) = 'de-DE']) and
                    (empty(xoev:xoevCodeliste(.)/beschreibung[xoev:get-language(.) != 'de-DE']) or
                    xoev:xoevCodeliste(.)/beschreibung[xoev:get-language(.) = 'de-DE']) and
                    (empty(xoev:xoevCodeliste(.)/herausgebernameLang[xoev:get-language(.) != 'de-DE']) or
                    xoev:xoevCodeliste(.)/herausgebernameLang[xoev:get-language(.) = 'de-DE']) and
                    (empty(xoev:xoevCodeliste(.)/herausgebernameKurz[xoev:get-language(.) != 'de-DE']) or
                    xoev:xoevCodeliste(.)/herausgebernameKurz[xoev:get-language(.) = 'de-DE']) and
                    (empty(xoev:xoevVersionCodeliste(.)/beschreibung[xoev:get-language(.) != 'de-DE']) or
                    xoev:xoevVersionCodeliste(.)/beschreibung[xoev:get-language(.) = 'de-DE']) and
                    (empty(xoev:xoevVersionCodeliste(.)/aenderungZurVorversion[xoev:get-language(.) != 'de-DE']) or
                    xoev:xoevVersionCodeliste(.)/aenderungZurVorversion[xoev:get-language(.) = 'de-DE'])">Wenn für ein mehrsprachiges Metadatenelement eine Sprache ungleich "de-DE" angegeben ist, muss immer auch ein Wert für die Sprache de-DE mit expliziter Kennzeichnung ("[de-DE]") vorliegen, siehe Konformitätskriterien K-10 und K-11 im Codelistenhandbuch. Die Codeliste(nversion) <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="pattern.C-CLH-1.2-R42-KorrekteSprachangabeInCodelistenspalte">
        <sch:title>Korrekte Codelistenmodellierung</sch:title>
        <sch:rule context="
                uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//ownedAttribute[
                xoev:xoevCodelistenspalte(.)/@sprache[. != ''] and not(xoev:xsdDraft(.))]">
            <sch:assert role="error" id="rule.C-CLH-1.2-R42-KorrekteSprachangabeInCodelistenspalte" test="
                    xoev:xoevCodelistenspalte(.)/@sprache/matches(., '^[a-z]{2}-[A-Z]{2}.*$')">Die Sprachangabe für eine Spalte muss auf der Basis von RFC-5646 kodiert sein (Muster: "xx-XX"), siehe Konformitätskriterium K-13 im Codelistenhandbuch. Die Codelistenspalte <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:let name="bestandskennungen" value="('urn:xoev-de:xdomea:codeliste:anschriftstyp', 'urn:de:dsmeld:schluesseltabelle:religion.nicht.steuererhebend', 'urn:xoev-de:xbau:codeliste:benachrichtigunganlass', 'urn:xoev-de:xbau:codeliste:formellebefundeart', 'urn:de:bund:kba:xkfz:codeliste:quittungsebene', 'urn:xoev-de:xdomea:codeliste:beteiligungsstatus', 'urn:xoev-de:xdomea:codeliste:bewertungsvorschlag', 'urn:xoev-de:xdomea:codeliste:dateiformat', 'urn:de:bund:kba:xkfz:codeliste:rolle', 'urn:xoev-de:xdomea:codeliste:datenaustauschart', 'urn:xoev-de:xdomea:codeliste:kommunikationsart', 'urn:de:bund:kba:xkfz:codeliste:schluesselnummerderueberwachungsinstitutionoderzdk', 'urn:xoev-de:xbau:nw:codeliste:technischeanlage', 'urn:de:bund:kba:xkfz:codeliste:statuselektronischerantrag', 'urn:de:bund:kba:xkfz:codeliste:statuselektronischerantragauskunft', 'urn:xoev-de:xdomea:codeliste:kompressionsverfahren', 'urn:xoev-de:xdomea:codeliste:konfigurationsparameter', 'urn:xoev-de:xdomea:codeliste:medium', 'urn:xoev-de:xdomea:codeliste:nachrichtentyp', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0602', 'urn:de:gkleika:leika:modul', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0604', 'urn:de:xinneres:codeliste:dvdvpraefix', 'urn:de:xinneres:codeliste:nachrichtentyp', 'urn:de:xmeld:schluesseltabelle:behoerdenauskunft.anforderungselement', 'urn:de:xwaffe:codelisten:munitionsbezeichnungkalibersynonym', 'urn:de:xauslaender:codelist:azr:abrufzweck', 'urn:xoev-de:xbau:codeliste:mppvotechnischeanlage', 'urn:de:xauslaender:codelist:azr:artablehnungfeststellungdtstaatsangehoerigkeit', 'urn:de:xauslaender:codelist:azr:artderanerkennung', 'urn:de:xauslaender:codelist:azr:artderaugenfarbe', 'urn:de:xauslaender:codelist:azr:artderauslieferungdurchlieferung', 'urn:de:xauslaender:codelist:azr:artderaussiedlereigenschaft', 'urn:de:xauslaender:codelist:azr:artderintegrationsundarbeitsvermittlungsdaten', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0606', 'urn:de:xmeld:schluesseltabelle:xmeldit.aenderungsart', 'urn:de:xauslaender:codelist:aenderungsart', 'urn:dsmeld:schluesseltabelle:religion.nicht.steuererhebend', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0607', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0609', 'urn:de:xauslaender:codelist:azr:artderschule', 'urn:de:xauslaender:codelist:abhabh:aktenanforderung:antwort', 'urn:de:xauslaender:codelist:abhabh:aktenanforderung:grund', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0612', 'urn:de:xauslaender:codelist:abhbamf:integration:kurseigenschaften', 'urn:xoev-de:bund:kba:codeliste:artderbremse', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0615', 'urn:de:xauslaender:codelist:abhmb:grundderablehnung', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0616', 'urn:de:xauslaender:codelist:aufenthaltsantrag:entscheidung', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0617', 'urn:de:xauslaender:codelist:aufenthaltsantrag:gegenstand', 'urn:de:xauslaender:codelist:aufenthaltsantrag:ohneentscheidung', 'urn:de:xauslaender:codelist:aufenthaltsbeginart', 'urn:de:xauslaender:codelist:aufenthaltsendesart', 'urn:de:xauslaender:codelist:azr:artderverurteilung', 'urn:de:xauslaender:codelist:aufenthaltszweckart', 'urn:de:xauslaender:codelist:ausweisart', 'urn:de:xauslaender:codelist:azr:aenderungsart', 'urn:de:xauslaender:codelist:azr:anderername', 'urn:de:xwaffe:codelisten:munitionsbezeichnungkaliber', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0620', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0621', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0623', 'urn:de:xauslaender:codelist:azr:artdesausreiseverbots', 'urn:xoev-de:bund:kba:codeliste:artderuntersuchungsstelle', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0624', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0625', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0626', 'urn:xoev-de:bund:kba:codeliste:artdesdokuments', 'urn:xoev-de:bund:kba:codeliste:artdesgeschaeftsvorfalls', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0631', 'urn:xoev-de:bund:kba:codeliste:artdesgutachtens', 'urn:xoev-de:xdomea:codeliste:transportweg', 'urn:xoev-de:bund:kba:codeliste:artdesmandats', 'urn:xoev-de:bund:kba:codeliste:artdessiegels', 'urn:xoev-de:xdomea:codeliste:vertraulichkeitsstufe', 'urn:xoev-de:xgewerbeanzeige:codeliste:artdereintragung', 'urn:de:xauslaender:codelist:azr:artdesberufs', 'urn:de:xauslaender:codelist:azr:artdeskursabschlusses', 'urn:xoev-de:xgewerbeanzeige:codeliste:empfaengerklassen', 'urn:xoev-de:bund:kba:codeliste:bearbeitungsart', 'urn:xoev-de:bund:kba:codeliste:datengruppenregistersatz', 'urn:xoev-de:xgewerbeanzeige:codeliste:grundfueranmeldung', 'urn:xoev-de:xgewerbeanzeige:codeliste:geschlecht', 'urn:xoev-de:xgewerbeanzeige:codeliste:janein', 'urn:xoev-de:xgewerbeanzeige:codeliste:korrekturgrund', 'urn:xoev-de:bund:kba:codeliste:ergebnisderuntersuchung', 'urn:xoev-de:xgewerbeanzeige:codeliste:nachrichtentypen', 'urn:de:xauslaender:codelist:azr:artdeskurses', 'urn:xoev-de:bund:kba:codeliste:kennzeichenformat', 'urn:xoev-de:xgewerbeanzeige:codeliste:rechtsformen', 'urn:de:xauslaender:codelist:azr:artdesschulabschlusses', 'urn:xoev-de:bund:kba:codeliste:nachrichtentyp', 'urn:de:xauslaender:codelist:azr:artdesstraftatverdachts', 'urn:xoev-de:bund:kba:codeliste:nummerderfeinstaubplakette', 'urn:xoev-de:xjustiz:codeliste:bnotk.empfangstyp.ztr', 'urn:de:xauslaender:codelist:bamfabh:asyl:abschlussinformationen', 'urn:de:xauslaender:codelist:bamfabh:asyl:antragsniederschrift', 'urn:xoev-de:bund:kba:codeliste:positionderbremse', 'urn:de:xauslaender:codelist:abhmb:grundderabmeldung', 'urn:de:xauslaender:codelist:bamfabh:asyl:asylantrag', 'urn:de:xauslaender:codelist:bamfabh:asyl:feststellungsinformationen', 'urn:de:xauslaender:codelist:bamfabh:asyl:gerichtsinstanz', 'urn:xoev-de:xjustiz:codeliste:bnotk.empfangstyp.ztr.bw', 'urn:de:xauslaender:codelist:bamfabh:asyl:personendaten:aenderungsgrund', 'urn:de:xauslaender:codelist:bamfabh:int:auskunftnichtmoeglich', 'urn:xoev-de:xjustiz:codeliste:bnotk.mitteilungstyp.ztr.bw', 'urn:de:xauslaender:codelist:azr:arteinschraenkungpolitischebetaetigung', 'urn:de:xauslaender:codelist:azr:artpassrechtlichemassnahmen', 'urn:de:xauslaender:codelist:azr:artpersonalie', 'urn:de:xauslaender:codelist:dokumentformat', 'urn:de:xauslaender:codelist:familienstand', 'urn:de:xauslaender:codelist:fehlercodes:synchron', 'urn:de:xauslaender:codelist:gericht', 'urn:de:xauslaender:codelist:int:behoerdentyp', 'urn:de:xauslaender:codelist:azr:artueberwachungsmassnahme', 'urn:de:xauslaender:codelist:mbabh:abmeldung', 'urn:de:xauslaender:codelist:mbauskunftssperre', 'urn:de:xauslaender:codelist:nebenbestimmungen:beschaeftigung', 'urn:xoev-de:xjustiz:codeliste:bnotk.urkunde.status.ztr', 'urn:de:xauslaender:codelist:nebenbestimmungen:bildungsweg', 'urn:xoev-de:xjustiz:codeliste:grbu.belastungsart.abtiii', 'urn:de:xauslaender:codelist:nebenbestimmungen:erloeschen', 'urn:de:xauslaender:codelist:nebenbestimmungen:oertlichebeschraenkung', 'urn:xoev-de:bund:kba:codeliste:quittungsebene', 'urn:de:xauslaender:codelist:nebenbestimmungen:selbstaendig', 'urn:de:xauslaender:codelist:religion', 'urn:xoev-de:xjustiz:codeliste:grbu.dokumentart', 'urn:de:xauslaender:codelist:vertretungsart', 'urn:xoev-de:xjustiz:codeliste:grbu.rang', 'urn:de:xauslaender:codelist:vonamtswegen', 'urn:de:xauslaender:codelist:wohnungsstatus', 'urn:de:xauslaender:codelist:azr:artzurueckweisungzurueckschiebung', 'urn:xoev-de:xjustiz:codeliste:grbu.rollenbezeichnung', 'urn:xoev-de:bund:kba:codeliste:statuselektronischerantrag', 'urn:de:xwaffe:codelisten:herstellerbezeichnungsammlung', 'urn:xoev-de:xauslaender:codeliste:asyl:datenberichtigungsanlass', 'urn:xoev-de:xjustiz:codeliste:reg.besondere-befreiung', 'urn:xoev-de:xauslaender:codeliste:asyl:einstellungsgrund', 'urn:xoev-de:xjustiz:codeliste:reg.dokumentart', 'urn:xoev-de:xauslaender:codeliste:asyl:fortfuehrungsantragart', 'urn:xoev-de:xauslaender:codeliste:asyl:prognosefolgeantrag', 'urn:de:xauslaender:codelist:azr:asylstatus', 'urn:xoev-de:xauslaender:codeliste:asyl:ruecknahmegrund', 'urn:de:bund:bzst:schluessel:rts.fehlercodes', 'urn:de:xauslaender:codelist:azr:aufenthaltserlaubnis', 'urn:de:xauslaender:codelist:azr:aufenthaltsgestattung', 'urn:xoev-de:xjustiz:codeliste:reg.dokumentstatus', 'urn:de:xauslaender:codelist:azr:dokumentenformat', 'urn:de:xauslaender:codelist:azr:dokumenttyp', 'urn:de:xauslaender:codelist:azr:entscheidungba', 'urn:de:xauslaender:codelist:azr:euaufenthaltsrecht', 'urn:de:xauslaender:codelist:azr:familienbeziehung', 'urn:de:xauslaender:codelist:azr:gesundheitsdatenart', 'urn:de:xauslaender:codelist:azr:graddersprachkenntnis', 'urn:de:xauslaender:codelist:azr:trefferkategorie', 'urn:de:xauslaender:codelist:azr:lichtbildgroesse', 'urn:de:dsmeld:schluesseltabelle:auskunftssperre', 'urn:de:xauslaender:codelist:azr:meldestatusart', 'urn:de:xauslaender:codelist:azr:artderfestnahmeaufenthaltsermittlung', 'urn:de:xauslaender:codelist:azr:nebenbestimmungerwerbstaetigkeit', 'urn:de:xauslaender:codelist:azr:rechtsstellung', 'urn:xoev-de:xjustiz:codeliste:reg.rollenbezeichnung', 'urn:xoev-de:xjustiz:codeliste:reg.status-rechtstraeger', 'urn:de:xauslaender:codelist:azr:sicherheitsleistung', 'urn:de:dsmeld:schluesseltabelle:staatsangehoerigkeit.glaubhaftmachung', 'urn:de:xauslaender:codelist:azr:sicherheitsrechtlichebefragung', 'urn:de:xauslaender:codelist:azr:sichtbarkeitdessuchvermerks', 'urn:de:xauslaender:codelist:azr:suchprofil', 'urn:xoev-de:bund:kba:codeliste:typdergebuehrenaufstellung', 'urn:de:xauslaender:codelist:azr:suchvermerk', 'urn:xoev-de:bund:kba:codeliste:typdesidentifikationsdokuments', 'urn:de:xauslaender:codelist:azr:uebermittlungssperre', 'urn:de:xauslaender:codelist:azr:unerlaubteeinreiseundaufenthaltart', 'urn:de:xauslaender:codelist:azr:verfuegungstextstatus', 'urn:xoev-de:bund:kba:codeliste:versandart', 'urn:de:xauslaender:codelist:azr:zustimmungsfreiebeschaeftigung', 'urn:xoev-de:bund:kba:xkfz:codeliste:statusprozessschritt', 'urn:de:bund:bfj:schluesseltabelle:anerkennungsform.sonstige', 'urn:de:bund:bfj:schluesseltabelle:anerkennungsform.ueberbeglaubigung', 'urn:de:bund:bfj:schluesseltabelle:fuehrungszeugnis.anfrageart', 'urn:de:bund:bfj:schluesseltabelle:fuehrungszeugnis.gebuehr', 'urn:de:xmeld:schluesseltabelle:antwortstatus', 'urn:de:xmeld:schluesseltabelle:azr.anlass', 'urn:de:xmeld:schluesseltabelle:behoerdenauskunft.aktualitaet.suche.status', 'urn:de:xmeld:schluesseltabelle:behoerdenauskunft.ergebnisstatus', 'urn:de:xmeld:schluesseltabelle:lra.aenderung.anlass', 'urn:de:xmeld:schluesseltabelle:behoerdenauskunft.nichterstellung.grund', 'urn:de:xmeld:schluesseltabelle:bzst.anforderung.idnr', 'urn:xoev-de:xdomea:codeliste:aussonderungsart', 'urn:de:xmeld:schluesseltabelle:bzst.antwort.idnr-ehegatte-lebenspartner', 'urn:de:xmeld:schluesseltabelle:bzst.beendigung.der.zustaendigkeit', 'urn:de:xmeld:schluesseltabelle:bzst.hinweis.auf.inkonsistenz', 'urn:de:xmeld:schluesseltabelle:bzst.hinweis.auf.inkonsistenz.rolle.beteiligte.person', 'urn:de:xmeld:schluesseltabelle:dsrv.anlass.bruttolieferung', 'urn:de:xmeld:schluesseltabelle:ehegatte.oder.lebenspartner', 'urn:de:xmeld:schluesseltabelle:fortschreibung.datenuebermittlungsanlaesse.fachspezifisch', 'urn:de:xmeld:schluesseltabelle:melderegister.abweichung', 'urn:de:xmeld:schluesseltabelle:melderegisterauskunft.ergebnisstatus', 'urn:de:xmeld:schluesseltabelle:melderegisterauskunft.nichterstellung.grund', 'urn:de:xmeld:schluesseltabelle:melderegisterauskunft.optionen', 'urn:de:xmeld:schluesseltabelle:melderegisterauskunft.zusatzinformation', 'urn:de:xmeld:schluesseltabelle:mime-type', 'urn:de:xmeld:schluesseltabelle:partnerdaten.anlass.der.fortschreibung', 'urn:de:xmeld:schluesseltabelle:partnerschaftsinformation', 'urn:de:xmeld:schluesseltabelle:quittung.ebene', 'urn:de:xmeld:schluesseltabelle:ruecksendung.einer.nachricht', 'urn:de:xmeld:schluesseltabelle:stornierung', 'urn:de:xmeld:schluesseltabelle:vorausgefuellter.meldeschein.antwortstatus', 'urn:de:xmeld:schluesseltabelle:xmeld.datenuebermittlungsanlaesse', 'urn:de:xmeld:schluesseltabelle:xmeldit.art.der.untersuchung', 'urn:de:xmeld:schluesseltabelle:xmeldit.konsequenz.fehler', 'urn:xoev-de:xdomea:codeliste:datentyp', 'urn:xoev-de:xmeld:codeliste:xmeld.fortschreibung.aenderungsart', 'urn:xoev-de:xmeld:codeliste:xmeld.kirche.hintergrundinformation', 'urn:de:xauslaender:codelist:azr:artdesanlassesderausschreibung', 'urn:xoev-de:bund:kba:codeliste:artdergebuehr', 'urn:xoev-de:xdomea:codeliste:konfigurationsparametergruppe', 'urn:de:xauslaender:codelist:azr:artderausschreibung', 'urn:xoev-de:xdomea:codeliste:schriftgutobjekttyp', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0601', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0603', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0605', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0608', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0610', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0611', 'urn:xoev-de:xjustiz:codeliste:reg.mitteilungsart', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0613', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0614', 'urn:xoev-de:xbau:codeliste:xbau-fehlerkennzahlen', 'urn:de:bund:kba:xkfz:codeliste:typderreferenz', 'urn:de:bund:kba:xkfz:codeliste:typderreferenzdatei', 'urn:de:bund:kba:xkfz:codeliste:typderuntersuchung', 'urn:de:bund:kba:xkfz:codeliste:typdeskontakts', 'urn:de:bund:kba:xkfz:codeliste:versandart', 'urn:de:bund:kba:xkfz:codeliste:xkfzkommunikationspartner', 'urn:de:bund:kba:xkfz:codeliste:waehrung', 'urn:de:dsmeld:schluesseltabelle:anschrift.unbekannt', 'urn:de:dsmeld:schluesseltabelle:familienstand', 'urn:de:dsmeld:schluesseltabelle:familienstand.beendigungsgrund', 'urn:de:dsmeld:schluesseltabelle:gesetzlicher.vertreter', 'urn:de:dsmeld:schluesseltabelle:geschlecht', 'urn:de:dsmeld:schluesseltabelle:passversagung.status', 'urn:de:dsmeld:schluesseltabelle:religion.steuererhebend', 'urn:de:dsmeld:schluesseltabelle:wahlausschluss', 'urn:de:dsmeld:schluesseltabelle:wohnungsart', 'urn:de:dsmeld:schluesseltabelle:wohnungsstatus', 'urn:de:fim:leika:modul', 'urn:de:fim:leika:verrichtung', 'urn:de:gkleika:leika:leistungsgruppierung', 'urn:de:gkleika:leika:typisierung', 'urn:de:xauslaender:codelist:aufenthaltsstatusart', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0618', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0619', 'urn:xoev-de:xauslaender:codeliste:sprachenkatalog', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0622', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:bundesland', 'urn:de:xauslaender:codelist:azr:verpflichtungserklaerung', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0627', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0628', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0632', 'urn:xoev-de:fim:codeliste:ozg-themenfeld', 'urn:xoev-de:xgewerbeanzeige:codeliste:artdermeldung', 'urn:xoev-de:xgewerbeanzeige:codeliste:artderniederlassung', 'urn:xoev-de:xgewerbeanzeige:codeliste:funktioneinerperson', 'urn:xoev-de:xgewerbeanzeige:codeliste:grundfuerabmeldung', 'urn:de:xauslaender:codelist:nachrichtentyp', 'urn:de:xauslaender:codelist:bamftgs:int:verkuerzennichtmoeglich', 'urn:de:xfalldaten:kommunikationskanal', 'urn:de:xmeld:schluesseltabelle:melderegisterauskunft.gewerblicher.zweck', 'urn:de:xmeld:schluesseltabelle:rueckweisungsgrund', 'urn:de:xoev:codeliste:erreichbarkeit', 'urn:de:xoev:codeliste:koordinatensystemtyp', 'urn:de:xprozess:codeliste:modellierungsmethode', 'urn:de:bund:kba:xkfz:codeliste:sucheinschraenkungkennzeichen', 'urn:de:bund:kba:xkfz:codeliste:rechtsgrundlagehalterauskunft', 'urn:de:xprozess:codeliste:zwecksetzung', 'urn:de:xta:codeliste:business.scenario', 'urn:de:xta:codeliste:report.type', 'urn:de:xta:codeliste:type.of.party.identifier', 'urn:de:bund:kba:xkfz:codeliste:nutzungbankverbindung', 'urn:de:bund:kba:xkfz:codeliste:statusgutachten', 'urn:de:bund:kba:xkfz:codeliste:typdesidentifikationsdokuments', 'urn:de:xzufi:codeliste:zustaendigkeitsrolle', 'urn:eu:commission:regulation:105:2007:nuts:nuts-1', 'urn:xoev-de:bund:bamf:codeliste:integration:fehlercodes:synchron.spezifisch', 'urn:xoev-de:xbau:codeliste:baulicheanlagen.sonstige', 'urn:de:xauslaender:codelist:bamfabh:int:kursart', 'urn:xoev-de:bund:bamf:codeliste:asyl:bamfaussenstellen', 'urn:de:xauslaender:codelist:azr:artdergrenzfahndung', 'urn:de:bund:bamf:codelist:integration:ablehnungsgrund', 'urn:de:xauslaender:codelist:bamfabh:integration:artberechtigung', 'urn:de:xauslaender:codelist:azr:artdesanlassesdergrenzfahndung', 'urn:xoev-de:kosit:codeliste:icd', 'urn:de:xauslaender:codelist:bamfabh:int:verpflichtungnichtmoeglich', 'urn:de:xauslaender:codelist:integration:ba.dienststellen', 'urn:de:bund:bamf:codelist:berd:fehlercode', 'urn:de:bund:bamf:codelist:berd:dublettenverdacht', 'urn:de:bund:bamf:codelist:berd:ablehnungsgrund', 'urn:de:bund:bamf:codelist:berd:aufenthaltsstatus', 'urn:xoev-de:bund:bmj:codeliste:fundstellennachweis.bund.a', 'urn:de:bund:bamf:codelist:berd:modulart', 'urn:xoev-de:bund:destatis:codeliste:xmeld.zensus.rueckweisung-fehlercodes', 'urn:xoev-de:bund:destatis:codeliste:xmeld.zenus.rueckweisung-fehlercodes', 'urn:xoev-de:bund:kba:codeliste:artdermonetaereneinnahme', 'urn:xoev-de:bund:kba:codeliste:artderumruestung', 'urn:xoev-de:bund:kba:codeliste:artderunterlage', 'urn:xoev-de:bund:kba:codeliste:artderuntersuchung', 'urn:xoev-de:bund:kba:codeliste:artderzahlung', 'urn:xoev-de:bund:kba:codeliste:auskunftsmedium', 'urn:xoev-de:bund:kba:codeliste:kbaarbeitsgang', 'urn:xoev-de:bund:kba:codeliste:kurzzeichenherstellerdruckstuecke', 'urn:xoev-de:bund:kba:codeliste:lieferdienst', 'urn:xoev-de:bund:kba:codeliste:nutzungbankverbindung', 'urn:xoev-de:bund:kba:codeliste:prozessschrittname', 'urn:xoev-de:bund:kba:codeliste:prueforganisation', 'urn:xoev-de:bund:kba:codeliste:quittungsart', 'urn:de:bund:bamf:codelist:berd:artbeschaeftigung', 'urn:xoev-de:bund:kba:codeliste:rechtsgrundlagehalterauskunft', 'urn:xoev-de:bund:kba:codeliste:rolle', 'urn:de:xpersonenstand:codeliste:staat', 'urn:de:xpersonenstand:codeliste:staatsangehoerigkeit', 'urn:xoev-de:bund:kba:codeliste:statuselektronischerantragauskunft', 'urn:xpersonenstand:schluesseltabelle:aufenthaltsstatus', 'urn:xpersonenstand:schluesseltabelle:beendigungsgrundfamilienstand', 'urn:xpersonenstand:schluesseltabelle:beschlussart', 'urn:xpersonenstand:schluesseltabelle:bestattungsart', 'urn:xpersonenstand:schluesseltabelle:familienstand', 'urn:xpersonenstand:schluesseltabelle:familienstandpersonenstandswesen', 'urn:xpersonenstand:schluesseltabelle:geschlecht', 'urn:xpersonenstand:schluesseltabelle:namensart', 'urn:xpersonenstand:schluesseltabelle:registerart', 'urn:xpersonenstand:schluesseltabelle:wahlehename', 'urn:xpersonenstand:schluesseltabelle:wahllpname', 'urn:xoev-de:bund:kba:codeliste:statusgutachten', 'urn:xoev-de:bund:kba:codeliste:sucheinschraenkungkennzeichen', 'urn:xoev-de:bund:kba:codeliste:systemcode', 'urn:xoev-de:bund:kba:codeliste:typderreferenzdatei', 'urn:xoev-de:bund:kba:codeliste:typderuntersuchung', 'urn:xoev-de:bund:kba:codeliste:typdesdokuments', 'urn:xoev-de:bund:kba:codeliste:typdeskennzeichens', 'urn:xoev-de:bund:kba:codeliste:typdeskontakts', 'urn:xoev-de:bund:kba:codeliste:waehrung', 'urn:de:bund:bamf:codelist:berd:artberechtigungverpflichtung', 'urn:xoev-de:bund:kba:xkfz:codeliste:herstellerdruckstuecke', 'urn:xoev-de:bund:kba:xkfz:codeliste:steuerzahlweise', 'urn:xoev-de:kirche:codeliste:xmeld.kirchen.rts-fehlercodes', 'urn:xoev-de:kosit:codeliste:handwerkskammern', 'urn:xoev-de:stala:codeliste:xmeld.statistik.bevstatg.rueckweisung-fehlercodes', 'urn:xoev-de:xbau:codeliste:erleichterung.gegenstand', 'urn:xoev-de:xdomea:codeliste:allgemeinerueckmeldung', 'urn:xoev-de:xbau:codeliste:xbau-mimetypes', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:synopse-gebiete', 'urn:xoev-de:bund:kba:codeliste:kba-arbeitsgang', 'urn:xoev-de:kosit:codeliste:eas', 'urn:xoev-de:bund:kba:codeliste:typderreferenz', 'urn:xoev-de:bund:kba:codeliste:quittungscode', 'urn:xoev-de:fim:codeliste:sdginformationsbereich', 'urn:xoev-de:fim:codeliste:ozg-lage', 'urn:xoev-de:fim:codeliste:ozg-leistung', 'urn:xoev-de:xgewerbeanzeige:codeliste:grundfuerummeldung', 'urn:de:dvzmv:codelisten:verarbeitung', 'urn:xoev-de:xgewerbeanzeige:codeliste:handwerkskammern', 'urn:xoev-de:fim:codeliste:onlinedienstlinktyp', 'urn:de:dvzmv:nwr:codelisten:verarbeitung', 'urn:xoev-de:fim:codeliste:identifizierungsmittel', 'urn:xoev-de:bund:kba:codeliste:nachrichtentypen', 'urn:de:xauslaender:codelist:azr:artdesausweispruefungsergebnis', 'urn:de:xauslaender:codelist:azr:wohnsitzauflage', 'urn:de:xauslaender:codelist:azr:artdeseinreiseaufenthaltsverbots', 'urn:de:xauslaender:codelist:azr:artderabschiebung', 'urn:de:xauslaender:codelist:azr:artdesausreisenachweis', 'urn:de:xauslaender:codelist:azr:artderausweisung', 'urn:de:xauslaender:codelist:azr:artderausreisefoerderung', 'urn:de:xauslaender:codelist:azr:artdesabschiebungsverbots', 'urn:xoev-de:xjustiz:codeliste:bnotk.dokumententyp.ztr.bw', 'urn:xoev-de:xjustiz:codeliste:bnotk.registrierung.status.ztr.bw', 'urn:xoev-de:xauslaender:codeliste:asyl:abschlusssachverhalt', 'urn:de:xauslaender:codelist:volkszugehoerigkeit', 'urn:de:xauslaender:codelist:azr:niederlassungserlaubnis', 'urn:xoev-de:xjustiz:codeliste:grbu.berechtigungsveraeltnis', 'urn:de:xauslaender:codelist:azr:aufenthaltsstatus', 'urn:xoev-de:xjustiz:codeliste:grbu.berechtigungsverhaeltnis', 'urn:xoev-de:bund:kba:codeliste:stba', 'urn:de:fim:leika:leistungsgruppierung', 'urn:xoev-de:xauslaender:codeliste:asyl:teilabschlusssachverhalt', 'urn:xoev-de:bund:bmi:bit:codeliste:dvdv.praefix', 'urn:xoev-de:bund:bva:azr:codeliste:xmeld.fachliche-fehlercodes', 'urn:xoev-de:fim:codeliste:xzufi.anschrifttyp', 'urn:xoev-de:fim:codeliste:xzufi.begriffimkontexttyp', 'urn:xoev-de:xbau:codeliste:abweichungart', 'urn:xoev-de:fim:codeliste:xzufi.fristtyp', 'urn:xoev-de:xbau:codeliste:baumassnahme', 'urn:xoev-de:xbau:codeliste:bautechnischernachweisart', 'urn:xoev-de:xbau:codeliste:bauvorlageberechtigungsachverhalt', 'urn:xoev-de:fim:codeliste:xzufi.hierarchietyp', 'urn:xoev-de:xbau:codeliste:bauweise', 'urn:xoev-de:xbau:codeliste:beteiligungrolle', 'urn:xoev-de:fim:codeliste:xzufi.kostentyp', 'urn:xoev-de:xbau:codeliste:formellebefundeantragart', 'urn:xoev-de:fim:codeliste:xzufi.leistungsadressat', 'urn:xoev-de:xbau:codeliste:genehmigungsfreistellung', 'urn:xoev-de:fim:codeliste:xzufi.nachrichtantwortcode', 'urn:xoev-de:xbau:codeliste:mbogaragentyp', 'urn:xoev-de:xbau:codeliste:mbogebaeudeklasse', 'urn:xoev-de:fim:codeliste:xzufi.onlinedienstdynamischerparametertyp', 'urn:xoev-de:fim:codeliste:xzufi.signatur', 'urn:xoev-de:xbau:codeliste:mbosonderbauten', 'urn:xoev-de:xbau:codeliste:mppvobauwerksklasse', 'urn:xoev-de:fim:codeliste:xzufi.tagesposition', 'urn:xoev-de:fim:codeliste:xzufi.tagestyp', 'urn:xoev-de:xbau:codeliste:mppvonachpruefunggrund', 'urn:xoev-de:fim:codeliste:xzufi.zeiteinheit', 'urn:xoev-de:xbau:codeliste:mppvopruefungtechnischeanlageanlass', 'urn:xoev-de:xbau:codeliste:mppvotechnischeanlageweiterbetrieb', 'urn:xoev-de:fim:codeliste:xzufi.zeitserientyp', 'urn:xoev-de:xbau:codeliste:nebenbestimmungart', 'urn:xoev-de:fim:codeliste:xzufi.zustaendigkeitskriterium', 'urn:xoev-de:xbau:codeliste:statistikmeldunganlass', 'urn:xoev-de:xbau:codeliste:vorbescheidbetreff', 'urn:xoev-de:xbau:codeliste:vorlagenbauantragbauvorhaben', 'urn:xoev-de:xbau:codeliste:vorlagenbauantragbearbeitung', 'urn:xoev-de:xbau:codeliste:vorlagenbauzustand', 'urn:xoev-de:xbau:codeliste:xbau-nachrichten', 'urn:xoev-de:xfim:codeliste:xzufi.leistungsklasse', 'urn:xoev-de:kosit:codeliste:rec21', 'urn:de:xauslaender:codelist:int:abschlusstestartsprache', 'urn:xoev-de:kosit:codeliste:currency-codes', 'urn:de:xauslaender:codelist:int:abschlusstestdatensprache', 'urn:xoev-de:kosit:codeliste:vatex', 'urn:xoev-de:kosit:codeliste:untdid.1001', 'urn:de:xauslaender:codelist:int:abschlusstestergebnisinterpretation', 'urn:xoev-de:kosit:codeliste:untdid.1153', 'urn:xoev-de:kosit:codeliste:untdid.2005', 'urn:xoev-de:kosit:codeliste:untdid.4451', 'urn:xoev-de:kosit:codeliste:untdid.5189', 'urn:xoev-de:kosit:codeliste:untdid.5305', 'urn:xoev-de:kosit:codeliste:untdid.7143', 'urn:xoev-de:kosit:codeliste:mime-type-xrechnung', 'urn:xoev-de:kosit:codeliste:rec20', 'urn:xoev-de:kosit:codeliste:untdid.7161', 'urn:xoev-de:bund:bfj:codeliste:bfjstaat', 'urn:xoev-de:kosit:codeliste:country-codes', 'urn:xoev-de:bund:bfj:codeliste:bfj.berichtigungart', 'urn:xoev-de:bund:bfj:codeliste:bfj.staat', 'urn:xoev-de:bund:bfj:codeliste:bfj.fehlerkennzahl', 'urn:de:xauslaender:codelist:azr:artderduldung', 'urn:xoev-de:bund:bfj:codeliste:bfj.geschlecht', 'urn:xoev-de:xgewerbeanzeige:codeliste:schematron-fehlercodes', 'urn:xoev-de:bund:bfj:codeliste:bfj.uebermittelndestelle', 'urn:xoev-de:bund:bfj:codeliste:bfj.waehrung', 'urn:xoev-de:xgewerbeanzeige:codeliste:beteiligungoeffentlichehand', 'urn:xoev-de:bund:bfj:codeliste:bzr.behoerdenfuehrungszeugnisgrund', 'urn:de:xauslaender:codelist:azr:sachverhaltsgruppe', 'urn:xoev-de:bund:bfj:codeliste:bzr.benachrichtigunggrund', 'urn:xoev-de:bund:bfj:codeliste:bzr.freiheitsentziehungart', 'urn:de:bund:ba:codelist:integration:ba.dienststellen', 'urn:xoev-de:bund:bfj:codeliste:bfj.gebuehrenbefreiunggrund', 'urn:xoev-de:bund:bfj:codeliste:bzr.hinweisanlass', 'urn:xoev-de:bund:bfj:codeliste:bzr.hinweisart', 'urn:xoev-de:xgewerbeanzeige:codeliste:laenderkennziffern', 'urn:xoev-de:xgewerbeanzeige:codeliste:status', 'urn:xoev-de:xgewerbeanzeige:codeliste:unfallversicherungstraeger', 'urn:xoev-de:xgewerbeanzeige:codeliste:verdachtsmomente', 'urn:xoev-de:xgewerbeanzeige:codeliste:ursachefuerabmeldung', 'urn:xoev-de:xgewerbeanzeige:codeliste:weiterekommunikationspartner', 'urn:xoev-de:xjustiz:codeliste:bnotk.dokumententyp.ztr', 'urn:xoev-de:bund:bfj:codeliste:bzr.identitaetsdokumentart', 'urn:xoev-de:xjustiz:codeliste:bnotk.mitteilungstyp.ztr', 'urn:xoev-de:xjustiz:codeliste:bnotk.registrierung.status.ztr', 'urn:xoev-de:bund:bfj:codeliste:bzr.textkennzahl', 'urn:de:xauslaender:codelist:azr:artdereinreisebedenken', 'urn:xoev-de:xjustiz:codeliste:bnotk.vorgangsart.ztr', 'urn:xoev-de:xjustiz:codeliste:bnotk.urkunde.status.ztr.bw', 'urn:xoev-de:xjustiz:codeliste:grbu.auszugsart', 'urn:xoev-de:xjustiz:codeliste:bnotk.vorgangsart.ztr.bw', 'urn:xoev-de:xjustiz:codeliste:grbu.belastungsart.abtii', 'urn:de:xauslaender:codelist:azr:deutschestaatsangehoerigkeitart', 'urn:xoev-de:xjustiz:codeliste:grbu.ereignis', 'urn:xoev-de:mv:em:codeliste:xprozess:handlungsgrundlagenart', 'urn:xoev-de:bund:bfj:codeliste:gzr.verwendungszweckbehoerdenvorlage', 'urn:xoev-de:xjustiz:codeliste:grbu.veraenderungen.abtii', 'urn:xoev-de:xjustiz:codeliste:grbu.veraenderungen.abtiii', 'urn:xoev-de:bund:bfj:codeliste:gzr.gewerbeart', 'urn:xoev-de:xjustiz:codeliste:reg.allgemeine-befreiung', 'urn:xoev-de:xjustiz:codeliste:reg.allgemeine-vertretungsregelung', 'urn:xoev-de:xjustiz:codeliste:reg.besondere-vertretungsregelung', 'urn:xoev-de:xjustiz:codeliste:reg.eintragungsart', 'urn:xoev-de:xjustiz:codeliste:reg.rechtsform', 'urn:xoev-de:xjustiz:codeliste:reg.mitteilungsgsart', 'urn:xoev-de:bund:bfj:codeliste:gzr.gewerbeschluessel', 'urn:xoev-de:xjustiz:codeliste:reg.sachliche-erweiterung-prokura', 'urn:xoev-de:xpersonenstandsregister:codeliste:geschlecht', 'urn:xoev-de:xpersonenstand:codelist:nachrichtentyp', 'urn:xoev-de:xrechnung:codeliste:untdid.4461', 'urn:xoev-de:bund:bfj:codeliste:gzr.rechtsform', 'urn:xoev-de:bund:bfj:codeliste:gzr.oeffentlichesregister', 'urn:xoev-de:bund:bfj:codeliste:gzr.rechtsvorschriften', 'urn:de:bund:bamf:codelist:integration:nachfragegrund', 'urn:de:bund:bfj:schluesseltabelle:behoerdenkennzeichen', 'urn:de:bund:bfj:schluesseltabelle:fuehrungszeugnis.verwendungszweck', 'urn:de:bund:bfj:schluesseltabelle:justizbehoerdenkennzeichen', 'urn:xoev-de:bund:bfj:codeliste:nachrichtencode.bzr.anfrageaehnlichenservice', 'urn:de:bund:bmi:meldewesen:schluessel:religion_nicht_steuererhebend', 'urn:de:bund:bmi:meldewesen:schluessel:religion_steuererhebend', 'urn:de:bund:bzst:schluessel:fachliche.fehlercodes', 'urn:xoev-de:xgewerbeanzeige:codeliste:rueckweisungsgruende', 'urn:xoev-de:bund:bfj:codeliste:gzr.textkennzahl', 'urn:xoev-de:bund:bfj:codeliste:nachrichtencode.bzr.anfrageunbeschraenkteauskunft', 'urn:xoev-de:bund:bfj:codeliste:nachrichtencode.bzr.antragbehoerdenfuehrungszeugnis', 'urn:de:bund:kba:xkfz:codeliste:artderbremse', 'urn:xoev-de:bund:bfj:codeliste:nachrichtencode.bzr.antragprivatfuehrungszeugnis', 'urn:xoev-de:bund:bfj:codeliste:nachrichtencode.gzr.anfragebetroffeneperson', 'urn:xoev-de:bund:bfj:codeliste:nachrichtencode.bzr.auskunft', 'urn:xoev-de:bund:bfj:codeliste:nachrichtencode.bzr.mitteilung', 'urn:xoev-de:bund:bfj:codeliste:nachrichtencode.gzr.anfrageoeffentlichestelle', 'urn:xoev-de:bund:bfj:codeliste:nachrichtencode.gzr.auskunft', 'urn:xoev-de:bund:bfj:codeliste:nachrichtencode.gzr.mitteilung', 'urn:xoev-de:bund:bfj:codeliste:xbfj-nachrichten', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:kreis', 'urn:xoev-de:bund:bfj:codeliste:bfj.verwendungszweckauskunft', 'urn:xoev-de:bund:bfj:codeliste:bfj.behoerde', 'urn:xoev-de:bund:kba:codeliste:xkfzkommunikationspartner', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:staatsangehoerigkeit', 'urn:de:bund:kba:xkfz:codeliste:artderumruestung', 'urn:de:bund:kba:xkfz:codeliste:artderunterlage', 'urn:de:bund:kba:xkfz:codeliste:artderuntersuchung', 'urn:de:bund:kba:xkfz:codeliste:artderzahlung', 'urn:de:bund:kba:xkfz:codeliste:artdesgeschaeftsvorfalls', 'urn:de:bund:kba:xkfz:codeliste:artdesgutachtens', 'urn:de:bund:kba:xkfz:codeliste:auskunftsmedium', 'urn:de:bund:kba:xkfz:codeliste:datengruppenregistersatz', 'urn:de:bund:kba:xkfz:codeliste:ergebnisderuntersuchung', 'urn:de:bund:kba:xkfz:codeliste:kba-arbeitsgang', 'urn:de:bund:kba:xkfz:codeliste:kennzeichenformat', 'urn:de:bund:kba:xkfz:codeliste:lieferdienst', 'urn:de:bund:kba:xkfz:codeliste:nachrichtentyp', 'urn:de:bund:kba:xkfz:codeliste:positionderbremse', 'urn:de:bund:kba:xkfz:codeliste:prueforganisation', 'urn:de:bund:kba:xkfz:codeliste:artdergebuehr', 'urn:de:bund:kba:xkfz:codeliste:artdermonetaereneinnahme', 'urn:de:bund:kba:xkfz:codeliste:artderuntersuchungsstelle', 'urn:de:xwaffe:codelisten:abfragegrund', 'urn:de:xwaffe:codelisten:aktivitaet', 'urn:de:xwaffe:codelisten:anschrifttyp', 'urn:de:xwaffe:codelisten:artabhandenkommen', 'urn:de:xwaffe:codelisten:artaustausch', 'urn:de:xwaffe:codelisten:bearbeitungunbrauchbarmachung', 'urn:de:xwaffe:codelisten:bedeutung', 'urn:de:xwaffe:codelisten:beduerfnisgrund', 'urn:de:xwaffe:codelisten:behoerdenstatus', 'urn:de:xwaffe:codelisten:dokumentstatus', 'urn:de:xwaffe:codelisten:erlaubnisstatus', 'urn:de:xwaffe:codelisten:erlaubnistyp', 'urn:de:xwaffe:codelisten:erstregistrierungsart', 'urn:de:xwaffe:codelisten:erwerbsart', 'urn:de:xwaffe:codelisten:fehlerartregister', 'urn:de:bund:kba:xkfz:codeliste:artdesdokuments', 'urn:de:xwaffe:codelisten:fehlerklassekopfstelle', 'urn:de:xwaffe:codelisten:fehlernummerkopfstelle', 'urn:de:xwaffe:codelisten:geschlecht', 'urn:de:xwaffe:codelisten:hinweisart', 'urn:de:xwaffe:codelisten:kommunikationskanal', 'urn:de:xwaffe:codelisten:meldungsart', 'urn:de:xwaffe:codelisten:munitionsarten', 'urn:de:xwaffe:codelisten:objekttyp', 'urn:de:xwaffe:codelisten:personenrolle', 'urn:de:bund:kba:xkfz:codeliste:artdesmandats', 'urn:de:xwaffe:codelisten:personobjektstatus', 'urn:de:xwaffe:codelisten:suchebestand', 'urn:de:xwaffe:codelisten:suchprofil', 'urn:de:bund:kba:xkfz:codeliste:artdessiegels', 'urn:de:xwaffe:codelisten:transaktionsstatus', 'urn:de:xwaffe:codelisten:ueberlassungsabsicht', 'urn:de:xwaffe:codelisten:ueberlassungsart', 'urn:de:xwaffe:codelisten:ueberlassungsstatus', 'urn:de:xwaffe:codelisten:voreintragstatus', 'urn:de:xwaffe:codelisten:waffenkategorie', 'urn:de:bund:kba:xkfz:codeliste:codedessystems', 'urn:de:xwaffe:codelisten:waffenstatus', 'urn:de:xwaffe:codelisten:waffentechnischeausfuehrung', 'urn:de:xwaffe:codelisten:waffentrageberechtigungsart', 'urn:de:xwaffe:codelisten:waffentypanlage1', 'urn:de:xwaffe:codelisten:waffentypfeingliederung', 'urn:de:xwaffe:codelisten:waffenverbotsart', 'urn:de:xwaffe:codelisten:waffenverweisstatus', 'urn:de:xwaffe:codelisten:waffewaffenteil', 'urn:de:xwaffe:codelisten:wesentlicheswaffenteil', 'urn:de:xwaffe:codelisten:zuordnungsart', 'urn:de:xwaffe:codelisten:zustaendigebehoerdestatus', 'urn:de:bund:kba:xkfz:codeliste:herstellerdruckstuecke', 'urn:de:xauslaender:codelist:abhkennung', 'urn:de:bund:kba:xkfz:codeliste:kurzzeichenherstellerdruckstuecke', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:bezirk', 'urn:xoev-de:bund:bmi:bit:codeliste:dvdv.behoerdenschluessel', 'urn:de:bund:kba:xkfz:codeliste:nummerderfeinstaubplakette', 'urn:de:bund:kba:xkfz:codeliste:prozessschrittname', 'urn:de:bund:kba:xkfz:codeliste:quittungsart', 'urn:xoev-de:mv:em:xprozess:codeliste:handlungsgrundlagenart', 'urn:de:bund:kba:xkfz:codeliste:quittungscode', 'urn:xoev-de:xprozess:codeliste:entscheidungsart', 'urn:xoev-de:xprozess:codeliste:verfahrensart', 'urn:de:xprozess:codeliste:uebermittlungsart', 'urn:xoev-de:xprozess:codeliste:uebermittlungsart', 'urn:xoev-de:xprozess:codeliste:beteiligungsform', 'urn:de:xprozess:codeliste:detaillierungsstufe', 'urn:xoev-de:xprozess:codeliste:detaillierungsstufe', 'urn:de:xprozess:codeliste:handlungsform', 'urn:xoev-de:xprozess:codeliste:handlungsform', 'urn:de:xprozess:codeliste:operativesziel', 'urn:xoev-de:xprozess:codeliste:operativesziel', 'urn:xoev-de:xprozess:codeliste:zwecksetzung', 'urn:xoev-de:xprozess:codeliste:bearbeitungsart', 'urn:xoev-de:xprozess:codeliste:formellepruefung', 'urn:xoev-de:xprozess:codeliste:prozessrolle', 'urn:de:bund:kba:xkfz:codeliste:statusprozessschritt', 'urn:xoev-de:xprozess:codeliste:status', 'urn:xoev-de:xprozess:codeliste:modellierungsmethode', 'urn:xoev-de:xprozess:codeliste:ausfertigungsform', 'urn:xoev-de:xprozess:codeliste:schriftformfunktion', 'urn:xoev-de:xprozess:codeliste:referenzaktivitaetengruppe', 'urn:xoev-de:xprozess:codeliste:referenzaufgabe', 'urn:xoev-de:fim:codeliste:vertrauensniveau', 'urn:xoev-de:xbau:codeliste:bauwerte.gebaeudearten', 'urn:xoev-de:xbau-nw:codeliste:technischeanlage', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:ags', 'urn:de:bund:kba:xkfz:codeliste:stba', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:gemeindeverband', 'urn:xoev-de:bund:destatis:bevoelkerungsstatistik:codeliste:ags.historie', 'urn:de:bund:kba:xkfz:codeliste:steuerzahlweise', 'urn:de:bund:kba:xkfz:codeliste:typdergebuehrenaufstellung', 'urn:de:bund:kba:xkfz:codeliste:typdesdokuments', 'urn:de:bund:kba:xkfz:codeliste:typdeskennzeichens', 'urn:xoev-de:xinneres:codeliste:quittungsrelevanter-sachverhalt', 'urn:de:dsmeld:schluesseltabelle:einwilligung.datenuebermittlung', 'urn:xoev-de:xgewerbeanzeige:codeliste:registergerichte', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:rs', 'urn:de:dsmeld:schluesseltabelle:pass.und.ausweisdokumente', 'urn:de:xauslaender:codelist:azr:artdersprache', 'urn:xoev-de:bund:kba:codeliste:schluesselnummerderueberwachungsinstitutionoderzdk', 'urn:de:xauslaender:codelist:azr:ausweisart', 'urn:de:fim:codeliste:dokumenttyp', 'urn:de:fim:leika:leistung', 'urn:de:fim:leika:typisierung', 'urn:de:kirche:agszuordnung', 'urn:de:xauslaender:codelist:bamfabh:int:anmeldestatus', 'urn:de:xauslaender:codelist:bamfabh:int:informationberechtigungsschein', 'urn:de:xauslaender:codelist:bamfabh:int:kursabschnitt', 'urn:de:xauslaender:codelist:geschlecht', 'urn:de:xauslaender:codelist:integration:aufenthaltstitel', 'urn:de:xinneres:codeliste:fehlercodes', 'urn:de:xmeld:lra:schluessel:rts.fehlercodes', 'urn:de:xmeld:schluesseltabelle:xmeld.nachrichten', 'urn:de:xprozess:codeliste:beteiligungsform', 'urn:de:xprozess:codeliste:handlungsgrundlagenart', 'urn:de:xprozess:codeliste:verfahrensart', 'urn:de:xta:codeliste:category.of.party', 'urn:de:xta:codeliste:service.parameter.type', 'urn:de:xta:codeliste:xhd-nachrichten', 'urn:de:xwaffe:codelisten:munitionsbezeichnungkalibersammlung', 'urn:de:xzufi:codeliste:leistungstextmodulleika', 'urn:de:xzufi:codeliste:zahlungsweise', 'urn:de:xwaffe:codelisten:herstellersammlung', 'urn:de:xwaffe:codelisten:kalibersammlung', 'urn:de:xauslaender:codelist:bamfabh:int:dublettenmeldung', 'urn:de:gkleika:leika:leistung', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:staat', 'urn:de:bund:dsrv:schluessel:fehlerkatalog', 'urn:de:xwaffe:codelisten:herstellerbezeichnungsynonym', 'urn:de:bund:bzst:schluessel:fehlerkatalog', 'urn:de:gkleika:leika:verrichtung', 'urn:de:xwaffe:codelisten:herstellerbezeichnung', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:staatsgebiete', 'urn:dsmeld:schluesseltabelle:religion.steuererhebend', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:standesamtsnummern', 'urn:xoev-de:bmk:codeliste:bauwerkszuordnungskatalog', 'urn:xoev-de:bund:bfj:codeliste:bfjbehoerde', 'urn:xoev-de:bund:bfj:codeliste:fehlerkennzahl', 'urn:xoev-de:bund:bfj:codeliste:uebermittelndestelle', 'urn:xoev-de:bund:bfj:codeliste:verwendungszweck', 'urn:de:xauslaender:codelist:int:informationberechtigungverpflichtung', 'urn:de:xauslaender:codelist:abhmb:anlassmitteilungazrnummer')"/>

</sch:schema>
