<?xml version="1.0" encoding="UTF-8"?>
<!-- $Id: xoev-profil.ndr.sch 7434 2017-08-24 11:06:25Z fbuettner $ -->
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xmi="http://www.omg.org/spec/XMI/20131001" queryBinding="xslt2">

    <sch:title>XÖV-Prüfanweisungen: Schematron</sch:title>
    <xsl:include href="xgenerator-library.xgen-core.xsl"/>
    <xsl:include href="xgenerator-library.uml-access-layer.xsl"/>
    <xsl:include href="xoev-profil.profile-access-layer.xsl"/>
    <xsl:include href="xoev-profil.helpers.xsl"/>
    <xsl:include href="xoev-profil.schematron.helpers.xsl"/>

    <sch:ns uri="http://www.xoev.de/de/xgenerator/framework/1/library" prefix="xgen"/>
    <sch:ns uri="http://www.omg.org/spec/XMI/20131001" prefix="xmi"/>
    <sch:ns uri="http://www.eclipse.org/uml2/5.0.0/UML" prefix="uml"/>
    <sch:ns uri="http://www.xoev.de/de/xoev-profil/3_0_0" prefix="xoev"/>
    <sch:ns uri="http://www.xoev.de/de/xoev-profil/schematron/3_0_0" prefix="xoev-sch"/>

    <sch:pattern id="Schematron-SchematronRuleSetHatKeineEigenschaften">
        <sch:title>Einhaltung der Methodik zur Modellierung von Schematron-Regeln</sch:title>
        <sch:rule context="
                uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:schRuleSet(.) and ownedAttribute] |
                uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:schRuleSet(.) and ownedAttribute]">
            <sch:assert role="error" id="SchematronRuleSetHatKeineEigenschaften" test="false()">Ein Schematron Rule Set (UML-Klasse mit dem Stereotyp schRuleSet) hat keine UML-Eigenschaften, sondern ausschließlich UML-Zusicherungen. Die Klasse <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="Schematron-SchematronRuleSetHatMindestensEinenContext">
        <sch:title>Einhaltung der Methodik zur Modellierung von Schematron-Regeln</sch:title>
        <sch:rule context="
                uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:schRuleSet(.) and not(xoev:dependencies-by-client(.)[xoev:schContext(.)])] |
                uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:schRuleSet(.) and not(xoev:dependencies-by-client(.)[xoev:schContext(.)])]">
            <sch:assert role="error" id="SchematronRuleSetHatMindestensEinenContext" test="false()">Ein Schematron Rule Set (UML-Klasse mit dem Stereotyp schRuleSet) muss mindestens einen Fachkontext haben (von der UML-Klasse ausgehende UML-Abhängigkeitsbeziehung mit dem Stereotyp schContext). Die Klasse <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="Schematron-ContextDependencyBeginntBeiRuleSet">
        <sch:title>Einhaltung der Methodik zur Modellierung von Schematron-Regeln</sch:title>
        <sch:rule context="uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:schContext(.) and uml:resolve-client(.)[not(xoev:schRuleSet(.))]]">
            <sch:assert role="error" id="ContextDependencyBeginntBeiRuleSet" test="false()">Eine Schematron Fachkontext-Beziehung (UML-Abhängigkeitsbeziehung mit dem Stereotyp schContext) muss bei einem Rule Set (UML-Klasse mit dem Stereotyp schRuleSet) beginnen. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="Schematron-ContextDependencyEndetBeiKlasseOderEigenschaft">
        <sch:title>Einhaltung der Methodik zur Modellierung von Schematron-Regeln</sch:title>
        <sch:rule context="
                uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[
                xoev:schContext(.) and uml:resolve-supplier(.)[not(uml:is-Class(.) or uml:is-Property(.))]]">
            <sch:assert role="error" id="ContextDependencyEndetBeiKlasseOderEigenschaft" test="false()">Eine Schematron Fachkontext-Beziehung (UML-Abhängigkeitsbeziehung mit dem Stereotyp schContext) muss bei einer UML-Klasse oder -Eigenschaft enden. <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="Schematron-SchematronRegelHatSpezifikation">
        <sch:title>Einhaltung der Methodik zur Modellierung von Schematron-Regeln</sch:title>
        <sch:rule context="
                uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedRule[not(specification/body or specification/@value)]">
            <sch:assert role="error" id="SchematronRegelHatSpezifikation" test="false()">Eine Geschäftsregel (UML-Zusicherung) muss eine Spezifikation besitzen. Die Regel <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe.</sch:assert>
        </sch:rule>
    </sch:pattern>

    <sch:pattern id="Schematron-EingeschränktesElementVonSchematronContextErreichbar">
        <sch:title>Einhaltung der Methodik zur Modellierung von Schematron-Regeln</sch:title>
        <sch:rule context="uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedRule">
            <sch:let name="rule" value="."/>
            <sch:let name="owner" value="$rule/parent::*"/>
            <sch:let name="contexts" value="
                    $owner[xoev:schRuleSet(.)]/xoev:dependencies-by-client(.)[xoev:schContext(.)]/uml:resolve-supplier(.),
                    $owner[not(xoev:schRuleSet(.))]"/>
            <sch:assert role="error" id="EingeschränktesElementVonSchematronContextErreichbar" test="
                    every $context in $contexts
                        satisfies
                        (some $constrained-element-in-message-trees in ($rule/uml:resolve-constrainedElement(.), $context)[1]/(xoev-sch:message-nodes-by-id(@xmi:id), xoev-sch:message-nodes-by-type-id(@xmi:id))
                            satisfies xoev-sch:id-path-from-constrained-element-to-context(
                            $constrained-element-in-message-trees,
                            $context/(xoev-sch:message-nodes-by-id(@xmi:id), xoev-sch:message-nodes-by-type-id(@xmi:id))[1]) = '' or
                            xoev-sch:id-path-from-constrained-element-to-context(
                            $constrained-element-in-message-trees,
                            $context/(xoev-sch:message-nodes-by-id(@xmi:id), xoev-sch:message-nodes-by-type-id(@xmi:id))[1])[
                            not(starts-with(., '#null#'))])">Ein in einer Geschäftsregel (UML-Zusicherung) eingeschränktes Element muss vom Fachkontext der Regel aus erreichbar sein. Die Regel <sch:value-of select="xgen:model-path(.)"/> verletzt diese Vorgabe."/></sch:assert>
        </sch:rule>
    </sch:pattern>

</sch:schema>
