<?xml version="1.0" encoding="UTF-8"?>
<!-- $Id: xgenerator-library.xgen-core.xsl 8772 2018-05-25 11:35:48Z fbuettner $ -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library" xmlns:xmi="http://www.omg.org/spec/XMI/20131001" xmlns:uml="http://www.eclipse.org/uml2/5.0.0/UML" xmlns:log="http://www.xoev.de/de/xgenerator/framework/1/log" xmlns:saxon="http://saxon.sf.net/" xmlns:awt-font="java:java.awt.Font" xmlns:awt-fontrendercontext="java:java.awt.font.FontRenderContext" xmlns:awt-textlayout="java:java.awt.font.TextLayout" xmlns:awt-affinetransform="java:java.awt.geom.AffineTransform" xmlns:awt-rectangle2d="java:java.awt.geom.Rectangle2D" exclude-result-prefixes="xs xd xml uml saxon xmi xgen" version="2.0">
    <xsl:output method="xml" indent="yes" use-character-maps="xgen:_unescaped-xml-character-map"/>
    <xsl:param name="result-directory" required="no"/>
    <xsl:variable name="frameworkVersion" as="xs:string">1.0.1</xsl:variable>
    <xd:doc>
        <xd:desc>Kopie des Default-Template von XSLT - aber nur für den Mode #default.</xd:desc>
    </xd:doc>
    <xsl:template match="*" mode="#default" priority="-50">
        <xsl:apply-templates/>
    </xsl:template>
    <xd:doc>
        <xd:desc>Kopie des Default-Template von XSLT - aber nur für den Mode #default.</xd:desc>
    </xd:doc>
    <xsl:template match="text() | @*" mode="#default" priority="-50">
        <xsl:value-of select="."/>
    </xsl:template>
    <xd:doc>
        <xd:desc>"Catch-All"-Template (Basisversion) für nicht gematchte apply-templates mit expliziter Mode-Angabe, welches anstelle des XSLT-Default-Verhaltens eine Fehlermeldung auslöst.</xd:desc>
    </xd:doc>
    <xsl:template match="node()" mode="#all" priority="-100" use-when="not(function-available('saxon:current-mode-name'))">
        <xsl:call-template name="xgen:report-error">
            <xsl:with-param name="message">
                <xsl:text>Internal error: There is no template with the requested mode. </xsl:text>
                <xsl:text>Maybe an xsl:include is missing?</xsl:text>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    <xd:doc>
        <xd:desc>"Catch-All"-Template (Saxon-EE) für nicht gematchte apply-templates mit expliziter Mode-Angabe, welches anstelle des XSLT-Default-Verhaltens eine Fehlermeldung auslöst.</xd:desc>
    </xd:doc>
    <xsl:template match="node()" mode="#all" priority="-100" use-when="function-available('saxon:current-mode-name')">
        <xsl:call-template name="xgen:report-error">
            <xsl:with-param name="message">
                <xsl:text>Internal error: There is no template with mode </xsl:text>
                <xsl:value-of select="saxon:current-mode-name()"/>
                <xsl:text>. Maybe an xsl:include is missing?</xsl:text>
                <xsl:value-of select="saxon:print-stack()"/>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    <xd:doc>
        <xd:desc>Wrapper für xsl:result-document. Alle Dokumente, die aus einer XGenerator-Anwendung heraus erzeugt werden, müssen über diese Funktion erzeugt werden. Der Wrapper stellt sicher, dass die notwendigen Angaben im Ausführungsprotokoll erscheinen.</xd:desc>
        <xd:param name="local-path">Dateiname der zu erzeugenden Datei. Dieser wird relativ zum Parameter $result-directory interpretiert.</xd:param>
        <xd:param name="content">Das herauszuschreibende Dokument.</xd:param>
    </xd:doc>
    <xsl:template name="xgen:result-document">
        <xsl:param name="local-path" as="xs:anyURI" required="yes"/>
        <xsl:param name="content" as="document-node()" required="yes"/>
        <xsl:param name="method" required="no">xml</xsl:param>
        <xsl:variable name="path" select="concat($result-directory, '/', $local-path)"/>
        <xsl:result-document href="{$path}" method="{$method}">
            <xsl:sequence select="$content"/>
        </xsl:result-document>
        <log:result-document>
            <xsl:value-of select="$path"/>
        </log:result-document>
    </xsl:template>
    <xd:doc>
        <xd:desc>Index aller Element nach @xmi:id - nur zur internen Nutzung in dieser Datei.</xd:desc>
    </xd:doc>
    <xsl:key name="uml:_element-by-id" match="//*[@xmi:id]" use="@xmi:id"/>
    <xd:doc>
        <xd:desc>
            <xd:p>Diese Funktion Löst einen XMI-Querverweis auf und liefert das bzw. die referenzierte(n) Element(e).</xd:p>
            <xd:p>Das EMFUML2-XMI-Format sieht zwei Möglichkeiten für die Darstellung von Querverweisen vor: (1) in einem Attribut, welches die XMI-ID enthält [Querverweis innerhalb des gleichen Dokuments] und (2) in einem Kindelement, welches in einem href-Attribut mit Anker den Verweis auf eine ID in einem externen Dokument enthält. Aus diesem Grund hat die Funktion zwei Parameter, von denen in der Praxis immer mindestens einer leer ist.</xd:p>
        </xd:desc>
        <xd:param name="id-attr">Das Attribute, welches die XMI-ID oder die XML-IDs (durch Leerzeichen getrennt) direkt enthält.</xd:param>
        <xd:param name="href-elements">Die Elemente, welche href-Attribute enthalten.</xd:param>
        <xd:return>Das referenzierte Element. Falls einer der beiden Eingabe-Parameter nicht-leer ist, muss auch das Ergebnis nicht-leer sein (interne Zusicherung).</xd:return>
    </xd:doc>
    <xsl:function name="xgen:resolve-ids-or-hrefs" as="element()*">
        <!-- z. B. type="..."  -->
        <xsl:param name="id-attr" as="attribute()?"/>
        <!-- z. B. <type xmi:id="..." ref="..."/> -->
        <xsl:param name="href-elements" as="element()*"/>
        <xsl:if test="$id-attr">
            <xsl:for-each select="tokenize($id-attr, ' ')">
                <xsl:sequence select="xgen:safe-key('uml:_element-by-id', ., root($id-attr))"/>
            </xsl:for-each>
        </xsl:if>
        <xsl:for-each select="$href-elements">
            <xsl:variable name="uri" select="tokenize(@href, '#')[1]" as="xs:string"/>
            <xsl:variable name="xmi-id" select="tokenize(@href, '#')[2]" as="xs:string"/>
            <xsl:variable name="doc" select="document($uri, .)" as="document-node()"/>
            <xsl:sequence select="xgen:safe-key('uml:_element-by-id', $xmi-id, $doc)"/>
        </xsl:for-each>
    </xsl:function>
    <xd:doc>
        <xd:desc>Dieser Schlüssel wird von den generierten Profil-Zugriffsschichten verwendet.</xd:desc>
    </xd:doc>
    <xsl:key name="xgen:stereotype-applications" match="/xmi:XMI/*[position() > 1]" use="@*[starts-with(name(), 'base_')]"/>
    <xd:doc>
        <xd:desc>
            <xd:p>Diese Variable beinhaltet eine Struktur (Wurzelelement xgen:profile-applications) welche für jedes im aktuellen Modell angewendete Profil ein Kindelement xgen:profile-application enthält. </xd:p>
            <xd:p>Beispiel:</xd:p>
            <xd:pre><![CDATA[
                <xgen:profile-applications>
                    <xgen:profile-application name="OSCITransportProfil" nsURI="http:///schemas/OSCITransportProfil/_RxSuABscEeWPu5bSLDLVYQ/0"/>
                    <xgen:profile-application profile name="XOEVProfil" nsURI="http:///schemas/XOEVProfil/_Rxe7QBscEeWPu5bSLDLVYQ/0" version="1.4.1"/>
                    ...
                </xgen:profile-applications>
                ]]></xd:pre>
        </xd:desc>
    </xd:doc>
    <xsl:variable name="xgen:profile-applications" as="element(xgen:profile-applications)">
        <xgen:profile-applications>
            <xsl:for-each select="$uml:root-model/profileApplication">
                <!-- The use of the namespace http://www.eclipse.org/uml2/2.0.0/UML for the ECore model of the profile is a design decision in EMFUML2.-->
                <xsl:variable name="profile-href" select="eAnnotations[@source = 'http://www.eclipse.org/uml2/2.0.0/UML']/references/@href" as="node()"/>
                <!-- Yields, e. g., 'XOEV-Profil.profile.uml#_R0cKTBscEeWPu5bSLDLVYQ'. -->
                <xsl:variable name="profile-uri" select="tokenize($profile-href, '#')[1]" as="xs:string"/>
                <xsl:variable name="profile-xmi-id" select="tokenize($profile-href, '#')[2]" as="xs:string"/>
                <!-- Yields the UML profile for this href (from one of the other resources in this resource set). -->
                <xsl:variable name="profile-doc" select="document($profile-uri, /)" as="document-node()"/>
                <xsl:variable name="profile" select="
                        $profile-doc/(if (xmi:XMI) then
                            xmi:XMI
                        else
                            .)/uml:Profile" as="node()"/>
                <!-- Das könnte man theoretisch noch sauberer lösen, indem man den korrekten Namensraum für <Info> ermittelt.
             Allerdings scheint mir (FB) der Aufwand nicht gerechtfertigt. -->
                <xsl:variable name="version" select="$profile-doc/xmi:XMI/*:Info[@base_Package = $profile/@xmi:id]/@version"/>
                <!-- Yields the Ecore model of that profile. -->
                <xsl:variable name="profile-contents" select="$profile/eAnnotations/contents[@xmi:id = $profile-xmi-id]" as="node()"/>
                <!-- Record name and namespace for later use ... -->
                <xgen:profile-application name="{$profile/@name}" nsPrefix="{$profile-contents/@nsPrefix}" nsURI="{$profile-contents/@nsURI}">
                    <xsl:for-each select="$version">
                        <xsl:attribute name="version" select="$version"/>
                    </xsl:for-each>
                </xgen:profile-application>
            </xsl:for-each>
        </xgen:profile-applications>
    </xsl:variable>
    <xd:doc>
        <xd:desc>Das oberste uml:Model im Dokument (dieses kann das Wurzelelement sein oder das erste Kindelement eines Wurzelelements xmi:XMI.</xd:desc>
    </xd:doc>
    <xsl:variable name="uml:root-model" as="element(uml:Model)?" select="
            /(if (xmi:XMI) then
                xmi:XMI
            else
                .)/uml:Model"/>
    <xd:doc>
        <xd:desc>Das oberste uml:Profile im Dokument (dieses kann das Wurzelelement sein oder das erste Kindelement eines Wurzelelements xmi:XMI.</xd:desc>
    </xd:doc>
    <xsl:variable name="uml:root-profile" as="element(uml:Profile)" select="
            /(if (xmi:XMI) then
                xmi:XMI
            else
                .)/uml:Profile"/>
    <xd:doc>
        <xd:desc>Dieses Template stellt sicher, dass das aktuelle Dokument zur erwarteten XMI- und UML-Version passt und ein UML-Modell enthält. Es sollte zu Beginn jeder XSLT-Transformation aufgerufen werden.</xd:desc>
    </xd:doc>
    <xsl:template match="/" mode="xgen:assert-supported-uml-model">
        <xsl:if test="empty(*[@xmi:version = '20131001']) or empty(.//uml:Model)">
            <xsl:call-template name="xgen:report-error">
                <xsl:with-param name="message">Dieses Quelldokument enthält kein UML-Modell im erforderlichen EMFUML2-Format.</xsl:with-param>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    <xd:doc>
        <xd:desc>Dieses Template stellt sicher, dass das aktuelle Dokument zur erwarteten XMI- und UML-Version passt und ein UML-Profil enthält. Es sollte zu Beginn jeder XSLT-Transformation aufgerufen werden.</xd:desc>
    </xd:doc>
    <xsl:template match="/" mode="xgen:assert-supported-uml-profile">
        <xsl:if test="not(*/@xmi:version = '20131001') or empty(.//uml:Profile)">
            <xsl:call-template name="xgen:report-error">
                <xsl:with-param name="message">Dieses Quelldokument enthält kein UML-Profil im erforderlichen EMFUML2-Format.</xsl:with-param>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    <xd:doc>
        <xd:desc>
            <xd:p>Liefert einen Pfad von der Wurzel zum übergebenen Modellelement. Dabei werden nur die NamedElements berücksichtigt und durch '/' zusammengefügt.</xd:p>
            <xd:p>Vergleiche auch die Umsetzung im XGenerator 2: <xd:a href="https://osci.bremen.de/svn/xoev/produkte/xgenerator2/trunk/de.init.xgenerator.core/src/java/de/init/xgenerator/core/model/uml/TextualReferenceToElement.java"/>.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:function name="xgen:model-path" as="xs:string">
        <xsl:param name="element" as="node()"/>
        <xsl:choose>
            <xsl:when test="$element/parent::* and string-length($element/@name)">
                <xsl:value-of select="concat(xgen:model-path($element/parent::*), '/', $element/@name)"/>
            </xsl:when>
            <xsl:when test="string-length($element/@name) > 0">
                <xsl:value-of select="$element/@name"/>
            </xsl:when>
            <xsl:when test="uml:conforms-to-Dependency($element)">
                <xsl:value-of select="
                        concat(
                        'Die Abhängigkeit zwischen ',
                        xgen:model-path(uml:resolve-client($element)),
                        ' und ',
                        xgen:model-path(uml:resolve-supplier($element)))"/>
            </xsl:when>
            <xsl:when test="uml:conforms-to-Generalization($element)">
                <xsl:value-of select="
                        concat(
                        'Die Generalisierung zwischen ',
                        xgen:model-path($element/parent::*),
                        ' und ',
                        xgen:model-path(uml:resolve-general($element)))"/>
            </xsl:when>
            <xsl:when test="uml:conforms-to-Association($element)">
                <xsl:value-of select="
                        concat(
                        'Die Assoziation zwischen ',
                        string-join(uml:resolve-memberEnd($element)/uml:resolve-type(.)/xgen:model-path(.), ' und '))"/>
            </xsl:when>
            <xsl:when test="$element/parent::*">
                <xsl:value-of select="xgen:model-path($element/parent::*)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>
    <xd:doc>
        <xd:desc>Zusicherung. Ist der übergebene Wert nicht leer, wird er unverändert zurückgeliefert. Andernfalls wird ein Fehler ausgelöst.</xd:desc>
    </xd:doc>
    <xsl:function name="xgen:assert">
        <xsl:param name="non-empty" as="node()*"/>
        <xsl:if test="empty($non-empty)">
            <xsl:call-template name="xgen:report-error">
                <xsl:with-param name="message">Internal error. Assertion failed. Expected non-empty value.</xsl:with-param>
            </xsl:call-template>
        </xsl:if>
        <xsl:sequence select="$non-empty"/>
    </xsl:function>
    <xd:doc>
        <xd:desc>Gibt eine Fehlermeldung aus, welche die Ausführungsumgebung dem Anwendung anzeigen soll. Bricht die Ausführung ab.</xd:desc>
    </xd:doc>
    <xsl:template name="xgen:report-error">
        <xsl:param name="message" as="xs:string"/>
        <xsl:message terminate="yes" select="$message"/>
    </xsl:template>
    <xd:doc>
        <xd:desc>Gibt eine Fehlermeldung aus, welche die Ausführungsumgebung dem Anwendung anzeigen soll.</xd:desc>
    </xd:doc>
    <xsl:template name="xgen:report-warning">
        <xsl:param name="message" as="xs:string"/>
        <xsl:message select="$message"/>
    </xsl:template>
    <xd:doc>
        <xd:desc>Gibt eine Log-Message für das Protokoll aus.</xd:desc>
    </xd:doc>
    <xsl:template name="xgen:log">
        <xsl:param name="message" as="xs:string"/>
        <xsl:message select="$message"/>
    </xsl:template>
    <xd:doc>
        <xd:desc>Wrapper für die xsl:key Funktion. Sichert zu, dass bei nicht-leerem Schlüssel auch der Wert nicht leer ist.</xd:desc>
    </xd:doc>
    <xsl:function name="xgen:safe-key">
        <xsl:param name="key-name" as="xs:string"/>
        <xsl:param name="key"/>
        <xsl:param name="top" as="node()"/>
        <xsl:variable name="result" select="key($key-name, $key, $top)"/>
        <xsl:if test="empty($result)">
            <xsl:message terminate="yes">Assertion failed: Could not lookup element with <xsl:sequence select="$key"/>.</xsl:message>
        </xsl:if>
        <xsl:sequence select="$result"/>
    </xsl:function>
    <xd:doc>
        <xd:desc>Diese character-map definiert Ersatzwerte zum unmaskierten Serialisieren von XML-Text. Siehe <xd:ref name="xgen:unescaped-xml" type="function"/>.</xd:desc>
    </xd:doc>
    <xsl:character-map name="xgen:_unescaped-xml-character-map">
        <xsl:output-character character="&#xE801;" string="&lt;"/>
        <xsl:output-character character="&#xE802;" string="&gt;"/>
        <xsl:output-character character="&#xE803;" string="&amp;"/>
    </xsl:character-map>
    <xd:doc>
        <xd:desc>Ersetzt in einem String diejenigen Zeichen, die normalerweise beim Serialisieren des XML-Baums maskiert werden müssen, durch Codes aus der UNICODE Range E000–F8FF, welche zur "privaten Nutzung" reserviert sind. Wenn in xsl:output die dazugehörige character-map <xd:ref name="xgen:_unescaped-character-map" type="character-map"/> verwendet wird, werden die so ersetzten Zeichen ohne weitere Maskierung serialisiert. Siehe auch: http://www.xmlplease.com/charactermap#s2.</xd:desc>
    </xd:doc>
    <xsl:function name="xgen:unescaped-xml" as="xs:string">
        <xsl:param name="string" as="xs:string"/>
        <xsl:value-of select="translate($string, '&lt;&gt;&amp;', '&#xE801;&#xE802;&#xE803;')"/>
    </xsl:function>
    <xd:doc>
        <xd:desc>Diese Funktion wird durch den Java-Teil der XGenerator-Bibliothek realisiert und steht ohne explizite Initialisierung von Saxon-HE (d. h. ohne XGenerator-Ausführungsumgebung) nicht zur Verfügung. Der Ersatz betrachtet alle Eingaben als fehlerfrei.</xd:desc>
    </xd:doc>
    <xsl:function name="xgen:relaxng-instance-errors" as="xs:string*" use-when="not(function-available('xgen:relaxng-instance-errors'))">
        <xsl:param name="string" as="xs:string?"/>
    </xsl:function>
    <xd:doc>
        <xd:desc>Diese Funktion wird durch den Java-Teil der XGenerator-Bibliothek realisiert und steht ohne explizite Initialisierung von Saxon-HE (d. h. ohne XGenerator-Ausführungsumgebung) nicht zur Verfügung. Der Ersatz betrachtet alle Eingaben als fehlerfrei.</xd:desc>
    </xd:doc>
    <xsl:function name="xgen:parse-xml" as="document-node()" use-when="function-available('saxon:parse')">
        <xsl:param name="string" as="xs:string?"/>
        <xsl:sequence select="saxon:parse($string)"/>
    </xsl:function>
    <xsl:function name="xgen:svg.text-width" as="xs:double" use-when="function-available('xgen:awt-text-width')">
        <xsl:param name="text" as="xs:string?"/>
        <xsl:param name="font-style" as="xs:integer"/>
        <xsl:param name="font-size" as="xs:integer"/>
        <xsl:choose>
            <xsl:when test="$text">
                <xsl:sequence select="xgen:awt-text-width($text, 'Arial', $font-style, $font-size)"/>
            </xsl:when>
            <xsl:otherwise>0.0</xsl:otherwise>
        </xsl:choose>
    </xsl:function>
    <!-- Fallback when user defined extension function xgen:awt-text-width is not available.
         Requires Saxon-PE or SAXON-HE. -->
    <xsl:variable name="xgen:svg.font-render-context" select="awt-fontrendercontext:new(awt-affinetransform:new(), false(), false())" use-when="not(function-available('xgen:awt-text-width')) and function-available('awt-textlayout:getBounds')"/>
    <xsl:function name="xgen:svg.text-width" as="xs:double" use-when="not(function-available('xgen:awt-text-width')) and function-available('awt-textlayout:getBounds')">
        <xsl:param name="text" as="xs:string?"/>
        <xsl:param name="font-style" as="xs:integer"/>
        <xsl:param name="font-size" as="xs:integer"/>
        <xsl:variable name="bounds" select="awt-textlayout:getBounds(awt-textlayout:new($text, awt-font:new('Arial', $font-style, $font-size), $xgen:svg.font-render-context))"/>
        <xsl:choose>
            <xsl:when test="$text">
                <xsl:sequence select="awt-rectangle2d:getWidth($bounds)"/>
            </xsl:when>
            <xsl:otherwise>0.0</xsl:otherwise>
        </xsl:choose>
    </xsl:function>
</xsl:stylesheet>
