<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<xsl:stylesheet xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:saxon="http://saxon.sf.net/"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:schold="http://www.ascc.net/xml/schematron"
                xmlns:iso="http://purl.oclc.org/dsdl/schematron"
                xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library"
                xmlns:xmi="http://www.omg.org/spec/XMI/20131001"
                xmlns:uml="http://www.eclipse.org/uml2/5.0.0/UML"
                xmlns:xoev="http://www.xoev.de/de/xoev-profil/3_0_0"
                version="2.0"><!--Implementers: please note that overriding process-prolog or process-root is 
    the preferred method for meta-stylesheets to use where possible. -->
   <xsl:param name="archiveDirParameter"/>
   <xsl:param name="archiveNameParameter"/>
   <xsl:param name="fileNameParameter"/>
   <xsl:param name="fileDirParameter"/>
   <xsl:variable name="document-uri">
      <xsl:value-of select="document-uri(/)"/>
   </xsl:variable>
   <!--PHASES-->
   <!--PROLOG-->
   <xsl:output xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
               method="xml"
               omit-xml-declaration="no"
               standalone="yes"
               indent="yes"/>
   <!--XSD TYPES FOR XSLT2-->
   <!--KEYS AND FUNCTIONS-->
   <!--DEFAULT RULES-->
   <!--MODE: SCHEMATRON-SELECT-FULL-PATH-->
   <!--This mode can be used to generate an ugly though full XPath for locators-->
   <xsl:template match="*" mode="schematron-select-full-path">
      <xsl:apply-templates select="." mode="schematron-get-full-path-3"/>
   </xsl:template>
   <!--MODE: SCHEMATRON-FULL-PATH-->
   <!--This mode can be used to generate an ugly though full XPath for locators-->
   <xsl:template match="*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">
            <xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>*:</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>[namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="preceding"
                    select="count(preceding-sibling::*[local-name()=local-name(current())                                   and namespace-uri() = namespace-uri(current())])"/>
      <xsl:text>[</xsl:text>
      <xsl:value-of select="1+ $preceding"/>
      <xsl:text>]</xsl:text>
   </xsl:template>
   <xsl:template match="@*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">@<xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>@*[local-name()='</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>' and namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <!--MODE: SCHEMATRON-FULL-PATH-2-->
   <!--This mode can be used to generate prefixed XPath for humans-->
   <xsl:template match="node() | @*" mode="schematron-get-full-path-2">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="preceding-sibling::*[name(.)=name(current())]">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>
   <!--MODE: SCHEMATRON-FULL-PATH-3-->
   <!--This mode can be used to generate prefixed XPath for humans 
	(Top-level element has index)-->
   <xsl:template match="node() | @*" mode="schematron-get-full-path-3">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="parent::*">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>
   <!--MODE: GENERATE-ID-FROM-PATH -->
   <xsl:template match="/" mode="generate-id-from-path"/>
   <xsl:template match="text()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/>
   </xsl:template>
   <xsl:template match="comment()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/>
   </xsl:template>
   <xsl:template match="processing-instruction()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.@', name())"/>
   </xsl:template>
   <xsl:template match="*" mode="generate-id-from-path" priority="-0.5">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:text>.</xsl:text>
      <xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/>
   </xsl:template>
   <!--MODE: GENERATE-ID-2 -->
   <xsl:template match="/" mode="generate-id-2">U</xsl:template>
   <xsl:template match="*" mode="generate-id-2" priority="2">
      <xsl:text>U</xsl:text>
      <xsl:number level="multiple" count="*"/>
   </xsl:template>
   <xsl:template match="node()" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>n</xsl:text>
      <xsl:number count="node()"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="string-length(local-name(.))"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="translate(name(),':','.')"/>
   </xsl:template>
   <!--Strip characters-->
   <xsl:template match="text()" priority="-1"/>
   <!--SCHEMA SETUP-->
   <xsl:template match="/">
      <svrl:schematron-output xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                              title="XÖV-Prüfanweisungen: Namens- und Entwurfsregeln"
                              schemaVersion="">
         <svrl:ns-prefix-in-attribute-values uri="http://www.xoev.de/de/xgenerator/framework/1/library"
                                             prefix="xgen"/>
         <svrl:ns-prefix-in-attribute-values uri="http://www.omg.org/spec/XMI/20131001" prefix="xmi"/>
         <svrl:ns-prefix-in-attribute-values uri="http://www.eclipse.org/uml2/5.0.0/UML" prefix="uml"/>
         <svrl:ns-prefix-in-attribute-values uri="http://www.xoev.de/de/xoev-profil/3_0_0" prefix="xoev"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M9"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M10"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-2-HauptstrukturEinesXOEVFachmodells-GenauEinXOEVFachmodellAufObersterModellebene</xsl:attribute>
            <xsl:attribute name="name">NDR-2: Hauptstruktur eines XÖV-Fachmodells</xsl:attribute>
            <svrl:text>Das XÖV-Fachmodell eines XÖV-Standards muss auf oberster Ebene einer vordefinierten Struktur folgen, welche die Inhalte des eigenen Standards von externen, in den XÖV-Standard eingebundenen Inhalten unterscheidet.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M11"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-2-HauptstrukturEinesXOEVFachmodells-ExterneModelleImPaketExterneModelle</xsl:attribute>
            <xsl:attribute name="name">NDR-2: Hauptstruktur eines XÖV-Fachmodells</xsl:attribute>
            <svrl:text>Das XÖV-Fachmodell eines XÖV-Standards muss auf oberster Ebene einer vordefinierten Struktur folgen, welche die Inhalte des eigenen Standards von externen, in den XÖV-Standard eingebundenen Inhalten unterscheidet.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M12"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-UnqualifizierteElementeBeiRestriktionUeberMehrereNamensraeume</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M13"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-UnionIstSimpleType</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M14"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-UnionMemberIstSimpleType</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M15"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-UnionMemberIstBenannt</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M16"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-KeysKeyrefsUniquesImportsUndIncludesSchliessenSichGegenseitigAus</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M17"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-NamedTypeGlobalElementUndGlobalElementAndNamedTypeSchliessenSichGegenseitigAus</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M18"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-XsdNamedTypeUndXsdMessageSchliessenSichGegenseitigAus</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M19"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-AttributeElementeUndLokaleStrukturenSchliessenSichGegenseitigAus</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M20"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-DefaultUndFixedWerteSchliessenSichGegenseitigAus</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M21"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-ElementenpositionIstNatuerlicheZahlGroesserNull</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M22"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-ElementenpositionIstEindeutig</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M23"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-NamenVonTypenEindeutig</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M24"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-NamenVonGlobalenElementenEindeutig</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M25"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-SchemaDefinitionenNichtVerschachtelt</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M26"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-CodelistenHabenEinenNamen</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M27"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-CodelistenBasistypIstSimpleType</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M28"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-CodelistenBasistypIstTokenOderAbleitungVonToken</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M29"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-ElementeUndAttributeSindBenannt</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M30"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-ElementnamenSindAufBausteinebeneEindeutig</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M31"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-GlobaleElementeMitTypHabenKeineEigenenElementeOderAttribute</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M32"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-TypisierteGlobaleElementeDuerfenKeineBenanntenTypenSein</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M33"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-GlobaleElementeMaximalEinenTyp</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M34"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-TypisierteGlobaleElementeHabenBenanntenTyp</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M35"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-ElementReferenzReferenziertGlobalesElementOderElementgruppe</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M36"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-DateinameEinerXMLSchemaDefinitionIstAngegeben</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M37"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-SchemaLocationEinerXMLSchemaDefinitionIstAngegeben</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M38"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-ImportsNurZwischenXMLSchemaDefinitionenUnterschiedlicherNamensraeume</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M39"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-ImportUndIncludeBeziehungenZyklenfrei</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M40"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-DateinamenVonXMLSchemaDefinitionenEindeutig</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M41"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-SchemaLocationsVonXMLSchemaDefinitionenEindeutig</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M42"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-InkludierterNamensraumUndInkludiertesPraefixEntsprechenDenenDesInkludierendemSchemas</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M43"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-ImportsUndIncludesNurZwischenSchemaPaketen</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M44"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-BenannteTypenMuessenNamenHaben</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M45"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-GruppenMuessenNamenHaben</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M46"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-GlobaleElementeMuessenNamenHaben</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M47"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-GruppenHabenMindestensEinElementOderAttribut</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M48"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-GruppenEnthaltenEntwederElementeOderAttribute</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M49"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-AnnotierteKlassenInSchemaPaketen</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M50"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-AnnotierteAbhaengigkeitsbeziehungenInSchemaPaketen</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M51"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-AnnotierteGeneralisierungenInSchemaPaketen</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M52"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-AnnotierteElementeUndAttributeInSchemaPaketen</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M53"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-TypenUndGlobaleElementeEnthaltenElementeAttributeOderLokaleStrukturen</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M54"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-AnyContentsKlassenOhneEigenschaften</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M55"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-EinfacheVererbung</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M56"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionSchraenktEin</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M57"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-GlobaleElementeOhneStereotypenXsdAnyContents</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M58"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-AnyElementeOhneStereotypenXsdGlobalElementXsdCodeUndXsdChoice</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M59"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-ChoiceOhneStereotypenXsdAnyContentsUndXsdCode</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M60"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-CodeDatentypenOhneStereotypenXsdGlobalElementXsdAnyContentsUndXsdChoice</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M61"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-GlobaleElementeSindKlassenOderEnumerationen</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M62"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-KeineTypenImEntwurfGenutzt</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M63"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionMitKorrekterElementenreihenfolge</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M64"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionFacettenNurBeiSimpleContent</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M65"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionFractionDigitsMitKorrektenW3CDatentypen</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M66"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionLengthMitKorrektenW3CDatentypen</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M67"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionMaxExclusiveMitKorrektenW3CDatentypen</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M68"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionMaxInclusiveMitKorrektenW3CDatentypen</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M69"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionMaxLengthMitKorrektenW3CDatentypen</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M70"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionMinExclusiveMitKorrektenW3CDatentypen</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M71"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionMinInclusiveMitKorrektenW3CDatentypen</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M72"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionMinLengthMitKorrektenW3CDatentypen</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M73"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionPatternMitKorrektenW3CDatentypen</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M74"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionTotalDigitsMitKorrektenW3CDatentypen</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M75"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionWhitespaceMitKorrektenW3CDatentypen</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M76"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionLengthIstPositiveGanzeZahl</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M77"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionMaxLengthIstPositiveGanzeZahl</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M78"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionTotalDigitsIstPositiveGanzeZahl</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M79"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionFractionDigitsIstPositiveGanzeZahl</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M80"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionLengthSchliesstMaxLengthUndMinLengthAus</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M81"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionMaxExclusiveUndMaxInclusiveSchliessenSichAus</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M82"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionMinExclusiveUndMinInclusiveSchliessenSichAus</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M83"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionWhitespaceMitKorrektenWerten</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M84"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-AttributMitKorrektemTyp</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M85"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-ElementMitKorrektemTyp</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M86"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-ElementUndAttributTypenSichtbar</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M87"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-TypenGlobalerElementeUndAttributeSichtbar</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M88"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-BasistypenSichtbar</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M89"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-EigenschaftenHabenEinenTyp</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M90"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-AttributeMitEinzelnemWert</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M91"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-SchemaDateiEndungXsd</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M92"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-SchemaLocationEndungXsd</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M93"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-AssoziationImGleichenPaketWieEigenschaft</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M94"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-KeineMehrfachenXMLIncludes</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M95"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-29-IdentifizierendeNamensraeume-XMLSchemaDefinitionenHabenNamensraum</xsl:attribute>
            <xsl:attribute name="name">NDR-29: Identifizierende Namensräume</xsl:attribute>
            <svrl:text>Alle im Rahmen eines XÖV-Standards definierten globalen XML-Elemente und benannten XML-Typen müssen sich in einem Namensraum befinden, der den betroffenen XÖV-Standard eindeutig identifiziert.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M96"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-29-IdentifizierendeNamensraeume-XMLSchemaDefinitionenHabenPraefix</xsl:attribute>
            <xsl:attribute name="name">NDR-29: Identifizierende Namensräume</xsl:attribute>
            <svrl:text>Alle im Rahmen eines XÖV-Standards definierten globalen XML-Elemente und benannten XML-Typen müssen sich in einem Namensraum befinden, der den betroffenen XÖV-Standard eindeutig identifiziert.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M97"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-30-VersionierungDerXMLSchemaDefinitionen-XMLSchemaDefinitionenSindVersioniert</xsl:attribute>
            <xsl:attribute name="name">NDR-30: Versionierung der XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Jede XML Schema-Definition eines XÖV-Standards muss versioniert sein.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M98"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardNameLangMussBefuelltSein</xsl:attribute>
            <xsl:attribute name="name">NDR-32: Dokumentation der Metadaten des Standards</xsl:attribute>
            <svrl:text>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M99"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardNameKurzMussBefuelltSein</xsl:attribute>
            <xsl:attribute name="name">NDR-32: Dokumentation der Metadaten des Standards</xsl:attribute>
            <svrl:text>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M100"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardNameTechnischMussBefuelltSein</xsl:attribute>
            <xsl:attribute name="name">NDR-32: Dokumentation der Metadaten des Standards</xsl:attribute>
            <svrl:text>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M101"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardKennungMussBefuelltSein</xsl:attribute>
            <xsl:attribute name="name">NDR-32: Dokumentation der Metadaten des Standards</xsl:attribute>
            <svrl:text>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M102"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardBeschreibungMussBefuelltSein</xsl:attribute>
            <xsl:attribute name="name">NDR-32: Dokumentation der Metadaten des Standards</xsl:attribute>
            <svrl:text>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M103"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementVersionStandardVersionMussBefuelltSein</xsl:attribute>
            <xsl:attribute name="name">NDR-32: Dokumentation der Metadaten des Standards</xsl:attribute>
            <svrl:text>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M104"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementVersionStandardVersionXOEVHandbuchMussBefuelltSein</xsl:attribute>
            <xsl:attribute name="name">NDR-32: Dokumentation der Metadaten des Standards</xsl:attribute>
            <svrl:text>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M105"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementVersionStandardVersionXGeneratorMussBefuelltSein</xsl:attribute>
            <xsl:attribute name="name">NDR-32: Dokumentation der Metadaten des Standards</xsl:attribute>
            <svrl:text>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M106"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementVersionStandardVersionModellierungswerkzeugMussBefuelltSein</xsl:attribute>
            <xsl:attribute name="name">NDR-32: Dokumentation der Metadaten des Standards</xsl:attribute>
            <svrl:text>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M107"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardKennungMussMitUrnXoevDeBeginnen</xsl:attribute>
            <xsl:attribute name="name">NDR-32: Dokumentation der Metadaten des Standards</xsl:attribute>
            <svrl:text>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M108"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardKennungMussStandardEnthalten</xsl:attribute>
            <xsl:attribute name="name">NDR-32: Dokumentation der Metadaten des Standards</xsl:attribute>
            <svrl:text>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M109"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardKennungMussNameTechnischEnthalten</xsl:attribute>
            <xsl:attribute name="name">NDR-32: Dokumentation der Metadaten des Standards</xsl:attribute>
            <svrl:text>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M110"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardKennungDarfNichtXoevEnthalten</xsl:attribute>
            <xsl:attribute name="name">NDR-32: Dokumentation der Metadaten des Standards</xsl:attribute>
            <svrl:text>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M111"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardKennungDarfNurErlaubteZeichenEnthalten</xsl:attribute>
            <xsl:attribute name="name">NDR-32: Dokumentation der Metadaten des Standards</xsl:attribute>
            <svrl:text>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M112"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardNameTechnischDarfNurErlaubteZeichenEnthalten</xsl:attribute>
            <xsl:attribute name="name">NDR-32: Dokumentation der Metadaten des Standards</xsl:attribute>
            <svrl:text>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M113"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementVersionStandardVersionDarfNurErlaubteZeichenEnthalten</xsl:attribute>
            <xsl:attribute name="name">NDR-32: Dokumentation der Metadaten des Standards</xsl:attribute>
            <svrl:text>Die Metadaten eines XÖV-Standards und seiner Version müssen im XÖV-Fachmodell dokumentiert werden.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M114"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-12-ErlaubteZeichenFuerKlassifikationenInNamen-NamenBenannterTypenUndGlobalerElementeOhneAufeinanderfolgendePunkte</xsl:attribute>
            <xsl:attribute name="name">NDR-12: Erlaubte Zeichen für Klassifikationen in Namen</xsl:attribute>
            <svrl:text>Zur Abbildung von Klassifikationen in Namen sollen Punkte verwendet werden.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M115"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-12-ErlaubteZeichenFuerKlassifikationenInNamen-NamenVonElementenUndAttributenOhneAufeinanderfolgendePunkte</xsl:attribute>
            <xsl:attribute name="name">NDR-12: Erlaubte Zeichen für Klassifikationen in Namen</xsl:attribute>
            <svrl:text>Zur Abbildung von Klassifikationen in Namen sollen Punkte verwendet werden.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M116"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-12-ErlaubteZeichenFuerKlassifikationenInNamen-NamenVonCodelistenEnumerationenAlsBenannteTypenOhneAufeinanderfolgendePunkte</xsl:attribute>
            <xsl:attribute name="name">NDR-12: Erlaubte Zeichen für Klassifikationen in Namen</xsl:attribute>
            <svrl:text>Zur Abbildung von Klassifikationen in Namen sollen Punkte verwendet werden.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M117"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-4-ErlaubteEinbindungsartenFuerCodelisten-CodeDatentypEntsprichtCodeTyp1bis4</xsl:attribute>
            <xsl:attribute name="name">NDR-4: Erlaubte Einbindungsarten für Codelisten</xsl:attribute>
            <svrl:text>Eine Codeliste soll ausschließlich mittels der in Abschnitt 8.5: Nutzung von Codelisten beschriebenen Code-Typen 1 bis 4 in einem XÖV-Standard genutzt werden.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M118"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-11-ErlaubteZeichenFuerNamen-NurErlaubteZeichenFuerBenannteTypenUndGlobaleElemente</xsl:attribute>
            <xsl:attribute name="name">NDR-11: Erlaubte Zeichen für Namen</xsl:attribute>
            <svrl:text>Namen von XML-Attributen, XML-Elementen und XML-Typen eines XÖV-Standards sollen nur Buchstaben, Ziffern, Punkte, Unterstriche und Bindestriche enthalten.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M119"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-11-ErlaubteZeichenFuerNamen-KeineWhitespacesInNamenBenannterTypenUndGlobalerElemente</xsl:attribute>
            <xsl:attribute name="name">NDR-11: Erlaubte Zeichen für Namen</xsl:attribute>
            <svrl:text>Namen von XML-Attributen, XML-Elementen und XML-Typen eines XÖV-Standards sollen nur Buchstaben, Ziffern, Punkte, Unterstriche und Bindestriche enthalten.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M120"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-11-ErlaubteZeichenFuerNamen-NurErlaubteZeichenFuerNamensPraefixeUndSuffixe</xsl:attribute>
            <xsl:attribute name="name">NDR-11: Erlaubte Zeichen für Namen</xsl:attribute>
            <svrl:text>Namen von XML-Attributen, XML-Elementen und XML-Typen eines XÖV-Standards sollen nur Buchstaben, Ziffern, Punkte, Unterstriche und Bindestriche enthalten.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M121"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-11-ErlaubteZeichenFuerNamen-KeineWhitespacesInNamensPraefixenUndSuffixen</xsl:attribute>
            <xsl:attribute name="name">NDR-11: Erlaubte Zeichen für Namen</xsl:attribute>
            <svrl:text>Namen von XML-Attributen, XML-Elementen und XML-Typen eines XÖV-Standards sollen nur Buchstaben, Ziffern, Punkte, Unterstriche und Bindestriche enthalten.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M122"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-11-ErlaubteZeichenFuerNamen-NurErlaubteZeichenFuerElementeUndAttribute</xsl:attribute>
            <xsl:attribute name="name">NDR-11: Erlaubte Zeichen für Namen</xsl:attribute>
            <svrl:text>Namen von XML-Attributen, XML-Elementen und XML-Typen eines XÖV-Standards sollen nur Buchstaben, Ziffern, Punkte, Unterstriche und Bindestriche enthalten.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M123"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-11-ErlaubteZeichenFuerNamen-KeineWhitespacesInElementUndAttributnamen</xsl:attribute>
            <xsl:attribute name="name">NDR-11: Erlaubte Zeichen für Namen</xsl:attribute>
            <svrl:text>Namen von XML-Attributen, XML-Elementen und XML-Typen eines XÖV-Standards sollen nur Buchstaben, Ziffern, Punkte, Unterstriche und Bindestriche enthalten.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M124"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-11-ErlaubteZeichenFuerNamen-NurErlaubteZeichenFuerNamenVonBenanntenDatentypenFuerCodelistenversionen</xsl:attribute>
            <xsl:attribute name="name">NDR-12: Erlaubte Zeichen für Klassifikationen in Namen</xsl:attribute>
            <svrl:text>Zur Abbildung von Klassifikationen in Namen sollen Punkte verwendet werden.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M125"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-11-ErlaubteZeichenFuerNamen-KeineWhitespacesInNamenBenannterDatentypenFuerCodelistenversionen</xsl:attribute>
            <xsl:attribute name="name">NDR-12: Erlaubte Zeichen für Klassifikationen in Namen</xsl:attribute>
            <svrl:text>Zur Abbildung von Klassifikationen in Namen sollen Punkte verwendet werden.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M126"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-5-DetaillierteStrukturEinesXOEVFachmodells-BasisdatentypenSchemaDefiniert</xsl:attribute>
            <xsl:attribute name="name">NDR-5: Detaillierte Struktur eines XÖV-Fachmodells</xsl:attribute>
            <svrl:text>Für die inhaltliche Gliederung des XÖV-Fachmodells eines XÖV-Standards wird die Nutzung einer bewährten Struktur empfohlen.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M127"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-5-DetaillierteStrukturEinesXOEVFachmodells-BaukastenSchemaDefiniert</xsl:attribute>
            <xsl:attribute name="name">NDR-5: Detaillierte Struktur eines XÖV-Fachmodells</xsl:attribute>
            <svrl:text>Für die inhaltliche Gliederung des XÖV-Fachmodells eines XÖV-Standards wird die Nutzung einer bewährten Struktur empfohlen.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M128"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-5-DetaillierteStrukturEinesXOEVFachmodells-NachrichtenOderFachmodulePaketDefiniert</xsl:attribute>
            <xsl:attribute name="name">NDR-5: Detaillierte Struktur eines XÖV-Fachmodells</xsl:attribute>
            <svrl:text>Für die inhaltliche Gliederung des XÖV-Fachmodells eines XÖV-Standards wird die Nutzung einer bewährten Struktur empfohlen.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M129"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-5-DetaillierteStrukturEinesXOEVFachmodells-MindestensEinHauptgruppenschema</xsl:attribute>
            <xsl:attribute name="name">NDR-5: Detaillierte Struktur eines XÖV-Fachmodells</xsl:attribute>
            <svrl:text>Für die inhaltliche Gliederung des XÖV-Fachmodells eines XÖV-Standards wird die Nutzung einer bewährten Struktur empfohlen.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M130"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-5-DetaillierteStrukturEinesXOEVFachmodells-NachrichtenNurInHauptgruppenpaketen</xsl:attribute>
            <xsl:attribute name="name">NDR-5: Detaillierte Struktur eines XÖV-Fachmodells</xsl:attribute>
            <svrl:text>Für die inhaltliche Gliederung des XÖV-Fachmodells eines XÖV-Standards wird die Nutzung einer bewährten Struktur empfohlen.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M131"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-5-DetaillierteStrukturEinesXOEVFachmodells-HauptgruppenpaketeNichtOhneNachrichten</xsl:attribute>
            <xsl:attribute name="name">NDR-5: Detaillierte Struktur eines XÖV-Fachmodells</xsl:attribute>
            <svrl:text>Für die inhaltliche Gliederung des XÖV-Fachmodells eines XÖV-Standards wird die Nutzung einer bewährten Struktur empfohlen.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M132"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-7-XMLWildcardElementeMitNamensraum-AnyElementeMitNamensraum</xsl:attribute>
            <xsl:attribute name="name">NDR-7: XML-Wildcard-Elemente mit Namensraum</xsl:attribute>
            <svrl:text>Für XML-Wildcard-Elemente wird die Angabe eines Namensraums empfohlen.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M133"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-15-GroßUndKleinschreibungVonNamen-UpperCamelCaseFuerNamenBenannterTypen</xsl:attribute>
            <xsl:attribute name="name">NDR-15: Groß- und Kleinschreibung von (und innerhalb zusammengesetzter) Namen</xsl:attribute>
            <svrl:text>Es wird empfohlen, in Namen von XML-Typen eines XÖV-Standards alle eigenständigen Wörter mit einem Großbuchstaben zu beginnen (Upper Camel Case). In den Namen von XML-Attributen und -Elementen wird eine analoge Schreibweise empfohlen. Hier sollte das erste Zeichen des Namens jedoch ein Kleinbuchstabe sein (Lower Camel Case). Im Falle von Namen globaler XML-Elemente, und damit auch von Nachrichten, wird ebenfalls die Lower Camel Case Schreibweise empfohlen. Nach Klassifikationsmerkmalen in Namen globaler Elemente sollte ebenfalls mit einem Kleinbuchstaben begonnen werden.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M134"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-15-GroßUndKleinschreibungVonNamen-LowerCamelCaseFuerNamenVonElementenUndAttributen</xsl:attribute>
            <xsl:attribute name="name">NDR-15: Groß- und Kleinschreibung von (und innerhalb zusammengesetzter) Namen</xsl:attribute>
            <svrl:text>Es wird empfohlen, in Namen von XML-Typen eines XÖV-Standards alle eigenständigen Wörter mit einem Großbuchstaben zu beginnen (Upper Camel Case). In den Namen von XML-Attributen und -Elementen wird eine analoge Schreibweise empfohlen. Hier sollte das erste Zeichen des Namens jedoch ein Kleinbuchstabe sein (Lower Camel Case). Im Falle von Namen globaler XML-Elemente, und damit auch von Nachrichten, wird ebenfalls die Lower Camel Case Schreibweise empfohlen. Nach Klassifikationsmerkmalen in Namen globaler Elemente sollte ebenfalls mit einem Kleinbuchstaben begonnen werden.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M135"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-15-GroßUndKleinschreibungVonNamen-LowerCamelCaseFuerNamenGlobalerElemente</xsl:attribute>
            <xsl:attribute name="name">NDR-15: Groß- und Kleinschreibung von (und innerhalb zusammengesetzter) Namen</xsl:attribute>
            <svrl:text>Es wird empfohlen, in Namen von XML-Typen eines XÖV-Standards alle eigenständigen Wörter mit einem Großbuchstaben zu beginnen (Upper Camel Case). In den Namen von XML-Attributen und -Elementen wird eine analoge Schreibweise empfohlen. Hier sollte das erste Zeichen des Namens jedoch ein Kleinbuchstabe sein (Lower Camel Case). Im Falle von Namen globaler XML-Elemente, und damit auch von Nachrichten, wird ebenfalls die Lower Camel Case Schreibweise empfohlen. Nach Klassifikationsmerkmalen in Namen globaler Elemente sollte ebenfalls mit einem Kleinbuchstaben begonnen werden.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M136"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-16-NamensstrukturGlobalerElemente-NachrichtennamenMitPraefix</xsl:attribute>
            <xsl:attribute name="name">NDR-16: Namensstruktur globaler Elementen</xsl:attribute>
            <svrl:text>Für Nachrichtennamen wird empfohlen, den Namen der jeweiligen Nachrichtenhauptgruppe als Präfix voranzustellen. Das Präfix wird mit einem Punkt von dem eigentlichen Namen der Nachricht abgegrenzt.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M137"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-16-NamensstrukturGlobalerElemente-NameNachrichtenpraefixEntsprichtNameSchemapaket</xsl:attribute>
            <xsl:attribute name="name">NDR-16: Namensstruktur globaler Elementen</xsl:attribute>
            <svrl:text>Für Nachrichtennamen wird empfohlen, den Namen der jeweiligen Nachrichtenhauptgruppe als Präfix voranzustellen. Das Präfix wird mit einem Punkt von dem eigentlichen Namen der Nachricht abgegrenzt.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M138"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-17-VersionsuebergreifendEindeutigeNachrichtennummern-NachrichtennameMitNumerischemSuffix</xsl:attribute>
            <xsl:attribute name="name">NDR-17: Versionsübergreifend eindeutige Nachrichtennummern</xsl:attribute>
            <svrl:text>Es wird empfohlen, Nachrichten im Kontext eines XÖV-Standards versionsübergreifend eindeutige Nummern als Namenssuffix zuzuweisen. Das Suffix wird mit einem Punkt abgegrenzt. Darüber hinaus wird empfohlen, ungültig gewordene Nachrichtennummern nicht im Kontext neuer Nachrichten wiederzuverwenden.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M139"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-17-VersionsuebergreifendEindeutigeNachrichtennummern-NachrichtennummerEindeutig</xsl:attribute>
            <xsl:attribute name="name">NDR-17: Versionsübergreifend eindeutige Nachrichtennummern</xsl:attribute>
            <svrl:text>Es wird empfohlen, Nachrichten im Kontext eines XÖV-Standards versionsübergreifend eindeutige Nummern als Namenssuffix zuzuweisen. Das Suffix wird mit einem Punkt abgegrenzt. Darüber hinaus wird empfohlen, ungültig gewordene Nachrichtennummern nicht im Kontext neuer Nachrichten wiederzuverwenden.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M140"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-18-NamenVonXMLSchemaDateien-NameSchemadateiEnthaeltNameTechnisch</xsl:attribute>
            <xsl:attribute name="name">NDR-18: Namen von XML Schema-Dateien</xsl:attribute>
            <svrl:text>Es wird empfohlen, den Namen des betroffenen XÖV-Standards in den Namen seiner XML Schema-Dateien aufzuführen.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M141"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-18-NamenVonXMLSchemaDateien-SchemaLocationEnthaeltNameTechnischDesStandards</xsl:attribute>
            <xsl:attribute name="name">NDR-18: Namen von XML Schema-Dateien</xsl:attribute>
            <svrl:text>Es wird empfohlen, den Namen des betroffenen XÖV-Standards in den Namen seiner XML Schema-Dateien aufzuführen.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M142"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-20-DokumentationDerRechtsgrundlagen-RechtsgrundlageFuerNachrichtenDokumentiert</xsl:attribute>
            <xsl:attribute name="name">NDR-20: Dokumentation der Rechtsgrundlagen</xsl:attribute>
            <svrl:text>Für die Nachrichten eines XÖV-Standards wird empfohlen, ihre rechtliche Grundlagen innerhalb des Standards zu dokumentieren.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M143"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-21-CodenamenFuerCodesEinerCodeliste-BeschreibungEinesCodesSpezifiziert</xsl:attribute>
            <xsl:attribute name="name">NDR-21: Codenamen für Codes einer Codeliste</xsl:attribute>
            <svrl:text>Es wird empfohlen, allen Codes einer Codeliste eine Beschreibung ihrer Bedeutung zuzuweisen.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M144"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-27-VerwendungDesUrspruenglichenNamensraumpraefixesBeiXMLSchemaImporten-ImportPraefixAusImportiertemSchemaUebernommen</xsl:attribute>
            <xsl:attribute name="name">NDR-27: Verwendung des ursprünglichen Namensraumpräfixes bei XML Schema-Importen</xsl:attribute>
            <svrl:text>Es wird empfohlen, die Bestandteile einer importierten XML Schema-Definition über genau den Namensraumpräfix anzusprechen, der in der importierten XML Schema-Definition genutzt wird.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M145"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-6-NutzungVonXMLAttributenUndXMLElementen-ElementreferenzenUnbenannt</xsl:attribute>
            <xsl:attribute name="name">NDR-6: Nutzung von XML-Attributen und XML-Elementen</xsl:attribute>
            <svrl:text>Es wird empfohlen, fachliche Inhalte eines XÖV-Standards mit Hilfe von XML-Elementen zu modellieren, technische bzw. erläuternde Metadaten dagegen mit der Hilfe von XML-Attributen.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M146"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-6-NutzungVonXMLAttributenUndXMLElementen-KlasseineigenschaftenMitGlobalenElementenAlsTypSindReferenzen</xsl:attribute>
            <xsl:attribute name="name">NDR-6: Nutzung von XML-Attributen und XML-Elementen</xsl:attribute>
            <svrl:text>Es wird empfohlen, fachliche Inhalte eines XÖV-Standards mit Hilfe von XML-Elementen zu modellieren, technische bzw. erläuternde Metadaten dagegen mit der Hilfe von XML-Attributen.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M147"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-6-NutzungVonXMLAttributenUndXMLElementen-KlasseineigenschaftenMitGruppenAlsTypSindReferenzen</xsl:attribute>
            <xsl:attribute name="name">NDR-6: Nutzung von XML-Attributen und XML-Elementen</xsl:attribute>
            <svrl:text>Es wird empfohlen, fachliche Inhalte eines XÖV-Standards mit Hilfe von XML-Elementen zu modellieren, technische bzw. erläuternde Metadaten dagegen mit der Hilfe von XML-Attributen.</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M148"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern-CodelistenversionMitCodelisteVerbunden</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M149"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern-CodelistenspaltenGehoerenZuCodelistenversion</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M150"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern-EigenschaftenVonCodelistenversionenSindCodelistenspalten</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M151"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern-EmpfohleneCodeSpalteIstEineAllgemeineCodeSpalte</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M152"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern-GenutzteCodelistenversionNichtDraft</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M153"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern-GenutzteCodelistenNichtDraft</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M154"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern-UsageBeziehungMitCodeTyp1und2EndetBeiCodelistenversion</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M155"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern-UsageBeziehungOhneCodeTyp1und2EndetBeiCodeliste</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M156"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern-CodeDatentypHatKeineEigenschaften</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M157"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern-CodeTyp1undCodeTyp2SchliessenSichAus</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M158"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern-UsageBeziehungZuCodelistenversionHatStereotypXoevCodeTyp1oder2</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M159"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern-KeineMehrfachbeziehungenZwischenCodeDatentypUndCodelistenOderCodelistenversionen</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M160"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern-GenutzteCodeSpalteEntsprichtCodeSpalteDerGenutztenCodelistenversion</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M161"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern-GenutzteBeschreibungsspalteEntsprichtSpalteDerGenutztenCodelistenversion</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M162"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern-BlacklistUndWhitelistSchliessenSichAus</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M163"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern-EintraegeBlacklistOderWhiteListEntsprechenEintraegenDerGenutztenCodelistenversion</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M164"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern-TypDesCodeElementsIstTokenOderDavonAbgeleitet</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M165"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern-DeprecatedCodesNichtWiederverwenden</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M166"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.0-R1</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M167"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.0-R3</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M168"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.0-R4</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M169"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.0-R5</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M170"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern-C-XOEV-R6</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M171"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-XOEV-R8</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M172"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.0-R9</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M173"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.0-R11</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M174"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.0-R12</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M175"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.0-R13</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M176"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.0-R14</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M177"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.0-R15</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M178"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.0-R16</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M179"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.0-R17</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M180"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.0-R18</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M181"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.0-R19</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M182"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.0-R20</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M183"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.0-R21</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M184"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.0-R23</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M185"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.0-R24</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M186"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.0-R25</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M187"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.0-R26</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M188"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.0-R28</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M189"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.0-R29</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M190"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.0-R30</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M191"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.2-R31-A</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M192"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.2-R32-A</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M193"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-XOEV-R33</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M194"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern-C-XOEV-2.2-R34</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M195"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern-CodelisteImUMLPaketMitKennungAlsNamen</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M196"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern-CodelistenversionImUMLPaketMitVersionAlsNamen</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M197"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern-CodelisteneinträgeImUMLPaketDerCodelistenversion</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M198"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern-CodelistenNachCodelistenHandbuchModelliert</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M199"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.0-R35</xsl:attribute>
            <xsl:attribute name="name">pattern.C-CLH-1.0-R35</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M200"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern-NDR-34-Modellierung-von-Codelistenversionen-als-benannte-Typen</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M201"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern-Korrekte-Codelisten-Ablage</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M202"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern-Keine-Namenskollisionen-bei-benannten-Codelistentypen</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M203"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern-xoevVersionCodeliste-und-NamedType-schliessen-sich-aus</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M204"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern-benannterCodelistenDatentypXSD-verweist-auf-internes-Schema-Paket</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M205"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">NDR-28-ValideW3CXMLSchemaDefinitionen-ValideStandardkonfiguration</xsl:attribute>
            <xsl:attribute name="name">NDR-28: Valide W3C XML Schema-Definitionen</xsl:attribute>
            <svrl:text>Alle XML Schema-Definitionen eines XÖV-Standards müssen gültig bezüglich der XML Schema-Spezifikation des W3C sein (siehe http://www.w3.org/2001/XMLSchema).</svrl:text>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M206"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.2-R42-KorrekteAngabenZurMehrsprachigkeit</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M207"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.2-R40-VollstaendigeSprachauszeichnungFuerCodeliste</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M208"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.2-R40-VollstaendigeSprachauszeichnungFuerVersionCodeliste</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M209"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.2-R39-KorrekteAngabeInDeutscherSprache</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M210"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">pattern.C-CLH-1.2-R42-KorrekteSprachangabeInCodelistenspalte</xsl:attribute>
            <xsl:attribute name="name">Korrekte Codelistenmodellierung</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M211"/>
      </svrl:schematron-output>
   </xsl:template>
   <!--SCHEMATRON PATTERNS-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">XÖV-Prüfanweisungen: Namens- und Entwurfsregeln</svrl:text>
   <xsl:include xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                href="xgenerator-library.xgen-core.xsl"/>
   <xsl:include xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                href="xgenerator-library.uml-access-layer.xsl"/>
   <xsl:include xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                href="xoev-profil.profile-access-layer.xsl"/>
   <xsl:include xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                href="xoev-profil.helpers.xsl"/>
   <!--PATTERN -->
   <!--RULE -->
   <xsl:template match="/" priority="1000" mode="M9">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test=".//@xmi:id"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test=".//@xmi:id">
               <xsl:attribute name="id">id1</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Das Dokument entspricht keiner vom XGenerator verarbeitbaren XMI-Version.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M9"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M9"/>
   <xsl:template match="@*|node()" priority="-2" mode="M9">
      <xsl:apply-templates select="*" mode="M9"/>
   </xsl:template>
   <!--PATTERN -->
   <!--RULE -->
   <xsl:template match="/" priority="1000" mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test=".//uml:Model"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test=".//uml:Model">
               <xsl:attribute name="id">id2</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Das Dokument enthält kein Modell in einer vom XGenerator verarbeitbaren UML-Version.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M10"/>
   <xsl:template match="@*|node()" priority="-2" mode="M10">
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>
   <!--PATTERN NDR-2-HauptstrukturEinesXOEVFachmodells-GenauEinXOEVFachmodellAufObersterModellebeneNDR-2: Hauptstruktur eines XÖV-Fachmodells-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-2: Hauptstruktur eines XÖV-Fachmodells</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model[count(packagedElement[xoev:xsdXModel(.)]) != 1]"
                 priority="1000"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">GenauEinXOEVFachmodellAufObersterModellebene</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Auf der obersten Modellebene darf nur das Modell des eigenen Standards (UML-Modell mit dem Stereotyp xsdXModel) vorliegen. Alle weiteren XÖV-Fachmodelle müssen als externe Modelle im Paket "Externe Modelle" vorliegen. Aktuell existieren <xsl:text/>
                  <xsl:value-of select="count(packagedElement[xoev:xsdXModel(.)])"/>
                  <xsl:text/> Modelle auf der obersten Modellebene: <xsl:text/>
                  <xsl:value-of select="packagedElement[xoev:xsdXModel(.)]/@name"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M11"/>
   <xsl:template match="@*|node()" priority="-2" mode="M11">
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>
   <!--PATTERN NDR-2-HauptstrukturEinesXOEVFachmodells-ExterneModelleImPaketExterneModelleNDR-2: Hauptstruktur eines XÖV-Fachmodells-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-2: Hauptstruktur eines XÖV-Fachmodells</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model" priority="1000" mode="M12">
      <xsl:variable name="models" select="//packagedElement[xoev:xsdXModel(.)]"/>
      <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     count($models) - count($models[ancestor::packagedElement/@name = 'Externe Modelle']) = 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count($models) - count($models[ancestor::packagedElement/@name = 'Externe Modelle']) = 1">
               <xsl:attribute name="id">ExterneModelleImPaketExterneModelle</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Externe Modelle (UML-Modelle mit dem Stereotyp xsdXModel, deren Inhalte nicht zum eigenen Standard gehören) müssen im Paket "Externe Modelle" abgelegt werden. Folgende Modelle liegen derzeit außerhalb des Pakets "Externe Modelle" vor: <xsl:text/>
                  <xsl:value-of select="//packagedElement[xoev:xsdXModel(.) and not(parent::packagedElement/@name = 'Externe Modelle')]/@name"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M12"/>
   <xsl:template match="@*|node()" priority="-2" mode="M12">
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-UnqualifizierteElementeBeiRestriktionUeberMehrereNamensraeumeNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//generalization[                 xoev:xsdRestriction(.) and                 not(xoev:getNamespace(parent::*) = xoev:getNamespace(uml:resolve-general(.)))]"
                 priority="1000"
                 mode="M13">
      <xsl:variable name="elem" select="."/>
      <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     not(                     ((some $e in parent::*/xoev:elements(.)                         satisfies                         xoev:xsdElement($e)/@form = 'qualified' or (xoev:xsdElement($e)/@form = 'default' and                         (ancestor::packagedElement/xoev:xsdSchema(.)/@elementFormDefault = 'qualified' or                         (ancestor::packagedElement/xoev:xsdSchema(.)/@elementFormDefault = 'default' and                         ancestor::packagedElement/xoev:xsdXModel(.)/@elementFormDefault = 'qualified')))) or                     (some $e in uml:resolve-general(.)/xoev:allElements(.)                         satisfies                         xoev:xsdElement($e)/@form = 'qualified' or (xoev:xsdElement($e)/@form = 'default' and                         (uml:resolve-general(.)/ancestor::packagedElement/xoev:xsdSchema(.)/@elementFormDefault = 'qualified' or                         (uml:resolve-general(.)/ancestor::packagedElement/xoev:xsdSchema(.)/@elementFormDefault = 'default' and                         uml:resolve-general(.)/ancestor::packagedElement/xoev:xsdXModel(.)/@elementFormDefault = 'qualified'))))))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not( ((some $e in parent::*/xoev:elements(.) satisfies xoev:xsdElement($e)/@form = 'qualified' or (xoev:xsdElement($e)/@form = 'default' and (ancestor::packagedElement/xoev:xsdSchema(.)/@elementFormDefault = 'qualified' or (ancestor::packagedElement/xoev:xsdSchema(.)/@elementFormDefault = 'default' and ancestor::packagedElement/xoev:xsdXModel(.)/@elementFormDefault = 'qualified')))) or (some $e in uml:resolve-general(.)/xoev:allElements(.) satisfies xoev:xsdElement($e)/@form = 'qualified' or (xoev:xsdElement($e)/@form = 'default' and (uml:resolve-general(.)/ancestor::packagedElement/xoev:xsdSchema(.)/@elementFormDefault = 'qualified' or (uml:resolve-general(.)/ancestor::packagedElement/xoev:xsdSchema(.)/@elementFormDefault = 'default' and uml:resolve-general(.)/ancestor::packagedElement/xoev:xsdXModel(.)/@elementFormDefault = 'qualified'))))))">
               <xsl:attribute name="id">UnqualifizierteElementeBeiRestriktionUeberMehrereNamensraeume</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Eine XML-Restriktion (UML-Generalisierung mit dem Stereotyp xsdRestriction) zwischen zwei in unterschiedlichen Namensräumen liegenden Bausteinen erfordert, dass alle XML-Elemente (UML-Eigenschaften mit dem Stereotyp xsdElement) der beiden Bausteine unqualifiziert sind (XML-Element-Form ist "unqualified"). Im Falle der Restriktion zwischen den beiden Bausteinen <xsl:text/>
                  <xsl:value-of select="xgen:model-path(parent::*)"/>
                  <xsl:text/> (eingeschränkter Baustein) und <xsl:text/>
                  <xsl:value-of select="xgen:model-path(uml:resolve-general(.))"/>
                  <xsl:text/> (Basis-Baustein) wird diese Vorgabe nicht eingehalten.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M13"/>
   <xsl:template match="@*|node()" priority="-2" mode="M13">
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-UnionIstSimpleTypeNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdUnion(.) and (xoev:allElements(.) or xoev:allAttributes(.))] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdUnion(.) and (xoev:allElements(.) or xoev:allAttributes(.))]"
                 priority="1000"
                 mode="M14">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">UnionIstSimpleType</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Ein Datentyp, der eine XML-Union darstellt (Stereotyp xsdUnion), muss ein einfacher Typ sein. Der Union-Typ <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M14"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M14"/>
   <xsl:template match="@*|node()" priority="-2" mode="M14">
      <xsl:apply-templates select="*" mode="M14"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-UnionMemberIstSimpleTypeNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[                 xoev:xsdUnionMember(.) and                 (uml:resolve-supplier(.)[                 not(xoev:topmost-parent(.)/parent::packagedElement/@name = 'W3C Data Types') or xoev:allElements(.) or xoev:allAttributes(.)])]"
                 priority="1000"
                 mode="M15">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">UnionMemberIstSimpleType</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Ein Datentyp, der als Member einer XML-Union genutzt wird (Stereotyp xsdUnionMember), muss ein einfacher Datentyp sein. Der Typ <xsl:text/>
                  <xsl:value-of select="xgen:model-path(uml:resolve-supplier(.))"/>
                  <xsl:text/> verletzt diese Vorgabe. Er wird als Member der Union <xsl:text/>
                  <xsl:value-of select="xgen:model-path(uml:resolve-client(.))"/>
                  <xsl:text/> genutzt.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M15"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M15"/>
   <xsl:template match="@*|node()" priority="-2" mode="M15">
      <xsl:apply-templates select="*" mode="M15"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-UnionMemberIstBenanntNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[                 xoev:xsdUnionMember(.) and                 uml:resolve-supplier(.)[not(parent::packagedElement/@name = 'W3C Data Types' or xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.))]]"
                 priority="1000"
                 mode="M16">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">UnionMemberIstBenannt</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Ein Datentyp, der als Member einer XML-Union genutzt wird (Stereotyp xsdUnionMember), muss ein benannter Datentyp sein. Der Typ <xsl:text/>
                  <xsl:value-of select="xgen:model-path(uml:resolve-supplier(.))"/>
                  <xsl:text/> verletzt diese Vorgabe. Er wird als Member der Union <xsl:text/>
                  <xsl:value-of select="xgen:model-path(uml:resolve-client(.))"/>
                  <xsl:text/> genutzt.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M16"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M16"/>
   <xsl:template match="@*|node()" priority="-2" mode="M16">
      <xsl:apply-templates select="*" mode="M16"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-KeysKeyrefsUniquesImportsUndIncludesSchliessenSichGegenseitigAusNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Dependency(.) and                 count((xoev:xsdImport(.), xoev:xsdInclude(.), xoev:xsdKey(.), xoev:xsdKeyref(.), xoev:xsdUnique(.))) ge 2]"
                 priority="1000"
                 mode="M17">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">KeysKeyrefsUniquesImportsUndIncludesSchliessenSichGegenseitigAus</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Stereotypen xsdKey, xsdKeyref, xsdUnique, xsdInclude und xsdImport schließen sich gegenseitig aus. Die UML-Abhängigkeitsbeziehung zwischen dem Baustein <xsl:text/>
                  <xsl:value-of select="xgen:model-path(uml:resolve-client(.))"/>
                  <xsl:text/> (abhängiger Baustein) und dem Baustein <xsl:text/>
                  <xsl:value-of select="xgen:model-path(uml:resolve-supplier(.))"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M17"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M17"/>
   <xsl:template match="@*|node()" priority="-2" mode="M17">
      <xsl:apply-templates select="*" mode="M17"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-NamedTypeGlobalElementUndGlobalElementAndNamedTypeSchliessenSichGegenseitigAusNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[                 xoev:xsdNamedType(.) and xoev:xsdGlobalElement(.) or xoev:xsdNamedType(.) and xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdGlobalElement(.) and xoev:xsdGlobalElementAndNamedType(.)] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[                 xoev:xsdNamedType(.) and xoev:xsdGlobalElement(.) or xoev:xsdNamedType(.) and xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdGlobalElement(.) and xoev:xsdGlobalElementAndNamedType(.)]"
                 priority="1000"
                 mode="M18">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NamedTypeGlobalElementUndGlobalElementAndNamedTypeSchliessenSichGegenseitigAus</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Stereotypen xsdNamedType, xsdGlobalElement und xsdGlobalElementAndNamedType schließen sich gegenseitig aus. Der Baustein <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M18"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M18"/>
   <xsl:template match="@*|node()" priority="-2" mode="M18">
      <xsl:apply-templates select="*" mode="M18"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-XsdNamedTypeUndXsdMessageSchliessenSichGegenseitigAusNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdNamedType(.) and xoev:xsdMessage(.)] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdNamedType(.) and xoev:xsdMessage(.)]"
                 priority="1000"
                 mode="M19">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">XsdNamedTypeUndXsdMessageSchliessenSichGegenseitigAus</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Stereotypen xsdNamedType und xsdMessage schließen sich gegenseitig aus. Der Baustein <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M19"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M19"/>
   <xsl:template match="@*|node()" priority="-2" mode="M19">
      <xsl:apply-templates select="*" mode="M19"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-AttributeElementeUndLokaleStrukturenSchliessenSichGegenseitigAusNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[count((xoev:xsdLocalStructure(.), xoev:xsdElement(.), xoev:xsdAttribute(.))) ge 2]"
                 priority="1000"
                 mode="M20">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">AttributeElementeUndLokaleStrukturenSchliessenSichGegenseitigAus</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Stereotypen xsdLocalStructure, xsdAttribute und xsdElement schließen sich gegenseitig aus. Die UML-Eigenschaft <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M20"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M20"/>
   <xsl:template match="@*|node()" priority="-2" mode="M20">
      <xsl:apply-templates select="*" mode="M20"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-DefaultUndFixedWerteSchliessenSichGegenseitigAusNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[                 xoev:xsdGlobalAttribute(.)/@defaultwert[. != ''] and xoev:xsdGlobalAttribute(.)/@fixedwert[. != '']]"
                 priority="1000"
                 mode="M21">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">DefaultUndFixedWerteSchliessenSichGegenseitigAus</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Ein globales Attribut darf nicht gleichzeitig einen Defaultwert und einen Fixedwert haben. <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M21"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M21"/>
   <xsl:template match="@*|node()" priority="-2" mode="M21">
      <xsl:apply-templates select="*" mode="M21"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-ElementenpositionIstNatuerlicheZahlGroesserNullNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[(xoev:xsdLocalStructure(.) or xoev:is-element(.)) and                 (ancestor::packagedElement/xoev:xsdXModel(.)/@ermittlungElementreihenfolge = 'Stereotyp' or ../ownedAttribute/(xoev:xsdLocalStructure(.), xoev:xsdElement(.))/@position) and                 not(xs:integer((xoev:xsdLocalStructure(.), xoev:xsdElement(.))/@position) ge 1)]"
                 priority="1000"
                 mode="M22">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">ElementenpositionIstNatuerlicheZahlGroesserNull</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Position eines Elements (Eigenschaft position des Stereotyps xsdElement) muss eine Zahl größer null sein. Die UML-Eigenschaft <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M22"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M22"/>
   <xsl:template match="@*|node()" priority="-2" mode="M22">
      <xsl:apply-templates select="*" mode="M22"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-ElementenpositionIstEindeutigNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[(xoev:xsdElement(.) or xoev:xsdLocalStructure(.)) and                 ../(xoev:elements(.), xoev:xsdLocalStructure(.))[@xmi:id != current()/@xmi:id and (xoev:xsdElement(.), xoev:xsdLocalStructure(.))/@position = current()/(xoev:xsdElement(.), xoev:xsdLocalStructure(.))/@position]]"
                 priority="1000"
                 mode="M23">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">ElementenpositionIstEindeutig</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Position eines Elements (Eigenschaft position des Stereotyps xsdElement) muss innerhalb eines Bausteins (UML-Klasse) eindeutig sein. Die UML-Eigenschaft <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> besitzt jedoch dieselbe Position wie die folgenden Eigenschaften: <xsl:text/>
                  <xsl:value-of select="../(xoev:elements(.), xoev:xsdLocalStructure(.))[@xmi:id != current()/@xmi:id and (xoev:xsdElement(.), xoev:xsdLocalStructure(.))/@position = current()/(xoev:xsdElement(.), xoev:xsdLocalStructure(.))/@position]/@name"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M23"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M23"/>
   <xsl:template match="@*|node()" priority="-2" mode="M23">
      <xsl:apply-templates select="*" mode="M23"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-NamenVonTypenEindeutigNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)) and                 ancestor::packagedElement[xoev:xsdXModel(.)]//(packagedElement | nestedClassifier)[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)) and                 @xmi:id != current()/@xmi:id and xoev:getNamespace(.) = xoev:getNamespace(current()) and @name = current()/@name]] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)) and                 ancestor::packagedElement[xoev:xsdXModel(.)]//(packagedElement | nestedClassifier)[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)) and                 @xmi:id != current()/@xmi:id and xoev:getNamespace(.) = xoev:getNamespace(current()) and @name = current()/@name]]"
                 priority="1000"
                 mode="M24">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NamenVonTypenEindeutig</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Im gleichen Namensraum dürfen keine benannten Datentypen (UML-Klassen mit dem Stereotyp xsdNamedType oder xsdGlobalElementAndNamedType) mit dem gleichen Namen existieren. Der Name des Typs <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> ist im Namensraum "<xsl:text/>
                  <xsl:value-of select="xoev:getNamespace(.)"/>
                  <xsl:text/>" nicht eindeutig.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M24"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M24"/>
   <xsl:template match="@*|node()" priority="-2" mode="M24">
      <xsl:apply-templates select="*" mode="M24"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-NamenVonGlobalenElementenEindeutigNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdGlobalElement(.) or xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdMessage(.)) and                 ancestor::packagedElement[xoev:xsdXModel(.)]//(packagedElement | nestedClassifier)[(xoev:xsdGlobalElement(.) or xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdMessage(.)) and                 @xmi:id != current()/@xmi:id and xoev:getNamespace(.) = xoev:getNamespace(current()) and @name = current()/@name]] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[(xoev:xsdGlobalElement(.) or xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdMessage(.)) and                 ancestor::packagedElement[xoev:xsdXModel(.)]//(packagedElement | nestedClassifier)[(xoev:xsdGlobalElement(.) or xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdMessage(.)) and                 @xmi:id != current()/@xmi:id and xoev:getNamespace(.) = xoev:getNamespace(current()) and @name = current()/@name]]"
                 priority="1000"
                 mode="M25">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NamenVonGlobalenElementenEindeutig</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Im gleichen Namensraum dürfen keine globalen Elemente (UML-Klassen mit dem Stereotyp xsdGlobalElement) mit dem gleichen Namen existieren. Der Name des globalen Elements <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> ist im Namensraum "<xsl:text/>
                  <xsl:value-of select="xoev:getNamespace(.)"/>
                  <xsl:text/>" nicht eindeutig.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M25"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M25"/>
   <xsl:template match="@*|node()" priority="-2" mode="M25">
      <xsl:apply-templates select="*" mode="M25"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-SchemaDefinitionenNichtVerschachteltNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdSchema(.) and ancestor::packagedElement[xoev:xsdSchema(.)]]"
                 priority="1000"
                 mode="M26">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">SchemaDefinitionenNichtVerschachtelt</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>XML Schema-Definitionen (UML-Pakete mit dem Stereotyp xsdSchema) dürfen nicht verschachtelt sein. Das XML Schema-Paket <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> befindet sich jedoch im XML Schema-Paket <xsl:text/>
                  <xsl:value-of select="xgen:model-path(ancestor::packagedElement[xoev:xsdSchema(.)])"/>
                  <xsl:text/>.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M26"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M26"/>
   <xsl:template match="@*|node()" priority="-2" mode="M26">
      <xsl:apply-templates select="*" mode="M26"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-CodelistenHabenEinenNamenNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xoevCodeliste(.) and xoev:xsdNamedType(.) and @name = ''] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xoevCodeliste(.) and xoev:xsdNamedType(.) and @name = '']"
                 priority="1000"
                 mode="M27">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">CodelistenHabenEinenNamen</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Benannte Codelisten (UML-Enumerationen mit den Stereotypen xoevCodeliste und xsdNamedType) müssen einen Namen (Name der UML-Enumeration) besitzen. Im Paket <xsl:text/>
                  <xsl:value-of select="xgen:model-path(parent::packagedElement)"/>
                  <xsl:text/> befindet sich jedoch eine Codeliste ohne einen solchen Namen.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M27"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M27"/>
   <xsl:template match="@*|node()" priority="-2" mode="M27">
      <xsl:apply-templates select="*" mode="M27"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-CodelistenBasistypIstSimpleTypeNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[                 xoev:xsdCodeList(.)/xoev:resolve-base(.)[not(xoev:topmost-parent(.)/parent::packagedElement/@name = 'W3C Data Types') or xoev:allElements(.) or xoev:allAttributes(.)]] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[                 xoev:xsdCodeList(.)/xoev:resolve-base(.)[not(xoev:topmost-parent(.)/parent::packagedElement/@name = 'W3C Data Types') or xoev:allElements(.) or xoev:allAttributes(.)]]"
                 priority="1000"
                 mode="M28">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">CodelistenBasistypIstSimpleType</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Der Basistyp einer Codeliste (Eigenschaft base des Stereotyps xsdCodeList) muss ein einfacher Datentyp sein. Die Codeliste <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe. Der Basistyp der Codeliste ist <xsl:text/>
                  <xsl:value-of select="xoev:xsdCodeList(.)/xoev:resolve-base(.)/xgen:model-path(.)"/>
                  <xsl:text/>.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M28"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M28"/>
   <xsl:template match="@*|node()" priority="-2" mode="M28">
      <xsl:apply-templates select="*" mode="M28"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-CodelistenBasistypIstTokenOderAbleitungVonTokenNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdCodeList(.)/xoev:resolve-base(.)[empty((., xoev:allParents(.))[@name = 'token'])]] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdCodeList(.)/xoev:resolve-base(.)[empty((., xoev:allParents(.))[@name = 'token'])]]"
                 priority="1000"
                 mode="M29">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">CodelistenBasistypIstTokenOderAbleitungVonToken</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Der Basistyp einer Codeliste (Eigenschaft des Stereotyps xsdCodeList) muss xs:token oder einem davon abgeleiteten Datentypen entsprechen. Die Codeliste <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe. Der Basistyp der Codeliste ist <xsl:text/>
                  <xsl:value-of select="xoev:xsdCodeList(.)/xoev:resolve-base(.)/xgen:model-path(.)"/>
                  <xsl:text/>.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M29"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M29"/>
   <xsl:template match="@*|node()" priority="-2" mode="M29">
      <xsl:apply-templates select="*" mode="M29"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-ElementeUndAttributeSindBenanntNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="             /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[(xoev:xsdAttribute(.) or xoev:xsdElement(.)) and not(xoev:is-ref(.)) and @name = '']"
                 priority="1000"
                 mode="M30">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">ElementeUndAttributeSindBenannt</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>XML-Elemente und XML-Attribute müssen benannt sein. Ein Element bzw. Attribut in der Klasse <xsl:text/>
                  <xsl:value-of select="xgen:model-path(parent::*)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M30"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M30"/>
   <xsl:template match="@*|node()" priority="-2" mode="M30">
      <xsl:apply-templates select="*" mode="M30"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-ElementnamenSindAufBausteinebeneEindeutigNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[ancestor::packagedElement[xoev:xsdSchema(.)] and uml:is-Class(.)] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[ancestor::packagedElement[xoev:xsdSchema(.)] and uml:is-Class(.)]"
                 priority="1000"
                 mode="M31">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(xoev:allElementNamesIncludingRefsAndGroups(.)) = count(distinct-values(xoev:allElementNamesIncludingRefsAndGroups(.)))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(xoev:allElementNamesIncludingRefsAndGroups(.)) = count(distinct-values(xoev:allElementNamesIncludingRefsAndGroups(.)))">
               <xsl:attribute name="id">ElementnamenSindAufBausteinebeneEindeutig</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die XML-Elemente eines Bausteins (UML-Klasse) müssen eindeutig benannt sein. Hierbei sind auch die Namen referenzierter globaler Elemente und die Namen der Elemente in referenzierten Gruppen zu berücksichtigen. Im Kontext des Bausteins <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> sind die folgenden Namen nicht eindeutig: <xsl:text/>
                  <xsl:value-of select="                         if (xoev:getDuplicateStrings(xoev:allElementNamesIncludingRefsAndGroups(.)) = '') then                             'Elemente ohne Namen'                         else                             xoev:getDuplicateStrings(xoev:allElementNamesIncludingRefsAndGroups(.))"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M31"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M31"/>
   <xsl:template match="@*|node()" priority="-2" mode="M31">
      <xsl:apply-templates select="*" mode="M31"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-GlobaleElementeMitTypHabenKeineEigenenElementeOderAttributeNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and xoev:dependencies-by-client(.)[xoev:xsdGlobalElementType(.)] and                 (xoev:allElements(.) or xoev:allAttributes(.))] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifer[(xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and xoev:dependencies-by-client(.)[xoev:xsdGlobalElementType(.)] and                 (xoev:allElements(.) or xoev:allAttributes(.))]"
                 priority="1000"
                 mode="M32">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">GlobaleElementeMitTypHabenKeineEigenenElementeOderAttribute</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Typisierte globale Elemente (UML-Klassen mit dem Stereotyp xsdGlobalElement und einer UML-Abhängigkeitsbeziehung mit dem Stereotyp xsdGlobalElementType) dürfen keine eigenen XML-Elemente (UML-Eigenschaften mit dem Stereotyp xsdElement) oder XML-Attribute (UML-Eigenschaften mit dem Stereotyp xsdAttribute) besitzen. Das globale Element <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M32"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M32"/>
   <xsl:template match="@*|node()" priority="-2" mode="M32">
      <xsl:apply-templates select="*" mode="M32"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-TypisierteGlobaleElementeDuerfenKeineBenanntenTypenSeinNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)) and xoev:dependencies-by-client(.)[xoev:xsdGlobalElementType(.)]] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifer[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)) and xoev:dependencies-by-client(.)[xoev:xsdGlobalElementType(.)]]"
                 priority="1000"
                 mode="M33">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">TypisierteGlobaleElementeDuerfenKeineBenanntenTypenSein</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Typisierte globale Elemente (UML-Abhängigkeitsbeziehung mit dem Stereotyp xsdGlobalElementType) dürfen keine benannten Typen sein (Stereotyp xsdNamedType oder xsdGlobalElementAndNamedType). Der Baustein <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M33"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M33"/>
   <xsl:template match="@*|node()" priority="-2" mode="M33">
      <xsl:apply-templates select="*" mode="M33"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-GlobaleElementeMaximalEinenTypNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and count(xoev:dependencies-by-client(.)[xoev:xsdGlobalElementType(.)]) ge 2] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifer[(xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and count(xoev:dependencies-by-client(.)[xoev:xsdGlobalElementType(.)]) ge 2]"
                 priority="1000"
                 mode="M34">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">GlobaleElementeMaximalEinenTyp</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Globale Elemente (UML-Klassen mit dem Stereotyp xsdGlobalElement) dürfen nicht mehr als einen Typen zugewiesen bekommen (UML-Abhängigkeitsbeziehung mit dem Stereotyp xsdGlobalElementType). Das globale Element <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe. Ihm sind die folgenden Typen zugewiesen: <xsl:text/>
                  <xsl:value-of select="xoev:dependencies-by-client(.)[xoev:xsdGlobalElementType(.)]/uml:resolve-supplier(.)/@name"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M34"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M34"/>
   <xsl:template match="@*|node()" priority="-2" mode="M34">
      <xsl:apply-templates select="*" mode="M34"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-TypisierteGlobaleElementeHabenBenanntenTypNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and                 xoev:dependencies-by-client(.)[xoev:xsdGlobalElementType(.)]/uml:resolve-supplier(.)[not(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.) or parent::packagedElement/@name = 'W3C Data Types')]] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and                 xoev:dependencies-by-client(.)[xoev:xsdGlobalElementType(.)]/uml:resolve-supplier(.)[not(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.) or parent::packagedElement/@name = 'W3C Data Types')]]"
                 priority="1000"
                 mode="M35">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">TypisierteGlobaleElementeHabenBenanntenTyp</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Typisierte globale Elemente (UML-Klassen mit dem Stereotyp xsdGlobalElement und einer UML-Abhängigkeitsbeziehung mit dem Stereotyp xsdGlobalElementType) müssen einen benannten Typ haben. Das globale Element <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe. Ihm ist der folgende Baustein zugewiesen: <xsl:text/>
                  <xsl:value-of select="xoev:dependencies-by-client(.)[xoev:xsdGlobalElementType(.)]/uml:resolve-supplier(.)/@name"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M35"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M35"/>
   <xsl:template match="@*|node()" priority="-2" mode="M35">
      <xsl:apply-templates select="*" mode="M35"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-ElementReferenzReferenziertGlobalesElementOderElementgruppeNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="             /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[xoev:xsdElement(.) and xoev:is-ref(.) and                 uml:resolve-type(.)[not(xoev:xsdGlobalElement(.) or xoev:xsdMessage(.) or xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdGroup(.))]]"
                 priority="1000"
                 mode="M36">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">ElementReferenzReferenziertGlobalesElementOderElementgruppe</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Element-Referenzen müssen auf globale Elemente oder Elementgruppen referenzieren. Das globale Element <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe. Ihm ist der folgende Baustein zugewiesen: <xsl:text/>
                  <xsl:value-of select="uml:resolve-type(.)/@name"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M36"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M36"/>
   <xsl:template match="@*|node()" priority="-2" mode="M36">
      <xsl:apply-templates select="*" mode="M36"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-DateinameEinerXMLSchemaDefinitionIstAngegebenNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdSchema(.)] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdSchema(.)]"
                 priority="1000"
                 mode="M37">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="xoev:xsdSchema(.)/@schemaFile[. != '']"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="xoev:xsdSchema(.)/@schemaFile[. != '']">
               <xsl:attribute name="id">DateinameEinerXMLSchemaDefinitionIstAngegeben</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>XML Schema-Definitionen (UML-Pakete mit dem Stereotyp xsdSchema) müssen einen Dateinamen aufweisen (Eigenschaft schemaFile des Stereotyps xsdSchema). Das Schema-Paket <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M37"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M37"/>
   <xsl:template match="@*|node()" priority="-2" mode="M37">
      <xsl:apply-templates select="*" mode="M37"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-SchemaLocationEinerXMLSchemaDefinitionIstAngegebenNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[                 xoev:xsdSchema(.) and ancestor::packagedElement/xoev:xsdXModel(.)[@deployment = 'true' and not(@schemaLocationBase[. != ''])]] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[                 xoev:xsdSchema(.) and ancestor::packagedElement/xoev:xsdXModel(.)[@deployment = 'true' and not(@schemaLocationBase[. != ''])]]"
                 priority="1000"
                 mode="M38">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="xoev:xsdSchema(.)/@schemaLocation[. != '']"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="xoev:xsdSchema(.)/@schemaLocation[. != '']">
               <xsl:attribute name="id">SchemaLocationEinerXMLSchemaDefinitionIstAngegeben</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>XML Schema-Definitionen (UML-Pakete mit dem Stereotyp xsdSchema) müssen eine Schema Location aufweisen (Eigenschaft schemaLocation des Stereotyps xsdSchema), sofern keine Schema Location Base für das XÖV-Fachmodell (UML-Modell mit der Eigenschaft schemaLocationBase des Stereotyps xsdXModel) vorliegt. Das Schema-Paket <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> besitzt keine Schema Location. Gleichzeitig ist auch keine Schema Location Base spezifiziert.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M38"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M38"/>
   <xsl:template match="@*|node()" priority="-2" mode="M38">
      <xsl:apply-templates select="*" mode="M38"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-ImportsNurZwischenXMLSchemaDefinitionenUnterschiedlicherNamensraeumeNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdImport(.)] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdImport(.)]"
                 priority="1000"
                 mode="M39">
      <xsl:variable name="client" select="uml:resolve-client(.)"/>
      <xsl:variable name="supplier" select="uml:resolve-supplier(.)"/>
      <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     not($client/xoev:getNamespace(.) = $supplier/xoev:getNamespace(.)) and                     not(($client/xoev:xsdSchema(.)/@prefix, $client/ancestor::packagedElement/xoev:xsdXModel(.)/@prefix)[1] =                     (xoev:xsdImport(.)/@prefix, $supplier/xoev:xsdSchema(.)/@prefix, $supplier/ancestor::packagedElement/xoev:xsdXModel(.)/@prefix)[1])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not($client/xoev:getNamespace(.) = $supplier/xoev:getNamespace(.)) and not(($client/xoev:xsdSchema(.)/@prefix, $client/ancestor::packagedElement/xoev:xsdXModel(.)/@prefix)[1] = (xoev:xsdImport(.)/@prefix, $supplier/xoev:xsdSchema(.)/@prefix, $supplier/ancestor::packagedElement/xoev:xsdXModel(.)/@prefix)[1])">
               <xsl:attribute name="id">ImportsNurZwischenXMLSchemaDefinitionenUnterschiedlicherNamensraeume</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Namensräume (spezifiziert an Schema-Paketen mittels der Eigenschaft namespace des Stereotyps xsdSchema oder am XÖV-Fachmodell mittels der Eigenschaft namespace des Stereotyps xsdXModel) und Namensraumpräfixe (spezifiziert an der Import-Beziehung mittels der Eigenschaft prefix des Stereotyps xsdImport, am Schema-Paket mittels der Eigenschaft prefix des Stereotyps xsdSchema oder am XÖV-Fachmodell mittels der Eigenschaft prefix des Stereotyps xsdXModel) zweier XML Schema-Definitionen (UML-Pakete mit dem Stereotyp xsdSchema), zwischen denen eine XML-Import-Beziehung besteht (UML-Abhängigkeitsbeziehung mit dem Stereotyp xsdImport) müssen sich unterscheiden. Die beiden Schema-Pakete <xsl:text/>
                  <xsl:value-of select="xgen:model-path(uml:resolve-client(.))"/>
                  <xsl:text/> (importierendes Paket) und <xsl:text/>
                  <xsl:value-of select="xgen:model-path(uml:resolve-supplier(.))"/>
                  <xsl:text/> (importiertes Paket) verletzen diese Vorgabe.<xsl:text/>
                  <xsl:value-of select="                         if ($client/xoev:getNamespace(.) = $supplier/xoev:getNamespace(.)) then                             concat(' Der Namensraum ist identisch: ', $client/xoev:getNamespace(.), '.')                         else                             ''"/>
                  <xsl:text/>
                  <xsl:text/>
                  <xsl:value-of select="                         if (($client/xoev:xsdSchema(.)/@prefix, $client/ancestor::packagedElement/xoev:xsdXModel(.)/@prefix)[1] =                         (xoev:xsdImport(.)/@prefix, $supplier/xoev:xsdSchema(.)/@prefix, $supplier/ancestor::packagedElement/xoev:xsdXModel(.)/@prefix)[1]) then                             concat(' Das Präfix ist identisch: ', ($client/xoev:xsdSchema(.)/@prefix, $client/ancestor::packagedElement/xoev:xsdXModel(.)/@prefix)[1], '.')                         else                             ''"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M39"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M39"/>
   <xsl:template match="@*|node()" priority="-2" mode="M39">
      <xsl:apply-templates select="*" mode="M39"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-ImportUndIncludeBeziehungenZyklenfreiNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdSchema(.)] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdSchema(.)]"
                 priority="1000"
                 mode="M40">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     empty(                     index-of(                     xoev:allImportedAndIncludedPackageIDs(                     xoev:dependencies-by-client(.)[xoev:xsdImport(.) or xoev:xsdInclude(.)]/uml:resolve-supplier(.)/@xmi:id,                     ancestor::uml:Model),                     @xmi:id))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="empty( index-of( xoev:allImportedAndIncludedPackageIDs( xoev:dependencies-by-client(.)[xoev:xsdImport(.) or xoev:xsdInclude(.)]/uml:resolve-supplier(.)/@xmi:id, ancestor::uml:Model), @xmi:id))">
               <xsl:attribute name="id">ImportUndIncludeBeziehungenZyklenfrei</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Eine XML Schema-Definition (UML-Paket mit dem Stereotyp xsdSchema) darf sich nicht direkt oder indirekt selbst inkludieren oder importieren. Das Schema-Paket <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M40"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M40"/>
   <xsl:template match="@*|node()" priority="-2" mode="M40">
      <xsl:apply-templates select="*" mode="M40"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-DateinamenVonXMLSchemaDefinitionenEindeutigNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]"
                 priority="1000"
                 mode="M41">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     count(descendant::packagedElement/xoev:xsdSchema(.)/@schemaFile) =                     count(distinct-values(descendant::packagedElement/xoev:xsdSchema(.)/@schemaFile))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(descendant::packagedElement/xoev:xsdSchema(.)/@schemaFile) = count(distinct-values(descendant::packagedElement/xoev:xsdSchema(.)/@schemaFile))">
               <xsl:attribute name="id">DateinamenVonXMLSchemaDefinitionenEindeutig</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>XML Schema-Definition (UML-Pakete mit dem Stereotyp xsdSchema) müssen im XÖV-Fachmodell eindeutige Dateinamen aufweisen (Eigenschaft schemaFile des Sterotyps xsdSchema). Die folgenden Dateinamen werden mehrfach verwendet: <xsl:text/>
                  <xsl:value-of select="                         distinct-values(descendant::packagedElement[xoev:xsdSchema(.) and                         (some $s in current()/descendant::packagedElement[xoev:xsdSchema(.)]                             satisfies $s/@xmi:id != @xmi:id and $s/xoev:xsdSchema(.)/@schemaFile = xoev:xsdSchema(.)/@schemaFile)]/xoev:xsdSchema(.)/@schemaFile)"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M41"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M41"/>
   <xsl:template match="@*|node()" priority="-2" mode="M41">
      <xsl:apply-templates select="*" mode="M41"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-SchemaLocationsVonXMLSchemaDefinitionenEindeutigNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]"
                 priority="1000"
                 mode="M42">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     count(descendant::packagedElement/xoev:xsdSchema(.)/@schemaLocation) =                     count(distinct-values(descendant::packagedElement/xoev:xsdSchema(.)/@schemaLocation))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(descendant::packagedElement/xoev:xsdSchema(.)/@schemaLocation) = count(distinct-values(descendant::packagedElement/xoev:xsdSchema(.)/@schemaLocation))">
               <xsl:attribute name="id">SchemaLocationsVonXMLSchemaDefinitionenEindeutig</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>XML Schema-Definition (UML-Pakete mit dem Stereotyp xsdSchema) müssen im XÖV-Fachmodell eindeutige Schema Locations aufweisen (Eigenschaft schemaLocation des Stereotyps xsdSchema), sofern solche explizit angegeben wurden. Die folgenden Schema Locations werden mehrfach verwendet: <xsl:text/>
                  <xsl:value-of select="                         distinct-values(descendant::packagedElement[xoev:xsdSchema(.) and                         (some $s in current()/descendant::packagedElement[xoev:xsdSchema(.)]                             satisfies $s/@xmi:id != @xmi:id and $s/xoev:xsdSchema(.)/@schemaLocation = xoev:xsdSchema(.)/@schemaLocation)]/xoev:xsdSchema(.)/@schemaLocation)"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M42"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M42"/>
   <xsl:template match="@*|node()" priority="-2" mode="M42">
      <xsl:apply-templates select="*" mode="M42"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-InkludierterNamensraumUndInkludiertesPraefixEntsprechenDenenDesInkludierendemSchemasNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdInclude(.)]"
                 priority="1000"
                 mode="M43">
      <xsl:variable name="client" select="uml:resolve-client(.)"/>
      <xsl:variable name="supplier" select="uml:resolve-supplier(.)"/>
      <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     $client/xoev:getNamespace(.) = $supplier/xoev:getNamespace(.) and                     ($client/xoev:xsdSchema(.)/@prefix, $client/ancestor::packagedElement/xoev:xsdXModel(.)/@prefix)[1] =                     ($supplier/xoev:xsdSchema(.)/@prefix, $supplier/ancestor::packagedElement/xoev:xsdXModel(.)/@prefix)[1]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="$client/xoev:getNamespace(.) = $supplier/xoev:getNamespace(.) and ($client/xoev:xsdSchema(.)/@prefix, $client/ancestor::packagedElement/xoev:xsdXModel(.)/@prefix)[1] = ($supplier/xoev:xsdSchema(.)/@prefix, $supplier/ancestor::packagedElement/xoev:xsdXModel(.)/@prefix)[1]">
               <xsl:attribute name="id">InkludierterNamensraumUndInkludiertesPraefixEntsprechenDenenDesInkludierendemSchemas</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Der Namensraum und das Präfix einer inkludierten XML Schema-Definition müssen denen der inkludierenden XML Schema-Definition entsprechen. Die inkludierende XML Schema-Definition <xsl:text/>
                  <xsl:value-of select="xgen:model-path($client)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M43"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M43"/>
   <xsl:template match="@*|node()" priority="-2" mode="M43">
      <xsl:apply-templates select="*" mode="M43"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-ImportsUndIncludesNurZwischenSchemaPaketenNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdInclude(.) or xoev:xsdImport(.)]"
                 priority="1000"
                 mode="M44">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="uml:resolve-supplier(.)[xoev:xsdSchema(.)] and uml:resolve-client(.)[xoev:xsdSchema(.)]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="uml:resolve-supplier(.)[xoev:xsdSchema(.)] and uml:resolve-client(.)[xoev:xsdSchema(.)]">
               <xsl:attribute name="id">ImportsUndIncludesNurZwischenSchemaPaketen</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>XML-Imports (UML-Abhängigkeitsbeziehung mit dem Stereotyp xsdImport) und XML-Includes (UML-Abhängigkeitsbeziehung mit dem Stereotyp xsdInclude) müssen zwei XML Schema-Definitionen (UML-Pakete mit dem Stereotyp xsdSchema) verbinden. <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M44"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M44"/>
   <xsl:template match="@*|node()" priority="-2" mode="M44">
      <xsl:apply-templates select="*" mode="M44"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-BenannteTypenMuessenNamenHabenNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)) and not(@name[. != ''])]"
                 priority="1000"
                 mode="M45">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">BenannteTypenMuessenNamenHaben</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Benannte Datentypen (UML-Klassen mit dem Stereotyp xsdNamedType oder xsdGlobalElementAndNamedType) müssen einen Namen besitzen. Im Paket <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> liegt ein Typ ohne Namen vor.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M45"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M45"/>
   <xsl:template match="@*|node()" priority="-2" mode="M45">
      <xsl:apply-templates select="*" mode="M45"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-GruppenMuessenNamenHabenNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdGroup(.) and not(@name[. != ''])]"
                 priority="1000"
                 mode="M46">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">GruppenMuessenNamenHaben</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>XML-Gruppen (UML-Klassen mit dem Stereotyp xsdGroup) müssen einen Namen besitzen. Im Paket <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> liegt eine solche Gruppe ohne Namen vor.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M46"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M46"/>
   <xsl:template match="@*|node()" priority="-2" mode="M46">
      <xsl:apply-templates select="*" mode="M46"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-GlobaleElementeMuessenNamenHabenNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdGlobalElement(.) or xoev:xsdMessage(.) or xoev:xsdGlobalElementAndNamedType(.)) and not(@name[. != ''])]"
                 priority="1000"
                 mode="M47">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">GlobaleElementeMuessenNamenHaben</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Globale Elemente (UML-KLassen mit dem Stereotyp xsdGlobalElement) müssen einen Namen besitzen. Im Paket <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> liegt ein solches globales Element ohne Namen vor.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M47"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M47"/>
   <xsl:template match="@*|node()" priority="-2" mode="M47">
      <xsl:apply-templates select="*" mode="M47"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-GruppenHabenMindestensEinElementOderAttributNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdGroup(.)]"
                 priority="1000"
                 mode="M48">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="xoev:elements(.) or xoev:attributes(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="xoev:elements(.) or xoev:attributes(.)">
               <xsl:attribute name="id">GruppenHabenMindestensEinElementOderAttribut</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>XML-Gruppen (UML-Klassen mit dem Stereotyp xsdGroup) müssen mindestens ein XML-Element oder -Attribut besitzen. Die Gruppe <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> versetzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M48"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M48"/>
   <xsl:template match="@*|node()" priority="-2" mode="M48">
      <xsl:apply-templates select="*" mode="M48"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-GruppenEnthaltenEntwederElementeOderAttributeNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdGroup(.) and xoev:attributes(.) and xoev:elements(.)]"
                 priority="1000"
                 mode="M49">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">GruppenEnthaltenEntwederElementeOderAttribute</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>XML-Gruppen (UML-Klassen mit dem Stereotyp xsdGroup) besitzen entweder ausschließlich XML-Elemente oder ausschließlich XML-Attribute. Die Gruppe <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M49"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M49"/>
   <xsl:template match="@*|node()" priority="-2" mode="M49">
      <xsl:apply-templates select="*" mode="M49"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-AnnotierteKlassenInSchemaPaketenNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[                 xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdChoice(.) or xoev:xsdCode(.) or xoev:xsdGlobalElement(.) or xoev:xsdMessage(.) or xoev:xsdAnyContents(.)]"
                 priority="1000"
                 mode="M50">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="ancestor::packagedElement[xoev:xsdSchema(.)]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="ancestor::packagedElement[xoev:xsdSchema(.)]">
               <xsl:attribute name="id">AnnotierteKlassenInSchemaPaketen</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>UML-Klassen, die mit Stereotypen annotiert sind, müssen sich direkt oder indirekt in einem Schema-Paket (UML-Paket mit dem Stereotyp xsdSchema) befinden. Die Klasse <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M50"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M50"/>
   <xsl:template match="@*|node()" priority="-2" mode="M50">
      <xsl:apply-templates select="*" mode="M50"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-AnnotierteAbhaengigkeitsbeziehungenInSchemaPaketenNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[                 xoev:xsdInclude(.) or xoev:xsdImport(.) or xoev:xsdKey(.) or xoev:xsdKeyref(.) or xoev:xsdUnique(.)]"
                 priority="1000"
                 mode="M51">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="ancestor::packagedElement[xoev:xsdSchema(.)]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="ancestor::packagedElement[xoev:xsdSchema(.)]">
               <xsl:attribute name="id">AnnotierteAbhaengigkeitsbeziehungenInSchemaPaketen</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>UML-Abhängigkeitsbeziehungen (Dependencies), die mit Stereotypen annotiert sind, müssen sich direkt oder indirekt in einem Schema-Paket (UML-Paket mit dem Stereotyp xsdSchema) befinden. <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M51"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M51"/>
   <xsl:template match="@*|node()" priority="-2" mode="M51">
      <xsl:apply-templates select="*" mode="M51"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-AnnotierteGeneralisierungenInSchemaPaketenNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//generalization[xoev:xsdRestriction(.)]"
                 priority="1000"
                 mode="M52">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="ancestor::packagedElement[xoev:xsdSchema(.)]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="ancestor::packagedElement[xoev:xsdSchema(.)]">
               <xsl:attribute name="id">AnnotierteGeneralisierungenInSchemaPaketen</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>UML-Generalisierungsbeziehungen, die mit Stereotypen annotiert sind, müssen sich direkt oder indirekt in einem Schema-Paket (UML-Paket mit dem Stereotyp xsdSchema) befinden. <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M52"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M52"/>
   <xsl:template match="@*|node()" priority="-2" mode="M52">
      <xsl:apply-templates select="*" mode="M52"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-AnnotierteElementeUndAttributeInSchemaPaketenNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[xoev:xsdElement(.) or xoev:xsdAttribute(.) or xoev:xsdLocalStructure(.)]"
                 priority="1000"
                 mode="M53">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="ancestor::packagedElement[xoev:xsdSchema(.)]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="ancestor::packagedElement[xoev:xsdSchema(.)]">
               <xsl:attribute name="id">AnnotierteElementeUndAttributeInSchemaPaketen</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>XML-Elemente und -Attribute (UML-Eigenschaften mit dem Stereotyp xsdElement oder xsdAttribute) müssen sich direkt oder indirekt in einem Schema-Paket (UML-Paket mit dem Stereotyp xsdSchema) befinden. Das <xsl:text/>
                  <xsl:value-of select="                         if (xoev:xsdElement(.)) then                             'Element '                         else                             'Attribut '"/>
                  <xsl:text/>
                  <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M53"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M53"/>
   <xsl:template match="@*|node()" priority="-2" mode="M53">
      <xsl:apply-templates select="*" mode="M53"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-TypenUndGlobaleElementeEnthaltenElementeAttributeOderLokaleStrukturenNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)/@standardeinstellungEigenschaften = 'keine']//packagedElement[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and ownedAttribute and not(xoev:xoevVersionCodeliste(.))] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)/@standardeinstellungEigenschaften = 'keine']//nestedClassifier[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and ownedAttribute and not(xoev:xoevVersionCodeliste(.))]"
                 priority="1000"
                 mode="M54">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(ownedAttribute[xoev:xsdElement(.) or xoev:xsdAttribute(.) or xoev:xsdLocalStructure(.)]) = count(ownedAttribute)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(ownedAttribute[xoev:xsdElement(.) or xoev:xsdAttribute(.) or xoev:xsdLocalStructure(.)]) = count(ownedAttribute)">
               <xsl:attribute name="id">TypenUndGlobaleElementeEnthaltenElementeAttributeOderLokaleStrukturen</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>UML-Klassen, die Typen (Stereotyp xsdNamedType) oder globale Elemente (Stereotyp xsdGlobalElement) bzw. beides (Stereotyp xsdGlobalElementAndNamedType) repräsentieren, besitzen ausschließlich Eigenschaften, die XML-Elemente (Stereotyp xsdElement), XML-Attribute (Stereotyp xsdAttribute) oder lokale XML-Strukturen (Stereotyp xsdLocalStructure) repräsentieren. Die Klasse <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M54"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M54"/>
   <xsl:template match="@*|node()" priority="-2" mode="M54">
      <xsl:apply-templates select="*" mode="M54"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-AnyContentsKlassenOhneEigenschaftenNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdAnyContents(.)] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdAnyContents(.)]"
                 priority="1000"
                 mode="M55">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="empty(xoev:elements(.))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="empty(xoev:elements(.))">
               <xsl:attribute name="id">AnyContentsKlassenOhneEigenschaften</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>UML-Klassen, die any-Elemente repräsentieren (Stereotyp xsdAnyContents), dürfen keine XML-Elemente (UML-Eigenschaften mit dem Stereotyp xsdElement) besitzen. Die Klasse <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M55"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M55"/>
   <xsl:template match="@*|node()" priority="-2" mode="M55">
      <xsl:apply-templates select="*" mode="M55"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-EinfacheVererbungNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Class(.) and count(generalization) gt 1] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Class(.) and count(generalization) gt 1]"
                 priority="1000"
                 mode="M56">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">EinfacheVererbung</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Typen und globale Elemente dürfen von maximal einem Basistypen ableiten. Die Klasse <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M56"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M56"/>
   <xsl:template match="@*|node()" priority="-2" mode="M56">
      <xsl:apply-templates select="*" mode="M56"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionSchraenktEinNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//generalization[xoev:xsdRestriction(.) and                 not(uml:resolve-general(.)/ancestor::packagedElement[xoev:xoevAdapter(.)])]"
                 priority="1000"
                 mode="M57">
      <xsl:variable name="restricted" select=".."/>
      <xsl:variable name="base" select="uml:resolve-general(.)"/>
      <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     (every $p in $restricted/ownedAttribute                         satisfies                         $base/ownedAttribute[@name = $p/@name]/uml:resolve-type(.)[                                                  (if (uml:resolve-type($p)/xoev:xoevCodeTyp4(.) or uml:resolve-type($p)/xoev:usages-by-client(.)) then                             xoev:xoevDatentyp(.)/@kennung = 'urn:xoev-de:kosit:xoev:datentyp:code' or xoev:xoevCodeTyp4(.) or xoev:usages-by-client(.)                         else                             @xmi:id = $p/uml:resolve-type(.)/(., xoev:allRestrictionParents(.))/@xmi:id or                             @name = ('token', 'string', 'normalizedString') and $p/uml:resolve-type(.)[uml:is-Enumeration(.)])]                                                  and                                                  $base/ownedAttribute[@name = $p/@name and xoev:lowerBound($p) ge xoev:lowerBound(.) and                         (xoev:upperBound(.) = -1 or xoev:upperBound($p) != -1 and xoev:upperBound($p) le xoev:upperBound(.))]) and                     ($restricted/xoev:xsdChoice(.) or (every $p in $base/ownedAttribute                         satisfies                         xoev:lowerBound($p) = 0 or $restricted/ownedAttribute[@name = $p/@name]))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="(every $p in $restricted/ownedAttribute satisfies $base/ownedAttribute[@name = $p/@name]/uml:resolve-type(.)[ (if (uml:resolve-type($p)/xoev:xoevCodeTyp4(.) or uml:resolve-type($p)/xoev:usages-by-client(.)) then xoev:xoevDatentyp(.)/@kennung = 'urn:xoev-de:kosit:xoev:datentyp:code' or xoev:xoevCodeTyp4(.) or xoev:usages-by-client(.) else @xmi:id = $p/uml:resolve-type(.)/(., xoev:allRestrictionParents(.))/@xmi:id or @name = ('token', 'string', 'normalizedString') and $p/uml:resolve-type(.)[uml:is-Enumeration(.)])] and $base/ownedAttribute[@name = $p/@name and xoev:lowerBound($p) ge xoev:lowerBound(.) and (xoev:upperBound(.) = -1 or xoev:upperBound($p) != -1 and xoev:upperBound($p) le xoev:upperBound(.))]) and ($restricted/xoev:xsdChoice(.) or (every $p in $base/ownedAttribute satisfies xoev:lowerBound($p) = 0 or $restricted/ownedAttribute[@name = $p/@name]))">
               <xsl:attribute name="id">XMLRestriktionSchraenktEin</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Eine per XML-Restriktion (UML-Generalisierung mit dem Stereotyp xsdRestriction) abgeleitete UML-Klasse darf dem Basistyp keine UML-Klasseneigenschaften mehr hinzufügen. Die Eigenschaftstypen müssen gleich den Typen der entpsrechenden Eigenschaften im Basistyp sein bzw. diese einschränken. Ebenso müssen die Multiplizitäten der Eigenschaften gleich bzw. eingeschränkt gegenüber den Multiplizitäten im Basistyp sein. <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M57"/>
   <xsl:template match="@*|node()" priority="-2" mode="M57">
      <xsl:apply-templates select="*" mode="M57"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-GlobaleElementeOhneStereotypenXsdAnyContentsNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdGlobalElement(.) or xoev:xsdMessage(.) or xoev:xsdGlobalElementAndNamedType(.)) and xoev:xsdAnyContents(.)] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[(xoev:xsdGlobalElement(.) or xoev:xsdMessage(.) or xoev:xsdGlobalElementAndNamedType(.)) and xoev:xsdAnyContents(.)]"
                 priority="1000"
                 mode="M58">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">GlobaleElementeOhneStereotypenXsdAnyContents</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Globale Elemente (UML-Klassen mit dem Stereotyp xsdGlobalElement) dürfen nicht gleichzeitig mit dem Stereotypen xsdAnyContents annotiert sein. Die Klasse <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M58"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M58"/>
   <xsl:template match="@*|node()" priority="-2" mode="M58">
      <xsl:apply-templates select="*" mode="M58"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-AnyElementeOhneStereotypenXsdGlobalElementXsdCodeUndXsdChoiceNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdAnyContents(.) and                 (xoev:xsdGlobalElement(.), xoev:xsdMessage(.), xoev:xsdCode(.), xoev:xsdChoice(.))] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdAnyContents(.) and                 (xoev:xsdGlobalElement(.), xoev:xsdMessage(.), xoev:xsdCode(.), xoev:xsdChoice(.))]"
                 priority="1000"
                 mode="M59">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">AnyElementeOhneStereotypenXsdGlobalElementXsdCodeUndXsdChoice</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Any-Elemente (UML-Klassen mit dem Stereotyp xsdAnyContents) dürfen nicht gleichzeitig mit den Stereotypen xsdGlobalElement, xsdCode oder xsdChoice annotiert sein. Die Klasse <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M59"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M59"/>
   <xsl:template match="@*|node()" priority="-2" mode="M59">
      <xsl:apply-templates select="*" mode="M59"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-ChoiceOhneStereotypenXsdAnyContentsUndXsdCodeNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdChoice(.) and                 (xoev:xsdAnyContents(.), xoev:xsdCode(.))] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdChoice(.) and                 (xoev:xsdAnyContents(.), xoev:xsdCode(.))]"
                 priority="1000"
                 mode="M60">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">ChoiceOhneStereotypenXsdAnyContentsUndXsdCode</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>XML-Choices (UML-Klassen mit dem Stereotyp xsdChoice) dürfen nicht gleichzeitig mit den Stereotypen xsdAnyContents oder xsdCode annotiert sein. Die Klasse <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M60"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M60"/>
   <xsl:template match="@*|node()" priority="-2" mode="M60">
      <xsl:apply-templates select="*" mode="M60"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-CodeDatentypenOhneStereotypenXsdGlobalElementXsdAnyContentsUndXsdChoiceNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdCode(.) and                 (xoev:xsdGlobalElement(.), xoev:xsdMessage(.), xoev:xsdAnyContents(.), xoev:xsdChoice(.))] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdCode(.) and                 (xoev:xsdGlobalElement(.), xoev:xsdMessage(.), xoev:xsdAnyContents(.), xoev:xsdChoice(.))]"
                 priority="1000"
                 mode="M61">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">CodeDatentypenOhneStereotypenXsdGlobalElementXsdAnyContentsUndXsdChoice</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Code-Datentypen (UML-Klassen mit dem Stereotyp xsdCode) dürfen nicht gleichzeitig mit den Stereotypen xsdGlobalElement, xsdAnyContents oder xsdChoice annotiert sein. Die Klasse <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M61"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M61"/>
   <xsl:template match="@*|node()" priority="-2" mode="M61">
      <xsl:apply-templates select="*" mode="M61"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-GlobaleElementeSindKlassenOderEnumerationenNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and not(uml:is-Class(.) or uml:is-Enumeration(.))] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[(xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and not(uml:is-Class(.) or uml:is-Enumeration(.))]"
                 priority="1000"
                 mode="M62">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">GlobaleElementeSindKlassenOderEnumerationen</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Globale Elemente müssen UML-Klassen oder UML-Enumerationen sein. Das UML-Element <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M62"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M62"/>
   <xsl:template match="@*|node()" priority="-2" mode="M62">
      <xsl:apply-templates select="*" mode="M62"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-KeineTypenImEntwurfGenutztNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[(xoev:is-element(.) or xoev:xsdAttribute(.))]"
                 priority="1000"
                 mode="M63">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="../xoev:xsdDraft(.) or empty(uml:resolve-type(.)/xoev:xsdDraft(.))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="../xoev:xsdDraft(.) or empty(uml:resolve-type(.)/xoev:xsdDraft(.))">
               <xsl:attribute name="id">KeineTypenImEntwurfGenutzt</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>XML-Elemente (UML-Eigenschaften mit dem Stereotyp xsdElement) und XML-Attribute (UML-Eigenschaften mit dem Stereotyp xsdAttribute) dürfen keine sich im Entwurf befindenden Typen bzw. Elemente nutzen (UML-Klassen mit dem Stereotyp xsdDraft), sofern sie nicht Teil einer Klasse sind, die sich ebenso im Entwurf befindet. Die UML-Eigenschaft <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M63"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M63"/>
   <xsl:template match="@*|node()" priority="-2" mode="M63">
      <xsl:apply-templates select="*" mode="M63"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionMitKorrekterElementenreihenfolgeNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[generalization/xoev:xsdRestriction(.) and not(xoev:xsdAll(.)) and                 not(xoev:allParents(.)/ancestor::packagedElement[xoev:xoevAdapter(.)])] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[generalization/xoev:xsdRestriction(.) and not(xoev:xsdAll(.)) and                 not(xoev:allParents(.)/ancestor::packagedElement[xoev:xoevAdapter(.)])]"
                 priority="1000"
                 mode="M64">
      <xsl:variable name="class" select="."/>
      <xsl:variable name="basistyp" select="$class/generalization/uml:resolve-general(.)"/>
      <xsl:variable name="elemente-basistyp"
                    select="                 $basistyp/xoev:allElements(.)[(if (xoev:is-ref(.)) then                         uml:resolve-type(.)/xoev:global-element-name(.)                     else                     @name) = $class/xoev:elements(.)/(if (xoev:is-ref(.)) then                         uml:resolve-type(.)/xoev:global-element-name(.)                     else                         @name)]"/>
      <xsl:variable name="elemente-rest" select="$class/xoev:elements(.)"/>
      <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     every $e in $elemente-rest                         satisfies count($elemente-rest[xoev:position(.) le xoev:position($e)]) =                         count($elemente-basistyp[xoev:getRealPosition((if (xoev:is-ref(.)) then                             uml:resolve-type(.)/xoev:global-element-name(.)                         else                         @name), $basistyp) le xoev:getRealPosition($e/(if (xoev:is-ref(.)) then                             uml:resolve-type(.)/xoev:global-element-name(.)                         else                             @name), $basistyp)])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="every $e in $elemente-rest satisfies count($elemente-rest[xoev:position(.) le xoev:position($e)]) = count($elemente-basistyp[xoev:getRealPosition((if (xoev:is-ref(.)) then uml:resolve-type(.)/xoev:global-element-name(.) else @name), $basistyp) le xoev:getRealPosition($e/(if (xoev:is-ref(.)) then uml:resolve-type(.)/xoev:global-element-name(.) else @name), $basistyp)])">
               <xsl:attribute name="id">XMLRestriktionMitKorrekterElementenreihenfolge</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>XML-Elemente müssen in einem per XML-Restriktion (UML-Generalisierung mit dem Stereotyp xsdRestriction) eingeschränkten Datentypen die gleiche Reihenfolge wie die Elemente des Basistyps aufweisen. Die UML-Klasse <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe. Elementreihenfolge des Basistyps: <xsl:text/>
                  <xsl:value-of select="xoev:sortAndConcatForXMLRestriktionMitKorrekterElementenreihenfolge($basistyp)"/>
                  <xsl:text/> Elementreihenfolge des eingeschränkten Typs: <xsl:text/>
                  <xsl:value-of select="xoev:sortAndConcatForXMLRestriktionMitKorrekterElementenreihenfolge($class)"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M64"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M64"/>
   <xsl:template match="@*|node()" priority="-2" mode="M64">
      <xsl:apply-templates select="*" mode="M64"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionFacettenNurBeiSimpleContentNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)) and                 generalization/xoev:xsdRestriction(.)[@fractionDigits or @length or @totalDigits or @maxExclusive or @maxInclusive or @maxLength or                 @minInclusive or @minInclusive or @minLength or @pattern or                 @whitespace]] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)) and                 generalization/xoev:xsdRestriction(.)[@fractionDigits or @length or @totalDigits or @maxExclusive or                 @maxInclusive or @maxLength or @minInclusive or @minInclusive or @minLength or @pattern or                 @whitespace]]"
                 priority="1000"
                 mode="M65">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     empty(xoev:elements(.)) and empty(generalization/uml:resolve-general(.)/xoev:allElements(.))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="empty(xoev:elements(.)) and empty(generalization/uml:resolve-general(.)/xoev:allElements(.))">
               <xsl:attribute name="id">XMLRestriktionFacettenNurBeiSimpleContent</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>XML-Restriction-Facetten (Eigenschaften des Stereotyps xsdRestriction) dürfen ausschließich im Kontext von Datentypen mit einfachem Inhalt genutzt werden. Die UML-Klasse <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M65"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M65"/>
   <xsl:template match="@*|node()" priority="-2" mode="M65">
      <xsl:apply-templates select="*" mode="M65"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionFractionDigitsMitKorrektenW3CDatentypenNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[generalization/xoev:xsdRestriction(.)[@fractionDigits]] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[generalization/xoev:xsdRestriction(.)[@fractionDigits]]"
                 priority="1000"
                 mode="M66">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = 'decimal'"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = 'decimal'">
               <xsl:attribute name="id">XMLRestriktionFractionDigitsMitKorrektenW3CDatentypen</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Datentypen, die per XML-Restriction mit der Facette fractionDigits (Eigenschaft fractionDigits des Stereotyps xsdRestriction) ableiten, müssen den W3C-Datentyp xs:decimal als Basistyp haben. Die UML-Klasse<xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M66"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M66"/>
   <xsl:template match="@*|node()" priority="-2" mode="M66">
      <xsl:apply-templates select="*" mode="M66"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionLengthMitKorrektenW3CDatentypenNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[generalization/xoev:xsdRestriction(.)[@length]] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[generalization/xoev:xsdRestriction(.)[@length]]"
                 priority="1000"
                 mode="M67">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name =                     ('anyURI', 'base64Binary', 'ENTITIES', 'ENTITY', 'hexBinary', 'ID', 'IDREF', 'IDREFS', 'language', 'Name', 'NCName', 'NMTOKEN', 'NMTOKENS',                     'normalizedString', 'NOTATION', 'QName', 'string', 'token')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = ('anyURI', 'base64Binary', 'ENTITIES', 'ENTITY', 'hexBinary', 'ID', 'IDREF', 'IDREFS', 'language', 'Name', 'NCName', 'NMTOKEN', 'NMTOKENS', 'normalizedString', 'NOTATION', 'QName', 'string', 'token')">
               <xsl:attribute name="id">XMLRestriktionLengthMitKorrektenW3CDatentypen</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Datentypen, die per XML-Restriction mit der Facette length (Eigenschaft length des Stereotyps xsdRestriction) ableiten, müssen den W3C-Datentyp xs:anyURI, base64Binary, xs:ENTITIES, xs:ENTITY, xs:hexBinary, xs:ID, xs:IDREF, xs:IDREFS, xs:language, xs:Name, xs:NCName, xs:NMTOKEN, xs:NMTOKENS, xs:normalizedString, xs:NOTATION, xs:QName, xs:string oder xs:token als Basistyp haben. Die UML-Klasse<xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M67"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M67"/>
   <xsl:template match="@*|node()" priority="-2" mode="M67">
      <xsl:apply-templates select="*" mode="M67"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionMaxExclusiveMitKorrektenW3CDatentypenNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[generalization/xoev:xsdRestriction(.)[@maxExclusive]] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[generalization/xoev:xsdRestriction(.)[@maxExclusive]]"
                 priority="1000"
                 mode="M68">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = ('byte', 'date', 'dateTime', 'decimal', 'double', 'duration', 'float', 'gDay', 'gMonth', 'gYear', 'gYearMonth', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'time', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = ('byte', 'date', 'dateTime', 'decimal', 'double', 'duration', 'float', 'gDay', 'gMonth', 'gYear', 'gYearMonth', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'time', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')">
               <xsl:attribute name="id">XMLRestriktionMaxExclusiveMitKorrektenW3CDatentypen</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Datentypen, die per XML-Restriction mit der Facette maxExclusive (Eigenschaft maxExclusive des Stereotyps xsdRestriction) ableiten, müssen den W3C-Datentyp xs:byte, xs:date, xs:dateTime, xs:decimal, xs:double, xs:duration, xs:float, xs:gDay, xs:gMonth, xs:gYear, xs:gYearMonth, xs:int, xs:integer, xs:long, xs:negativeInteger, xs:nonNegativeInteger, xs:nonPositiveInteger, xs:positiveInteger, xs:short, xs:time, xs:unsignedByte, xs:unsignedInt, xs:unsignedLong oder xs:unsignedShort als Basistyp haben. Die UML-Klasse<xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M68"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M68"/>
   <xsl:template match="@*|node()" priority="-2" mode="M68">
      <xsl:apply-templates select="*" mode="M68"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionMaxInclusiveMitKorrektenW3CDatentypenNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[generalization/xoev:xsdRestriction(.)[@maxInclusive]] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[generalization/xoev:xsdRestriction(.)[@maxInclusive]]"
                 priority="1000"
                 mode="M69">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = ('byte', 'date', 'dateTime', 'decimal', 'double', 'duration', 'float', 'gDay', 'gMonth', 'gYear', 'gYearMonth', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'time', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = ('byte', 'date', 'dateTime', 'decimal', 'double', 'duration', 'float', 'gDay', 'gMonth', 'gYear', 'gYearMonth', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'time', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')">
               <xsl:attribute name="id">XMLRestriktionMaxInclusiveMitKorrektenW3CDatentypen</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Datentypen, die per XML-Restriction mit der Facette maxInclusive (Eigenschaft maxInclusive des Stereotyps xsdRestriction) ableiten, müssen den W3C-Datentyp xs:byte, xs:date, xs:dateTime, xs:decimal, xs:double, xs:duration, xs:float, xs:gDay, xs:gMonth, xs:gYear, xs:gYearMonth, xs:int, xs:integer, xs:long, xs:negativeInteger, xs:nonNegativeInteger, xs:nonPositiveInteger, xs:positiveInteger, xs:short, xs:time, xs:unsignedByte, xs:unsignedInt, xs:unsignedLong oder xs:unsignedShort als Basistyp haben. Die UML-Klasse<xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M69"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M69"/>
   <xsl:template match="@*|node()" priority="-2" mode="M69">
      <xsl:apply-templates select="*" mode="M69"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionMaxLengthMitKorrektenW3CDatentypenNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[generalization/xoev:xsdRestriction(.)[@maxLength]] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[generalization/xoev:xsdRestriction(.)[@maxLength]]"
                 priority="1000"
                 mode="M70">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = ('anyURI', 'base64Binary', 'ENTITIES', 'ENTITY', 'hexBinary', 'ID', 'IDREF', 'IDREFS', 'language', 'Name', 'NCName', 'NMTOKEN', 'NMTOKENS', 'normalizedString', 'NOTATION', 'QName', 'string', 'token')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = ('anyURI', 'base64Binary', 'ENTITIES', 'ENTITY', 'hexBinary', 'ID', 'IDREF', 'IDREFS', 'language', 'Name', 'NCName', 'NMTOKEN', 'NMTOKENS', 'normalizedString', 'NOTATION', 'QName', 'string', 'token')">
               <xsl:attribute name="id">XMLRestriktionMaxLengthMitKorrektenW3CDatentypen</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Datentypen, die per XML-Restriction mit der Facette maxLength (Eigenschaft maxLength des Stereotyps xsdRestriction) ableiten, müssen den W3C-Datentyp xs:anyURI, base64Binary, xs:ENTITIES, xs:ENTITY, xs:hexBinary, xs:ID, xs:IDREF, xs:IDREFS, xs:language, xs:Name, xs:NCName, xs:NMTOKEN, xs:NMTOKENS, xs:normalizedString, xs:NOTATION, xs:QName, xs:string oder xs:token als Basistyp haben. Die UML-Klasse<xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M70"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M70"/>
   <xsl:template match="@*|node()" priority="-2" mode="M70">
      <xsl:apply-templates select="*" mode="M70"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionMinExclusiveMitKorrektenW3CDatentypenNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[generalization/xoev:xsdRestriction(.)[@minExclusive]] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[generalization/xoev:xsdRestriction(.)[@minExclusive]]"
                 priority="1000"
                 mode="M71">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = ('byte', 'date', 'dateTime', 'decimal', 'double', 'duration', 'float', 'gDay', 'gMonth', 'gYear', 'gYearMonth', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'time', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = ('byte', 'date', 'dateTime', 'decimal', 'double', 'duration', 'float', 'gDay', 'gMonth', 'gYear', 'gYearMonth', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'time', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')">
               <xsl:attribute name="id">XMLRestriktionMinExclusiveMitKorrektenW3CDatentypen</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Datentypen, die per XML-Restriction mit der Facette minExclusive (Eigenschaft minExclusive des Stereotyps xsdRestriction) ableiten, müssen den W3C-Datentyp xs:byte, xs:date, xs:dateTime, xs:decimal, xs:double, xs:duration, xs:float, xs:gDay, xs:gMonth, xs:gYear, xs:gYearMonth, xs:int, xs:integer, xs:long, xs:negativeInteger, xs:nonNegativeInteger, xs:nonPositiveInteger, xs:positiveInteger, xs:short, xs:time, xs:unsignedByte, xs:unsignedInt, xs:unsignedLong oder xs:unsignedShort als Basistyp haben. Die UML-Klasse<xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M71"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M71"/>
   <xsl:template match="@*|node()" priority="-2" mode="M71">
      <xsl:apply-templates select="*" mode="M71"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionMinInclusiveMitKorrektenW3CDatentypenNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[generalization/xoev:xsdRestriction(.)[@minInclusive]] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[generalization/xoev:xsdRestriction(.)[@minInclusive]]"
                 priority="1000"
                 mode="M72">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = ('byte', 'date', 'dateTime', 'decimal', 'double', 'duration', 'float', 'gDay', 'gMonth', 'gYear', 'gYearMonth', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'time', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = ('byte', 'date', 'dateTime', 'decimal', 'double', 'duration', 'float', 'gDay', 'gMonth', 'gYear', 'gYearMonth', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'time', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')">
               <xsl:attribute name="id">XMLRestriktionMinInclusiveMitKorrektenW3CDatentypen</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Datentypen, die per XML-Restriction mit der Facette minInclusive (Eigenschaft minInclusive des Stereotyps xsdRestriction) ableiten, müssen den W3C-Datentyp xs:byte, xs:date, xs:dateTime, xs:decimal, xs:double, xs:duration, xs:float, xs:gDay, xs:gMonth, xs:gYear, xs:gYearMonth, xs:int, xs:integer, xs:long, xs:negativeInteger, xs:nonNegativeInteger, xs:nonPositiveInteger, xs:positiveInteger, xs:short, xs:time, xs:unsignedByte, xs:unsignedInt, xs:unsignedLong oder xs:unsignedShort als Basistyp haben. Die UML-Klasse<xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M72"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M72"/>
   <xsl:template match="@*|node()" priority="-2" mode="M72">
      <xsl:apply-templates select="*" mode="M72"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionMinLengthMitKorrektenW3CDatentypenNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[generalization/xoev:xsdRestriction(.)[@minLength]] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[generalization/xoev:xsdRestriction(.)[@minLength]]"
                 priority="1000"
                 mode="M73">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = ('anyURI', 'base64Binary', 'ENTITIES', 'ENTITY', 'hexBinary', 'ID', 'IDREF', 'IDREFS', 'language', 'Name', 'NCName', 'NMTOKEN', 'NMTOKENS', 'normalizedString', 'NOTATION', 'QName', 'string', 'token')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = ('anyURI', 'base64Binary', 'ENTITIES', 'ENTITY', 'hexBinary', 'ID', 'IDREF', 'IDREFS', 'language', 'Name', 'NCName', 'NMTOKEN', 'NMTOKENS', 'normalizedString', 'NOTATION', 'QName', 'string', 'token')">
               <xsl:attribute name="id">XMLRestriktionMinLengthMitKorrektenW3CDatentypen</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Datentypen, die per XML-Restriction mit der Facette minLength (Eigenschaft minLength des Stereotyps xsdRestriction) ableiten, müssen den W3C-Datentyp xs:anyURI, base64Binary, xs:ENTITIES, xs:ENTITY, xs:hexBinary, xs:ID, xs:IDREF, xs:IDREFS, xs:language, xs:Name, xs:NCName, xs:NMTOKEN, xs:NMTOKENS, xs:normalizedString, xs:NOTATION, xs:QName, xs:string oder xs:token als Basistyp haben. Die UML-Klasse<xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M73"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M73"/>
   <xsl:template match="@*|node()" priority="-2" mode="M73">
      <xsl:apply-templates select="*" mode="M73"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionPatternMitKorrektenW3CDatentypenNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[generalization/xoev:xsdRestriction(.)[@pattern]] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[generalization/xoev:xsdRestriction(.)[@pattern]]"
                 priority="1000"
                 mode="M74">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = ('anyURI', 'base64Binary', 'boolean', 'byte', 'date', 'dateTime', 'decimal', 'double', 'duration', 'ENTITY', 'float', 'gDay', 'gMonth', 'gYear', 'gYearMonth', 'hexBinary', 'ID', 'IDREF', 'int', 'integer', 'language', 'long', 'Name', 'NCName', 'negativeInteger', 'NMTOKEN', 'nonNegativeInteger', 'nonPositiveInteger', 'normalizedString', 'NOTATION', 'positiveInteger', 'QName', 'short', 'string', 'time', 'token', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = ('anyURI', 'base64Binary', 'boolean', 'byte', 'date', 'dateTime', 'decimal', 'double', 'duration', 'ENTITY', 'float', 'gDay', 'gMonth', 'gYear', 'gYearMonth', 'hexBinary', 'ID', 'IDREF', 'int', 'integer', 'language', 'long', 'Name', 'NCName', 'negativeInteger', 'NMTOKEN', 'nonNegativeInteger', 'nonPositiveInteger', 'normalizedString', 'NOTATION', 'positiveInteger', 'QName', 'short', 'string', 'time', 'token', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')">
               <xsl:attribute name="id">XMLRestriktionPatternMitKorrektenW3CDatentypen</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Datentypen, die per XML-Restriction mit der Facette pattern (Eigenschaft pattern des Stereotyps xsdRestriction) ableiten, müssen den W3C-Datentyp xs:anyURI, xs:base64Binary, xs:boolean, xs:byte, xs:date, xs:dateTime, xs:decimal, xs:double, xs:duration, xs:ENTITY, xs:float, xs:gDay, xs:gMonth, xs:gYear, xs:gYearMonth, xs:hexBinary, xs:ID, xs:IDREF, xs:int, xs:integer, xs:language, xs:long, xs:Name, xs:NCName, xs:negativeInteger, xs:NMTOKEN, xs:nonNegativeInteger, xs:nonPositiveInteger, xs:normalizedString, xs:NOTATION, xs:positiveInteger, xs:QName, xs:short, xs:string, xs:time, xs:token, xs:unsignedByte, xs:unsignedInt, xs:unsignedLong oder xs:unsignedShort als Basistyp haben. Die UML-Klasse<xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M74"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M74"/>
   <xsl:template match="@*|node()" priority="-2" mode="M74">
      <xsl:apply-templates select="*" mode="M74"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionTotalDigitsMitKorrektenW3CDatentypenNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[generalization/xoev:xsdRestriction(.)[@totalDigits]] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[generalization/xoev:xsdRestriction(.)[@totalDigits]]"
                 priority="1000"
                 mode="M75">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = ('byte', 'decimal', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = ('byte', 'decimal', 'int', 'integer', 'long', 'negativeInteger', 'nonNegativeInteger', 'nonPositiveInteger', 'positiveInteger', 'short', 'unsignedByte', 'unsignedInt', 'unsignedLong', 'unsignedShort')">
               <xsl:attribute name="id">XMLRestriktionTotalDigitsMitKorrektenW3CDatentypen</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Datentypen, die per XML-Restriction mit der Facette totalDigits (Eigenschaft totalDigits des Stereotyps xsdRestriction) ableiten, müssen den W3C-Datentyp xs:byte, xs:decimal, xs:int, xs:integer, xs:long, xs:negativeInteger, xs:nonNegativeInteger, xs:nonPositiveInteger, xs:positiveInteger, xs:short, xs:unsignedByte, xs:unsignedInt, xs:unsignedLong oder xs:unsignedShort als Basistyp haben. Die UML-Klasse<xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M75"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M75"/>
   <xsl:template match="@*|node()" priority="-2" mode="M75">
      <xsl:apply-templates select="*" mode="M75"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionWhitespaceMitKorrektenW3CDatentypenNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[generalization/xoev:xsdRestriction(.)[@whitespace]] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[generalization/xoev:xsdRestriction(.)[@whitespace]]"
                 priority="1000"
                 mode="M76">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = ('ENTITIES', 'ENTITY', 'ID', 'IDREF', 'IDREFS', 'Name', 'NCName', 'NMTOKEN', 'NMTOKENS', 'normalizedString', 'string', 'token')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="generalization/uml:resolve-general(.)/xoev:topmost-parent(.)/@name = ('ENTITIES', 'ENTITY', 'ID', 'IDREF', 'IDREFS', 'Name', 'NCName', 'NMTOKEN', 'NMTOKENS', 'normalizedString', 'string', 'token')">
               <xsl:attribute name="id">XMLRestriktionWhitespaceMitKorrektenW3CDatentypen</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Datentypen, die per XML-Restriction mit der Facette whitespace (Eigenschaft whitespace des Stereotyps xsdRestriction) ableiten, müssen den W3C-Datentyp xs:ENTITIES, xs:ENTITY, xs:ID, xs:IDREF, xs:IDREFS, xs:language, xs:Name, xs:NCName, xs:NMTOKEN, xs:NMTOKENS, xs:normalizedString, xs:string oder xs:token als Basistyp haben. Die UML-Klasse<xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M76"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M76"/>
   <xsl:template match="@*|node()" priority="-2" mode="M76">
      <xsl:apply-templates select="*" mode="M76"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionLengthIstPositiveGanzeZahlNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//generalization[xoev:xsdRestriction(.)[@length]]"
                 priority="1000"
                 mode="M77">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     replace(xoev:xsdRestriction(.)/@length, '[0-9]+', '') = ''"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="replace(xoev:xsdRestriction(.)/@length, '[0-9]+', '') = ''">
               <xsl:attribute name="id">XMLRestriktionLengthIstPositiveGanzeZahl</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Eigenschaft length des Stereotyps xsdRestriction muss eine positive ganze Zahl sein. <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M77"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M77"/>
   <xsl:template match="@*|node()" priority="-2" mode="M77">
      <xsl:apply-templates select="*" mode="M77"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionMaxLengthIstPositiveGanzeZahlNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//generalization[xoev:xsdRestriction(.)[@maxLength]]"
                 priority="1000"
                 mode="M78">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     replace(xoev:xsdRestriction(.)/@maxLength, '[0-9]+', '') = ''"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="replace(xoev:xsdRestriction(.)/@maxLength, '[0-9]+', '') = ''">
               <xsl:attribute name="id">XMLRestriktionMaxLengthIstPositiveGanzeZahl</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Eigenschaft maxLength des Stereotyps xsdRestriction muss eine positive ganze Zahl sein. <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M78"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M78"/>
   <xsl:template match="@*|node()" priority="-2" mode="M78">
      <xsl:apply-templates select="*" mode="M78"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionTotalDigitsIstPositiveGanzeZahlNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//generalization[xoev:xsdRestriction(.)[@totalDigits]]"
                 priority="1000"
                 mode="M79">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     replace(xoev:xsdRestriction(.)/@totalDigits, '[0-9]+', '') = ''"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="replace(xoev:xsdRestriction(.)/@totalDigits, '[0-9]+', '') = ''">
               <xsl:attribute name="id">XMLRestriktionTotalDigitsIstPositiveGanzeZahl</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Eigenschaft totalDigits des Stereotyps xsdRestriction muss eine positive ganze Zahl sein. <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M79"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M79"/>
   <xsl:template match="@*|node()" priority="-2" mode="M79">
      <xsl:apply-templates select="*" mode="M79"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionFractionDigitsIstPositiveGanzeZahlNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//generalization[xoev:xsdRestriction(.)[@fractionDigits]]"
                 priority="1000"
                 mode="M80">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     replace(xoev:xsdRestriction(.)/@fractionDigits, '[0-9]+', '') = ''"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="replace(xoev:xsdRestriction(.)/@fractionDigits, '[0-9]+', '') = ''">
               <xsl:attribute name="id">XMLRestriktionFractionDigitsIstPositiveGanzeZahl</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Eigenschaft fractionDigits des Stereotyps xsdRestriction muss eine positive ganze Zahl sein. <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M80"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M80"/>
   <xsl:template match="@*|node()" priority="-2" mode="M80">
      <xsl:apply-templates select="*" mode="M80"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionLengthSchliesstMaxLengthUndMinLengthAusNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//generalization[xoev:xsdRestriction(.)[@length]]"
                 priority="1000"
                 mode="M81">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     empty(xoev:xsdRestriction(.)/@maxLength) and empty(xoev:xsdRestriction(.)/@minLength)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="empty(xoev:xsdRestriction(.)/@maxLength) and empty(xoev:xsdRestriction(.)/@minLength)">
               <xsl:attribute name="id">XMLRestriktionLengthSchliesstMaxLengthUndMinLengthAus</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Eigenschaft length des Stereotyps xsdRestriction darf nicht zusammen mit den Eigenschaften maxLength oder minLength angegeben sein. <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M81"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M81"/>
   <xsl:template match="@*|node()" priority="-2" mode="M81">
      <xsl:apply-templates select="*" mode="M81"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionMaxExclusiveUndMaxInclusiveSchliessenSichAusNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//generalization[xoev:xsdRestriction(.)[@maxExclusive and @maxInclusive]]"
                 priority="1000"
                 mode="M82">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">XMLRestriktionMaxExclusiveUndMaxInclusiveSchliessenSichAus</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Eigenschaften maxExclusive und maxInclusive des Stereotyps xsdRestriction schließen sich gegenseitig aus. <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M82"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M82"/>
   <xsl:template match="@*|node()" priority="-2" mode="M82">
      <xsl:apply-templates select="*" mode="M82"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionMinExclusiveUndMinInclusiveSchliessenSichAusNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//generalization[xoev:xsdRestriction(.)[@minExclusive and @minInclusive]]"
                 priority="1000"
                 mode="M83">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">XMLRestriktionMinExclusiveUndMinInclusiveSchliessenSichAus</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Eigenschaften minExclusive und minInclusive des Stereotyps xsdRestriction schließen sich gegenseitig aus. <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M83"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M83"/>
   <xsl:template match="@*|node()" priority="-2" mode="M83">
      <xsl:apply-templates select="*" mode="M83"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-XMLRestriktionWhitespaceMitKorrektenWertenNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//generalization[xoev:xsdRestriction(.)[@whitespace]]"
                 priority="1000"
                 mode="M84">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="xoev:xsdRestriction(.)/@whitespace = ('preserve', 'replace', 'collapse')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="xoev:xsdRestriction(.)/@whitespace = ('preserve', 'replace', 'collapse')">
               <xsl:attribute name="id">XMLRestriktionWhitespaceMitKorrektenWerten</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Eigenschaft whitespace des Stereotyps xsdRestriction muss den Wert "preserve", "replace" oder "collapse" besitzen. <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M84"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M84"/>
   <xsl:template match="@*|node()" priority="-2" mode="M84">
      <xsl:apply-templates select="*" mode="M84"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-AttributMitKorrektemTypNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[xoev:xsdAttribute(.) and not(xoev:is-ref(.))]"
                 priority="1000"
                 mode="M85">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     uml:resolve-type(.)/xoev:topmost-parent(.)/parent::packagedElement/@name = 'W3C Data Types' or                     uml:resolve-type(.)/uml:is-Enumeration(.) or                     uml:resolve-type(.)[xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="uml:resolve-type(.)/xoev:topmost-parent(.)/parent::packagedElement/@name = 'W3C Data Types' or uml:resolve-type(.)/uml:is-Enumeration(.) or uml:resolve-type(.)[xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)]">
               <xsl:attribute name="id">AttributMitKorrektemTyp</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Der Typ eines XML-Attributs (UML-Eigenschaft mit dem Stereotyp xsdAttribute) muss ein W3C-Datentyp, die Ableitung eines W3C-Datentyps, eine Enumeration oder ein benannter Datentyp sein. <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M85"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M85"/>
   <xsl:template match="@*|node()" priority="-2" mode="M85">
      <xsl:apply-templates select="*" mode="M85"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-ElementMitKorrektemTypNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Class(.)]/ownedAttribute[xoev:is-element(.)] | /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Class(.)]/ownedAttribute[xoev:is-element(.)]"
                 priority="1000"
                 mode="M86">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     uml:resolve-type(.)[xoev:topmost-parent(.)/parent::packagedElement/@name = 'W3C Data Types'] or                     uml:resolve-type(.)/uml:is-Enumeration(.) or                     uml:resolve-type(.)/ancestor::packagedElement/xoev:xsdSchema(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="uml:resolve-type(.)[xoev:topmost-parent(.)/parent::packagedElement/@name = 'W3C Data Types'] or uml:resolve-type(.)/uml:is-Enumeration(.) or uml:resolve-type(.)/ancestor::packagedElement/xoev:xsdSchema(.)">
               <xsl:attribute name="id">ElementMitKorrektemTyp</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Der Typ eines XML-Elements (UML-Eigenschaft mit dem Stereotyp xsdElement) muss ein W3C-Datentyp, die Ableitung eines W3C-Datentyps, eine Enumeration oder ein benannter Datentyp sein. <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M86"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M86"/>
   <xsl:template match="@*|node()" priority="-2" mode="M86">
      <xsl:apply-templates select="*" mode="M86"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-ElementUndAttributTypenSichtbarNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and $xoev:ist-zyklenfrei]//ownedAttribute[xoev:is-element(.) or xoev:xsdAttribute(.)]"
                 priority="1000"
                 mode="M87">
      <xsl:variable name="property" select="."/>
      <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     not(uml:resolve-type(.)[xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)] and                     ancestor::packagedElement[xoev:xsdSchema(.)]) or                     uml:resolve-type(.)/ancestor::packagedElement[xoev:xsdSchema(.)]/@xmi:id =                     (ancestor::packagedElement[xoev:xsdSchema(.)]/@xmi:id,                     xoev:package-with-imports-and-includes(ancestor::packagedElement[xoev:xsdSchema(.)])/(import, include)/@id)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(uml:resolve-type(.)[xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)] and ancestor::packagedElement[xoev:xsdSchema(.)]) or uml:resolve-type(.)/ancestor::packagedElement[xoev:xsdSchema(.)]/@xmi:id = (ancestor::packagedElement[xoev:xsdSchema(.)]/@xmi:id, xoev:package-with-imports-and-includes(ancestor::packagedElement[xoev:xsdSchema(.)])/(import, include)/@id)">
               <xsl:attribute name="id">ElementUndAttributTypenSichtbar</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Der Typ einer UML-Eigenschaft (bzw. die XML Schema-Definition, die den Typ enthält) muss in der XML Schema-Definition, in der die Eigenschaft spezifiziert ist, sichtbar sein, d. h. direkt oder indirekt per XML-Import bzw. -Include eingebunden sein. Die Eigenschaft <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe (genutzter Typ: <xsl:text/>
                  <xsl:value-of select="uml:resolve-type(.)/xoev:qualified-type-name(., $property, false())"/>
                  <xsl:text/>).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M87"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M87"/>
   <xsl:template match="@*|node()" priority="-2" mode="M87">
      <xsl:apply-templates select="*" mode="M87"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-TypenGlobalerElementeUndAttributeSichtbarNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and $xoev:ist-zyklenfrei]//packagedElement[                 (xoev:xsdGlobalElement(.) or xoev:xsdGlobalAttribute(.)) and                 uml:resolve-supplier(xoev:dependencies-by-client(.)[xoev:xsdGlobalElementType(.) or xoev:xsdGlobalAttributeType(.)])/xoev:xsdNamedType(.) and                 ancestor::packagedElement[xoev:xsdSchema(.)]]"
                 priority="1000"
                 mode="M88">
      <xsl:variable name="object" select="."/>
      <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     uml:resolve-supplier(xoev:dependencies-by-client(.)[xoev:xsdGlobalElementType(.) or xoev:xsdGlobalAttributeType(.)])/                     ancestor::packagedElement[xoev:xsdSchema(.)]/@xmi:id =                     (ancestor::packagedElement[xoev:xsdSchema(.)]/@xmi:id,                     xoev:package-with-imports-and-includes(ancestor::packagedElement[xoev:xsdSchema(.)])/                     (import, include)/@id)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="uml:resolve-supplier(xoev:dependencies-by-client(.)[xoev:xsdGlobalElementType(.) or xoev:xsdGlobalAttributeType(.)])/ ancestor::packagedElement[xoev:xsdSchema(.)]/@xmi:id = (ancestor::packagedElement[xoev:xsdSchema(.)]/@xmi:id, xoev:package-with-imports-and-includes(ancestor::packagedElement[xoev:xsdSchema(.)])/ (import, include)/@id)">
               <xsl:attribute name="id">TypenGlobalerElementeUndAttributeSichtbar</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Der Typ eines globalen Elements oder globalen Attributs (bzw. die XML Schema-Definition, die dieses enthält) muss in der XML Schema-Definition, in der dieses spezifiziert ist, sichtbar sein, d. h. direkt oder indirekt per XML-Import bzw. -Include eingebunden sein. Das globale Element bzw. Attribut <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe (genutzter Typ: <xsl:text/>
                  <xsl:value-of select="uml:resolve-supplier(xoev:dependencies-by-client(.)[xoev:xsdGlobalElementType(.) or xoev:xsdGlobalAttributeType(.)])/xoev:qualified-type-name(., $object, false())"/>
                  <xsl:text/>).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M88"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M88"/>
   <xsl:template match="@*|node()" priority="-2" mode="M88">
      <xsl:apply-templates select="*" mode="M88"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-BasistypenSichtbarNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and                 $xoev:ist-zyklenfrei]//packagedElement[uml:is-Class(.) and generalization/uml:resolve-general(.)[xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)]] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and                 $xoev:ist-zyklenfrei]//nestedClassifier[uml:is-Class(.) and generalization/uml:resolve-general(.)[xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)]]"
                 priority="1000"
                 mode="M89">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     generalization/uml:resolve-general(.)/ancestor::packagedElement[xoev:xsdSchema(.)]/@xmi:id =                     (ancestor::packagedElement[xoev:xsdSchema(.)]/@xmi:id,                     (if (ancestor::packagedElement[xoev:xsdSchema(.)]) then                         xoev:package-with-imports-and-includes(ancestor::packagedElement[xoev:xsdSchema(.)])                     else                         ())/(import, include)/@id)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="generalization/uml:resolve-general(.)/ancestor::packagedElement[xoev:xsdSchema(.)]/@xmi:id = (ancestor::packagedElement[xoev:xsdSchema(.)]/@xmi:id, (if (ancestor::packagedElement[xoev:xsdSchema(.)]) then xoev:package-with-imports-and-includes(ancestor::packagedElement[xoev:xsdSchema(.)]) else ())/(import, include)/@id)">
               <xsl:attribute name="id">BasistypenSichtbar</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Der Basistyp einer UML-Klasse, von dem per UML-Generalisierung abgeleitet wird (bzw. die XML Schema-Definition, die den Typen enthält) muss in der XML Schema-Definition, in der die ableitende Klasse spezifiziert ist, sichtbar sein, d. h. direkt oder indirekt per XML-Import bzw. -Include (UML-Abhängigkeitsbeziehung mit dem Stereotyp xsdImport bzw. xsdInclude) eingebunden sein. Die ableitende Klasse <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M89"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M89"/>
   <xsl:template match="@*|node()" priority="-2" mode="M89">
      <xsl:apply-templates select="*" mode="M89"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-EigenschaftenHabenEinenTypNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Class(.)]/ownedAttribute[xoev:is-element(.) or xoev:xsdAttribute(.)] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Class(.)]/ownedAttribute[xoev:is-element(.) or xoev:xsdAttribute(.)]"
                 priority="1000"
                 mode="M90">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="uml:resolve-type(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="uml:resolve-type(.)">
               <xsl:attribute name="id">EigenschaftenHabenEinenTyp</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Jede UML-Eigenschaft mit dem Stereotyp xsdAttribute oder xsdElement muss einen Typ besitzen. Die Eigenschaft <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M90"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M90"/>
   <xsl:template match="@*|node()" priority="-2" mode="M90">
      <xsl:apply-templates select="*" mode="M90"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-AttributeMitEinzelnemWertNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[xoev:xsdAttribute(.) and (xoev:upperBound(.) gt 1 or xoev:upperBound(.) = -1)]"
                 priority="1000"
                 mode="M91">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">AttributeMitEinzelnemWert</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>XML-Attribute (UML-Eigenschaften mit dem Stereotyp xsdAttribute) müssen die Multiplizität 0..1 oder 1 besitzen. Die Eigenschaft <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M91"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M91"/>
   <xsl:template match="@*|node()" priority="-2" mode="M91">
      <xsl:apply-templates select="*" mode="M91"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-SchemaDateiEndungXsdNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdSchema(.) and                 not(ends-with(xoev:xsdSchema(.)/@schemaFile, lower-case('.xsd')))]"
                 priority="1000"
                 mode="M92">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">SchemaDateiEndungXsd</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Dateinamen von Schema-Paketen (Eigenschaft schemaFile des Stereotyps xsdSchema) müssen "xsd" als Dateiendung beinhalten. Das UML-Paket <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M92"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M92"/>
   <xsl:template match="@*|node()" priority="-2" mode="M92">
      <xsl:apply-templates select="*" mode="M92"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-SchemaLocationEndungXsdNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdSchema(.) and xoev:xsdSchema(.)/@schemaLocation and                 not(ends-with(xoev:xsdSchema(.)/@schemaLocation, lower-case('.xsd')))]"
                 priority="1000"
                 mode="M93">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">SchemaLocationEndungXsd</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Schema Locations (Eigenschaft schemaLocation des Stereotyps xsdSchema) müssen "xsd" als Dateiendung beinhalten, sofern sie im Kontext eines Schema-Pakets spezifiziert sind. Das UML-Paket <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M93"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M93"/>
   <xsl:template match="@*|node()" priority="-2" mode="M93">
      <xsl:apply-templates select="*" mode="M93"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-AssoziationImGleichenPaketWieEigenschaftNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[uml:resolve-association(.)]"
                 priority="1000"
                 mode="M94">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="                     ancestor::packagedElement[uml:is-Package(.)][1] = uml:resolve-association(.)/ancestor::packagedElement[uml:is-Package(.)][1]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="ancestor::packagedElement[uml:is-Package(.)][1] = uml:resolve-association(.)/ancestor::packagedElement[uml:is-Package(.)][1]">
               <xsl:attribute name="id">AssoziationImGleichenPaketWieEigenschaft</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Es wird empfohlen, dass eine UML-Assoziation (i. d. R. eine Komposition) im selben Paket wie die über die Assoziation spezifizierte Eigenschaft vorliegt. Die Eigenschaft (Assoziationsende) <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> hält diese Empfehlung nicht ein.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M94"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M94"/>
   <xsl:template match="@*|node()" priority="-2" mode="M94">
      <xsl:apply-templates select="*" mode="M94"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-KeineMehrfachenXMLIncludesNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdSchema(.) and xoev:dependencies-by-client(.)[xoev:xsdInclude(.)]]"
                 priority="1000"
                 mode="M95">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     every $d in xoev:dependencies-by-client(.)[xoev:xsdInclude(.)]                         satisfies                         not(xoev:dependencies-by-client(.)[xoev:xsdInclude(.) and @xmi:id != $d/@xmi:id]/uml:resolve-supplier(.)/@xmi:id =                         $d/uml:resolve-supplier(.)/@xmi:id)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="every $d in xoev:dependencies-by-client(.)[xoev:xsdInclude(.)] satisfies not(xoev:dependencies-by-client(.)[xoev:xsdInclude(.) and @xmi:id != $d/@xmi:id]/uml:resolve-supplier(.)/@xmi:id = $d/uml:resolve-supplier(.)/@xmi:id)">
               <xsl:attribute name="id">KeineMehrfachenXMLIncludes</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Ein Schema-Paket (UML-Paket mit dem Stereotyp xsdSchema) darf ein anderes Schema-Paket nicht mehrfach per XML-Include (UML-Abhängigkeitsbeziehung mit dem Stereotyp xsdInclude) einbinden. Das Paket <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M95"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M95"/>
   <xsl:template match="@*|node()" priority="-2" mode="M95">
      <xsl:apply-templates select="*" mode="M95"/>
   </xsl:template>
   <!--PATTERN NDR-29-IdentifizierendeNamensraeume-XMLSchemaDefinitionenHabenNamensraumNDR-29: Identifizierende Namensräume-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-29: Identifizierende Namensräume</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdSchema(.) and empty(xoev:getNamespace(.)[. != ''])]"
                 priority="1000"
                 mode="M96">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">XMLSchemaDefinitionenHabenNamensraum</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>XML Schema-Definitionen (UML-Pakete mit dem Stereotyp xsdSchema) müssen einen Namensraum besitzen, entweder über die Eigenschaft namespace des Stereotyps xsdSchema oder die Eigenschaft namespace des Stereotyps xsdXModel. Das Paket <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M96"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M96"/>
   <xsl:template match="@*|node()" priority="-2" mode="M96">
      <xsl:apply-templates select="*" mode="M96"/>
   </xsl:template>
   <!--PATTERN NDR-29-IdentifizierendeNamensraeume-XMLSchemaDefinitionenHabenPraefixNDR-29: Identifizierende Namensräume-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-29: Identifizierende Namensräume</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[                 xoev:xsdSchema(.) and empty((xoev:xsdSchema(.)/@prefix, ancestor::packagedElement/xoev:xsdXModel(.)/@prefix)[. != ''])]"
                 priority="1000"
                 mode="M97">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">XMLSchemaDefinitionenHabenPraefix</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>XML Schema-Definitionen (UML-Pakete mit dem Stereotyp xsdSchema) müssen ein Namensraumpräfix besitzen, entweder über die Eigenschaft prefix des Stereotyps xsdSchema oder die Eigenschaft prefix des Stereotyps xsdXModel. Das Paket <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M97"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M97"/>
   <xsl:template match="@*|node()" priority="-2" mode="M97">
      <xsl:apply-templates select="*" mode="M97"/>
   </xsl:template>
   <!--PATTERN NDR-30-VersionierungDerXMLSchemaDefinitionen-XMLSchemaDefinitionenSindVersioniertNDR-30: Versionierung der XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-30: Versionierung der XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdSchema(.)                 and empty((xoev:xsdSchema(.)/@version, ancestor::packagedElement/xoev:xoevVersionStandard(.)/@version)[. != ''])]"
                 priority="1000"
                 mode="M98">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">XMLSchemaDefinitionenSindVersioniert</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>XML Schema-Definitionen (UML-Pakete mit dem Stereotyp xsdSchema) müssen eine Version besitzen, entweder über die Eigenschaft version des Stereotyps xsdSchema oder die Eigenschaft version des Stereotyps xoevVersionStandard. Das Paket <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M98"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M98"/>
   <xsl:template match="@*|node()" priority="-2" mode="M98">
      <xsl:apply-templates select="*" mode="M98"/>
   </xsl:template>
   <!--PATTERN NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardNameLangMussBefuelltSeinNDR-32: Dokumentation der Metadaten des Standards-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-32: Dokumentation der Metadaten des Standards</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and empty(xoev:xoevStandard(.)/@nameLang[. != ''])]"
                 priority="1000"
                 mode="M99">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">MetadatenelementStandardNameLangMussBefuelltSein</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Der Name (lang) eines Standards muss spezifiziert sein (Eigenschaft nameLang des Stereotyps xoevStandard).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M99"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M99"/>
   <xsl:template match="@*|node()" priority="-2" mode="M99">
      <xsl:apply-templates select="*" mode="M99"/>
   </xsl:template>
   <!--PATTERN NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardNameKurzMussBefuelltSeinNDR-32: Dokumentation der Metadaten des Standards-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-32: Dokumentation der Metadaten des Standards</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and empty(xoev:xoevStandard(.)/@nameKurz[. != ''])]"
                 priority="1000"
                 mode="M100">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">MetadatenelementStandardNameKurzMussBefuelltSein</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Der Name (kurz) eines Standards muss spezifiziert sein (Eigenschaft nameKurz des Stereotyps xoevStandard).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M100"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M100"/>
   <xsl:template match="@*|node()" priority="-2" mode="M100">
      <xsl:apply-templates select="*" mode="M100"/>
   </xsl:template>
   <!--PATTERN NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardNameTechnischMussBefuelltSeinNDR-32: Dokumentation der Metadaten des Standards-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-32: Dokumentation der Metadaten des Standards</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and empty(xoev:xoevStandard(.)/@nameTechnisch[. != ''])]"
                 priority="1000"
                 mode="M101">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">MetadatenelementStandardNameTechnischMussBefuelltSein</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Der Name (technisch) eines Standards muss spezifiziert sein (Eigenschaft nameTechnisch des Stereotyps xoevStandard).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M101"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M101"/>
   <xsl:template match="@*|node()" priority="-2" mode="M101">
      <xsl:apply-templates select="*" mode="M101"/>
   </xsl:template>
   <!--PATTERN NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardKennungMussBefuelltSeinNDR-32: Dokumentation der Metadaten des Standards-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-32: Dokumentation der Metadaten des Standards</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and empty(xoev:xoevStandard(.)/@kennung[. != ''])]"
                 priority="1000"
                 mode="M102">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">MetadatenelementStandardKennungMussBefuelltSein</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Kennung eines Standards muss spezifiziert sein (Eigenschaft kennung des Stereotyps xoevStandard).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M102"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M102"/>
   <xsl:template match="@*|node()" priority="-2" mode="M102">
      <xsl:apply-templates select="*" mode="M102"/>
   </xsl:template>
   <!--PATTERN NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardBeschreibungMussBefuelltSeinNDR-32: Dokumentation der Metadaten des Standards-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-32: Dokumentation der Metadaten des Standards</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and empty(xoev:xoevStandard(.)/@beschreibung[. != ''])]"
                 priority="1000"
                 mode="M103">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">MetadatenelementStandardBeschreibungMussBefuelltSein</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Beschreibung eines Standards muss vorliegen (Eigenschaft beschreibung des Stereotyps xoevStandard).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M103"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M103"/>
   <xsl:template match="@*|node()" priority="-2" mode="M103">
      <xsl:apply-templates select="*" mode="M103"/>
   </xsl:template>
   <!--PATTERN NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementVersionStandardVersionMussBefuelltSeinNDR-32: Dokumentation der Metadaten des Standards-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-32: Dokumentation der Metadaten des Standards</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and empty(xoev:xoevVersionStandard(.)/@version[. != ''])]"
                 priority="1000"
                 mode="M104">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">MetadatenelementVersionStandardVersionMussBefuelltSein</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Version eines Standards muss spezifiziert sein (Eigenschaft version des Stereotyps xoevVersionStandard).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M104"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M104"/>
   <xsl:template match="@*|node()" priority="-2" mode="M104">
      <xsl:apply-templates select="*" mode="M104"/>
   </xsl:template>
   <!--PATTERN NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementVersionStandardVersionXOEVHandbuchMussBefuelltSeinNDR-32: Dokumentation der Metadaten des Standards-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-32: Dokumentation der Metadaten des Standards</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and empty(xoev:xoevVersionStandard(.)/@versionXOEVHandbuch[. != ''])]"
                 priority="1000"
                 mode="M105">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">MetadatenelementVersionStandardVersionXOEVHandbuchMussBefuelltSein</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Version des XÖV-Handbuchs, zu dessen Regelungen die Version des Standards konform ist, muss spezifiziert sein (Eigenschaft versionXOEVHandbuch des Stereotyps xoevVersionStandard).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M105"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M105"/>
   <xsl:template match="@*|node()" priority="-2" mode="M105">
      <xsl:apply-templates select="*" mode="M105"/>
   </xsl:template>
   <!--PATTERN NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementVersionStandardVersionXGeneratorMussBefuelltSeinNDR-32: Dokumentation der Metadaten des Standards-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-32: Dokumentation der Metadaten des Standards</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and empty(xoev:xoevVersionStandard(.)/@versionXGenerator[. != ''])]"
                 priority="1000"
                 mode="M106">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">MetadatenelementVersionStandardVersionXGeneratorMussBefuelltSein</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Version des XGenerators, mit dem das XÖV-Fachmodell der Version des Standards verarbeitet und die Bestandteile der Version des Standards erzeugt wurden, muss spezifiziert sein (Eigenschaft versionXGenerator des Stereotyps xoevVersionStandard).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M106"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M106"/>
   <xsl:template match="@*|node()" priority="-2" mode="M106">
      <xsl:apply-templates select="*" mode="M106"/>
   </xsl:template>
   <!--PATTERN NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementVersionStandardVersionModellierungswerkzeugMussBefuelltSeinNDR-32: Dokumentation der Metadaten des Standards-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-32: Dokumentation der Metadaten des Standards</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and empty(xoev:xoevVersionStandard(.)/@versionModellierungswerkzeug[. != ''])]"
                 priority="1000"
                 mode="M107">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">MetadatenelementVersionStandardVersionModellierungswerkzeugMussBefuelltSein</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Version des Modellierungswerkzeugs, mit dem das XÖV-Fachmodell der Version des Standards erstellt wurde, muss spezifiziert sein (Eigenschaft versionModellierungswerkzeug des Stereotyps xoevVersionStandard).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M107"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M107"/>
   <xsl:template match="@*|node()" priority="-2" mode="M107">
      <xsl:apply-templates select="*" mode="M107"/>
   </xsl:template>
   <!--PATTERN NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardKennungMussMitUrnXoevDeBeginnenNDR-32: Dokumentation der Metadaten des Standards-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-32: Dokumentation der Metadaten des Standards</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and not(starts-with(xoev:xoevStandard(.)/@kennung, 'urn:xoev-de:'))]"
                 priority="1000"
                 mode="M108">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">MetadatenelementStandardKennungMussMitUrnXoevDeBeginnen</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Kennung des Standards muss mit der Zeichenfolge "urn:xoev-de:" beginnen (Eigenschaft kennung des Stereotyps xoevStandard).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M108"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M108"/>
   <xsl:template match="@*|node()" priority="-2" mode="M108">
      <xsl:apply-templates select="*" mode="M108"/>
   </xsl:template>
   <!--PATTERN NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardKennungMussStandardEnthaltenNDR-32: Dokumentation der Metadaten des Standards-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-32: Dokumentation der Metadaten des Standards</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and not(contains(xoev:xoevStandard(.)/@kennung, ':standard:'))]"
                 priority="1000"
                 mode="M109">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">MetadatenelementStandardKennungMussStandardEnthalten</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Kennung des Standards muss die Zeichenfolge ":standard:" enthalten (Eigenschaft kennung des Stereotyps xoevStandard).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M109"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M109"/>
   <xsl:template match="@*|node()" priority="-2" mode="M109">
      <xsl:apply-templates select="*" mode="M109"/>
   </xsl:template>
   <!--PATTERN NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardKennungMussNameTechnischEnthaltenNDR-32: Dokumentation der Metadaten des Standards-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-32: Dokumentation der Metadaten des Standards</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and                 not(contains(xoev:xoevStandard(.)/@kennung,                 lower-case(xoev:xoevStandard(.)/@nameTechnisch)))]"
                 priority="1000"
                 mode="M110">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">MetadatenelementStandardKennungMussNameTechnischEnthalten</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Kennung des Standards (Eigenschaft kennung des Stereotyps xoevStandard) muss den Namen (technisch) des Standards in Kleinschreibung enthalten (Eigenschaft nameTechnisch des Stereotyps xoevStandard).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M110"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M110"/>
   <xsl:template match="@*|node()" priority="-2" mode="M110">
      <xsl:apply-templates select="*" mode="M110"/>
   </xsl:template>
   <!--PATTERN NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardKennungDarfNichtXoevEnthaltenNDR-32: Dokumentation der Metadaten des Standards-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-32: Dokumentation der Metadaten des Standards</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and contains(replace(xoev:xoevStandard(.)/@kennung, 'urn:xoev-de', ''), 'xoev')]"
                 priority="1000"
                 mode="M111">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">MetadatenelementStandardKennungDarfNichtXoevEnthalten</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Kennung des Standards muss mit der Zeichenfolge "urn:xoev-de:" beginnen, darf die Zeichenfolge "xoev" jedoch an keiner weiteren Stelle enthalten (Eigenschaft kennung des Stereotyps xoevStandard).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M111"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M111"/>
   <xsl:template match="@*|node()" priority="-2" mode="M111">
      <xsl:apply-templates select="*" mode="M111"/>
   </xsl:template>
   <!--PATTERN NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardKennungDarfNurErlaubteZeichenEnthaltenNDR-32: Dokumentation der Metadaten des Standards-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-32: Dokumentation der Metadaten des Standards</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and replace(xoev:xoevStandard(.)/@kennung, '[a-z0-9\.\-,:]', '') != '']"
                 priority="1000"
                 mode="M112">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">MetadatenelementStandardKennungDarfNurErlaubteZeichenEnthalten</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Kennung des Standards darf nur die Zeichen "a-z", "0-9", "-", ":" und "." enthalten (Eigenschaft kennung des Stereotyps xoevStandard).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M112"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M112"/>
   <xsl:template match="@*|node()" priority="-2" mode="M112">
      <xsl:apply-templates select="*" mode="M112"/>
   </xsl:template>
   <!--PATTERN NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementStandardNameTechnischDarfNurErlaubteZeichenEnthaltenNDR-32: Dokumentation der Metadaten des Standards-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-32: Dokumentation der Metadaten des Standards</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and replace(xoev:xoevStandard(.)/@nameTechnisch, '[a-zA-Z0-9\.\-,]', '') != '']"
                 priority="1000"
                 mode="M113">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">MetadatenelementStandardNameTechnischDarfNurErlaubteZeichenEnthalten</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Der Name (technisch) des Standards darf nur die Zeichen "a-z", "A-Z", "0-9", "-" und "." enthalten (Eigenschaft nameTechnisch des Stereotyps xoevStandard).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M113"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M113"/>
   <xsl:template match="@*|node()" priority="-2" mode="M113">
      <xsl:apply-templates select="*" mode="M113"/>
   </xsl:template>
   <!--PATTERN NDR-32-DokumentationDerMetadatenDesStandards-MetadatenelementVersionStandardVersionDarfNurErlaubteZeichenEnthaltenNDR-32: Dokumentation der Metadaten des Standards-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-32: Dokumentation der Metadaten des Standards</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and replace(xoev:xoevVersionStandard(.)/@version, '[a-zA-Z0-9\.\-,]', '') != '']"
                 priority="1000"
                 mode="M114">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">MetadatenelementVersionStandardVersionDarfNurErlaubteZeichenEnthalten</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Version des Standards darf nur die Zeichen "a-z", "A-Z", "0-9", "-", ":" und "." enthalten (Eigenschaft version des Stereotyps xoevVersionStandard).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M114"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M114"/>
   <xsl:template match="@*|node()" priority="-2" mode="M114">
      <xsl:apply-templates select="*" mode="M114"/>
   </xsl:template>
   <!--PATTERN NDR-12-ErlaubteZeichenFuerKlassifikationenInNamen-NamenBenannterTypenUndGlobalerElementeOhneAufeinanderfolgendePunkteNDR-12: Erlaubte Zeichen für Klassifikationen in Namen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-12: Erlaubte Zeichen für Klassifikationen in Namen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and contains(@name, '..')] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedElement[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and contains(@name, '..')]"
                 priority="1000"
                 mode="M115">

		<!--ASSERT warning-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NamenBenannterTypenUndGlobalerElementeOhneAufeinanderfolgendePunkte</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Namen benannter Datentypen (UML-Klasse mit dem Stereotyp xsdNamedType) und globaler Elemente (UML-Klasse mit dem Stereotyp xsdGlobalElement) oder beides (xsdGlobalElementAndNamedType) sollen keine aufeinanderfolgenden Punkte enthalten. Die Klasse <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M115"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M115"/>
   <xsl:template match="@*|node()" priority="-2" mode="M115">
      <xsl:apply-templates select="*" mode="M115"/>
   </xsl:template>
   <!--PATTERN NDR-12-ErlaubteZeichenFuerKlassifikationenInNamen-NamenVonElementenUndAttributenOhneAufeinanderfolgendePunkteNDR-12: Erlaubte Zeichen für Klassifikationen in Namen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-12: Erlaubte Zeichen für Klassifikationen in Namen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[(xoev:is-element(.) or xoev:xsdAttribute(.)) and contains(@name, '..')]"
                 priority="1000"
                 mode="M116">

		<!--ASSERT warning-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NamenVonElementenUndAttributenOhneAufeinanderfolgendePunkte</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Namen von XML-Elementen (UML-Eigenschaften mit dem Stereotyp xsdElement) und XML-Attributen (UML-Eigenschaften mit dem Stereotyp xsdAttribute) sollen keine aufeinanderfolgenden Punkte enthalten. Die Eigenschaft <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M116"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M116"/>
   <xsl:template match="@*|node()" priority="-2" mode="M116">
      <xsl:apply-templates select="*" mode="M116"/>
   </xsl:template>
   <!--PATTERN NDR-12-ErlaubteZeichenFuerKlassifikationenInNamen-NamenVonCodelistenEnumerationenAlsBenannteTypenOhneAufeinanderfolgendePunkteNDR-12: Erlaubte Zeichen für Klassifikationen in Namen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-12: Erlaubte Zeichen für Klassifikationen in Namen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xoevCodeliste(.) and xoev:xsdNamedType(.)) and contains(@name, '..')]"
                 priority="1000"
                 mode="M117">

		<!--ASSERT warning-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NamenVonCodelistenEnumerationenAlsBenannteTypenOhneAufeinanderfolgendePunkte</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Namen von UML-Enumerationen, die Codelisten und benannte Typen darstellen (UML-Enumeration mit den Stereotypen xoevCodeliste und xsdNamedType) sollen keine aufeinanderfolgenden Punkte enthalten. Die Enumeration <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M117"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M117"/>
   <xsl:template match="@*|node()" priority="-2" mode="M117">
      <xsl:apply-templates select="*" mode="M117"/>
   </xsl:template>
   <!--PATTERN NDR-4-ErlaubteEinbindungsartenFuerCodelisten-CodeDatentypEntsprichtCodeTyp1bis4NDR-4: Erlaubte Einbindungsarten für Codelisten-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-4: Erlaubte Einbindungsarten für Codelisten</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdCode(.) and empty(xoev:usages-by-client(.)) and empty(xoev:xoevCodeTyp4(.))] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdCode(.) and empty(xoev:usages-by-client(.)) and empty(xoev:xoevCodeTyp4(.))]"
                 priority="1000"
                 mode="M118">

		<!--ASSERT warning-->
      <xsl:choose>
         <xsl:when test="                     (ownedAttribute[@name = 'code' and xoev:xsdElement(.) and xoev:upperBound(.) = 1 and xoev:lowerBound(.) = 1] and                     ownedAttribute[@name = 'listURI' and xoev:xsdAttribute(.) and xoev:upperBound(.) = 1] and                     ownedAttribute[@name = 'listVersionID' and xoev:xsdAttribute(.) and xoev:upperBound(.) = 1]) and                                          (if (ownedAttribute[@name = 'code' and uml:resolve-type(.)[uml:is-Enumeration(.)]]) then                         ownedAttribute[@name = 'listURI' and (defaultValue/@value, defaultValue/body)[. != ''] and @isReadOnly = 'true'] and                         ownedAttribute[@name = 'listVersionID' and (defaultValue/@value, defaultValue/body)[. != ''] and @isReadOnly = 'true']                     else                         (ownedAttribute[@name = 'listURI' and (defaultValue/@value, defaultValue/body)[. != ''] and @isReadOnly = 'true'] and                         ownedAttribute[@name = 'listVersionID' and (defaultValue/@value, defaultValue/body)[. != ''] and @isReadOnly = 'true']) or                                                  (ownedAttribute[@name = 'listURI' and (defaultValue/@value, defaultValue/body)[. != ''] and @isReadOnly = 'true'] and                         ownedAttribute[@name = 'listVersionID' and xoev:lowerBound(.) = 1]) or                                                  (ownedAttribute[@name = 'listURI' and xoev:lowerBound(.) = 1] and                         ownedAttribute[@name = 'listVersionID' and xoev:lowerBound(.) = 1]))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="(ownedAttribute[@name = 'code' and xoev:xsdElement(.) and xoev:upperBound(.) = 1 and xoev:lowerBound(.) = 1] and ownedAttribute[@name = 'listURI' and xoev:xsdAttribute(.) and xoev:upperBound(.) = 1] and ownedAttribute[@name = 'listVersionID' and xoev:xsdAttribute(.) and xoev:upperBound(.) = 1]) and (if (ownedAttribute[@name = 'code' and uml:resolve-type(.)[uml:is-Enumeration(.)]]) then ownedAttribute[@name = 'listURI' and (defaultValue/@value, defaultValue/body)[. != ''] and @isReadOnly = 'true'] and ownedAttribute[@name = 'listVersionID' and (defaultValue/@value, defaultValue/body)[. != ''] and @isReadOnly = 'true'] else (ownedAttribute[@name = 'listURI' and (defaultValue/@value, defaultValue/body)[. != ''] and @isReadOnly = 'true'] and ownedAttribute[@name = 'listVersionID' and (defaultValue/@value, defaultValue/body)[. != ''] and @isReadOnly = 'true']) or (ownedAttribute[@name = 'listURI' and (defaultValue/@value, defaultValue/body)[. != ''] and @isReadOnly = 'true'] and ownedAttribute[@name = 'listVersionID' and xoev:lowerBound(.) = 1]) or (ownedAttribute[@name = 'listURI' and xoev:lowerBound(.) = 1] and ownedAttribute[@name = 'listVersionID' and xoev:lowerBound(.) = 1]))">
               <xsl:attribute name="id">CodeDatentypEntsprichtCodeTyp1bis4</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Code-Datentypen (UML-Klassen mit dem Stereotyp xsdCode) sollen entsprechend den Code-Typen 1 bis 4 ausgestaltet sein. Die Klasse <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Regel.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M118"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M118"/>
   <xsl:template match="@*|node()" priority="-2" mode="M118">
      <xsl:apply-templates select="*" mode="M118"/>
   </xsl:template>
   <!--PATTERN NDR-11-ErlaubteZeichenFuerNamen-NurErlaubteZeichenFuerBenannteTypenUndGlobaleElementeNDR-11: Erlaubte Zeichen für Namen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-11: Erlaubte Zeichen für Namen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and                 replace(@name, '[a-zA-Z0-9\.\-_]', '') != ''] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and                 replace(@name, '[a-zA-Z0-9\.\-_]', '') != '']"
                 priority="1000"
                 mode="M119">

		<!--ASSERT warning-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NurErlaubteZeichenFuerBenannteTypenUndGlobaleElemente</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Benannte Typen (UML-Klassen mit dem Stereotyp xsdNamedType) und globale Elemente (UML-Klassen mit dem Stereotyp xsdGlobalElement) oder beides (xsdGlobalElementAndNamedType) sollen nur die Zeichen "a-z", "A-Z", "0-9", ".", "_" und "-" enthalten. Die Klasse <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Regel.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M119"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M119"/>
   <xsl:template match="@*|node()" priority="-2" mode="M119">
      <xsl:apply-templates select="*" mode="M119"/>
   </xsl:template>
   <!--PATTERN NDR-11-ErlaubteZeichenFuerNamen-KeineWhitespacesInNamenBenannterTypenUndGlobalerElementeNDR-11: Erlaubte Zeichen für Namen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-11: Erlaubte Zeichen für Namen</svrl:text>
   <!--RULE -->
   <xsl:template match="             /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and             matches(@name, '\s')] |             /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.) or xoev:xsdGlobalElement(.) or xoev:xsdMessage(.)) and             matches(@name, '\s')]"
                 priority="1000"
                 mode="M120">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">KeineWhitespacesInNamenBenannterTypenUndGlobalerElemente</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Benannte Typen (UML-Klassen mit dem Stereotyp xsdNamedType) und globale Elemente (UML-Klassen mit dem Stereotyp xsdGlobalElement) oder beides (xsdGlobalElementAndNamedType) dürfen keine Whitespaces enthalten. Die Klasse <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Regel.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M120"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M120"/>
   <xsl:template match="@*|node()" priority="-2" mode="M120">
      <xsl:apply-templates select="*" mode="M120"/>
   </xsl:template>
   <!--PATTERN NDR-11-ErlaubteZeichenFuerNamen-NurErlaubteZeichenFuerNamensPraefixeUndSuffixeNDR-11: Erlaubte Zeichen für Namen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-11: Erlaubte Zeichen für Namen</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]"
                 priority="1000"
                 mode="M121">

		<!--ASSERT warning-->
      <xsl:choose>
         <xsl:when test="                     xoev:xsdXModel(.)[                     (not(@xsdGlobalElementNamePrefix[. != '']) or replace(@xsdGlobalElementNamePrefix, '[a-zA-Z0-9\.\-_]', '') = '') and                     (not(@xsdGlobalElementNameSuffix[. != '']) or replace(@xsdGlobalElementNameSuffix, '[a-zA-Z0-9\.\-_]', '') = '') and                     (not(@xsdNamedTypeNamePrefix[. != '']) or replace(@xsdNamedTypeNamePrefix, '[a-zA-Z0-9\.\-_]', '') = '') and                     (not(@xsdNamedTypeNameSuffix[. != '']) or replace(@xsdNamedTypeNameSuffix, '[a-zA-Z0-9\.\-_]', '') = '')]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="xoev:xsdXModel(.)[ (not(@xsdGlobalElementNamePrefix[. != '']) or replace(@xsdGlobalElementNamePrefix, '[a-zA-Z0-9\.\-_]', '') = '') and (not(@xsdGlobalElementNameSuffix[. != '']) or replace(@xsdGlobalElementNameSuffix, '[a-zA-Z0-9\.\-_]', '') = '') and (not(@xsdNamedTypeNamePrefix[. != '']) or replace(@xsdNamedTypeNamePrefix, '[a-zA-Z0-9\.\-_]', '') = '') and (not(@xsdNamedTypeNameSuffix[. != '']) or replace(@xsdNamedTypeNameSuffix, '[a-zA-Z0-9\.\-_]', '') = '')]">
               <xsl:attribute name="id">NurErlaubteZeichenFuerNamensPraefixeUndSuffixe</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Namenspräfixe und -suffixe von benannten Typen und globalen Elementen (Eigenschaften xsdGlobalElementNamePrefix, xsdGlobalElementNameSuffix, xsdNamedTypeNamePrefix, xsdNamedTypeNameSuffix des Stereotyps xsdXModel) sollen nur die Zeichen "a-z", "A-Z", "0-9", ".", "_" und "-" enthalten.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M121"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M121"/>
   <xsl:template match="@*|node()" priority="-2" mode="M121">
      <xsl:apply-templates select="*" mode="M121"/>
   </xsl:template>
   <!--PATTERN NDR-11-ErlaubteZeichenFuerNamen-KeineWhitespacesInNamensPraefixenUndSuffixenNDR-11: Erlaubte Zeichen für Namen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-11: Erlaubte Zeichen für Namen</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]"
                 priority="1000"
                 mode="M122">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                 xoev:xsdXModel(.)[                 not(matches(@xsdGlobalElementNamePrefix, '\s') or                     matches(@xsdGlobalElementNameSuffix, '\s') or                     matches(@xsdNamedTypeNamePrefix, '\s') or                     matches(@xsdNamedTypeNameSuffix, '\s'))]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="xoev:xsdXModel(.)[ not(matches(@xsdGlobalElementNamePrefix, '\s') or matches(@xsdGlobalElementNameSuffix, '\s') or matches(@xsdNamedTypeNamePrefix, '\s') or matches(@xsdNamedTypeNameSuffix, '\s'))]">
               <xsl:attribute name="id">KeineWhitespacesInNamensPraefixenUndSuffixen</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Namenspräfixe und -suffixe von benannten Typen und globalen Elementen (Eigenschaften xsdGlobalElementNamePrefix, xsdGlobalElementNameSuffix, xsdNamedTypeNamePrefix, xsdNamedTypeNameSuffix des Stereotyps xsdXModel) dürfen keine Whitespaces enthalten.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M122"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M122"/>
   <xsl:template match="@*|node()" priority="-2" mode="M122">
      <xsl:apply-templates select="*" mode="M122"/>
   </xsl:template>
   <!--PATTERN NDR-11-ErlaubteZeichenFuerNamen-NurErlaubteZeichenFuerElementeUndAttributeNDR-11: Erlaubte Zeichen für Namen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-11: Erlaubte Zeichen für Namen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[(xoev:is-element(.) or xoev:xsdAttribute(.)) and                 replace(@name, '[a-zA-Z0-9\.\-_]', '') != '']"
                 priority="1000"
                 mode="M123">

		<!--ASSERT warning-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NurErlaubteZeichenFuerElementeUndAttribute</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>XML-Elemente (UML-Eigenschaften mit dem Stereotyp xsdElement) und XML-Attribute (UML-Eigenschaften mit dem Stereotyp xsdAttribute) sollen nur die Zeichen "a-z", "A-Z", "0-9", ".", "_" und "-" enthalten. Die Eigenschaft <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Regel.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M123"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M123"/>
   <xsl:template match="@*|node()" priority="-2" mode="M123">
      <xsl:apply-templates select="*" mode="M123"/>
   </xsl:template>
   <!--PATTERN NDR-11-ErlaubteZeichenFuerNamen-KeineWhitespacesInElementUndAttributnamenNDR-11: Erlaubte Zeichen für Namen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-11: Erlaubte Zeichen für Namen</svrl:text>
   <!--RULE -->
   <xsl:template match="             /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[(xoev:is-element(.) or xoev:xsdAttribute(.)) and             matches(@name, '\s')]"
                 priority="1000"
                 mode="M124">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">KeineWhitespacesInElementUndAttributnamen</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>XML-Elemente (UML-Eigenschaften mit dem Stereotyp xsdElement) und XML-Attribute (UML-Eigenschaften mit dem Stereotyp xsdAttribute) dürfen keine Whitespaces enthalten. Die Eigenschaft <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Regel.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M124"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M124"/>
   <xsl:template match="@*|node()" priority="-2" mode="M124">
      <xsl:apply-templates select="*" mode="M124"/>
   </xsl:template>
   <!--PATTERN NDR-11-ErlaubteZeichenFuerNamen-NurErlaubteZeichenFuerNamenVonBenanntenDatentypenFuerCodelistenversionenNDR-12: Erlaubte Zeichen für Klassifikationen in Namen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-12: Erlaubte Zeichen für Klassifikationen in Namen</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Usage(.) and xoev:xoevCodeTyp1(.) and not(matches(xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentypName, '^[a-zA-Z0-9\.\-_]*$'))]"
                 priority="1000"
                 mode="M125">

		<!--ASSERT warning-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NurErlaubteZeichenFuerNamenVonBenanntenDatentypenFuerCodelistenversionen</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Namen explizit benannter Datentypen für Codelistenversionen (Eigenschaft benannterCodelistenDatentypName des Stereotyps xoevCodeTyp1) sollen nur die Zeichen "a-z", "A-Z", "0-9", ".", "_" und "-" enthalten. Im Kontext der Verwendungsbeziehung zwischen dem Code-Datentyp <xsl:text/>
                  <xsl:value-of select="uml:resolve-client(.)/@name"/>
                  <xsl:text/> und der Codelistenversion <xsl:text/>
                  <xsl:value-of select="uml:resolve-supplier(.)/@name"/>
                  <xsl:text/> der Codeliste <xsl:text/>
                  <xsl:value-of select="uml:resolve-supplier(.)/xoev:dependencies-by-client(.)/uml:resolve-supplier(.)/@name"/>
                  <xsl:text/> wurde der Datentypname "<xsl:text/>
                  <xsl:value-of select="xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentypName"/>
                  <xsl:text/>" mit ungültigen Zeichen spezifiziert.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M125"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M125"/>
   <xsl:template match="@*|node()" priority="-2" mode="M125">
      <xsl:apply-templates select="*" mode="M125"/>
   </xsl:template>
   <!--PATTERN NDR-11-ErlaubteZeichenFuerNamen-KeineWhitespacesInNamenBenannterDatentypenFuerCodelistenversionenNDR-12: Erlaubte Zeichen für Klassifikationen in Namen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-12: Erlaubte Zeichen für Klassifikationen in Namen</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Usage(.) and xoev:xoevCodeTyp1(.) and matches(xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentypName, '\s')]"
                 priority="1000"
                 mode="M126">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">KeineWhitespacesInNamenBenannterDatentypenFuerCodelistenversionen</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Namen explizit benannter Datentypen für Codelistenversionen (Eigenschaft benannterCodelistenDatentypName des Stereotyps xoevCodeTyp1) dürfen keine Whitespaces enthalten. Im Kontext der Verwendungsbeziehung zwischen dem Code-Datentyp <xsl:text/>
                  <xsl:value-of select="uml:resolve-client(.)/@name"/>
                  <xsl:text/> und der Codelistenversion <xsl:text/>
                  <xsl:value-of select="uml:resolve-supplier(.)/@name"/>
                  <xsl:text/> der Codeliste <xsl:text/>
                  <xsl:value-of select="uml:resolve-supplier(.)/xoev:dependencies-by-client(.)/uml:resolve-supplier(.)/@name"/>
                  <xsl:text/> wurde der Datentypname "<xsl:text/>
                  <xsl:value-of select="xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentypName"/>
                  <xsl:text/>" mit Whitespaces spezifiziert.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M126"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M126"/>
   <xsl:template match="@*|node()" priority="-2" mode="M126">
      <xsl:apply-templates select="*" mode="M126"/>
   </xsl:template>
   <!--PATTERN NDR-5-DetaillierteStrukturEinesXOEVFachmodells-BasisdatentypenSchemaDefiniertNDR-5: Detaillierte Struktur eines XÖV-Fachmodells-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-5: Detaillierte Struktur eines XÖV-Fachmodells</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and empty(packagedElement[xoev:xsdSchema(.) and @name = 'Basisdatentypen'])]"
                 priority="1000"
                 mode="M127">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">BasisdatentypenSchemaDefiniert</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Es wird empfohlen, auf der obersten Ebene des XÖV-Fachmodells ein Paket "Basisdatentypen" vorzusehen.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M127"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M127"/>
   <xsl:template match="@*|node()" priority="-2" mode="M127">
      <xsl:apply-templates select="*" mode="M127"/>
   </xsl:template>
   <!--PATTERN NDR-5-DetaillierteStrukturEinesXOEVFachmodells-BaukastenSchemaDefiniertNDR-5: Detaillierte Struktur eines XÖV-Fachmodells-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-5: Detaillierte Struktur eines XÖV-Fachmodells</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and empty(packagedElement[xoev:xsdSchema(.) and @name = 'Baukasten'])]"
                 priority="1000"
                 mode="M128">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">BaukastenSchemaDefiniert</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Es wird empfohlen, auf der obersten Ebene des XÖV-Fachmodells ein Paket "Baukasten" vorzusehen.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M128"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M128"/>
   <xsl:template match="@*|node()" priority="-2" mode="M128">
      <xsl:apply-templates select="*" mode="M128"/>
   </xsl:template>
   <!--PATTERN NDR-5-DetaillierteStrukturEinesXOEVFachmodells-NachrichtenOderFachmodulePaketDefiniertNDR-5: Detaillierte Struktur eines XÖV-Fachmodells-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-5: Detaillierte Struktur eines XÖV-Fachmodells</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.) and                 empty(packagedElement[not(xoev:xsdSchema(.)) and (@name = 'Nachrichten' or @name = 'Fachmodule')])]"
                 priority="1000"
                 mode="M129">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NachrichtenOderFachmodulePaketDefiniert</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Es wird empfohlen, auf der obersten Ebene des XÖV-Fachmodells ein Paket "Nachrichten" bzw. "Fachmodule" vorzusehen.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M129"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M129"/>
   <xsl:template match="@*|node()" priority="-2" mode="M129">
      <xsl:apply-templates select="*" mode="M129"/>
   </xsl:template>
   <!--PATTERN NDR-5-DetaillierteStrukturEinesXOEVFachmodells-MindestensEinHauptgruppenschemaNDR-5: Detaillierte Struktur eines XÖV-Fachmodells-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-5: Detaillierte Struktur eines XÖV-Fachmodells</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]/packagedElement                 [not(xoev:xsdSchema(.)) and (@name = 'Nachrichten' or @name = 'Fachmodule')]                 [empty(packagedElement[xoev:xsdSchema(.) and not(@name = 'Nachrichtentypen')])]"
                 priority="1000"
                 mode="M130">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">MindestensEinHauptgruppenschema</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Es wird empfohlen, im Paket "Nachrichten" bzw. "Fachmodule" mindestens ein Nachrichtenhauptgruppen-Schema vorzusehen.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M130"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M130"/>
   <xsl:template match="@*|node()" priority="-2" mode="M130">
      <xsl:apply-templates select="*" mode="M130"/>
   </xsl:template>
   <!--PATTERN NDR-5-DetaillierteStrukturEinesXOEVFachmodells-NachrichtenNurInHauptgruppenpaketenNDR-5: Detaillierte Struktur eines XÖV-Fachmodells-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-5: Detaillierte Struktur eines XÖV-Fachmodells</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdMessage(.) and                 not(ancestor::packagedElement[xoev:xsdSchema(.)]/parent::packagedElement[@name = 'Nachrichten' or @name = 'Fachmodule']/parent::packagedElement/@xmi:id =                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]/@xmi:id)] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdMessage(.) and                 not(ancestor::packagedElement[xoev:xsdSchema(.)]/parent::packagedElement[@name = 'Nachrichten' or @name = 'Fachmodule']/parent::packagedElement/@xmi:id =                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]/@xmi:id)]"
                 priority="1000"
                 mode="M131">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NachrichtenNurInHauptgruppenpaketen</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Es wird empfohlen, Nachrichten (UML-Klassen mit dem Stereotyp xsdMessage) nur in den Hauptgruppenpaketen unterhalb des Pakets "Nachrichten" bzw. "Fachmodule" zu spezifizieren. Die Klasse <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> entspricht der Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M131"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M131"/>
   <xsl:template match="@*|node()" priority="-2" mode="M131">
      <xsl:apply-templates select="*" mode="M131"/>
   </xsl:template>
   <!--PATTERN NDR-5-DetaillierteStrukturEinesXOEVFachmodells-HauptgruppenpaketeNichtOhneNachrichtenNDR-5: Detaillierte Struktur eines XÖV-Fachmodells-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-5: Detaillierte Struktur eines XÖV-Fachmodells</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]/packagedElement[not(xoev:xsdSchema(.)) and (@name = 'Nachrichten' or @name = 'Fachmodule')]/                 packagedElement[xoev:xsdSchema(.) and not(@name = 'Nachrichtentypen')]                 [empty((descendant::packagedElement | descendant::nestedClassifier)[xoev:xsdMessage(.)])]"
                 priority="1000"
                 mode="M132">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">HauptgruppenpaketeNichtOhneNachrichten</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Es wird empfohlen, in einer Nachrichtenhauptgruppe mindestens eine Nachricht zu spezifieren (UML-Klasse mit dem Stereotyp xsdMessage). Das Paket <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> entspricht der Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M132"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M132"/>
   <xsl:template match="@*|node()" priority="-2" mode="M132">
      <xsl:apply-templates select="*" mode="M132"/>
   </xsl:template>
   <!--PATTERN NDR-7-XMLWildcardElementeMitNamensraum-AnyElementeMitNamensraumNDR-7: XML-Wildcard-Elemente mit Namensraum-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-7: XML-Wildcard-Elemente mit Namensraum</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdAnyContents(.) and empty(xoev:xsdAnyContents(.)/@namespace[. != ''])] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdAnyContents(.) and empty(xoev:xsdAnyContents(.)/@namespace[. != ''])]"
                 priority="1000"
                 mode="M133">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">AnyElementeMitNamensraum</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Es wird empfohlen, für Any-Elemente (UML-Klassen mit dem Stereotyp xsdAnyContents) einen Namensraum zu vergeben (Eigenschaft namespace des Stereotyps xsdAnyContents). Die Klasse <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> entspricht der Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M133"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M133"/>
   <xsl:template match="@*|node()" priority="-2" mode="M133">
      <xsl:apply-templates select="*" mode="M133"/>
   </xsl:template>
   <!--PATTERN NDR-15-GroßUndKleinschreibungVonNamen-UpperCamelCaseFuerNamenBenannterTypenNDR-15: Groß- und Kleinschreibung von (und innerhalb zusammengesetzter) Namen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-15: Groß- und Kleinschreibung von (und innerhalb zusammengesetzter) Namen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)) and                 substring(@name, 1, 1) != upper-case(substring(@name, 1, 1))] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)) and                 substring(@name, 1, 1) != upper-case(substring(@name, 1, 1))]"
                 priority="1000"
                 mode="M134">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">UpperCamelCaseFuerNamenBenannterTypen</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Es wird empfohlen, Namen benannter Typen (UML-Klassen mit dem Stereotyp xsdNamedType oder xsdGlobalElementAndNamedType) mit einem Großbuchstaben zu beginnen. Die Klasse <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> entspricht der Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M134"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M134"/>
   <xsl:template match="@*|node()" priority="-2" mode="M134">
      <xsl:apply-templates select="*" mode="M134"/>
   </xsl:template>
   <!--PATTERN NDR-15-GroßUndKleinschreibungVonNamen-LowerCamelCaseFuerNamenVonElementenUndAttributenNDR-15: Groß- und Kleinschreibung von (und innerhalb zusammengesetzter) Namen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-15: Groß- und Kleinschreibung von (und innerhalb zusammengesetzter) Namen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[(xoev:is-element(.) or xoev:xsdAttribute(.)) and                 substring(@name, 1, 1) != lower-case(substring(@name, 1, 1))]"
                 priority="1000"
                 mode="M135">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">LowerCamelCaseFuerNamenVonElementenUndAttributen</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Es wird empfohlen, Namen von XML-Elementen (UML-Eigenschaft mit dem Stereotyp xsdElement) und XML-Attributen (UML-Eigenschaft mit dem Stereotyp xsdAttribute) mit einem Kleinbuchstaben zu beginnen. Die Eigenschaft <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> entspricht der Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M135"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M135"/>
   <xsl:template match="@*|node()" priority="-2" mode="M135">
      <xsl:apply-templates select="*" mode="M135"/>
   </xsl:template>
   <!--PATTERN NDR-15-GroßUndKleinschreibungVonNamen-LowerCamelCaseFuerNamenGlobalerElementeNDR-15: Groß- und Kleinschreibung von (und innerhalb zusammengesetzter) Namen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-15: Groß- und Kleinschreibung von (und innerhalb zusammengesetzter) Namen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xsdGlobalElement(.) or xoev:xsdMessage(.) or xoev:xsdGlobalElementAndNamedType(.)) and                 substring(@name, 1, 1) != lower-case(substring(@name, 1, 1))] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[(xoev:xsdGlobalElement(.) or xoev:xsdMessage(.) or xoev:xsdGlobalElementAndNamedType(.)) and                 substring(@name, 1, 1) != lower-case(substring(@name, 1, 1))]"
                 priority="1000"
                 mode="M136">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">LowerCamelCaseFuerNamenGlobalerElemente</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Es wird empfohlen, Namen globaler Elemente (UML-Klassen mit dem Stereotyp xsdGlobalElement) mit einem Kleinbuchstaben zu beginnen. Die Klasse <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> entspricht der Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M136"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M136"/>
   <xsl:template match="@*|node()" priority="-2" mode="M136">
      <xsl:apply-templates select="*" mode="M136"/>
   </xsl:template>
   <!--PATTERN NDR-16-NamensstrukturGlobalerElemente-NachrichtennamenMitPraefixNDR-16: Namensstruktur globaler Elementen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-16: Namensstruktur globaler Elementen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdMessage(.) and count(tokenize(@name, '\.')) lt 2] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdMessage(.) and count(tokenize(@name, '\.')) lt 2]"
                 priority="1000"
                 mode="M137">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NachrichtennamenMitPraefix</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Es wird empfohlen, Namen von Nachrichten (UML-Klassen mit dem Stereotyp xsdMessage) ein mit einem Punkt abgetrenntes Präfix voranzustelen. Die Klasse <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> entspricht der Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M137"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M137"/>
   <xsl:template match="@*|node()" priority="-2" mode="M137">
      <xsl:apply-templates select="*" mode="M137"/>
   </xsl:template>
   <!--PATTERN NDR-16-NamensstrukturGlobalerElemente-NameNachrichtenpraefixEntsprichtNameSchemapaketNDR-16: Namensstruktur globaler Elementen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-16: Namensstruktur globaler Elementen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdMessage(.)] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdMessage(.)]"
                 priority="1000"
                 mode="M138">
      <xsl:variable name="msg-prefix" select="tokenize(@name, '\.')[1]"/>
      <xsl:variable name="msg-prefix-norm"
                    select="concat(lower-case(substring($msg-prefix, 1, 1)), substring($msg-prefix, 2, string-length($msg-prefix)))"/>
      <xsl:variable name="schema-name"
                    select="ancestor::packagedElement[xoev:xsdSchema(.)]/@name"/>
      <xsl:variable name="schema-name-norm"
                    select="concat(lower-case(substring($schema-name, 1, 1)), substring($schema-name, 2, string-length($schema-name)))"/>
      <!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="$msg-prefix-norm = $schema-name-norm"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="$msg-prefix-norm = $schema-name-norm">
               <xsl:attribute name="id">NameNachrichtenpraefixEntsprichtNameSchemapaket</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Es wird empfohlen, Namen von Nachrichten (UML-Klassen mit dem Stereotyp xsdMessage) mit einem Präfix zu versehen, das dem Namen des zugehörigen Hauptgruppenpakets (UML-Paket mit dem Stereotyp xsdSchema) entspricht. (Hinweis: Die Anfangsbuchstaben der UML-Klasse und des UML-Pakets dürfen sich in ihrer Groß- und Kleinschreibung unterscheiden, z. B. "hamsterzuchtregister.hamstergeburtsmeldung.0101" und "Hamsterzuchtregister"). Die Klasse <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> entspricht der Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M138"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M138"/>
   <xsl:template match="@*|node()" priority="-2" mode="M138">
      <xsl:apply-templates select="*" mode="M138"/>
   </xsl:template>
   <!--PATTERN NDR-17-VersionsuebergreifendEindeutigeNachrichtennummern-NachrichtennameMitNumerischemSuffixNDR-17: Versionsübergreifend eindeutige Nachrichtennummern-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-17: Versionsübergreifend eindeutige Nachrichtennummern</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdMessage(.) and replace(tokenize(@name, '\.')[last()], '[0-9]', '') != ''] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdMessage(.) and replace(tokenize(@name, '\.')[last()], '[0-9]', '') != '']"
                 priority="1000"
                 mode="M139">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NachrichtennameMitNumerischemSuffix</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Es wird empfohlen, Namen von Nachrichten (UML-Klassen mit dem Stereotyp xsdMessage) mit einem Suffix zu versehen, das die Nachrichtennummer repräsentiert, also ausschließlich aus Ziffern besteht. Die Klasse <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> entspricht der Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M139"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M139"/>
   <xsl:template match="@*|node()" priority="-2" mode="M139">
      <xsl:apply-templates select="*" mode="M139"/>
   </xsl:template>
   <!--PATTERN NDR-17-VersionsuebergreifendEindeutigeNachrichtennummern-NachrichtennummerEindeutigNDR-17: Versionsübergreifend eindeutige Nachrichtennummern-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-17: Versionsübergreifend eindeutige Nachrichtennummern</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdMessage(.) and                 (some $m in                 ancestor::packagedElement[xoev:xsdXModel(.)]//(packagedElement | nestedClassifier)[@xmi:id != current()/@xmi:id and                 xoev:xsdMessage(.) and xoev:getNamespace(.) = current()/xoev:getNamespace(.)]                     satisfies tokenize($m/@name, '\.')[last()] = tokenize(@name, '\.')[last()])] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xsdMessage(.) and                 (some $m in                 ancestor::packagedElement[xoev:xsdXModel(.)]//(packagedElement | nestedClassifier)[@xmi:id != current()/@xmi:id and                 xoev:xsdMessage(.) and xoev:getNamespace(.) = current()/xoev:getNamespace(.)]                     satisfies tokenize($m/@name, '\.')[last()] = tokenize(@name, '\.')[last()])]"
                 priority="1000"
                 mode="M140">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NachrichtennummerEindeutig</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Es wird empfohlen, eindeutige Nachrichtennummern zu vergeben (Namenssuffix von UML-Klassen mit dem Stereotyp xsdMessage). Die Klasse <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> entspricht der Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M140"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M140"/>
   <xsl:template match="@*|node()" priority="-2" mode="M140">
      <xsl:apply-templates select="*" mode="M140"/>
   </xsl:template>
   <!--PATTERN NDR-18-NamenVonXMLSchemaDateien-NameSchemadateiEnthaeltNameTechnischNDR-18: Namen von XML Schema-Dateien-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-18: Namen von XML Schema-Dateien</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdSchema(.) and                 not(starts-with(lower-case(xoev:xsdSchema(.)/@schemaFile), lower-case(ancestor::packagedElement/xoev:xoevStandard(.)/@nameTechnisch)))]"
                 priority="1000"
                 mode="M141">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">NameSchemadateiEnthaeltNameTechnisch</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Es wird empfohlen, den Namen der XML Schema-Dateien eines Standards (Eigenschaft schemaFile des Stereotyps xsdSchema) den Namen (technisch) des Standards voranzustellen (Eigenschaft nameTechnisch des Stereotyps xoevStandard). Das Paket <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> entspricht der Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M141"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M141"/>
   <xsl:template match="@*|node()" priority="-2" mode="M141">
      <xsl:apply-templates select="*" mode="M141"/>
   </xsl:template>
   <!--PATTERN NDR-18-NamenVonXMLSchemaDateien-SchemaLocationEnthaeltNameTechnischDesStandardsNDR-18: Namen von XML Schema-Dateien-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-18: Namen von XML Schema-Dateien</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdSchema(.) and                 not(contains(                 lower-case((xoev:xsdSchema(.)/@schemaLocation[. != ''],                 concat(ancestor::packagedElement/xoev:xsdXModel(.)/@schemaLocationBase, xoev:xsdSchema(.)/@schemaFile))[1]),                 lower-case(ancestor::packagedElement/xoev:xoevStandard(.)/@nameTechnisch)))]"
                 priority="1000"
                 mode="M142">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">SchemaLocationEnthaeltNameTechnischDesStandards</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Es wird empfohlen, in der Schema Location (Eigenschaft schemaLocation des Stereotyps xsdSchema bzw. Eigenschaft schemaLocationBase des Stereotyps xsdXModel in Verbindung mit der Eigenschacht schemaFile des Stereotyps xsdSchema) eines Schema-Pakets (UML-Klasse mit dem Stereotyp xsdSchema) den technischen Namen des Standards aufzuführen (Eigenschaft nameTechnisch des Stereotyps xoevStandard). Das Paket <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> entspricht der Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M142"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M142"/>
   <xsl:template match="@*|node()" priority="-2" mode="M142">
      <xsl:apply-templates select="*" mode="M142"/>
   </xsl:template>
   <!--PATTERN NDR-20-DokumentationDerRechtsgrundlagen-RechtsgrundlageFuerNachrichtenDokumentiertNDR-20: Dokumentation der Rechtsgrundlagen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-20: Dokumentation der Rechtsgrundlagen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdMessage(.) and empty(xoev:xsdMessage(.)/rechtsgrundlagen)] |                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifer[xoev:xsdMessage(.) and empty(xoev:xsdMessage(.)/rechtsgrundlagen)]"
                 priority="1000"
                 mode="M143">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">RechtsgrundlageFuerNachrichtenDokumentiert</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Es wird empfohlen, für Nachrichten die jeweiligen Rechtsgrundlagen zu dokumentieren (Eigenschaft rechtsgrundlagen des Stereotyps xsdMessage). Die Klasse <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> entspricht der Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M143"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M143"/>
   <xsl:template match="@*|node()" priority="-2" mode="M143">
      <xsl:apply-templates select="*" mode="M143"/>
   </xsl:template>
   <!--PATTERN NDR-21-CodenamenFuerCodesEinerCodeliste-BeschreibungEinesCodesSpezifiziertNDR-21: Codenamen für Codes einer Codeliste-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-21: Codenamen für Codes einer Codeliste</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedLiteral[xoev:xoevCodelisteneintrag(.) and                 empty(xoev:xoevCodelisteneintrag(.)/@wertErsteBeschreibungsspalte[. != ''])]"
                 priority="1000"
                 mode="M144">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">BeschreibungEinesCodesSpezifiziert</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Es wird empfohlen, zu jedem Code einer Codeliste eine Beschreibung zu spezifizieren (Eigenschaft wertErsteBeschreibungsspalte des Stereotyps xoevCodelisteneintrag). Die Klasse <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> entspricht der Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M144"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M144"/>
   <xsl:template match="@*|node()" priority="-2" mode="M144">
      <xsl:apply-templates select="*" mode="M144"/>
   </xsl:template>
   <!--PATTERN NDR-27-VerwendungDesUrspruenglichenNamensraumpraefixesBeiXMLSchemaImporten-ImportPraefixAusImportiertemSchemaUebernommenNDR-27: Verwendung des ursprünglichen Namensraumpräfixes bei XML Schema-Importen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-27: Verwendung des ursprünglichen Namensraumpräfixes bei XML Schema-Importen</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:xsdImport(.) and xoev:xsdImport(.)/@prefix]"
                 priority="1000"
                 mode="M145">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">ImportPraefixAusImportiertemSchemaUebernommen</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Es wird empfohlen, bei einem XML-Import (UML-Abhängigkeit mit dem Stereotyp xsdImport) das Namensraumpräfix des importierten Schemas zu nutzen und das Präfix in der Import-Beziehung (Eigenschaft prefix des Stereotyps xsdImport) nicht zu spezifizieren. <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> entspricht der Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M145"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M145"/>
   <xsl:template match="@*|node()" priority="-2" mode="M145">
      <xsl:apply-templates select="*" mode="M145"/>
   </xsl:template>
   <!--PATTERN NDR-6-NutzungVonXMLAttributenUndXMLElementen-ElementreferenzenUnbenanntNDR-6: Nutzung von XML-Attributen und XML-Elementen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-6: Nutzung von XML-Attributen und XML-Elementen</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[xoev:xsdElement(.) and xoev:is-ref(.) and @name[. != '']]"
                 priority="1000"
                 mode="M146">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">ElementreferenzenUnbenannt</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Es wird empfohlen, bei der Referenzierung eines globalen Elements der UML-Eigenschaft keinen Namen zu geben, da dieser irrelevant für die XML Schema-Definition ist. Die Eigenschaft <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> entspricht der Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M146"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M146"/>
   <xsl:template match="@*|node()" priority="-2" mode="M146">
      <xsl:apply-templates select="*" mode="M146"/>
   </xsl:template>
   <!--PATTERN NDR-6-NutzungVonXMLAttributenUndXMLElementen-KlasseineigenschaftenMitGlobalenElementenAlsTypSindReferenzenNDR-6: Nutzung von XML-Attributen und XML-Elementen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-6: Nutzung von XML-Attributen und XML-Elementen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[xoev:xsdElement(.) and uml:resolve-type(.)/(xoev:xsdGlobalElement(.), xoev:xsdMessage(.)) and                 not(xoev:is-ref(.))]"
                 priority="1000"
                 mode="M147">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">KlasseineigenschaftenMitGlobalenElementenAlsTypSindReferenzen</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Es wird empfohlen, bei der Nutzung eines globalen Elements in einer UML-Eigenschaft, auf dieses zu referenzieren. Die Eigenschaft <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> entspricht der Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M147"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M147"/>
   <xsl:template match="@*|node()" priority="-2" mode="M147">
      <xsl:apply-templates select="*" mode="M147"/>
   </xsl:template>
   <!--PATTERN NDR-6-NutzungVonXMLAttributenUndXMLElementen-KlasseineigenschaftenMitGruppenAlsTypSindReferenzenNDR-6: Nutzung von XML-Attributen und XML-Elementen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-6: Nutzung von XML-Attributen und XML-Elementen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedAttribute[xoev:xsdElement(.) and uml:resolve-type(.)/xoev:xsdGroup(.) and                 not(xoev:is-ref(.))]"
                 priority="1000"
                 mode="M148">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">KlasseineigenschaftenMitGruppenAlsTypSindReferenzen</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Es wird empfohlen, bei der Nutzung einer Gruppe (UML-Klasse mit dem Stereotyp xsdGroup) in einer UML-Eigenschaft, auf die Gruppe zu referenzieren. Die Eigenschaft <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> entspricht der Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M148"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M148"/>
   <xsl:template match="@*|node()" priority="-2" mode="M148">
      <xsl:apply-templates select="*" mode="M148"/>
   </xsl:template>
   <!--PATTERN pattern-CodelistenversionMitCodelisteVerbundenKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-Class(.) and xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M149">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="xoev:dependencies-by-client(.)/uml:resolve-supplier(.)/xoev:xoevCodeliste(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="xoev:dependencies-by-client(.)/uml:resolve-supplier(.)/xoev:xoevCodeliste(.)">
               <xsl:attribute name="id">rule-CodelistenversionMitCodelisteVerbunden</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Eine Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) muss mittels einer UML-Abhängigkeitsbeziehung mit einer Codeliste (UML-Klasse mit dem Stereotyp xoevCodeliste) verbunden sein. Die Codelistenversion <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M149"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M149"/>
   <xsl:template match="@*|node()" priority="-2" mode="M149">
      <xsl:apply-templates select="*" mode="M149"/>
   </xsl:template>
   <!--PATTERN pattern-CodelistenspaltenGehoerenZuCodelistenversionKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//ownedAttribute[xoev:xoevCodelistenspalte(.) and not(xoev:xsdDraft(parent::*))]"
                 priority="1000"
                 mode="M150">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="parent::*/xoev:xoevVersionCodeliste(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="parent::*/xoev:xoevVersionCodeliste(.)">
               <xsl:attribute name="id">rule-CodelistenspaltenGehoerenZuCodelistenversion</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Eine UML-Eigenschaft mit dem Stereotyp xoevCodelistenspalte gehört zu einer Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste). Die Codelistenspalte <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M150"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M150"/>
   <xsl:template match="@*|node()" priority="-2" mode="M150">
      <xsl:apply-templates select="*" mode="M150"/>
   </xsl:template>
   <!--PATTERN pattern-EigenschaftenVonCodelistenversionenSindCodelistenspaltenKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-Class(.) and xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M151">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     every $p in ownedAttribute                         satisfies $p/xoev:xoevCodelistenspalte(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="every $p in ownedAttribute satisfies $p/xoev:xoevCodelistenspalte(.)">
               <xsl:attribute name="id">rule-EigenschaftenVonCodelistenversionenSindCodelistenspalten</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die UML-Eigenschaften einer Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) sind mit dem Stereotyp xoevCodelistenspalte versehen. Die Codelistenversion <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M151"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M151"/>
   <xsl:template match="@*|node()" priority="-2" mode="M151">
      <xsl:apply-templates select="*" mode="M151"/>
   </xsl:template>
   <!--PATTERN pattern-EmpfohleneCodeSpalteIstEineAllgemeineCodeSpalteKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//ownedAttribute[xoev:xoevCodelistenspalte(.) and not(xoev:xsdDraft(parent::*))]"
                 priority="1000"
                 mode="M152">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(xoev:xoevCodelistenspalte(.)/@empfohleneCodeSpalte = 'true') or xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true'"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(xoev:xoevCodelistenspalte(.)/@empfohleneCodeSpalte = 'true') or xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true'">
               <xsl:attribute name="id">rule-EmpfohleneCodeSpalteIstEineAllgemeineCodeSpalte</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Eine empfohlene Code-Spalte (UML-Eigenschaft mit dem Stereotyp xoevCodelistenspalte und der Stereotypeigenschaft empfohleneCodeSpalte = 'true') ist immer auch eine allgemeine Code-Spalte (Stereotypeigenschaft codeSpalte = 'true'). Die Codelistenspalte <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M152"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M152"/>
   <xsl:template match="@*|node()" priority="-2" mode="M152">
      <xsl:apply-templates select="*" mode="M152"/>
   </xsl:template>
   <!--PATTERN pattern-GenutzteCodelistenversionNichtDraftKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Class(.) and xoev:usages-by-client(.)/uml:resolve-supplier(.)/xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Class(.) and xoev:usages-by-client(.)/uml:resolve-supplier(.)/xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M153">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     not(xoev:usages-by-client(.)/uml:resolve-supplier(.)/xoev:xsdDraft(.)) and                     not(xoev:usages-by-client(.)/uml:resolve-supplier(.)/xoev:dependencies-by-client(.)/uml:resolve-supplier(.)/xoev:xsdDraft(.))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(xoev:usages-by-client(.)/uml:resolve-supplier(.)/xoev:xsdDraft(.)) and not(xoev:usages-by-client(.)/uml:resolve-supplier(.)/xoev:dependencies-by-client(.)/uml:resolve-supplier(.)/xoev:xsdDraft(.))">
               <xsl:attribute name="id">rule-GenutzteCodelistenversionNichtDraft</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Ein produktiv eingesetzter Code-Datentyp darf keine durch den Stereotyp xsdDraft als Entwurf gekennzeichnete Codeliste oder Codelistenversion nutzen (Code-Typ 1 und 2). Der Code-Datentyp <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M153"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M153"/>
   <xsl:template match="@*|node()" priority="-2" mode="M153">
      <xsl:apply-templates select="*" mode="M153"/>
   </xsl:template>
   <!--PATTERN pattern-GenutzteCodelistenNichtDraftKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Class(.) and xoev:usages-by-client(.)/uml:resolve-supplier(.)/xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Class(.) and xoev:usages-by-client(.)/uml:resolve-supplier(.)/xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M154">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(xoev:usages-by-client(.)/uml:resolve-supplier(.)/xoev:xsdDraft(.))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(xoev:usages-by-client(.)/uml:resolve-supplier(.)/xoev:xsdDraft(.))">
               <xsl:attribute name="id">rule-GenutzteCodelistenNichtDraft</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Ein produktiv eingesetzter Code-Datentyp darf keine durch den Stereotyp xsdDraft als Entwurf gekennzeichnete Codeliste nutzen (Code-Typ 3). Der Code-Datentyp <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M154"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M154"/>
   <xsl:template match="@*|node()" priority="-2" mode="M154">
      <xsl:apply-templates select="*" mode="M154"/>
   </xsl:template>
   <!--PATTERN pattern-UsageBeziehungMitCodeTyp1und2EndetBeiCodelistenversionKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Usage(.) and (xoev:xoevCodeTyp1(.) or xoev:xoevCodeTyp2(.))] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Usage(.) and (xoev:xoevCodeTyp1(.) or xoev:xoevCodeTyp2(.))]"
                 priority="1000"
                 mode="M155">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="uml:resolve-supplier(.)/xoev:xoevVersionCodeliste(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="uml:resolve-supplier(.)/xoev:xoevVersionCodeliste(.)">
               <xsl:attribute name="id">rule-UsageBeziehungMitCodeTyp1und2EndetBeiCodelistenversion</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Usage-Beziehungen mit dem Stereotyp xoevCodeTyp1 oder xoevCodeTyp2 müssen bei einer Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) enden. <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M155"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M155"/>
   <xsl:template match="@*|node()" priority="-2" mode="M155">
      <xsl:apply-templates select="*" mode="M155"/>
   </xsl:template>
   <!--PATTERN pattern-UsageBeziehungOhneCodeTyp1und2EndetBeiCodelisteKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Usage(.) and (not(xoev:xoevCodeTyp1(.) or xoev:xoevCodeTyp2(.)))] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Usage(.) and (not(xoev:xoevCodeTyp1(.) or xoev:xoevCodeTyp2(.)))]"
                 priority="1000"
                 mode="M156">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="uml:resolve-supplier(.)/xoev:xoevCodeliste(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="uml:resolve-supplier(.)/xoev:xoevCodeliste(.)">
               <xsl:attribute name="id">rule-UsageBeziehungOhneCodeTyp1und2EndetBeiCodeliste</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Usage-Beziehungen ohne Stereotyp bzw. mit dem Stereotyp xoevCodeTyp3 müssen bei einer Codeliste (UML-Klasse mit dem Stereotyp xoevCodeliste) enden. <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M156"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M156"/>
   <xsl:template match="@*|node()" priority="-2" mode="M156">
      <xsl:apply-templates select="*" mode="M156"/>
   </xsl:template>
   <!--PATTERN pattern-CodeDatentypHatKeineEigenschaftenKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Class(.) and (xoev:xoevCodeTyp4(.) or xoev:usages-by-client(.))] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Class(.) and (xoev:xoevCodeTyp4(.) or xoev:usages-by-client(.))]"
                 priority="1000"
                 mode="M157">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="empty(xoev:allElements(.)) and empty(xoev:allAttributes(.))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="empty(xoev:allElements(.)) and empty(xoev:allAttributes(.))">
               <xsl:attribute name="id">rule-CodeDatentypHatKeineEigenschaften</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Im XÖV-Fachmodell modellierte Code-Datentypen (UML-Klassen mit dem Stereotyp xoevCodeTyp4 oder einer ausgehenden Usage-Beziehung) haben keine Eigenschaften (XML-Attribute oder -Elemente). Die UML-Klasse <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M157"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M157"/>
   <xsl:template match="@*|node()" priority="-2" mode="M157">
      <xsl:apply-templates select="*" mode="M157"/>
   </xsl:template>
   <!--PATTERN pattern-CodeTyp1undCodeTyp2SchliessenSichAusKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Usage(.) and xoev:xoevCodeTyp1(.) and xoev:xoevCodeTyp2(.)] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Usage(.) and xoev:xoevCodeTyp1(.) and xoev:xoevCodeTyp2(.)]"
                 priority="1000"
                 mode="M158">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">rule-CodeTyp1undCodeTyp2SchliessenSichAus</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Stereotypen xoevCodeTyp1 und xoevCodeTyp2 schließen sich gegenseitig aus. <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M158"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M158"/>
   <xsl:template match="@*|node()" priority="-2" mode="M158">
      <xsl:apply-templates select="*" mode="M158"/>
   </xsl:template>
   <!--PATTERN pattern-UsageBeziehungZuCodelistenversionHatStereotypXoevCodeTyp1oder2Korrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Usage(.) and uml:resolve-supplier(.)/xoev:xoevVersionCodeliste(.)] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Usage(.) and uml:resolve-supplier(.)/xoev:xoevVersionCodeliste(.)]"
                 priority="1000"
                 mode="M159">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="xoev:xoevCodeTyp1(.) or xoev:xoevCodeTyp2(.)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="xoev:xoevCodeTyp1(.) or xoev:xoevCodeTyp2(.)">
               <xsl:attribute name="id">rule-UsageBeziehungZuCodelistenversionHatStereotypXoevCodeTyp1oder2</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Usage-Beziehungen zu Codelistenversionen (UML-Klassen mit dem Stereotyp xoevVersionCodeliste) müssen den Stereotyp xoevCodeTyp1 oder xoevCodeTyp2 haben. <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M159"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M159"/>
   <xsl:template match="@*|node()" priority="-2" mode="M159">
      <xsl:apply-templates select="*" mode="M159"/>
   </xsl:template>
   <!--PATTERN pattern-KeineMehrfachbeziehungenZwischenCodeDatentypUndCodelistenOderCodelistenversionenKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="                 uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Class(.) and not(xoev:xoevCodeTyp4(.)) and count(xoev:usages-by-client(.)/uml:resolve-supplier(.)[xoev:xoevCodeliste(.) or xoev:xoevVersionCodeliste(.)]) gt 1] |                 uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Class(.) and not(xoev:xoevCodeTyp4(.)) and count(xoev:usages-by-client(.)/uml:resolve-supplier(.)[xoev:xoevCodeliste(.) or xoev:xoevVersionCodeliste(.)]) gt 1]"
                 priority="1000"
                 mode="M160">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">rule-KeineMehrfachbeziehungenZwischenCodeDatentypUndCodelistenOderCodelistenversionen</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Von einem Code-Datentyp darf maximal eine Usage-Beziehung zur selben oder zu unterschiedlichen Codelisten bzw. Codelistenversionen ausgehen. <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M160"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M160"/>
   <xsl:template match="@*|node()" priority="-2" mode="M160">
      <xsl:apply-templates select="*" mode="M160"/>
   </xsl:template>
   <!--PATTERN pattern-GenutzteCodeSpalteEntsprichtCodeSpalteDerGenutztenCodelistenversionKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Usage(.) and (xoev:xoevCodeTyp1(.)/@genutzteCodeSpalte or xoev:xoevCodeTyp2(.)/@genutzteCodeSpalte) and uml:resolve-supplier(.)/xoev:xoevVersionCodeliste(.)] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Usage(.) and (xoev:xoevCodeTyp1(.)/@genutzteCodeSpalte or xoev:xoevCodeTyp2(.)/@genutzteCodeSpalte) and uml:resolve-supplier(.)/xoev:xoevVersionCodeliste(.)]"
                 priority="1000"
                 mode="M161">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     (xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.))/@genutzteCodeSpalte = uml:resolve-supplier(.)/ownedAttribute[xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true']/@xmi:id"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="(xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.))/@genutzteCodeSpalte = uml:resolve-supplier(.)/ownedAttribute[xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true']/@xmi:id">
               <xsl:attribute name="id">rule-GenutzteCodeSpalteEntsprichtCodeSpalteDerGenutztenCodelistenversion</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die über die Eigenschaft genutzteCodeSpalte der Stereotypen xoevCodeTyp1 oder xoevCodeTyp2 bestimmte Spalte muss eine Code-Spalte (UML-Eigenschaft mit Eigenschaft xoevCodelistenspalte/codeSpalte = true) der genutzten Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) sein. <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M161"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M161"/>
   <xsl:template match="@*|node()" priority="-2" mode="M161">
      <xsl:apply-templates select="*" mode="M161"/>
   </xsl:template>
   <!--PATTERN pattern-GenutzteBeschreibungsspalteEntsprichtSpalteDerGenutztenCodelistenversionKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Usage(.) and (xoev:xoevCodeTyp1(.)/@genutzteBeschreibungsspalte or xoev:xoevCodeTyp2(.)/@genutzteBeschreibungsspalte) and uml:resolve-supplier(.)/xoev:xoevVersionCodeliste(.)] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Usage(.) and (xoev:xoevCodeTyp1(.)/@genutzteBeschreibungsspalte or xoev:xoevCodeTyp2(.)/@genutzteBeschreibungsspalte) and uml:resolve-supplier(.)/xoev:xoevVersionCodeliste(.)]"
                 priority="1000"
                 mode="M162">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     (xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.))/@genutzteBeschreibungsspalte = uml:resolve-supplier(.)/ownedAttribute/@xmi:id"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="(xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.))/@genutzteBeschreibungsspalte = uml:resolve-supplier(.)/ownedAttribute/@xmi:id">
               <xsl:attribute name="id">rule-GenutzteBeschreibungsspalteEntsprichtSpalteDerGenutztenCodelistenversion</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die über die Eigenschaft genutzteBeschreibungsspalte der Stereotypen xoevCodeTyp1 oder xoevCodeTyp2 bestimmte Spalte muss eine Spalte (UML-Eigenschaft mit Eigenschaft xoevCodelistenspalte/codeSpalte = true) der genutzten Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) sein. <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M162"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M162"/>
   <xsl:template match="@*|node()" priority="-2" mode="M162">
      <xsl:apply-templates select="*" mode="M162"/>
   </xsl:template>
   <!--PATTERN pattern-BlacklistUndWhitelistSchliessenSichAusKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Usage(.) and (xoev:xoevCodeTyp1(.) or xoev:xoevCodeTyp2(.))] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Usage(.) and (xoev:xoevCodeTyp1(.) or xoev:xoevCodeTyp2(.))]"
                 priority="1000"
                 mode="M163">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="empty((xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.))/@whiteList) or empty((xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.))/@blackList)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="empty((xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.))/@whiteList) or empty((xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.))/@blackList)">
               <xsl:attribute name="id">rule-BlacklistUndWhitelistSchliessenSichAus</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Eigenschaften whiteList und blackList der Stereotypen xoevCodeTyp1 und xoevCodeTyp2 schließen sich gegenseitig aus. <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M163"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M163"/>
   <xsl:template match="@*|node()" priority="-2" mode="M163">
      <xsl:apply-templates select="*" mode="M163"/>
   </xsl:template>
   <!--PATTERN pattern-EintraegeBlacklistOderWhiteListEntsprechenEintraegenDerGenutztenCodelistenversionKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Usage(.) and (xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.))/(@whiteList, @blackList)] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Usage(.) and (xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.))/(@whiteList, @blackList)]"
                 priority="1000"
                 mode="M164">
      <xsl:variable name="usage" select="."/>
      <xsl:variable name="eintraege-black-white"
                    select="tokenize((xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.))/(@whiteList, @blackList), ' ')"/>
      <xsl:variable name="eintraege-codeliste"
                    select="ancestor::packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-InstanceSpecification(.) and @classifier = $usage/uml:resolve-supplier(.)/@xmi:id]"/>
      <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     every $eintrag in $eintraege-black-white                         satisfies $eintrag = $eintraege-codeliste/@xmi:id"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="every $eintrag in $eintraege-black-white satisfies $eintrag = $eintraege-codeliste/@xmi:id">
               <xsl:attribute name="id">rule-EintraegeBlacklistOderWhiteListEntsprechenEintraegenDerGenutztenCodelistenversion</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die in den Eigenschaften whiteList und blackList der Stereotypen xoevCodeTyp1 oder xoevCodeTyp2 aufgeführten Codelisteneinträge müssen Codelisteneinträge der vom Code-Datentyp genutzten Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) sein. <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M164"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M164"/>
   <xsl:template match="@*|node()" priority="-2" mode="M164">
      <xsl:apply-templates select="*" mode="M164"/>
   </xsl:template>
   <!--PATTERN pattern-TypDesCodeElementsIstTokenOderDavonAbgeleitetKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[(xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.), xoev:xoevCodeTyp3(.), xoev:xoevCodeTyp4(.))/xoev:resolve-typDesCodeElements(.)] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[(xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.), xoev:xoevCodeTyp3(.), xoev:xoevCodeTyp4(.))/xoev:resolve-typDesCodeElements(.)]"
                 priority="1000"
                 mode="M165">
      <xsl:variable name="typ"
                    select="xoev:resolve-typDesCodeElements((xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.), xoev:xoevCodeTyp3(.), xoev:xoevCodeTyp4(.)))"/>
      <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     root()/descendant::packagedElement[xoev:xoevDatentyp(.)/@kennung = 'urn:xoev-de:kosit:xoev:datentyp:code']/ownedAttribute[@name = 'code']/uml:resolve-type(.)/@xmi:id = ($typ, xoev:allParents($typ))/@xmi:id"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="root()/descendant::packagedElement[xoev:xoevDatentyp(.)/@kennung = 'urn:xoev-de:kosit:xoev:datentyp:code']/ownedAttribute[@name = 'code']/uml:resolve-type(.)/@xmi:id = ($typ, xoev:allParents($typ))/@xmi:id">
               <xsl:attribute name="id">rule-TypDesCodeElementsIstTokenOderDavonAbgeleitet</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Der über die Eigenschaft typDesCodeElements der Stereotypen xoevCodeTyp1 bis xoevCodeTyp4 bestimmte Datentyp muss xs:token oder ein davon abgeleiteter Datentyp sein. <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M165"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M165"/>
   <xsl:template match="@*|node()" priority="-2" mode="M165">
      <xsl:apply-templates select="*" mode="M165"/>
   </xsl:template>
   <!--PATTERN pattern-DeprecatedCodesNichtWiederverwendenKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-InstanceSpecification(.) and xoev:xoevCodelisteneintragDeprecated(.)] | uml:Model/packagedElement[uml:is-InstanceSpecification(.) and xoev:xoevCodelisteneintragDeprecated(.)]"
                 priority="1000"
                 mode="M166">
      <xsl:variable name="eintrag" select="."/>
      <xsl:variable name="eintraege"
                    select="ancestor::packagedElement[xoev:xsdXModel(.)]//packagedElement[@xmi:id != $eintrag/@xmi:id and uml:is-InstanceSpecification(.) and @classifier = $eintrag/@classifier and not(xoev:xoevCodelisteneintragDeprecated(.))]"/>
      <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     every $own-slot in $eintrag/slot[uml:resolve-definingFeature(.)/xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true']                         satisfies (                         every $other-slot in $eintraege/slot[uml:resolve-definingFeature(.)/@xmi:id = $own-slot/uml:resolve-definingFeature(.)/@xmi:id]                             satisfies                             not($own-slot/value/@value/normalize-space(.) = $other-slot/value/@value/normalize-space(.)))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="every $own-slot in $eintrag/slot[uml:resolve-definingFeature(.)/xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true'] satisfies ( every $other-slot in $eintraege/slot[uml:resolve-definingFeature(.)/@xmi:id = $own-slot/uml:resolve-definingFeature(.)/@xmi:id] satisfies not($own-slot/value/@value/normalize-space(.) = $other-slot/value/@value/normalize-space(.)))">
               <xsl:attribute name="id">rule-DeprecatedCodesNichtWiederverwenden</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Codes in Codelisteneinträgen, die als veraltet gekennzeichnet sind (UML-Objekte mit dem Stereotyp xoevCodelisteneintragDeprecated), dürfen nicht in anderen Codelisteneinträgen derselben Codelistenversion wiederverwendet werden. Der Codelisteneintrag mit den Codes <xsl:text/>
                  <xsl:value-of select="$eintrag/slot[uml:resolve-definingFeature(.)/xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true']/value/@value/normalize-space(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M166"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M166"/>
   <xsl:template match="@*|node()" priority="-2" mode="M166">
      <xsl:apply-templates select="*" mode="M166"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.0-R1Korrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-Class(.) and xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M167">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="ownedAttribute[xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true']"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="ownedAttribute[xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true']">
               <xsl:attribute name="id">rule.C-CLH-1.0-R1</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Eine Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) muss mindestens eine Code-Spalte (UML-Eigenschaft mit dem Stereotyp xoevCodelistenspalte und der Stereotypeigenschaft codeSpalte = 'true') besitzen. Die Codelistenversion <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M167"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M167"/>
   <xsl:template match="@*|node()" priority="-2" mode="M167">
      <xsl:apply-templates select="*" mode="M167"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.0-R3Korrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//ownedAttribute[xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true']"
                 priority="1000"
                 mode="M168">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="xoev:xoevCodelistenspalte(.)/@verwendung = 'required'"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="xoev:xoevCodelistenspalte(.)/@verwendung = 'required'">
               <xsl:attribute name="id">rule.C-CLH-1.0-R3</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Das Metadatenelement Verwendung (Eigenschaft verwendung des Stereotyps xoevCodelistenspalte) muss bei Code-Spalten (UML-Eigenschaft mit dem Stereotyp xoevVersionCodeliste und der Stereotypeigenschaft codeSpalte = true) auf "required" gesetzt werden. Die Codelistenspalte <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M168"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M168"/>
   <xsl:template match="@*|node()" priority="-2" mode="M168">
      <xsl:apply-templates select="*" mode="M168"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.0-R4Korrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//ownedAttribute[xoev:xoevCodelistenspalte(.)/@verwendung = 'required']"
                 priority="1000"
                 mode="M169">
      <xsl:variable name="spalte" select="."/>
      <xsl:variable name="instanzen"
                    select="ancestor::packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-InstanceSpecification(.) and @classifier = $spalte/parent::*/@xmi:id and not(xoev:xoevCodelisteneintragDeprecated(.))]"/>
      <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     every $instanz in $instanzen                         satisfies $instanz/slot[uml:resolve-definingFeature(.)/@xmi:id = $spalte/@xmi:id]/value/@value"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="every $instanz in $instanzen satisfies $instanz/slot[uml:resolve-definingFeature(.)/@xmi:id = $spalte/@xmi:id]/value/@value">
               <xsl:attribute name="id">rule.C-CLH-1.0-R4</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Eine Spalte mit der Verwendung "required" (UML-Eigenschaft mit dem Stereotyp xoevVersionCodeliste und der Stereotypeigenschaft verwendung = 'required') muss in jedem Codelisteneintrag (UML-Objekt der UML-Klasse der Codelistenversion) mit einem Wert belegt sein. Die Codelistenspalte <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M169"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M169"/>
   <xsl:template match="@*|node()" priority="-2" mode="M169">
      <xsl:apply-templates select="*" mode="M169"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.0-R5Korrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M170">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="replace(xoev:xoevCodeliste(.)/@nameTechnisch, '[a-zA-Z0-9\.\-]', '') = ''"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="replace(xoev:xoevCodeliste(.)/@nameTechnisch, '[a-zA-Z0-9\.\-]', '') = ''">
               <xsl:attribute name="id">rule.C-CLH-1.0-R5</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Der Name (technisch) einer Codeliste (UML-Klasse mit dem Stereotyp xoevCodeliste und der Stereotypeigenschaft nameTechnisch) darf nur die Zeichen "A-Z", "a-z", "0-9", "-" und "." enthalten. Die Codeliste <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M170"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M170"/>
   <xsl:template match="@*|node()" priority="-2" mode="M170">
      <xsl:apply-templates select="*" mode="M170"/>
   </xsl:template>
   <!--PATTERN pattern-C-XOEV-R6Korrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M171">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     if (uml:is-Class(.)) then                         xoev:xoevVersionCodeliste(.)/@versionCodelistenHandbuch = ('1.0', '1.1', '1.2')                     else                         xoev:xoevVersionCodeliste(.)/@versionXOEVHandbuch = '2.1'"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="if (uml:is-Class(.)) then xoev:xoevVersionCodeliste(.)/@versionCodelistenHandbuch = ('1.0', '1.1', '1.2') else xoev:xoevVersionCodeliste(.)/@versionXOEVHandbuch = '2.1'">
               <xsl:attribute name="id">rule-C-XOEV-R6</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Version des Handbuchs, zu dessen Regelungen die technische Umsetzung der Version einer Codeliste konform ist, muss angegeben sein (Eigenschaft versionXOEVHandbuch bzw. versionCodelistenHandbuch des Stereotyps xoevVersionCodeliste) und einer existierenden Version entsprechen (XÖV-Handbuch 2.1 oder Codelisten-Handbuch 1.0, 1.1 bzw. 1.2). Die Codelistenversion <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M171"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M171"/>
   <xsl:template match="@*|node()" priority="-2" mode="M171">
      <xsl:apply-templates select="*" mode="M171"/>
   </xsl:template>
   <!--PATTERN pattern.C-XOEV-R8Korrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//ownedAttribute[xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true']"
                 priority="1000"
                 mode="M172">
      <xsl:variable name="spalte" select="."/>
      <xsl:variable name="instanzen"
                    select="ancestor::packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-InstanceSpecification(.) and @classifier = $spalte/parent::*/@xmi:id and not(xoev:xoevCodelisteneintragDeprecated(.))]"/>
      <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     count($instanzen/slot[uml:resolve-definingFeature(.)/@xmi:id = $spalte/@xmi:id]/value/@value) = count(distinct-values($instanzen/slot[uml:resolve-definingFeature(.)/@xmi:id = $spalte/@xmi:id]/value/@value))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count($instanzen/slot[uml:resolve-definingFeature(.)/@xmi:id = $spalte/@xmi:id]/value/@value) = count(distinct-values($instanzen/slot[uml:resolve-definingFeature(.)/@xmi:id = $spalte/@xmi:id]/value/@value))">
               <xsl:attribute name="id">rule.C-XOEV-R8</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Über die Werte in einer Code-Spalte (UML-Eigenschaft mit dem Stereotyp xoevCodelistenspalte und der Stereotypeigenschaft codeSpalte = true) müssen die einzelnen Einträge der Codeliste (UML-Objekte der UML-Klasse der Codelistenversion) eindeutig identifiziert werden können. Somit muss in einer Code-Spalte zu jedem Codelisteneintrag ein eindeutiger Wert vorliegen. Die Codelistenspalte <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M172"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M172"/>
   <xsl:template match="@*|node()" priority="-2" mode="M172">
      <xsl:apply-templates select="*" mode="M172"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.0-R9Korrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M173">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(xoev:xoevCodeliste(.)/nameLang[. != '']) = (1, count(distinct-values(xoev:xoevCodeliste(.)/nameLang/xoev:get-language(.))))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(xoev:xoevCodeliste(.)/nameLang[. != '']) = (1, count(distinct-values(xoev:xoevCodeliste(.)/nameLang/xoev:get-language(.))))">
               <xsl:attribute name="id">rule.C-CLH-1.0-R9</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Eine Codeliste muss genau einen Namen (lang) pro Sprache besitzen (Eigenschaft nameLang des Stereotyps xoevCodeliste). Die Codeliste <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M173"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M173"/>
   <xsl:template match="@*|node()" priority="-2" mode="M173">
      <xsl:apply-templates select="*" mode="M173"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.0-R11Korrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M174">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(xoev:xoevCodeliste(.)/nameKurz[. != '']) = (1, count(distinct-values(xoev:xoevCodeliste(.)/nameKurz/xoev:get-language(.))))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(xoev:xoevCodeliste(.)/nameKurz[. != '']) = (1, count(distinct-values(xoev:xoevCodeliste(.)/nameKurz/xoev:get-language(.))))">
               <xsl:attribute name="id">rule.C-CLH-1.0-R11</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Eine Codeliste muss genau einen Namen (kurz) pro Sprache besitzen (Eigenschaft nameKurz des Stereotyps xoevCodeliste). Die Codeliste <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M174"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M174"/>
   <xsl:template match="@*|node()" priority="-2" mode="M174">
      <xsl:apply-templates select="*" mode="M174"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.0-R12Korrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M175">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="xoev:xoevCodeliste(.)/@nameTechnisch[. != '']"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="xoev:xoevCodeliste(.)/@nameTechnisch[. != '']">
               <xsl:attribute name="id">rule.C-CLH-1.0-R12</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Eine Codeliste muss einen Namen (technisch) besitzen (Eigenschaft nameTechnisch des Stereotyps xoevCodeliste). Die Codeliste <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M175"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M175"/>
   <xsl:template match="@*|node()" priority="-2" mode="M175">
      <xsl:apply-templates select="*" mode="M175"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.0-R13Korrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M176">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="xoev:xoevCodeliste(.)/@kennung[. != '']"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="xoev:xoevCodeliste(.)/@kennung[. != '']">
               <xsl:attribute name="id">rule.C-CLH-1.0-R13</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Eine Codeliste muss eine Kennung besitzen (Eigenschaft kennung des Stereotyps xoevCodeliste). Die Codeliste <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M176"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M176"/>
   <xsl:template match="@*|node()" priority="-2" mode="M176">
      <xsl:apply-templates select="*" mode="M176"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.0-R14Korrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="                 uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.)) and not(xoev:xoevCodeliste(.)/@kennung = $bestandskennungen)]"
                 priority="1000"
                 mode="M177">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="replace(xoev:xoevCodeliste(.)/@kennung, '[a-z0-9\.\-:]', '') = ''"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="replace(xoev:xoevCodeliste(.)/@kennung, '[a-z0-9\.\-:]', '') = ''">
               <xsl:attribute name="id">rule.C-CLH-1.0-R14</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Kennung einer Codeliste darf ausschließlich die Zeichen "a-z", "0-9", ":", "-" und "." enthalten (Eigenschaft kennung des Stereotyps xoevCodeliste). Die Codeliste <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M177"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M177"/>
   <xsl:template match="@*|node()" priority="-2" mode="M177">
      <xsl:apply-templates select="*" mode="M177"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.0-R15Korrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.)) and not(xoev:xoevCodeliste(.)/@kennung = $bestandskennungen)]"
                 priority="1000"
                 mode="M178">
      <assert id="rule.C-CLH-1.0-R15"
              role="error"
              test="                 matches(., &#34;^urn:(urn-[1-9][0-9]*|[a-zA-z0-9][a-zA-Z0-9-]{1,30}[a-z0-9]):[a-zA-Z0-9:&amp;@\-\._~!\$'\(\)\*\+,;=][a-zA-Z0-9:&amp;@%\-\._~!\$'\(\)\*\+,;=/]*$&#34;)">Die Kennung einer Codeliste (/CodeList/Identification/CanonicalUri) muss in der Form eines URN notiert werden. [siehe Codelistenhandbuch 1.0, Abschnitt 1.3 "Identifikation von Codelisten"]</assert>
      <assert id="rule.C-CLH-1.0-R15-1"
              role="error"
              test="not(matches(., '^urn:urn-.*$')) or matches(., '^urn:urn-[1-9][0-9]*:.*$')">Die Kennung einer Codeliste (/CodeList/Identification/CanonicalUri) muss in der Form eines URN notiert werden: Ein informaler URN-Namespace darf nach "urn-" nur Zahlen enthalten.</assert>
      <assert id="rule.C-CLH-1.0-R15-2"
              role="error"
              test="not(matches(., '^urn:x-.*$'))">Die Kennung einer Codeliste (/CodeList/Identification/CanonicalUri) muss in der Form eines URN notiert werden: Der URN-Namespace darf nicht mit der Zeichenkette "X-" beginnen. </assert>
      <assert id="rule.C-CLH-1.0-R15-3"
              role="error"
              test="not(matches(., '^urn:..-.*$'))">Die Kennung einer Codeliste (/CodeList/Identification/CanonicalUri) muss in der Form eines URN notiert werden: Der URN-Namespace darf nicht mit zwei Zeichen, gefolgt von einem Bindestrich beginnen.</assert>
      <assert id="rule.C-CLH-1.0-R15-4"
              role="error"
              test="not(matches(., '^.*%.*$')) or matches(., '^urn:.*:.*%[0-9ABCDEF][0-9ABCDEF].*$')">Die Kennung einer Codeliste (/CodeList/Identification/CanonicalUri) muss in der Form eines URN notiert werden: Das Zeichen "%" darf nur zur Angabe von Hexadezimalzahlen verwendet werden.</assert>
      <xsl:apply-templates select="*" mode="M178"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M178"/>
   <xsl:template match="@*|node()" priority="-2" mode="M178">
      <xsl:apply-templates select="*" mode="M178"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.0-R16Korrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.)) and not(xoev:xoevCodeliste(.)/@kennung = $bestandskennungen)]"
                 priority="1000"
                 mode="M179">

		<!--ASSERT warning-->
      <xsl:choose>
         <xsl:when test="starts-with(xoev:xoevCodeliste(.)/@kennung, 'urn:xoev-de:')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="starts-with(xoev:xoevCodeliste(.)/@kennung, 'urn:xoev-de:')">
               <xsl:attribute name="id">rule.C-CLH-1.0-R16</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Es wird empfohlen, als globalen Teil der Kennung einer Codeliste (Eigenschaft kennung des Stereotyps xoevCodeliste) die Zeichenfolge "urn:xoev-de:" und die zugehörige Syntax zu verwenden. Die Codeliste <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> entspricht dieser Empfehlung nicht. Hinweis: Diese Meldung erscheint ausschließlich bei Codelisten, die noch nicht im XRepository vorliegen.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M179"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M179"/>
   <xsl:template match="@*|node()" priority="-2" mode="M179">
      <xsl:apply-templates select="*" mode="M179"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.0-R17Korrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.)) and starts-with(xoev:xoevCodeliste(.)/@kennung, 'urn:xoev-de:') and not(xoev:xoevCodeliste(.)/@kennung = $bestandskennungen)]"
                 priority="1000"
                 mode="M180">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="contains(xoev:xoevCodeliste(.)/@kennung, ':codeliste:')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="contains(xoev:xoevCodeliste(.)/@kennung, ':codeliste:')">
               <xsl:attribute name="id">rule.C-CLH-1.0-R17</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Kennung einer Codeliste (Eigenschaft kennung des Stereotyps xoevCodeliste) mit dem globalen Teil "urn:xoev-de:" muss die Art des Inhalts mittels der Zeichenfolge ":codeliste:" beschreiben. Die Codeliste <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M180"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M180"/>
   <xsl:template match="@*|node()" priority="-2" mode="M180">
      <xsl:apply-templates select="*" mode="M180"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.0-R18Korrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.)) and starts-with(xoev:xoevCodeliste(.)/@kennung, 'urn:xoev-de:') and not(xoev:xoevCodeliste(.)/@kennung = $bestandskennungen)]"
                 priority="1000"
                 mode="M181">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="ends-with(xoev:xoevCodeliste(.)/@kennung, lower-case(xoev:xoevCodeliste(.)/@nameTechnisch))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="ends-with(xoev:xoevCodeliste(.)/@kennung, lower-case(xoev:xoevCodeliste(.)/@nameTechnisch))">
               <xsl:attribute name="id">rule.C-CLH-1.0-R18</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Kennung einer Codeliste (Eigenschaft kennung des Stereotyps xoevCodeliste) mit dem globalen Teil "urn:xoev-de:" muss mit dem Namen (technisch) der Codeliste in Kleinschreibung enden. Die Codeliste <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M181"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M181"/>
   <xsl:template match="@*|node()" priority="-2" mode="M181">
      <xsl:apply-templates select="*" mode="M181"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.0-R19Korrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M182">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(xoev:xoevCodeliste(.)/beschreibung[. != '']) = (1, count(distinct-values(xoev:xoevCodeliste(.)/beschreibung/xoev:get-language(.))))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(xoev:xoevCodeliste(.)/beschreibung[. != '']) = (1, count(distinct-values(xoev:xoevCodeliste(.)/beschreibung/xoev:get-language(.))))">
               <xsl:attribute name="id">rule.C-CLH-1.0-R19</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Eine Codeliste muss genau eine Beschreibung pro Sprache besitzen (Eigenschaft beschreibung des Stereotyps xoevCodeliste). Die Codeliste <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M182"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M182"/>
   <xsl:template match="@*|node()" priority="-2" mode="M182">
      <xsl:apply-templates select="*" mode="M182"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.0-R20Korrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M183">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(xoev:xoevCodeliste(.)/herausgebernameLang[. != '']) = (1, count(distinct-values(xoev:xoevCodeliste(.)/herausgebernameLang/xoev:get-language(.))))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(xoev:xoevCodeliste(.)/herausgebernameLang[. != '']) = (1, count(distinct-values(xoev:xoevCodeliste(.)/herausgebernameLang/xoev:get-language(.))))">
               <xsl:attribute name="id">rule.C-CLH-1.0-R20</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Eine Codeliste muss genau einen Namen (lang) ihres Herausgebers pro Sprache enthalten (Eigenschaft herausgebernameLang des Stereotyps xoevCodeliste). Die Codeliste <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M183"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M183"/>
   <xsl:template match="@*|node()" priority="-2" mode="M183">
      <xsl:apply-templates select="*" mode="M183"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.0-R21Korrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M184">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(xoev:xoevCodeliste(.)/herausgebernameKurz[. != '']) = (1, count(distinct-values(xoev:xoevCodeliste(.)/herausgebernameKurz/xoev:get-language(.))))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(xoev:xoevCodeliste(.)/herausgebernameKurz[. != '']) = (1, count(distinct-values(xoev:xoevCodeliste(.)/herausgebernameKurz/xoev:get-language(.))))">
               <xsl:attribute name="id">rule.C-CLH-1.0-R21</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Eine Codeliste muss genau einen Namen (kurz) ihres Herausgebers pro Sprache enthalten (Eigenschaft herausgebernameKurz des Stereotyps xoevCodeliste). Die Codeliste <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M184"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M184"/>
   <xsl:template match="@*|node()" priority="-2" mode="M184">
      <xsl:apply-templates select="*" mode="M184"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.0-R23Korrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M185">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="replace(xoev:xoevVersionCodeliste(.)/@version, '[a-zA-Z0-9\.\-]', '') = ''"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="replace(xoev:xoevVersionCodeliste(.)/@version, '[a-zA-Z0-9\.\-]', '') = ''">
               <xsl:attribute name="id">rule.C-CLH-1.0-R23</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Versionsangabe in einer Codelistenversion darf ausschließlich die Zeichen 'a-z', 'A-Z', '0-9', '-' und '.' enthalten (Eigenschaft version des Stereotyps xoevVersionCodeliste). Die Codelistenversion <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M185"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M185"/>
   <xsl:template match="@*|node()" priority="-2" mode="M185">
      <xsl:apply-templates select="*" mode="M185"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.0-R24Korrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevVersionCodeliste(.) and uml:is-Class(.) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M186">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(ownedAttribute[xoev:xoevCodelistenspalte(.)]) &gt;= 2"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(ownedAttribute[xoev:xoevCodelistenspalte(.)]) &gt;= 2">
               <xsl:attribute name="id">rule.C-CLH-1.0-R24</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Eine Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) muss mindestens zwei Spalten enthalten (UML-Eigenschaften mit dem Stereotyp xoevCodelistenspalte). Die Codelistenversion <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M186"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M186"/>
   <xsl:template match="@*|node()" priority="-2" mode="M186">
      <xsl:apply-templates select="*" mode="M186"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.0-R25Korrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//ownedAttribute[xoev:xoevCodelistenspalte(.) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M187">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="replace(@name, '[a-zA-Z0-9\.\-]', '') = ''"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="replace(@name, '[a-zA-Z0-9\.\-]', '') = ''">
               <xsl:attribute name="id">rule.C-CLH-1.0-R25</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Der Name (technisch) einer Codelistenspalte (UML-Eigenschaft mit dem Stereotyp xoevCodelistenspalte und der Stereotypeigenschaft nameTechnisch) darf nur die Zeichen "a-z", "A-Z", "0-9", "-" und "." enthalten. Die Codelistenspalte <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M187"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M187"/>
   <xsl:template match="@*|node()" priority="-2" mode="M187">
      <xsl:apply-templates select="*" mode="M187"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.0-R26Korrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.)) and uml:is-Class(.)]"
                 priority="1000"
                 mode="M188">
      <xsl:variable name="codelistenversion" select="."/>
      <!--ASSERT warning-->
      <xsl:choose>
         <xsl:when test="count(ancestor::packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-InstanceSpecification(.) and @classifier = $codelistenversion/@xmi:id]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(ancestor::packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-InstanceSpecification(.) and @classifier = $codelistenversion/@xmi:id]) &gt;= 1">
               <xsl:attribute name="id">rule.C-CLH-1.0-R26</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Eine Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) sollte mindestens einen Eintrag (UML-Objekt der UML-Klasse der Codelistenversion) besitzen. Die Codelistenversion <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M188"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M188"/>
   <xsl:template match="@*|node()" priority="-2" mode="M188">
      <xsl:apply-templates select="*" mode="M188"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.0-R28Korrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevVersionCodeliste(.) and uml:is-Class(.) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M189">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(ownedAttribute[xoev:xoevCodelistenspalte(.)/@empfohleneCodeSpalte = 'true']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(ownedAttribute[xoev:xoevCodelistenspalte(.)/@empfohleneCodeSpalte = 'true']) &lt;= 1">
               <xsl:attribute name="id">rule.C-CLH-1.0-R28</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Eine Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) darf höchstens eine empfohlene Code-Spalte (UML-Eigenschaft mit dem Stereotyp xoevCodelistenspalte und der Eigenschaft empfohleneCodeSpalte = true) besitzen. Die Codelistenversion <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M189"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M189"/>
   <xsl:template match="@*|node()" priority="-2" mode="M189">
      <xsl:apply-templates select="*" mode="M189"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.0-R29Korrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.)) and xoev:xoevVersionCodeliste(.)/@datumGueltigkeitAb]"
                 priority="1000"
                 mode="M190">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="matches(xoev:xoevVersionCodeliste(.)/@datumGueltigkeitAb, '\d\d\d\d\-\d\d\-\d\d')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="matches(xoev:xoevVersionCodeliste(.)/@datumGueltigkeitAb, '\d\d\d\d\-\d\d\-\d\d')">
               <xsl:attribute name="id">rule.C-CLH-1.0-R29</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Das Datum "Gültigkeit ab" einer Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste und der Eigenschaft datumGueltigkeitAb) darf nur Datumsangaben im Format JJJJ-MM-TT enthalten. Die Codelistenversion <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M190"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M190"/>
   <xsl:template match="@*|node()" priority="-2" mode="M190">
      <xsl:apply-templates select="*" mode="M190"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.0-R30Korrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M191">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="xoev:xoevVersionCodeliste(.)/@version[. != '']"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="xoev:xoevVersionCodeliste(.)/@version[. != '']">
               <xsl:attribute name="id">rule.C-CLH-1.0-R30</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Versionangabe einer Codelistenversion muss spezifiziert sein (UML-Klasse mit dem Stereotyp xoevVersionCodeliste und der Eigenschaft version). Die Codelistenversion <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M191"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M191"/>
   <xsl:template match="@*|node()" priority="-2" mode="M191">
      <xsl:apply-templates select="*" mode="M191"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.2-R31-AKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M192">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(xoev:xoevVersionCodeliste(.)/beschreibung[. != '']) = (0, 1, count(distinct-values(xoev:xoevVersionCodeliste(.)/beschreibung/xoev:get-language(.))))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(xoev:xoevVersionCodeliste(.)/beschreibung[. != '']) = (0, 1, count(distinct-values(xoev:xoevVersionCodeliste(.)/beschreibung/xoev:get-language(.))))">
               <xsl:attribute name="id">rule.C-CLH-1.2-R31-A</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Eine Codelistenversion darf höchstens eine Beschreibung pro Sprache besitzen (Eigenschaft beschreibung des Stereotyps xoevVersionCodeliste). Die Codelistenversion <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M192"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M192"/>
   <xsl:template match="@*|node()" priority="-2" mode="M192">
      <xsl:apply-templates select="*" mode="M192"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.2-R32-AKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))] | uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M193">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(xoev:xoevVersionCodeliste(.)/aenderungZurVorversion[. != '']) = (0, 1, count(distinct-values(xoev:xoevVersionCodeliste(.)/aenderungZurVorversion/xoev:get-language(.))))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(xoev:xoevVersionCodeliste(.)/aenderungZurVorversion[. != '']) = (0, 1, count(distinct-values(xoev:xoevVersionCodeliste(.)/aenderungZurVorversion/xoev:get-language(.))))">
               <xsl:attribute name="id">rule.C-CLH-1.2-R32-A</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Eine Codelistenversion darf höchstens eine Beschreibung der Änderungen zur Vorversion pro Sprache besitzen (Eigenschaft aenderungZurVorversion des Stereotyps xoevVersionCodeliste). Die Codelistenversion <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M193"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M193"/>
   <xsl:template match="@*|node()" priority="-2" mode="M193">
      <xsl:apply-templates select="*" mode="M193"/>
   </xsl:template>
   <!--PATTERN pattern.C-XOEV-R33Korrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-Class(.) and xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M194">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     xoev:xoevVersionCodeliste(.)/@versionCodelistenHandbuch and                     empty(xoev:xoevVersionCodeliste(.)/@versionXOEVHandbuch)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="xoev:xoevVersionCodeliste(.)/@versionCodelistenHandbuch and empty(xoev:xoevVersionCodeliste(.)/@versionXOEVHandbuch)">
               <xsl:attribute name="id">rule.C-CLH-1.0-R33</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Im Kontext einer Codelistenversion, die der im Codelisten-Handbuch 1.0 dokumentierten Methodik entsprechend modelliert ist (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) muss die Version des Codelisten-Handbuchs angeben sein (Eigenschaft versionCodelistenHandbuch des Stereotyps xoevVersionCodeliste). Die Eigenschaft versionXOEVHandbuch des Stereotyps xoevVersionCodeliste darf nicht befüllt sein. Die Codelistenversion <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M194"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M194"/>
   <xsl:template match="@*|node()" priority="-2" mode="M194">
      <xsl:apply-templates select="*" mode="M194"/>
   </xsl:template>
   <!--PATTERN pattern-C-XOEV-2.2-R34Korrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-Enumeration(.) and xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M195">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     xoev:xoevVersionCodeliste(.)/@versionXOEVHandbuch and                     empty(xoev:xoevVersionCodeliste(.)/@versionCodelistenHandbuch)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="xoev:xoevVersionCodeliste(.)/@versionXOEVHandbuch and empty(xoev:xoevVersionCodeliste(.)/@versionCodelistenHandbuch)">
               <xsl:attribute name="id">rule-C-XOEV-2.2-R34</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Im Kontext einer Codelistenversion, die der im XÖV-Handbuch 2.1 dokumentierten Methodik entsprechend modelliert ist (UML-Enumeration mit dem Stereotyp xoevVersionCodeliste) muss die Version des XÖV-Handbuchs angeben sein (Eigenschaft versionXOEVHandbuch des Stereotyps xoevVersionCodeliste). Die Eigenschaft versionCodelistenHandbuch des Stereotyps xoevVersionCodeliste darf nicht befüllt sein. Die Codelistenversion <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M195"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M195"/>
   <xsl:template match="@*|node()" priority="-2" mode="M195">
      <xsl:apply-templates select="*" mode="M195"/>
   </xsl:template>
   <!--PATTERN pattern-CodelisteImUMLPaketMitKennungAlsNamenKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevCodeliste(.) and uml:is-Class(.) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M196">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="parent::packagedElement/@name = xoev:xoevCodeliste(.)/@kennung"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="parent::packagedElement/@name = xoev:xoevCodeliste(.)/@kennung">
               <xsl:attribute name="id">rule-CodelisteImUMLPaketMitKennungAlsNamen</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Es wird empfohlen, für jede Codeliste (UML-Klasse mit dem Stereotyp xoevCodeliste) ein eigenes UML-Paket zu erstellen, dessen Name der Kennung der Codeliste entspricht. Die Codeliste <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> entspricht dieser Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M196"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M196"/>
   <xsl:template match="@*|node()" priority="-2" mode="M196">
      <xsl:apply-templates select="*" mode="M196"/>
   </xsl:template>
   <!--PATTERN pattern-CodelistenversionImUMLPaketMitVersionAlsNamenKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevVersionCodeliste(.) and uml:is-Class(.) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M197">
      <xsl:variable name="codelistenversion" select="."/>
      <!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="parent::packagedElement[@name = $codelistenversion/xoev:xoevVersionCodeliste(.)/@version and parent::packagedElement/packagedElement/@xmi:id = $codelistenversion/xoev:dependencies-by-client(.)/uml:resolve-supplier(.)/@xmi:id]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="parent::packagedElement[@name = $codelistenversion/xoev:xoevVersionCodeliste(.)/@version and parent::packagedElement/packagedElement/@xmi:id = $codelistenversion/xoev:dependencies-by-client(.)/uml:resolve-supplier(.)/@xmi:id]">
               <xsl:attribute name="id">rule-CodelistenversionImUMLPaketMitVersionAlsNamen</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Es wird empfohlen, für jede Codelistenversion (UML-Klasse mit dem Stereotyp xoevVersionCodeliste) ein eigenes UML-Paket unterhalb des Pakets der Codeliste zu erstellen und dem Paket die Versionsangabe als Namen zu geben. Die Codelistenversion <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> entspricht dieser Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M197"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M197"/>
   <xsl:template match="@*|node()" priority="-2" mode="M197">
      <xsl:apply-templates select="*" mode="M197"/>
   </xsl:template>
   <!--PATTERN pattern-CodelisteneinträgeImUMLPaketDerCodelistenversionKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-InstanceSpecification(.) and not(xoev:xoevCodelisteneintragDeprecated(.)) and uml:resolve-classifier(.)/xoev:xoevVersionCodeliste(.)]"
                 priority="1000"
                 mode="M198">
      <xsl:variable name="codelistenversion" select="uml:resolve-classifier(.)"/>
      <!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="parent::packagedElement/packagedElement/@xmi:id = $codelistenversion/@xmi:id"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="parent::packagedElement/packagedElement/@xmi:id = $codelistenversion/@xmi:id">
               <xsl:attribute name="id">rule-CodelisteneinträgeImUMLPaketDerCodelistenversion</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Es wird empfohlen, die Codelisteneinträge (UML-Objekte der UML-Klasse der Codelistenversion) im UML-Paket der Codelistenversion abzulegen. Der Codelisteneintrag mit den Werten <xsl:text/>
                  <xsl:value-of select="slot/value/@value"/>
                  <xsl:text/> der Codelistenversion <xsl:text/>
                  <xsl:value-of select="xgen:model-path($codelistenversion)"/>
                  <xsl:text/> entspricht dieser Empfehlung nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M198"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M198"/>
   <xsl:template match="@*|node()" priority="-2" mode="M198">
      <xsl:apply-templates select="*" mode="M198"/>
   </xsl:template>
   <!--PATTERN pattern-CodelistenNachCodelistenHandbuchModelliertKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[xoev:xsdXModel(.)]"
                 priority="1000"
                 mode="M199">

		<!--ASSERT warning-->
      <xsl:choose>
         <xsl:when test="empty((descendant::packagedElement, descendant::nestedClassifier)[uml:is-Enumeration(.) and xoev:xoevCodeliste(.)])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="empty((descendant::packagedElement, descendant::nestedClassifier)[uml:is-Enumeration(.) and xoev:xoevCodeliste(.)])">
               <xsl:attribute name="id">rule-CodelistenNachCodelistenHandbuchModelliert</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Codelisten sollen der im Codelisten-Handbuch (Version 1.0) dokumentierten Methodik entsprechend modelliert werden. Im XÖV-Fachmodell des Standards liegt mindestens eine Codeliste vor, die einer älteren Methodik entspricht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M199"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M199"/>
   <xsl:template match="@*|node()" priority="-2" mode="M199">
      <xsl:apply-templates select="*" mode="M199"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.0-R35-->
   <!--RULE -->
   <xsl:template match="                 uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-InstanceSpecification(.) and not(xoev:xoevCodelisteneintragDeprecated(.)) and uml:resolve-classifier(.)/xoev:xoevVersionCodeliste(.) and                 not(uml:resolve-classifier(.)/xoev:dependencies-by-client(.)/uml:resolve-supplier(.)/xoev:xoevCodeliste(.)/@kennung = $bestandskennungen)]"
                 priority="1000"
                 mode="M200">

		<!--ASSERT warning-->
      <xsl:choose>
         <xsl:when test="                     every $value in slot[uml:resolve-definingFeature(.)/xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true']/value/@value                         satisfies string-length($value) &gt; 0 and not(matches($value, '^\p{Z}*$'))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="every $value in slot[uml:resolve-definingFeature(.)/xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true']/value/@value satisfies string-length($value) &gt; 0 and not(matches($value, '^\p{Z}*$'))">
               <xsl:attribute name="id">rule.C-CLH-1.0-R35</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Codes sollen nicht leer sein oder ausschließlich aus Unicode-Seperatoren (z. B. Leerzeichen oder Zeilenumbrüchen) bestehen, da dies Probleme bzgl. Lesbarkeit und automatischer Weiterverarbeitung verursachen kann. Ein Code im Codelisteneintrag <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Regel.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M200"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M200"/>
   <xsl:template match="@*|node()" priority="-2" mode="M200">
      <xsl:apply-templates select="*" mode="M200"/>
   </xsl:template>
   <!--PATTERN pattern-NDR-34-Modellierung-von-Codelistenversionen-als-benannte-TypenKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="                 uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Class(.) and xoev:usages-by-client(.)[xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentyp = 'false'] and not(xoev:xsdDraft(.))] |                 uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Class(.) and xoev:usages-by-client(.)[xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentyp = 'false'] and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M201">

		<!--ASSERT information-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">rule-NDR-34-Modellierung-von-Codelistenversionen-als-benannte-Typen</xsl:attribute>
               <xsl:attribute name="role">information</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Es wird empfohlen, Codelistenversionen als benannte Typen zu modellieren. Im Kontext des Code-Datentyps <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> wird diese Empfehlung nicht eingehalten.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M201"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M201"/>
   <xsl:template match="@*|node()" priority="-2" mode="M201">
      <xsl:apply-templates select="*" mode="M201"/>
   </xsl:template>
   <!--PATTERN pattern-Korrekte-Codelisten-AblageKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="/xmi:XMI/uml:Model//packagedElement[(xoev:xoevCodeliste(.) or xoev:xoevVersionCodeliste(.)) and uml:is-Class(.) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M202">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="ancestor::packagedElement[@name = ('eigene Codelisten', 'externe Codelisten')]/parent::packagedElement[@name = 'Codelisten']/parent::uml:Model/@xmi:id = $uml:root-model/@xmi:id or ancestor::packagedElement[@name = 'Externe Modelle']/parent::uml:Model/@xmi:id = $uml:root-model/@xmi:id"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="ancestor::packagedElement[@name = ('eigene Codelisten', 'externe Codelisten')]/parent::packagedElement[@name = 'Codelisten']/parent::uml:Model/@xmi:id = $uml:root-model/@xmi:id or ancestor::packagedElement[@name = 'Externe Modelle']/parent::uml:Model/@xmi:id = $uml:root-model/@xmi:id">
               <xsl:attribute name="id">rule-Korrekte-Codelisten-Ablage</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Alle eigenen und externen Codelisten (gemäß Abschnitt 8.1 "Codelisten im XÖV-Fachmodell" des XÖV-Handbuchs) müssen, im XÖV-Fachmodell auf oberster Ebene unterhalb eines UML-Pakets "Codelisten" (konkret "Codelisten/eigene Codelisten" oder "Codelisten/externe Codelisten") abgelegt werden. Die Codeliste <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> entspricht dieser Vorgabe nicht.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M202"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M202"/>
   <xsl:template match="@*|node()" priority="-2" mode="M202">
      <xsl:apply-templates select="*" mode="M202"/>
   </xsl:template>
   <!--PATTERN pattern-Keine-Namenskollisionen-bei-benannten-CodelistentypenKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model//packagedElement[                 xoev:xoevVersionCodeliste(.) and uml:is-Class(.) and not(xoev:xsdDraft(.)) and                 count(                 xoev:usages-by-supplier(.)[xoev:xoevCodeTyp1(.)[not(@benannterCodelistenDatentyp = 'false')]]/                 uml:resolve-client(.)[ancestor::packagedElement/@xmi:id = $xoev:my-xmodel/@xmi:id])                 gt 1]"
                 priority="1000"
                 mode="M203">
      <xsl:variable name="usages"
                    select="                     xoev:usages-by-supplier(.)[xoev:xoevCodeTyp1(.)[not(@benannterCodelistenDatentyp = 'false')] and                     uml:resolve-client(.)[ancestor::packagedElement/@xmi:id = $xoev:my-xmodel/@xmi:id]]"/>
      <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     every $usage1 in $usages                         satisfies (every $usage2 in $usages[@xmi:id != $usage1/@xmi:id]                             satisfies                             not($usage1/(xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentypXSD, uml:resolve-client(.)/ancestor::packagedElement[xoev:xsdSchema(.)]/@xmi:id)[1] =                             $usage2/(xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentypXSD, uml:resolve-client(.)/ancestor::packagedElement[xoev:xsdSchema(.)]/@xmi:id)[1])                             or                             not($usage1/(xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentypName,                             uml:resolve-supplier(.)/xoev:dependencies-by-client(.)/uml:resolve-supplier(.)/xoev:xoevCodeliste(.)/@nameTechnisch)[1] =                             $usage2/(xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentypName,                             uml:resolve-supplier(.)/xoev:dependencies-by-client(.)/uml:resolve-supplier(.)/xoev:xoevCodeliste(.)/@nameTechnisch)[1])                             or (                             $usage1/(xoev:xoevCodeTyp1(.)/@genutzteCodeSpalte/xoev:ids-to-elements(., root()),                             uml:resolve-supplier(.)/ownedAttribute[xoev:xoevCodelistenspalte(.)/@empfohleneCodeSpalte = 'true'],                             uml:resolve-supplier(.)/ownedAttribute[xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true'])[1]/@xmi:id =                             $usage2/(xoev:xoevCodeTyp1(.)/@genutzteCodeSpalte/xoev:ids-to-elements(., root()),                             uml:resolve-supplier(.)/ownedAttribute[xoev:xoevCodelistenspalte(.)/@empfohleneCodeSpalte = 'true'],                             uml:resolve-supplier(.)/ownedAttribute[xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true'])[1]/@xmi:id                             and                             ($usage1/xoev:xoevCodeTyp1(.)/xoev:resolve-typDesCodeElements(.)[@name != 'token']/@xmi:id, 'xs:token')[1] =                             ($usage2/xoev:xoevCodeTyp1(.)/xoev:resolve-typDesCodeElements(.)[@name != 'token']/@xmi:id, 'xs:token')[1]                             )                         )"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="every $usage1 in $usages satisfies (every $usage2 in $usages[@xmi:id != $usage1/@xmi:id] satisfies not($usage1/(xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentypXSD, uml:resolve-client(.)/ancestor::packagedElement[xoev:xsdSchema(.)]/@xmi:id)[1] = $usage2/(xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentypXSD, uml:resolve-client(.)/ancestor::packagedElement[xoev:xsdSchema(.)]/@xmi:id)[1]) or not($usage1/(xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentypName, uml:resolve-supplier(.)/xoev:dependencies-by-client(.)/uml:resolve-supplier(.)/xoev:xoevCodeliste(.)/@nameTechnisch)[1] = $usage2/(xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentypName, uml:resolve-supplier(.)/xoev:dependencies-by-client(.)/uml:resolve-supplier(.)/xoev:xoevCodeliste(.)/@nameTechnisch)[1]) or ( $usage1/(xoev:xoevCodeTyp1(.)/@genutzteCodeSpalte/xoev:ids-to-elements(., root()), uml:resolve-supplier(.)/ownedAttribute[xoev:xoevCodelistenspalte(.)/@empfohleneCodeSpalte = 'true'], uml:resolve-supplier(.)/ownedAttribute[xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true'])[1]/@xmi:id = $usage2/(xoev:xoevCodeTyp1(.)/@genutzteCodeSpalte/xoev:ids-to-elements(., root()), uml:resolve-supplier(.)/ownedAttribute[xoev:xoevCodelistenspalte(.)/@empfohleneCodeSpalte = 'true'], uml:resolve-supplier(.)/ownedAttribute[xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true'])[1]/@xmi:id and ($usage1/xoev:xoevCodeTyp1(.)/xoev:resolve-typDesCodeElements(.)[@name != 'token']/@xmi:id, 'xs:token')[1] = ($usage2/xoev:xoevCodeTyp1(.)/xoev:resolve-typDesCodeElements(.)[@name != 'token']/@xmi:id, 'xs:token')[1] ) )">
               <xsl:attribute name="id">rule-Keine-Namenskollisionen-bei-benannten-Codelistentypen</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Wenn für eine Codelistenversion aufgrund der Nutzung in verschiedenen Code-Datentypen mit unterschiedlichen Nutzungseinstellungen mehrere benannte Datentypen in derselben XML Schema-Definition angelegt werden, muss sich der Name dieser Codelisten-Datentypen unterscheiden. Die Code-Datentypen <xsl:text/>
                  <xsl:value-of select="$usages/uml:resolve-client(.)/@name"/>
                  <xsl:text/> nutzen die Codelistenversion <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> als benannter Datentyp mit demselben Namen, nutzen jedoch verschiedene Code-Spalten oder legen verschiedene Typen des Code-Elements fest.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M203"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M203"/>
   <xsl:template match="@*|node()" priority="-2" mode="M203">
      <xsl:apply-templates select="*" mode="M203"/>
   </xsl:template>
   <!--PATTERN pattern-xoevVersionCodeliste-und-NamedType-schliessen-sich-ausKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[xoev:xoevVersionCodeliste(.) and uml:is-Class(.) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M204">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.))">
               <xsl:attribute name="id">rule-xoevVersionCodeliste-und-xsdNamedType-schliessen-sich-aus</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Eine Codelistenversion darf nicht mit dem Stereotypen xsdNamedType oder xsdGlobalElementAndNamedType annotiert sein. <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe. Hinweis: Ob für eine Codelistenversion ein benannter Datentyp erstellt wird, wird an der Nutzungsbeziehung konfiguriert (Stereotyp xoevCodeTyp1).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M204"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M204"/>
   <xsl:template match="@*|node()" priority="-2" mode="M204">
      <xsl:apply-templates select="*" mode="M204"/>
   </xsl:template>
   <!--PATTERN pattern-benannterCodelistenDatentypXSD-verweist-auf-internes-Schema-PaketKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="                 uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[uml:is-Class(.) and xoev:usages-by-client(.)[xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentypXSD] and not(xoev:xsdDraft(.))] |                 uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[uml:is-Class(.) and xoev:usages-by-client(.)[xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentypXSD] and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M205">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="xoev:ids-to-elements(xoev:usages-by-client(.)/xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentypXSD, root())[xoev:xsdSchema(.)]/ancestor::packagedElement[xoev:xoevStandard(.)]/@xmi:id = $xoev:my-xmodel/@xmi:id"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="xoev:ids-to-elements(xoev:usages-by-client(.)/xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentypXSD, root())[xoev:xsdSchema(.)]/ancestor::packagedElement[xoev:xoevStandard(.)]/@xmi:id = $xoev:my-xmodel/@xmi:id">
               <xsl:attribute name="id">rule-benannterCodelistenDatentypXSD-verweist-auf-internes-Schema-Paket</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Das in der Eigenschaft benannterCodelistenDatentypXSD des Stereotyps xoevCodeTyp1 angegebene Paket muss ein zum Standard gehörendes Schema-Paket (xsdSchema) sein. Im Kontext des Code-Datentyps <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> wird diese Vorgabe nicht eingehalten.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M205"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M205"/>
   <xsl:template match="@*|node()" priority="-2" mode="M205">
      <xsl:apply-templates select="*" mode="M205"/>
   </xsl:template>
   <!--PATTERN NDR-28-ValideW3CXMLSchemaDefinitionen-ValideStandardkonfigurationNDR-28: Valide W3C XML Schema-Definitionen-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">NDR-28: Valide W3C XML Schema-Definitionen</svrl:text>
   <!--RULE -->
   <xsl:template match="                 /xmi:XMI/uml:Model/packagedElement[xoev:xsdXModel(.)/@ermittlungElementreihenfolge = 'Stereotyp' and not(xoev:xsdXModel(.)/@standardeinstellungEigenschaften = 'keine')]"
                 priority="1000"
                 mode="M206">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">ValideStandardkonfiguration</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Standardeinstellung für Eigenschaften mit dem Wert "Stereotyp" und die Ermittlung der Elementreihenfolge mit dem Wert "Element" (Eigenschaften standardeinstellungEigenschaften und ermittlungElementreihenfolge des Stereotyps xsdXModel) schließen sich gegenseitig aus.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M206"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M206"/>
   <xsl:template match="@*|node()" priority="-2" mode="M206">
      <xsl:apply-templates select="*" mode="M206"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.2-R42-KorrekteAngabenZurMehrsprachigkeitKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-Class(.) and (xoev:xoevCodeliste(.) or xoev:xoevVersionCodeliste(.)) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M207">
      <xsl:variable name="cl-vcl" select="."/>
      <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     every $m in (xoev:xoevCodeliste(.)/nameLang[count($cl-vcl/xoev:xoevCodeliste(.)/nameLang) gt 1],                     xoev:xoevCodeliste(.)/nameKurz[count($cl-vcl/xoev:xoevCodeliste(.)/nameKurz) gt 1],                     xoev:xoevCodeliste(.)/beschreibung[count($cl-vcl/xoev:xoevCodeliste(.)/beschreibung) gt 1],                     xoev:xoevCodeliste(.)/herausgebernameLang[count($cl-vcl/xoev:xoevCodeliste(.)/herausgebernameLang) gt 1],                     xoev:xoevCodeliste(.)/herausgebernameKurz[count($cl-vcl/xoev:xoevCodeliste(.)/herausgebernameKurz) gt 1],                     xoev:xoevVersionCodeliste(.)/beschreibung[count($cl-vcl/xoev:xoevVersionCodeliste(.)/beschreibung) gt 1],                     xoev:xoevVersionCodeliste(.)/aenderungZurVorversion[count($cl-vcl/xoev:xoevVersionCodeliste(.)/aenderungZurVorversion) gt 1])                         satisfies xoev:get-language($m)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="every $m in (xoev:xoevCodeliste(.)/nameLang[count($cl-vcl/xoev:xoevCodeliste(.)/nameLang) gt 1], xoev:xoevCodeliste(.)/nameKurz[count($cl-vcl/xoev:xoevCodeliste(.)/nameKurz) gt 1], xoev:xoevCodeliste(.)/beschreibung[count($cl-vcl/xoev:xoevCodeliste(.)/beschreibung) gt 1], xoev:xoevCodeliste(.)/herausgebernameLang[count($cl-vcl/xoev:xoevCodeliste(.)/herausgebernameLang) gt 1], xoev:xoevCodeliste(.)/herausgebernameKurz[count($cl-vcl/xoev:xoevCodeliste(.)/herausgebernameKurz) gt 1], xoev:xoevVersionCodeliste(.)/beschreibung[count($cl-vcl/xoev:xoevVersionCodeliste(.)/beschreibung) gt 1], xoev:xoevVersionCodeliste(.)/aenderungZurVorversion[count($cl-vcl/xoev:xoevVersionCodeliste(.)/aenderungZurVorversion) gt 1]) satisfies xoev:get-language($m)">
               <xsl:attribute name="id">rule.C-CLH-1.2-R42-KorrekteAngabenZurMehrsprachigkeit</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Wenn ein mehrsprachiges Metadatenelement mehr als einen Wert besitzt, muss jeder Wert mit einer Sprachangabe in der Form "[xx-XX]" beginnen, wobei "xx-XX" eine Codierung auf der Basis von RFC-5646 darstellen muss, siehe Konformitätskriterien K-11 und K-13 im Codelistenhandbuch. Die Codeliste(nversion) <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M207"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M207"/>
   <xsl:template match="@*|node()" priority="-2" mode="M207">
      <xsl:apply-templates select="*" mode="M207"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.2-R40-VollstaendigeSprachauszeichnungFuerCodelisteKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-Class(.) and xoev:xoevCodeliste(.) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M208">
      <xsl:variable name="cl" select="."/>
      <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     every $l in xoev:xoevCodeliste(.)/(nameLang, nameKurz, beschreibung, herausgebernameLang, herausgebernameKurz)/xoev:get-language(.)                         satisfies                         (xoev:xoevCodeliste(.)/nameLang[starts-with(., concat('[', $l, ']'))] and                         xoev:xoevCodeliste(.)/nameKurz[starts-with(., concat('[', $l, ']'))] and                         xoev:xoevCodeliste(.)/beschreibung[starts-with(., concat('[', $l, ']'))] and                         xoev:xoevCodeliste(.)/herausgebernameLang[starts-with(., concat('[', $l, ']'))] and                         xoev:xoevCodeliste(.)/herausgebernameKurz[starts-with(., concat('[', $l, ']'))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="every $l in xoev:xoevCodeliste(.)/(nameLang, nameKurz, beschreibung, herausgebernameLang, herausgebernameKurz)/xoev:get-language(.) satisfies (xoev:xoevCodeliste(.)/nameLang[starts-with(., concat('[', $l, ']'))] and xoev:xoevCodeliste(.)/nameKurz[starts-with(., concat('[', $l, ']'))] and xoev:xoevCodeliste(.)/beschreibung[starts-with(., concat('[', $l, ']'))] and xoev:xoevCodeliste(.)/herausgebernameLang[starts-with(., concat('[', $l, ']'))] and xoev:xoevCodeliste(.)/herausgebernameKurz[starts-with(., concat('[', $l, ']'))])">
               <xsl:attribute name="id">rule.C-CLH-1.2-R40-VollstaendigeSprachauszeichnungFuerCodeliste</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Jede für ein Metadatenelement genutzte Sprache muss ebenso als Sprache für die weiteren mehrsprachigen Metadatenelemente genutzt werden, außer für ein optionales Metadatenelement ist kein Wert angegeben, siehe Konformitätskriterium K-12 im Codelistenhandbuch. Die Codeliste <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M208"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M208"/>
   <xsl:template match="@*|node()" priority="-2" mode="M208">
      <xsl:apply-templates select="*" mode="M208"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.2-R40-VollstaendigeSprachauszeichnungFuerVersionCodelisteKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-Class(.) and xoev:xoevVersionCodeliste(.) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M209">
      <xsl:variable name="vcl" select="."/>
      <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     every $l in xoev:xoevVersionCodeliste(.)/(beschreibung, aenderungZurVorversion)/xoev:get-language(.)                         satisfies                         ((empty(xoev:xoevVersionCodeliste(.)/beschreibung) or xoev:xoevVersionCodeliste(.)/beschreibung[starts-with(., concat('[', $l, ']'))]) and                         (empty(xoev:xoevVersionCodeliste(.)/aenderungZurVorversion) or xoev:xoevVersionCodeliste(.)/aenderungZurVorversion[starts-with(., concat('[', $l, ']'))]))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="every $l in xoev:xoevVersionCodeliste(.)/(beschreibung, aenderungZurVorversion)/xoev:get-language(.) satisfies ((empty(xoev:xoevVersionCodeliste(.)/beschreibung) or xoev:xoevVersionCodeliste(.)/beschreibung[starts-with(., concat('[', $l, ']'))]) and (empty(xoev:xoevVersionCodeliste(.)/aenderungZurVorversion) or xoev:xoevVersionCodeliste(.)/aenderungZurVorversion[starts-with(., concat('[', $l, ']'))]))">
               <xsl:attribute name="id">rule.C-CLH-1.2-R40-VollstaendigeSprachauszeichnungFuerVersionCodeliste</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Jede für ein Metadatenelement genutzte Sprache muss ebenso als Sprache für die weiteren mehrsprachigen Metadatenelemente genutzt werden, außer für ein optionales Metadatenelement ist kein Wert angegeben, siehe Konformitätskriterium K-12 im Codelistenhandbuch. Die Codelistenversion <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M209"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M209"/>
   <xsl:template match="@*|node()" priority="-2" mode="M209">
      <xsl:apply-templates select="*" mode="M209"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.2-R39-KorrekteAngabeInDeutscherSpracheKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//packagedElement[uml:is-Class(.) and (xoev:xoevCodeliste(.) or xoev:xoevVersionCodeliste(.)) and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M210">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     (empty(xoev:xoevCodeliste(.)/nameLang[xoev:get-language(.) != 'de-DE']) or                     xoev:xoevCodeliste(.)/nameLang[xoev:get-language(.) = 'de-DE']) and                     (empty(xoev:xoevCodeliste(.)/nameKurz[xoev:get-language(.) != 'de-DE']) or                     xoev:xoevCodeliste(.)/nameKurz[xoev:get-language(.) = 'de-DE']) and                     (empty(xoev:xoevCodeliste(.)/beschreibung[xoev:get-language(.) != 'de-DE']) or                     xoev:xoevCodeliste(.)/beschreibung[xoev:get-language(.) = 'de-DE']) and                     (empty(xoev:xoevCodeliste(.)/herausgebernameLang[xoev:get-language(.) != 'de-DE']) or                     xoev:xoevCodeliste(.)/herausgebernameLang[xoev:get-language(.) = 'de-DE']) and                     (empty(xoev:xoevCodeliste(.)/herausgebernameKurz[xoev:get-language(.) != 'de-DE']) or                     xoev:xoevCodeliste(.)/herausgebernameKurz[xoev:get-language(.) = 'de-DE']) and                     (empty(xoev:xoevVersionCodeliste(.)/beschreibung[xoev:get-language(.) != 'de-DE']) or                     xoev:xoevVersionCodeliste(.)/beschreibung[xoev:get-language(.) = 'de-DE']) and                     (empty(xoev:xoevVersionCodeliste(.)/aenderungZurVorversion[xoev:get-language(.) != 'de-DE']) or                     xoev:xoevVersionCodeliste(.)/aenderungZurVorversion[xoev:get-language(.) = 'de-DE'])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="(empty(xoev:xoevCodeliste(.)/nameLang[xoev:get-language(.) != 'de-DE']) or xoev:xoevCodeliste(.)/nameLang[xoev:get-language(.) = 'de-DE']) and (empty(xoev:xoevCodeliste(.)/nameKurz[xoev:get-language(.) != 'de-DE']) or xoev:xoevCodeliste(.)/nameKurz[xoev:get-language(.) = 'de-DE']) and (empty(xoev:xoevCodeliste(.)/beschreibung[xoev:get-language(.) != 'de-DE']) or xoev:xoevCodeliste(.)/beschreibung[xoev:get-language(.) = 'de-DE']) and (empty(xoev:xoevCodeliste(.)/herausgebernameLang[xoev:get-language(.) != 'de-DE']) or xoev:xoevCodeliste(.)/herausgebernameLang[xoev:get-language(.) = 'de-DE']) and (empty(xoev:xoevCodeliste(.)/herausgebernameKurz[xoev:get-language(.) != 'de-DE']) or xoev:xoevCodeliste(.)/herausgebernameKurz[xoev:get-language(.) = 'de-DE']) and (empty(xoev:xoevVersionCodeliste(.)/beschreibung[xoev:get-language(.) != 'de-DE']) or xoev:xoevVersionCodeliste(.)/beschreibung[xoev:get-language(.) = 'de-DE']) and (empty(xoev:xoevVersionCodeliste(.)/aenderungZurVorversion[xoev:get-language(.) != 'de-DE']) or xoev:xoevVersionCodeliste(.)/aenderungZurVorversion[xoev:get-language(.) = 'de-DE'])">
               <xsl:attribute name="id">rule.C-CLH-1.2-R39-KorrekteAngabeInDeutscherSprache</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Wenn für ein mehrsprachiges Metadatenelement eine Sprache ungleich "de-DE" angegeben ist, muss immer auch ein Wert für die Sprache de-DE mit expliziter Kennzeichnung ("[de-DE]") vorliegen, siehe Konformitätskriterien K-10 und K-11 im Codelistenhandbuch. Die Codeliste(nversion) <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M210"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M210"/>
   <xsl:template match="@*|node()" priority="-2" mode="M210">
      <xsl:apply-templates select="*" mode="M210"/>
   </xsl:template>
   <!--PATTERN pattern.C-CLH-1.2-R42-KorrekteSprachangabeInCodelistenspalteKorrekte Codelistenmodellierung-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Korrekte Codelistenmodellierung</svrl:text>
   <!--RULE -->
   <xsl:template match="                 uml:Model/packagedElement[@name = 'Codelisten']/packagedElement[@name = 'eigene Codelisten']//ownedAttribute[                 xoev:xoevCodelistenspalte(.)/@sprache[. != ''] and not(xoev:xsdDraft(.))]"
                 priority="1000"
                 mode="M211">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     xoev:xoevCodelistenspalte(.)/@sprache/matches(., '^[a-z]{2}-[A-Z]{2}.*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="xoev:xoevCodelistenspalte(.)/@sprache/matches(., '^[a-z]{2}-[A-Z]{2}.*$')">
               <xsl:attribute name="id">rule.C-CLH-1.2-R42-KorrekteSprachangabeInCodelistenspalte</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Die Sprachangabe für eine Spalte muss auf der Basis von RFC-5646 kodiert sein (Muster: "xx-XX"), siehe Konformitätskriterium K-13 im Codelistenhandbuch. Die Codelistenspalte <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M211"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M211"/>
   <xsl:template match="@*|node()" priority="-2" mode="M211">
      <xsl:apply-templates select="*" mode="M211"/>
   </xsl:template>
   <xsl:param name="bestandskennungen"
              select="('urn:xoev-de:xdomea:codeliste:anschriftstyp', 'urn:de:dsmeld:schluesseltabelle:religion.nicht.steuererhebend', 'urn:xoev-de:xbau:codeliste:benachrichtigunganlass', 'urn:xoev-de:xbau:codeliste:formellebefundeart', 'urn:de:bund:kba:xkfz:codeliste:quittungsebene', 'urn:xoev-de:xdomea:codeliste:beteiligungsstatus', 'urn:xoev-de:xdomea:codeliste:bewertungsvorschlag', 'urn:xoev-de:xdomea:codeliste:dateiformat', 'urn:de:bund:kba:xkfz:codeliste:rolle', 'urn:xoev-de:xdomea:codeliste:datenaustauschart', 'urn:xoev-de:xdomea:codeliste:kommunikationsart', 'urn:de:bund:kba:xkfz:codeliste:schluesselnummerderueberwachungsinstitutionoderzdk', 'urn:xoev-de:xbau:nw:codeliste:technischeanlage', 'urn:de:bund:kba:xkfz:codeliste:statuselektronischerantrag', 'urn:de:bund:kba:xkfz:codeliste:statuselektronischerantragauskunft', 'urn:xoev-de:xdomea:codeliste:kompressionsverfahren', 'urn:xoev-de:xdomea:codeliste:konfigurationsparameter', 'urn:xoev-de:xdomea:codeliste:medium', 'urn:xoev-de:xdomea:codeliste:nachrichtentyp', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0602', 'urn:de:gkleika:leika:modul', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0604', 'urn:de:xinneres:codeliste:dvdvpraefix', 'urn:de:xinneres:codeliste:nachrichtentyp', 'urn:de:xmeld:schluesseltabelle:behoerdenauskunft.anforderungselement', 'urn:de:xwaffe:codelisten:munitionsbezeichnungkalibersynonym', 'urn:de:xauslaender:codelist:azr:abrufzweck', 'urn:xoev-de:xbau:codeliste:mppvotechnischeanlage', 'urn:de:xauslaender:codelist:azr:artablehnungfeststellungdtstaatsangehoerigkeit', 'urn:de:xauslaender:codelist:azr:artderanerkennung', 'urn:de:xauslaender:codelist:azr:artderaugenfarbe', 'urn:de:xauslaender:codelist:azr:artderauslieferungdurchlieferung', 'urn:de:xauslaender:codelist:azr:artderaussiedlereigenschaft', 'urn:de:xauslaender:codelist:azr:artderintegrationsundarbeitsvermittlungsdaten', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0606', 'urn:de:xmeld:schluesseltabelle:xmeldit.aenderungsart', 'urn:de:xauslaender:codelist:aenderungsart', 'urn:dsmeld:schluesseltabelle:religion.nicht.steuererhebend', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0607', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0609', 'urn:de:xauslaender:codelist:azr:artderschule', 'urn:de:xauslaender:codelist:abhabh:aktenanforderung:antwort', 'urn:de:xauslaender:codelist:abhabh:aktenanforderung:grund', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0612', 'urn:de:xauslaender:codelist:abhbamf:integration:kurseigenschaften', 'urn:xoev-de:bund:kba:codeliste:artderbremse', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0615', 'urn:de:xauslaender:codelist:abhmb:grundderablehnung', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0616', 'urn:de:xauslaender:codelist:aufenthaltsantrag:entscheidung', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0617', 'urn:de:xauslaender:codelist:aufenthaltsantrag:gegenstand', 'urn:de:xauslaender:codelist:aufenthaltsantrag:ohneentscheidung', 'urn:de:xauslaender:codelist:aufenthaltsbeginart', 'urn:de:xauslaender:codelist:aufenthaltsendesart', 'urn:de:xauslaender:codelist:azr:artderverurteilung', 'urn:de:xauslaender:codelist:aufenthaltszweckart', 'urn:de:xauslaender:codelist:ausweisart', 'urn:de:xauslaender:codelist:azr:aenderungsart', 'urn:de:xauslaender:codelist:azr:anderername', 'urn:de:xwaffe:codelisten:munitionsbezeichnungkaliber', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0620', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0621', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0623', 'urn:de:xauslaender:codelist:azr:artdesausreiseverbots', 'urn:xoev-de:bund:kba:codeliste:artderuntersuchungsstelle', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0624', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0625', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0626', 'urn:xoev-de:bund:kba:codeliste:artdesdokuments', 'urn:xoev-de:bund:kba:codeliste:artdesgeschaeftsvorfalls', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0631', 'urn:xoev-de:bund:kba:codeliste:artdesgutachtens', 'urn:xoev-de:xdomea:codeliste:transportweg', 'urn:xoev-de:bund:kba:codeliste:artdesmandats', 'urn:xoev-de:bund:kba:codeliste:artdessiegels', 'urn:xoev-de:xdomea:codeliste:vertraulichkeitsstufe', 'urn:xoev-de:xgewerbeanzeige:codeliste:artdereintragung', 'urn:de:xauslaender:codelist:azr:artdesberufs', 'urn:de:xauslaender:codelist:azr:artdeskursabschlusses', 'urn:xoev-de:xgewerbeanzeige:codeliste:empfaengerklassen', 'urn:xoev-de:bund:kba:codeliste:bearbeitungsart', 'urn:xoev-de:bund:kba:codeliste:datengruppenregistersatz', 'urn:xoev-de:xgewerbeanzeige:codeliste:grundfueranmeldung', 'urn:xoev-de:xgewerbeanzeige:codeliste:geschlecht', 'urn:xoev-de:xgewerbeanzeige:codeliste:janein', 'urn:xoev-de:xgewerbeanzeige:codeliste:korrekturgrund', 'urn:xoev-de:bund:kba:codeliste:ergebnisderuntersuchung', 'urn:xoev-de:xgewerbeanzeige:codeliste:nachrichtentypen', 'urn:de:xauslaender:codelist:azr:artdeskurses', 'urn:xoev-de:bund:kba:codeliste:kennzeichenformat', 'urn:xoev-de:xgewerbeanzeige:codeliste:rechtsformen', 'urn:de:xauslaender:codelist:azr:artdesschulabschlusses', 'urn:xoev-de:bund:kba:codeliste:nachrichtentyp', 'urn:de:xauslaender:codelist:azr:artdesstraftatverdachts', 'urn:xoev-de:bund:kba:codeliste:nummerderfeinstaubplakette', 'urn:xoev-de:xjustiz:codeliste:bnotk.empfangstyp.ztr', 'urn:de:xauslaender:codelist:bamfabh:asyl:abschlussinformationen', 'urn:de:xauslaender:codelist:bamfabh:asyl:antragsniederschrift', 'urn:xoev-de:bund:kba:codeliste:positionderbremse', 'urn:de:xauslaender:codelist:abhmb:grundderabmeldung', 'urn:de:xauslaender:codelist:bamfabh:asyl:asylantrag', 'urn:de:xauslaender:codelist:bamfabh:asyl:feststellungsinformationen', 'urn:de:xauslaender:codelist:bamfabh:asyl:gerichtsinstanz', 'urn:xoev-de:xjustiz:codeliste:bnotk.empfangstyp.ztr.bw', 'urn:de:xauslaender:codelist:bamfabh:asyl:personendaten:aenderungsgrund', 'urn:de:xauslaender:codelist:bamfabh:int:auskunftnichtmoeglich', 'urn:xoev-de:xjustiz:codeliste:bnotk.mitteilungstyp.ztr.bw', 'urn:de:xauslaender:codelist:azr:arteinschraenkungpolitischebetaetigung', 'urn:de:xauslaender:codelist:azr:artpassrechtlichemassnahmen', 'urn:de:xauslaender:codelist:azr:artpersonalie', 'urn:de:xauslaender:codelist:dokumentformat', 'urn:de:xauslaender:codelist:familienstand', 'urn:de:xauslaender:codelist:fehlercodes:synchron', 'urn:de:xauslaender:codelist:gericht', 'urn:de:xauslaender:codelist:int:behoerdentyp', 'urn:de:xauslaender:codelist:azr:artueberwachungsmassnahme', 'urn:de:xauslaender:codelist:mbabh:abmeldung', 'urn:de:xauslaender:codelist:mbauskunftssperre', 'urn:de:xauslaender:codelist:nebenbestimmungen:beschaeftigung', 'urn:xoev-de:xjustiz:codeliste:bnotk.urkunde.status.ztr', 'urn:de:xauslaender:codelist:nebenbestimmungen:bildungsweg', 'urn:xoev-de:xjustiz:codeliste:grbu.belastungsart.abtiii', 'urn:de:xauslaender:codelist:nebenbestimmungen:erloeschen', 'urn:de:xauslaender:codelist:nebenbestimmungen:oertlichebeschraenkung', 'urn:xoev-de:bund:kba:codeliste:quittungsebene', 'urn:de:xauslaender:codelist:nebenbestimmungen:selbstaendig', 'urn:de:xauslaender:codelist:religion', 'urn:xoev-de:xjustiz:codeliste:grbu.dokumentart', 'urn:de:xauslaender:codelist:vertretungsart', 'urn:xoev-de:xjustiz:codeliste:grbu.rang', 'urn:de:xauslaender:codelist:vonamtswegen', 'urn:de:xauslaender:codelist:wohnungsstatus', 'urn:de:xauslaender:codelist:azr:artzurueckweisungzurueckschiebung', 'urn:xoev-de:xjustiz:codeliste:grbu.rollenbezeichnung', 'urn:xoev-de:bund:kba:codeliste:statuselektronischerantrag', 'urn:de:xwaffe:codelisten:herstellerbezeichnungsammlung', 'urn:xoev-de:xauslaender:codeliste:asyl:datenberichtigungsanlass', 'urn:xoev-de:xjustiz:codeliste:reg.besondere-befreiung', 'urn:xoev-de:xauslaender:codeliste:asyl:einstellungsgrund', 'urn:xoev-de:xjustiz:codeliste:reg.dokumentart', 'urn:xoev-de:xauslaender:codeliste:asyl:fortfuehrungsantragart', 'urn:xoev-de:xauslaender:codeliste:asyl:prognosefolgeantrag', 'urn:de:xauslaender:codelist:azr:asylstatus', 'urn:xoev-de:xauslaender:codeliste:asyl:ruecknahmegrund', 'urn:de:bund:bzst:schluessel:rts.fehlercodes', 'urn:de:xauslaender:codelist:azr:aufenthaltserlaubnis', 'urn:de:xauslaender:codelist:azr:aufenthaltsgestattung', 'urn:xoev-de:xjustiz:codeliste:reg.dokumentstatus', 'urn:de:xauslaender:codelist:azr:dokumentenformat', 'urn:de:xauslaender:codelist:azr:dokumenttyp', 'urn:de:xauslaender:codelist:azr:entscheidungba', 'urn:de:xauslaender:codelist:azr:euaufenthaltsrecht', 'urn:de:xauslaender:codelist:azr:familienbeziehung', 'urn:de:xauslaender:codelist:azr:gesundheitsdatenart', 'urn:de:xauslaender:codelist:azr:graddersprachkenntnis', 'urn:de:xauslaender:codelist:azr:trefferkategorie', 'urn:de:xauslaender:codelist:azr:lichtbildgroesse', 'urn:de:dsmeld:schluesseltabelle:auskunftssperre', 'urn:de:xauslaender:codelist:azr:meldestatusart', 'urn:de:xauslaender:codelist:azr:artderfestnahmeaufenthaltsermittlung', 'urn:de:xauslaender:codelist:azr:nebenbestimmungerwerbstaetigkeit', 'urn:de:xauslaender:codelist:azr:rechtsstellung', 'urn:xoev-de:xjustiz:codeliste:reg.rollenbezeichnung', 'urn:xoev-de:xjustiz:codeliste:reg.status-rechtstraeger', 'urn:de:xauslaender:codelist:azr:sicherheitsleistung', 'urn:de:dsmeld:schluesseltabelle:staatsangehoerigkeit.glaubhaftmachung', 'urn:de:xauslaender:codelist:azr:sicherheitsrechtlichebefragung', 'urn:de:xauslaender:codelist:azr:sichtbarkeitdessuchvermerks', 'urn:de:xauslaender:codelist:azr:suchprofil', 'urn:xoev-de:bund:kba:codeliste:typdergebuehrenaufstellung', 'urn:de:xauslaender:codelist:azr:suchvermerk', 'urn:xoev-de:bund:kba:codeliste:typdesidentifikationsdokuments', 'urn:de:xauslaender:codelist:azr:uebermittlungssperre', 'urn:de:xauslaender:codelist:azr:unerlaubteeinreiseundaufenthaltart', 'urn:de:xauslaender:codelist:azr:verfuegungstextstatus', 'urn:xoev-de:bund:kba:codeliste:versandart', 'urn:de:xauslaender:codelist:azr:zustimmungsfreiebeschaeftigung', 'urn:xoev-de:bund:kba:xkfz:codeliste:statusprozessschritt', 'urn:de:bund:bfj:schluesseltabelle:anerkennungsform.sonstige', 'urn:de:bund:bfj:schluesseltabelle:anerkennungsform.ueberbeglaubigung', 'urn:de:bund:bfj:schluesseltabelle:fuehrungszeugnis.anfrageart', 'urn:de:bund:bfj:schluesseltabelle:fuehrungszeugnis.gebuehr', 'urn:de:xmeld:schluesseltabelle:antwortstatus', 'urn:de:xmeld:schluesseltabelle:azr.anlass', 'urn:de:xmeld:schluesseltabelle:behoerdenauskunft.aktualitaet.suche.status', 'urn:de:xmeld:schluesseltabelle:behoerdenauskunft.ergebnisstatus', 'urn:de:xmeld:schluesseltabelle:lra.aenderung.anlass', 'urn:de:xmeld:schluesseltabelle:behoerdenauskunft.nichterstellung.grund', 'urn:de:xmeld:schluesseltabelle:bzst.anforderung.idnr', 'urn:xoev-de:xdomea:codeliste:aussonderungsart', 'urn:de:xmeld:schluesseltabelle:bzst.antwort.idnr-ehegatte-lebenspartner', 'urn:de:xmeld:schluesseltabelle:bzst.beendigung.der.zustaendigkeit', 'urn:de:xmeld:schluesseltabelle:bzst.hinweis.auf.inkonsistenz', 'urn:de:xmeld:schluesseltabelle:bzst.hinweis.auf.inkonsistenz.rolle.beteiligte.person', 'urn:de:xmeld:schluesseltabelle:dsrv.anlass.bruttolieferung', 'urn:de:xmeld:schluesseltabelle:ehegatte.oder.lebenspartner', 'urn:de:xmeld:schluesseltabelle:fortschreibung.datenuebermittlungsanlaesse.fachspezifisch', 'urn:de:xmeld:schluesseltabelle:melderegister.abweichung', 'urn:de:xmeld:schluesseltabelle:melderegisterauskunft.ergebnisstatus', 'urn:de:xmeld:schluesseltabelle:melderegisterauskunft.nichterstellung.grund', 'urn:de:xmeld:schluesseltabelle:melderegisterauskunft.optionen', 'urn:de:xmeld:schluesseltabelle:melderegisterauskunft.zusatzinformation', 'urn:de:xmeld:schluesseltabelle:mime-type', 'urn:de:xmeld:schluesseltabelle:partnerdaten.anlass.der.fortschreibung', 'urn:de:xmeld:schluesseltabelle:partnerschaftsinformation', 'urn:de:xmeld:schluesseltabelle:quittung.ebene', 'urn:de:xmeld:schluesseltabelle:ruecksendung.einer.nachricht', 'urn:de:xmeld:schluesseltabelle:stornierung', 'urn:de:xmeld:schluesseltabelle:vorausgefuellter.meldeschein.antwortstatus', 'urn:de:xmeld:schluesseltabelle:xmeld.datenuebermittlungsanlaesse', 'urn:de:xmeld:schluesseltabelle:xmeldit.art.der.untersuchung', 'urn:de:xmeld:schluesseltabelle:xmeldit.konsequenz.fehler', 'urn:xoev-de:xdomea:codeliste:datentyp', 'urn:xoev-de:xmeld:codeliste:xmeld.fortschreibung.aenderungsart', 'urn:xoev-de:xmeld:codeliste:xmeld.kirche.hintergrundinformation', 'urn:de:xauslaender:codelist:azr:artdesanlassesderausschreibung', 'urn:xoev-de:bund:kba:codeliste:artdergebuehr', 'urn:xoev-de:xdomea:codeliste:konfigurationsparametergruppe', 'urn:de:xauslaender:codelist:azr:artderausschreibung', 'urn:xoev-de:xdomea:codeliste:schriftgutobjekttyp', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0601', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0603', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0605', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0608', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0610', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0611', 'urn:xoev-de:xjustiz:codeliste:reg.mitteilungsart', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0613', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0614', 'urn:xoev-de:xbau:codeliste:xbau-fehlerkennzahlen', 'urn:de:bund:kba:xkfz:codeliste:typderreferenz', 'urn:de:bund:kba:xkfz:codeliste:typderreferenzdatei', 'urn:de:bund:kba:xkfz:codeliste:typderuntersuchung', 'urn:de:bund:kba:xkfz:codeliste:typdeskontakts', 'urn:de:bund:kba:xkfz:codeliste:versandart', 'urn:de:bund:kba:xkfz:codeliste:xkfzkommunikationspartner', 'urn:de:bund:kba:xkfz:codeliste:waehrung', 'urn:de:dsmeld:schluesseltabelle:anschrift.unbekannt', 'urn:de:dsmeld:schluesseltabelle:familienstand', 'urn:de:dsmeld:schluesseltabelle:familienstand.beendigungsgrund', 'urn:de:dsmeld:schluesseltabelle:gesetzlicher.vertreter', 'urn:de:dsmeld:schluesseltabelle:geschlecht', 'urn:de:dsmeld:schluesseltabelle:passversagung.status', 'urn:de:dsmeld:schluesseltabelle:religion.steuererhebend', 'urn:de:dsmeld:schluesseltabelle:wahlausschluss', 'urn:de:dsmeld:schluesseltabelle:wohnungsart', 'urn:de:dsmeld:schluesseltabelle:wohnungsstatus', 'urn:de:fim:leika:modul', 'urn:de:fim:leika:verrichtung', 'urn:de:gkleika:leika:leistungsgruppierung', 'urn:de:gkleika:leika:typisierung', 'urn:de:xauslaender:codelist:aufenthaltsstatusart', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0618', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0619', 'urn:xoev-de:xauslaender:codeliste:sprachenkatalog', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0622', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:bundesland', 'urn:de:xauslaender:codelist:azr:verpflichtungserklaerung', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0627', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0628', 'urn:xoev-de:xdomea:codeliste:spezifischefehlermeldung0632', 'urn:xoev-de:fim:codeliste:ozg-themenfeld', 'urn:xoev-de:xgewerbeanzeige:codeliste:artdermeldung', 'urn:xoev-de:xgewerbeanzeige:codeliste:artderniederlassung', 'urn:xoev-de:xgewerbeanzeige:codeliste:funktioneinerperson', 'urn:xoev-de:xgewerbeanzeige:codeliste:grundfuerabmeldung', 'urn:de:xauslaender:codelist:nachrichtentyp', 'urn:de:xauslaender:codelist:bamftgs:int:verkuerzennichtmoeglich', 'urn:de:xfalldaten:kommunikationskanal', 'urn:de:xmeld:schluesseltabelle:melderegisterauskunft.gewerblicher.zweck', 'urn:de:xmeld:schluesseltabelle:rueckweisungsgrund', 'urn:de:xoev:codeliste:erreichbarkeit', 'urn:de:xoev:codeliste:koordinatensystemtyp', 'urn:de:xprozess:codeliste:modellierungsmethode', 'urn:de:bund:kba:xkfz:codeliste:sucheinschraenkungkennzeichen', 'urn:de:bund:kba:xkfz:codeliste:rechtsgrundlagehalterauskunft', 'urn:de:xprozess:codeliste:zwecksetzung', 'urn:de:xta:codeliste:business.scenario', 'urn:de:xta:codeliste:report.type', 'urn:de:xta:codeliste:type.of.party.identifier', 'urn:de:bund:kba:xkfz:codeliste:nutzungbankverbindung', 'urn:de:bund:kba:xkfz:codeliste:statusgutachten', 'urn:de:bund:kba:xkfz:codeliste:typdesidentifikationsdokuments', 'urn:de:xzufi:codeliste:zustaendigkeitsrolle', 'urn:eu:commission:regulation:105:2007:nuts:nuts-1', 'urn:xoev-de:bund:bamf:codeliste:integration:fehlercodes:synchron.spezifisch', 'urn:xoev-de:xbau:codeliste:baulicheanlagen.sonstige', 'urn:de:xauslaender:codelist:bamfabh:int:kursart', 'urn:xoev-de:bund:bamf:codeliste:asyl:bamfaussenstellen', 'urn:de:xauslaender:codelist:azr:artdergrenzfahndung', 'urn:de:bund:bamf:codelist:integration:ablehnungsgrund', 'urn:de:xauslaender:codelist:bamfabh:integration:artberechtigung', 'urn:de:xauslaender:codelist:azr:artdesanlassesdergrenzfahndung', 'urn:xoev-de:kosit:codeliste:icd', 'urn:de:xauslaender:codelist:bamfabh:int:verpflichtungnichtmoeglich', 'urn:de:xauslaender:codelist:integration:ba.dienststellen', 'urn:de:bund:bamf:codelist:berd:fehlercode', 'urn:de:bund:bamf:codelist:berd:dublettenverdacht', 'urn:de:bund:bamf:codelist:berd:ablehnungsgrund', 'urn:de:bund:bamf:codelist:berd:aufenthaltsstatus', 'urn:xoev-de:bund:bmj:codeliste:fundstellennachweis.bund.a', 'urn:de:bund:bamf:codelist:berd:modulart', 'urn:xoev-de:bund:destatis:codeliste:xmeld.zensus.rueckweisung-fehlercodes', 'urn:xoev-de:bund:destatis:codeliste:xmeld.zenus.rueckweisung-fehlercodes', 'urn:xoev-de:bund:kba:codeliste:artdermonetaereneinnahme', 'urn:xoev-de:bund:kba:codeliste:artderumruestung', 'urn:xoev-de:bund:kba:codeliste:artderunterlage', 'urn:xoev-de:bund:kba:codeliste:artderuntersuchung', 'urn:xoev-de:bund:kba:codeliste:artderzahlung', 'urn:xoev-de:bund:kba:codeliste:auskunftsmedium', 'urn:xoev-de:bund:kba:codeliste:kbaarbeitsgang', 'urn:xoev-de:bund:kba:codeliste:kurzzeichenherstellerdruckstuecke', 'urn:xoev-de:bund:kba:codeliste:lieferdienst', 'urn:xoev-de:bund:kba:codeliste:nutzungbankverbindung', 'urn:xoev-de:bund:kba:codeliste:prozessschrittname', 'urn:xoev-de:bund:kba:codeliste:prueforganisation', 'urn:xoev-de:bund:kba:codeliste:quittungsart', 'urn:de:bund:bamf:codelist:berd:artbeschaeftigung', 'urn:xoev-de:bund:kba:codeliste:rechtsgrundlagehalterauskunft', 'urn:xoev-de:bund:kba:codeliste:rolle', 'urn:de:xpersonenstand:codeliste:staat', 'urn:de:xpersonenstand:codeliste:staatsangehoerigkeit', 'urn:xoev-de:bund:kba:codeliste:statuselektronischerantragauskunft', 'urn:xpersonenstand:schluesseltabelle:aufenthaltsstatus', 'urn:xpersonenstand:schluesseltabelle:beendigungsgrundfamilienstand', 'urn:xpersonenstand:schluesseltabelle:beschlussart', 'urn:xpersonenstand:schluesseltabelle:bestattungsart', 'urn:xpersonenstand:schluesseltabelle:familienstand', 'urn:xpersonenstand:schluesseltabelle:familienstandpersonenstandswesen', 'urn:xpersonenstand:schluesseltabelle:geschlecht', 'urn:xpersonenstand:schluesseltabelle:namensart', 'urn:xpersonenstand:schluesseltabelle:registerart', 'urn:xpersonenstand:schluesseltabelle:wahlehename', 'urn:xpersonenstand:schluesseltabelle:wahllpname', 'urn:xoev-de:bund:kba:codeliste:statusgutachten', 'urn:xoev-de:bund:kba:codeliste:sucheinschraenkungkennzeichen', 'urn:xoev-de:bund:kba:codeliste:systemcode', 'urn:xoev-de:bund:kba:codeliste:typderreferenzdatei', 'urn:xoev-de:bund:kba:codeliste:typderuntersuchung', 'urn:xoev-de:bund:kba:codeliste:typdesdokuments', 'urn:xoev-de:bund:kba:codeliste:typdeskennzeichens', 'urn:xoev-de:bund:kba:codeliste:typdeskontakts', 'urn:xoev-de:bund:kba:codeliste:waehrung', 'urn:de:bund:bamf:codelist:berd:artberechtigungverpflichtung', 'urn:xoev-de:bund:kba:xkfz:codeliste:herstellerdruckstuecke', 'urn:xoev-de:bund:kba:xkfz:codeliste:steuerzahlweise', 'urn:xoev-de:kirche:codeliste:xmeld.kirchen.rts-fehlercodes', 'urn:xoev-de:kosit:codeliste:handwerkskammern', 'urn:xoev-de:stala:codeliste:xmeld.statistik.bevstatg.rueckweisung-fehlercodes', 'urn:xoev-de:xbau:codeliste:erleichterung.gegenstand', 'urn:xoev-de:xdomea:codeliste:allgemeinerueckmeldung', 'urn:xoev-de:xbau:codeliste:xbau-mimetypes', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:synopse-gebiete', 'urn:xoev-de:bund:kba:codeliste:kba-arbeitsgang', 'urn:xoev-de:kosit:codeliste:eas', 'urn:xoev-de:bund:kba:codeliste:typderreferenz', 'urn:xoev-de:bund:kba:codeliste:quittungscode', 'urn:xoev-de:fim:codeliste:sdginformationsbereich', 'urn:xoev-de:fim:codeliste:ozg-lage', 'urn:xoev-de:fim:codeliste:ozg-leistung', 'urn:xoev-de:xgewerbeanzeige:codeliste:grundfuerummeldung', 'urn:de:dvzmv:codelisten:verarbeitung', 'urn:xoev-de:xgewerbeanzeige:codeliste:handwerkskammern', 'urn:xoev-de:fim:codeliste:onlinedienstlinktyp', 'urn:de:dvzmv:nwr:codelisten:verarbeitung', 'urn:xoev-de:fim:codeliste:identifizierungsmittel', 'urn:xoev-de:bund:kba:codeliste:nachrichtentypen', 'urn:de:xauslaender:codelist:azr:artdesausweispruefungsergebnis', 'urn:de:xauslaender:codelist:azr:wohnsitzauflage', 'urn:de:xauslaender:codelist:azr:artdeseinreiseaufenthaltsverbots', 'urn:de:xauslaender:codelist:azr:artderabschiebung', 'urn:de:xauslaender:codelist:azr:artdesausreisenachweis', 'urn:de:xauslaender:codelist:azr:artderausweisung', 'urn:de:xauslaender:codelist:azr:artderausreisefoerderung', 'urn:de:xauslaender:codelist:azr:artdesabschiebungsverbots', 'urn:xoev-de:xjustiz:codeliste:bnotk.dokumententyp.ztr.bw', 'urn:xoev-de:xjustiz:codeliste:bnotk.registrierung.status.ztr.bw', 'urn:xoev-de:xauslaender:codeliste:asyl:abschlusssachverhalt', 'urn:de:xauslaender:codelist:volkszugehoerigkeit', 'urn:de:xauslaender:codelist:azr:niederlassungserlaubnis', 'urn:xoev-de:xjustiz:codeliste:grbu.berechtigungsveraeltnis', 'urn:de:xauslaender:codelist:azr:aufenthaltsstatus', 'urn:xoev-de:xjustiz:codeliste:grbu.berechtigungsverhaeltnis', 'urn:xoev-de:bund:kba:codeliste:stba', 'urn:de:fim:leika:leistungsgruppierung', 'urn:xoev-de:xauslaender:codeliste:asyl:teilabschlusssachverhalt', 'urn:xoev-de:bund:bmi:bit:codeliste:dvdv.praefix', 'urn:xoev-de:bund:bva:azr:codeliste:xmeld.fachliche-fehlercodes', 'urn:xoev-de:fim:codeliste:xzufi.anschrifttyp', 'urn:xoev-de:fim:codeliste:xzufi.begriffimkontexttyp', 'urn:xoev-de:xbau:codeliste:abweichungart', 'urn:xoev-de:fim:codeliste:xzufi.fristtyp', 'urn:xoev-de:xbau:codeliste:baumassnahme', 'urn:xoev-de:xbau:codeliste:bautechnischernachweisart', 'urn:xoev-de:xbau:codeliste:bauvorlageberechtigungsachverhalt', 'urn:xoev-de:fim:codeliste:xzufi.hierarchietyp', 'urn:xoev-de:xbau:codeliste:bauweise', 'urn:xoev-de:xbau:codeliste:beteiligungrolle', 'urn:xoev-de:fim:codeliste:xzufi.kostentyp', 'urn:xoev-de:xbau:codeliste:formellebefundeantragart', 'urn:xoev-de:fim:codeliste:xzufi.leistungsadressat', 'urn:xoev-de:xbau:codeliste:genehmigungsfreistellung', 'urn:xoev-de:fim:codeliste:xzufi.nachrichtantwortcode', 'urn:xoev-de:xbau:codeliste:mbogaragentyp', 'urn:xoev-de:xbau:codeliste:mbogebaeudeklasse', 'urn:xoev-de:fim:codeliste:xzufi.onlinedienstdynamischerparametertyp', 'urn:xoev-de:fim:codeliste:xzufi.signatur', 'urn:xoev-de:xbau:codeliste:mbosonderbauten', 'urn:xoev-de:xbau:codeliste:mppvobauwerksklasse', 'urn:xoev-de:fim:codeliste:xzufi.tagesposition', 'urn:xoev-de:fim:codeliste:xzufi.tagestyp', 'urn:xoev-de:xbau:codeliste:mppvonachpruefunggrund', 'urn:xoev-de:fim:codeliste:xzufi.zeiteinheit', 'urn:xoev-de:xbau:codeliste:mppvopruefungtechnischeanlageanlass', 'urn:xoev-de:xbau:codeliste:mppvotechnischeanlageweiterbetrieb', 'urn:xoev-de:fim:codeliste:xzufi.zeitserientyp', 'urn:xoev-de:xbau:codeliste:nebenbestimmungart', 'urn:xoev-de:fim:codeliste:xzufi.zustaendigkeitskriterium', 'urn:xoev-de:xbau:codeliste:statistikmeldunganlass', 'urn:xoev-de:xbau:codeliste:vorbescheidbetreff', 'urn:xoev-de:xbau:codeliste:vorlagenbauantragbauvorhaben', 'urn:xoev-de:xbau:codeliste:vorlagenbauantragbearbeitung', 'urn:xoev-de:xbau:codeliste:vorlagenbauzustand', 'urn:xoev-de:xbau:codeliste:xbau-nachrichten', 'urn:xoev-de:xfim:codeliste:xzufi.leistungsklasse', 'urn:xoev-de:kosit:codeliste:rec21', 'urn:de:xauslaender:codelist:int:abschlusstestartsprache', 'urn:xoev-de:kosit:codeliste:currency-codes', 'urn:de:xauslaender:codelist:int:abschlusstestdatensprache', 'urn:xoev-de:kosit:codeliste:vatex', 'urn:xoev-de:kosit:codeliste:untdid.1001', 'urn:de:xauslaender:codelist:int:abschlusstestergebnisinterpretation', 'urn:xoev-de:kosit:codeliste:untdid.1153', 'urn:xoev-de:kosit:codeliste:untdid.2005', 'urn:xoev-de:kosit:codeliste:untdid.4451', 'urn:xoev-de:kosit:codeliste:untdid.5189', 'urn:xoev-de:kosit:codeliste:untdid.5305', 'urn:xoev-de:kosit:codeliste:untdid.7143', 'urn:xoev-de:kosit:codeliste:mime-type-xrechnung', 'urn:xoev-de:kosit:codeliste:rec20', 'urn:xoev-de:kosit:codeliste:untdid.7161', 'urn:xoev-de:bund:bfj:codeliste:bfjstaat', 'urn:xoev-de:kosit:codeliste:country-codes', 'urn:xoev-de:bund:bfj:codeliste:bfj.berichtigungart', 'urn:xoev-de:bund:bfj:codeliste:bfj.staat', 'urn:xoev-de:bund:bfj:codeliste:bfj.fehlerkennzahl', 'urn:de:xauslaender:codelist:azr:artderduldung', 'urn:xoev-de:bund:bfj:codeliste:bfj.geschlecht', 'urn:xoev-de:xgewerbeanzeige:codeliste:schematron-fehlercodes', 'urn:xoev-de:bund:bfj:codeliste:bfj.uebermittelndestelle', 'urn:xoev-de:bund:bfj:codeliste:bfj.waehrung', 'urn:xoev-de:xgewerbeanzeige:codeliste:beteiligungoeffentlichehand', 'urn:xoev-de:bund:bfj:codeliste:bzr.behoerdenfuehrungszeugnisgrund', 'urn:de:xauslaender:codelist:azr:sachverhaltsgruppe', 'urn:xoev-de:bund:bfj:codeliste:bzr.benachrichtigunggrund', 'urn:xoev-de:bund:bfj:codeliste:bzr.freiheitsentziehungart', 'urn:de:bund:ba:codelist:integration:ba.dienststellen', 'urn:xoev-de:bund:bfj:codeliste:bfj.gebuehrenbefreiunggrund', 'urn:xoev-de:bund:bfj:codeliste:bzr.hinweisanlass', 'urn:xoev-de:bund:bfj:codeliste:bzr.hinweisart', 'urn:xoev-de:xgewerbeanzeige:codeliste:laenderkennziffern', 'urn:xoev-de:xgewerbeanzeige:codeliste:status', 'urn:xoev-de:xgewerbeanzeige:codeliste:unfallversicherungstraeger', 'urn:xoev-de:xgewerbeanzeige:codeliste:verdachtsmomente', 'urn:xoev-de:xgewerbeanzeige:codeliste:ursachefuerabmeldung', 'urn:xoev-de:xgewerbeanzeige:codeliste:weiterekommunikationspartner', 'urn:xoev-de:xjustiz:codeliste:bnotk.dokumententyp.ztr', 'urn:xoev-de:bund:bfj:codeliste:bzr.identitaetsdokumentart', 'urn:xoev-de:xjustiz:codeliste:bnotk.mitteilungstyp.ztr', 'urn:xoev-de:xjustiz:codeliste:bnotk.registrierung.status.ztr', 'urn:xoev-de:bund:bfj:codeliste:bzr.textkennzahl', 'urn:de:xauslaender:codelist:azr:artdereinreisebedenken', 'urn:xoev-de:xjustiz:codeliste:bnotk.vorgangsart.ztr', 'urn:xoev-de:xjustiz:codeliste:bnotk.urkunde.status.ztr.bw', 'urn:xoev-de:xjustiz:codeliste:grbu.auszugsart', 'urn:xoev-de:xjustiz:codeliste:bnotk.vorgangsart.ztr.bw', 'urn:xoev-de:xjustiz:codeliste:grbu.belastungsart.abtii', 'urn:de:xauslaender:codelist:azr:deutschestaatsangehoerigkeitart', 'urn:xoev-de:xjustiz:codeliste:grbu.ereignis', 'urn:xoev-de:mv:em:codeliste:xprozess:handlungsgrundlagenart', 'urn:xoev-de:bund:bfj:codeliste:gzr.verwendungszweckbehoerdenvorlage', 'urn:xoev-de:xjustiz:codeliste:grbu.veraenderungen.abtii', 'urn:xoev-de:xjustiz:codeliste:grbu.veraenderungen.abtiii', 'urn:xoev-de:bund:bfj:codeliste:gzr.gewerbeart', 'urn:xoev-de:xjustiz:codeliste:reg.allgemeine-befreiung', 'urn:xoev-de:xjustiz:codeliste:reg.allgemeine-vertretungsregelung', 'urn:xoev-de:xjustiz:codeliste:reg.besondere-vertretungsregelung', 'urn:xoev-de:xjustiz:codeliste:reg.eintragungsart', 'urn:xoev-de:xjustiz:codeliste:reg.rechtsform', 'urn:xoev-de:xjustiz:codeliste:reg.mitteilungsgsart', 'urn:xoev-de:bund:bfj:codeliste:gzr.gewerbeschluessel', 'urn:xoev-de:xjustiz:codeliste:reg.sachliche-erweiterung-prokura', 'urn:xoev-de:xpersonenstandsregister:codeliste:geschlecht', 'urn:xoev-de:xpersonenstand:codelist:nachrichtentyp', 'urn:xoev-de:xrechnung:codeliste:untdid.4461', 'urn:xoev-de:bund:bfj:codeliste:gzr.rechtsform', 'urn:xoev-de:bund:bfj:codeliste:gzr.oeffentlichesregister', 'urn:xoev-de:bund:bfj:codeliste:gzr.rechtsvorschriften', 'urn:de:bund:bamf:codelist:integration:nachfragegrund', 'urn:de:bund:bfj:schluesseltabelle:behoerdenkennzeichen', 'urn:de:bund:bfj:schluesseltabelle:fuehrungszeugnis.verwendungszweck', 'urn:de:bund:bfj:schluesseltabelle:justizbehoerdenkennzeichen', 'urn:xoev-de:bund:bfj:codeliste:nachrichtencode.bzr.anfrageaehnlichenservice', 'urn:de:bund:bmi:meldewesen:schluessel:religion_nicht_steuererhebend', 'urn:de:bund:bmi:meldewesen:schluessel:religion_steuererhebend', 'urn:de:bund:bzst:schluessel:fachliche.fehlercodes', 'urn:xoev-de:xgewerbeanzeige:codeliste:rueckweisungsgruende', 'urn:xoev-de:bund:bfj:codeliste:gzr.textkennzahl', 'urn:xoev-de:bund:bfj:codeliste:nachrichtencode.bzr.anfrageunbeschraenkteauskunft', 'urn:xoev-de:bund:bfj:codeliste:nachrichtencode.bzr.antragbehoerdenfuehrungszeugnis', 'urn:de:bund:kba:xkfz:codeliste:artderbremse', 'urn:xoev-de:bund:bfj:codeliste:nachrichtencode.bzr.antragprivatfuehrungszeugnis', 'urn:xoev-de:bund:bfj:codeliste:nachrichtencode.gzr.anfragebetroffeneperson', 'urn:xoev-de:bund:bfj:codeliste:nachrichtencode.bzr.auskunft', 'urn:xoev-de:bund:bfj:codeliste:nachrichtencode.bzr.mitteilung', 'urn:xoev-de:bund:bfj:codeliste:nachrichtencode.gzr.anfrageoeffentlichestelle', 'urn:xoev-de:bund:bfj:codeliste:nachrichtencode.gzr.auskunft', 'urn:xoev-de:bund:bfj:codeliste:nachrichtencode.gzr.mitteilung', 'urn:xoev-de:bund:bfj:codeliste:xbfj-nachrichten', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:kreis', 'urn:xoev-de:bund:bfj:codeliste:bfj.verwendungszweckauskunft', 'urn:xoev-de:bund:bfj:codeliste:bfj.behoerde', 'urn:xoev-de:bund:kba:codeliste:xkfzkommunikationspartner', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:staatsangehoerigkeit', 'urn:de:bund:kba:xkfz:codeliste:artderumruestung', 'urn:de:bund:kba:xkfz:codeliste:artderunterlage', 'urn:de:bund:kba:xkfz:codeliste:artderuntersuchung', 'urn:de:bund:kba:xkfz:codeliste:artderzahlung', 'urn:de:bund:kba:xkfz:codeliste:artdesgeschaeftsvorfalls', 'urn:de:bund:kba:xkfz:codeliste:artdesgutachtens', 'urn:de:bund:kba:xkfz:codeliste:auskunftsmedium', 'urn:de:bund:kba:xkfz:codeliste:datengruppenregistersatz', 'urn:de:bund:kba:xkfz:codeliste:ergebnisderuntersuchung', 'urn:de:bund:kba:xkfz:codeliste:kba-arbeitsgang', 'urn:de:bund:kba:xkfz:codeliste:kennzeichenformat', 'urn:de:bund:kba:xkfz:codeliste:lieferdienst', 'urn:de:bund:kba:xkfz:codeliste:nachrichtentyp', 'urn:de:bund:kba:xkfz:codeliste:positionderbremse', 'urn:de:bund:kba:xkfz:codeliste:prueforganisation', 'urn:de:bund:kba:xkfz:codeliste:artdergebuehr', 'urn:de:bund:kba:xkfz:codeliste:artdermonetaereneinnahme', 'urn:de:bund:kba:xkfz:codeliste:artderuntersuchungsstelle', 'urn:de:xwaffe:codelisten:abfragegrund', 'urn:de:xwaffe:codelisten:aktivitaet', 'urn:de:xwaffe:codelisten:anschrifttyp', 'urn:de:xwaffe:codelisten:artabhandenkommen', 'urn:de:xwaffe:codelisten:artaustausch', 'urn:de:xwaffe:codelisten:bearbeitungunbrauchbarmachung', 'urn:de:xwaffe:codelisten:bedeutung', 'urn:de:xwaffe:codelisten:beduerfnisgrund', 'urn:de:xwaffe:codelisten:behoerdenstatus', 'urn:de:xwaffe:codelisten:dokumentstatus', 'urn:de:xwaffe:codelisten:erlaubnisstatus', 'urn:de:xwaffe:codelisten:erlaubnistyp', 'urn:de:xwaffe:codelisten:erstregistrierungsart', 'urn:de:xwaffe:codelisten:erwerbsart', 'urn:de:xwaffe:codelisten:fehlerartregister', 'urn:de:bund:kba:xkfz:codeliste:artdesdokuments', 'urn:de:xwaffe:codelisten:fehlerklassekopfstelle', 'urn:de:xwaffe:codelisten:fehlernummerkopfstelle', 'urn:de:xwaffe:codelisten:geschlecht', 'urn:de:xwaffe:codelisten:hinweisart', 'urn:de:xwaffe:codelisten:kommunikationskanal', 'urn:de:xwaffe:codelisten:meldungsart', 'urn:de:xwaffe:codelisten:munitionsarten', 'urn:de:xwaffe:codelisten:objekttyp', 'urn:de:xwaffe:codelisten:personenrolle', 'urn:de:bund:kba:xkfz:codeliste:artdesmandats', 'urn:de:xwaffe:codelisten:personobjektstatus', 'urn:de:xwaffe:codelisten:suchebestand', 'urn:de:xwaffe:codelisten:suchprofil', 'urn:de:bund:kba:xkfz:codeliste:artdessiegels', 'urn:de:xwaffe:codelisten:transaktionsstatus', 'urn:de:xwaffe:codelisten:ueberlassungsabsicht', 'urn:de:xwaffe:codelisten:ueberlassungsart', 'urn:de:xwaffe:codelisten:ueberlassungsstatus', 'urn:de:xwaffe:codelisten:voreintragstatus', 'urn:de:xwaffe:codelisten:waffenkategorie', 'urn:de:bund:kba:xkfz:codeliste:codedessystems', 'urn:de:xwaffe:codelisten:waffenstatus', 'urn:de:xwaffe:codelisten:waffentechnischeausfuehrung', 'urn:de:xwaffe:codelisten:waffentrageberechtigungsart', 'urn:de:xwaffe:codelisten:waffentypanlage1', 'urn:de:xwaffe:codelisten:waffentypfeingliederung', 'urn:de:xwaffe:codelisten:waffenverbotsart', 'urn:de:xwaffe:codelisten:waffenverweisstatus', 'urn:de:xwaffe:codelisten:waffewaffenteil', 'urn:de:xwaffe:codelisten:wesentlicheswaffenteil', 'urn:de:xwaffe:codelisten:zuordnungsart', 'urn:de:xwaffe:codelisten:zustaendigebehoerdestatus', 'urn:de:bund:kba:xkfz:codeliste:herstellerdruckstuecke', 'urn:de:xauslaender:codelist:abhkennung', 'urn:de:bund:kba:xkfz:codeliste:kurzzeichenherstellerdruckstuecke', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:bezirk', 'urn:xoev-de:bund:bmi:bit:codeliste:dvdv.behoerdenschluessel', 'urn:de:bund:kba:xkfz:codeliste:nummerderfeinstaubplakette', 'urn:de:bund:kba:xkfz:codeliste:prozessschrittname', 'urn:de:bund:kba:xkfz:codeliste:quittungsart', 'urn:xoev-de:mv:em:xprozess:codeliste:handlungsgrundlagenart', 'urn:de:bund:kba:xkfz:codeliste:quittungscode', 'urn:xoev-de:xprozess:codeliste:entscheidungsart', 'urn:xoev-de:xprozess:codeliste:verfahrensart', 'urn:de:xprozess:codeliste:uebermittlungsart', 'urn:xoev-de:xprozess:codeliste:uebermittlungsart', 'urn:xoev-de:xprozess:codeliste:beteiligungsform', 'urn:de:xprozess:codeliste:detaillierungsstufe', 'urn:xoev-de:xprozess:codeliste:detaillierungsstufe', 'urn:de:xprozess:codeliste:handlungsform', 'urn:xoev-de:xprozess:codeliste:handlungsform', 'urn:de:xprozess:codeliste:operativesziel', 'urn:xoev-de:xprozess:codeliste:operativesziel', 'urn:xoev-de:xprozess:codeliste:zwecksetzung', 'urn:xoev-de:xprozess:codeliste:bearbeitungsart', 'urn:xoev-de:xprozess:codeliste:formellepruefung', 'urn:xoev-de:xprozess:codeliste:prozessrolle', 'urn:de:bund:kba:xkfz:codeliste:statusprozessschritt', 'urn:xoev-de:xprozess:codeliste:status', 'urn:xoev-de:xprozess:codeliste:modellierungsmethode', 'urn:xoev-de:xprozess:codeliste:ausfertigungsform', 'urn:xoev-de:xprozess:codeliste:schriftformfunktion', 'urn:xoev-de:xprozess:codeliste:referenzaktivitaetengruppe', 'urn:xoev-de:xprozess:codeliste:referenzaufgabe', 'urn:xoev-de:fim:codeliste:vertrauensniveau', 'urn:xoev-de:xbau:codeliste:bauwerte.gebaeudearten', 'urn:xoev-de:xbau-nw:codeliste:technischeanlage', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:ags', 'urn:de:bund:kba:xkfz:codeliste:stba', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:gemeindeverband', 'urn:xoev-de:bund:destatis:bevoelkerungsstatistik:codeliste:ags.historie', 'urn:de:bund:kba:xkfz:codeliste:steuerzahlweise', 'urn:de:bund:kba:xkfz:codeliste:typdergebuehrenaufstellung', 'urn:de:bund:kba:xkfz:codeliste:typdesdokuments', 'urn:de:bund:kba:xkfz:codeliste:typdeskennzeichens', 'urn:xoev-de:xinneres:codeliste:quittungsrelevanter-sachverhalt', 'urn:de:dsmeld:schluesseltabelle:einwilligung.datenuebermittlung', 'urn:xoev-de:xgewerbeanzeige:codeliste:registergerichte', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:rs', 'urn:de:dsmeld:schluesseltabelle:pass.und.ausweisdokumente', 'urn:de:xauslaender:codelist:azr:artdersprache', 'urn:xoev-de:bund:kba:codeliste:schluesselnummerderueberwachungsinstitutionoderzdk', 'urn:de:xauslaender:codelist:azr:ausweisart', 'urn:de:fim:codeliste:dokumenttyp', 'urn:de:fim:leika:leistung', 'urn:de:fim:leika:typisierung', 'urn:de:kirche:agszuordnung', 'urn:de:xauslaender:codelist:bamfabh:int:anmeldestatus', 'urn:de:xauslaender:codelist:bamfabh:int:informationberechtigungsschein', 'urn:de:xauslaender:codelist:bamfabh:int:kursabschnitt', 'urn:de:xauslaender:codelist:geschlecht', 'urn:de:xauslaender:codelist:integration:aufenthaltstitel', 'urn:de:xinneres:codeliste:fehlercodes', 'urn:de:xmeld:lra:schluessel:rts.fehlercodes', 'urn:de:xmeld:schluesseltabelle:xmeld.nachrichten', 'urn:de:xprozess:codeliste:beteiligungsform', 'urn:de:xprozess:codeliste:handlungsgrundlagenart', 'urn:de:xprozess:codeliste:verfahrensart', 'urn:de:xta:codeliste:category.of.party', 'urn:de:xta:codeliste:service.parameter.type', 'urn:de:xta:codeliste:xhd-nachrichten', 'urn:de:xwaffe:codelisten:munitionsbezeichnungkalibersammlung', 'urn:de:xzufi:codeliste:leistungstextmodulleika', 'urn:de:xzufi:codeliste:zahlungsweise', 'urn:de:xwaffe:codelisten:herstellersammlung', 'urn:de:xwaffe:codelisten:kalibersammlung', 'urn:de:xauslaender:codelist:bamfabh:int:dublettenmeldung', 'urn:de:gkleika:leika:leistung', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:staat', 'urn:de:bund:dsrv:schluessel:fehlerkatalog', 'urn:de:xwaffe:codelisten:herstellerbezeichnungsynonym', 'urn:de:bund:bzst:schluessel:fehlerkatalog', 'urn:de:gkleika:leika:verrichtung', 'urn:de:xwaffe:codelisten:herstellerbezeichnung', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:staatsgebiete', 'urn:dsmeld:schluesseltabelle:religion.steuererhebend', 'urn:de:bund:destatis:bevoelkerungsstatistik:schluessel:standesamtsnummern', 'urn:xoev-de:bmk:codeliste:bauwerkszuordnungskatalog', 'urn:xoev-de:bund:bfj:codeliste:bfjbehoerde', 'urn:xoev-de:bund:bfj:codeliste:fehlerkennzahl', 'urn:xoev-de:bund:bfj:codeliste:uebermittelndestelle', 'urn:xoev-de:bund:bfj:codeliste:verwendungszweck', 'urn:de:xauslaender:codelist:int:informationberechtigungverpflichtung', 'urn:de:xauslaender:codelist:abhmb:anlassmitteilungazrnummer')"/>
</xsl:stylesheet>
