<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:log="http://www.xoev.de/de/xgenerator/framework/1/log" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xmi="http://www.omg.org/spec/XMI/20131001" xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library" xmlns:xoev="http://www.xoev.de/de/xoev-profil/3_0_0" xmlns:xoev-sch="http://www.xoev.de/de/xoev-profil/schematron/3_0_0" xmlns:uml="http://www.eclipse.org/uml2/5.0.0/UML" xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" version="3.0" exclude-result-prefixes="xsl xmi xgen xoev xoev-sch uml xd">

    <!-- Hinweis: Während der Entwicklungszeit befinden sich die referenzierten Dateien der Infrastruktur / anderer Frameworks 
         nicht im gleichen Verzeichnis, zur Laufzeit hingegen schon. Während der Entwicklungszeit werden die Verweise über 
         Katalogdateien aufgelöst. -->

    <xsl:param name="transformation-name" as="xs:string" required="yes"/>

    <xsl:include href="xgenerator-library.xgen-core.xsl"/>
    <xsl:include href="xgenerator-library.uml-access-layer.xsl"/>
    <xsl:include href="xoev-profil.profile-access-layer.xsl"/>
    <xsl:include href="xoev-profil.helpers.xsl"/>
    <xsl:include href="xoev-profil.schematron.xsl"/>
    <xsl:include href="xoev-profil.schematron.helpers.xsl"/>

    <xsl:output method="xml" indent="yes"/>

    <xsl:template match="/">
        <log:transformation-results transformation="{$transformation-name}">
            <xsl:apply-templates select="/" mode="xgen:assert-supported-uml-model"/>
            <xsl:apply-templates select="." mode="xoev:default"/>
        </log:transformation-results>
    </xsl:template>

</xsl:stylesheet>
