<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<xsl:stylesheet xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:saxon="http://saxon.sf.net/"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:schold="http://www.ascc.net/xml/schematron"
                xmlns:iso="http://purl.oclc.org/dsdl/schematron"
                xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library"
                xmlns:xmi="http://www.omg.org/spec/XMI/20131001"
                xmlns:uml="http://www.eclipse.org/uml2/5.0.0/UML"
                xmlns:xoev="http://www.xoev.de/de/xoev-profil/3_0_0"
                xmlns:xoev-sch="http://www.xoev.de/de/xoev-profil/schematron/3_0_0"
                version="2.0"><!--Implementers: please note that overriding process-prolog or process-root is 
    the preferred method for meta-stylesheets to use where possible. -->
   <xsl:param name="archiveDirParameter"/>
   <xsl:param name="archiveNameParameter"/>
   <xsl:param name="fileNameParameter"/>
   <xsl:param name="fileDirParameter"/>
   <xsl:variable name="document-uri">
      <xsl:value-of select="document-uri(/)"/>
   </xsl:variable>
   <!--PHASES-->
   <!--PROLOG-->
   <xsl:output xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
               method="xml"
               omit-xml-declaration="no"
               standalone="yes"
               indent="yes"/>
   <!--XSD TYPES FOR XSLT2-->
   <!--KEYS AND FUNCTIONS-->
   <!--DEFAULT RULES-->
   <!--MODE: SCHEMATRON-SELECT-FULL-PATH-->
   <!--This mode can be used to generate an ugly though full XPath for locators-->
   <xsl:template match="*" mode="schematron-select-full-path">
      <xsl:apply-templates select="." mode="schematron-get-full-path-3"/>
   </xsl:template>
   <!--MODE: SCHEMATRON-FULL-PATH-->
   <!--This mode can be used to generate an ugly though full XPath for locators-->
   <xsl:template match="*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">
            <xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>*:</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>[namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="preceding"
                    select="count(preceding-sibling::*[local-name()=local-name(current())                                   and namespace-uri() = namespace-uri(current())])"/>
      <xsl:text>[</xsl:text>
      <xsl:value-of select="1+ $preceding"/>
      <xsl:text>]</xsl:text>
   </xsl:template>
   <xsl:template match="@*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">@<xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>@*[local-name()='</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>' and namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <!--MODE: SCHEMATRON-FULL-PATH-2-->
   <!--This mode can be used to generate prefixed XPath for humans-->
   <xsl:template match="node() | @*" mode="schematron-get-full-path-2">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="preceding-sibling::*[name(.)=name(current())]">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>
   <!--MODE: SCHEMATRON-FULL-PATH-3-->
   <!--This mode can be used to generate prefixed XPath for humans 
	(Top-level element has index)-->
   <xsl:template match="node() | @*" mode="schematron-get-full-path-3">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="parent::*">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>
   <!--MODE: GENERATE-ID-FROM-PATH -->
   <xsl:template match="/" mode="generate-id-from-path"/>
   <xsl:template match="text()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/>
   </xsl:template>
   <xsl:template match="comment()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/>
   </xsl:template>
   <xsl:template match="processing-instruction()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.@', name())"/>
   </xsl:template>
   <xsl:template match="*" mode="generate-id-from-path" priority="-0.5">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:text>.</xsl:text>
      <xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/>
   </xsl:template>
   <!--MODE: GENERATE-ID-2 -->
   <xsl:template match="/" mode="generate-id-2">U</xsl:template>
   <xsl:template match="*" mode="generate-id-2" priority="2">
      <xsl:text>U</xsl:text>
      <xsl:number level="multiple" count="*"/>
   </xsl:template>
   <xsl:template match="node()" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>n</xsl:text>
      <xsl:number count="node()"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="string-length(local-name(.))"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="translate(name(),':','.')"/>
   </xsl:template>
   <!--Strip characters-->
   <xsl:template match="text()" priority="-1"/>
   <!--SCHEMA SETUP-->
   <xsl:template match="/">
      <svrl:schematron-output xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                              title="XÖV-Prüfanweisungen: Schematron"
                              schemaVersion="">
         <svrl:ns-prefix-in-attribute-values uri="http://www.xoev.de/de/xgenerator/framework/1/library"
                                             prefix="xgen"/>
         <svrl:ns-prefix-in-attribute-values uri="http://www.omg.org/spec/XMI/20131001" prefix="xmi"/>
         <svrl:ns-prefix-in-attribute-values uri="http://www.eclipse.org/uml2/5.0.0/UML" prefix="uml"/>
         <svrl:ns-prefix-in-attribute-values uri="http://www.xoev.de/de/xoev-profil/3_0_0" prefix="xoev"/>
         <svrl:ns-prefix-in-attribute-values uri="http://www.xoev.de/de/xoev-profil/schematron/3_0_0"
                                             prefix="xoev-sch"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">Schematron-SchematronRuleSetHatKeineEigenschaften</xsl:attribute>
            <xsl:attribute name="name">Einhaltung der Methodik zur Modellierung von Schematron-Regeln</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M11"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">Schematron-SchematronRuleSetHatMindestensEinenContext</xsl:attribute>
            <xsl:attribute name="name">Einhaltung der Methodik zur Modellierung von Schematron-Regeln</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M12"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">Schematron-ContextDependencyBeginntBeiRuleSet</xsl:attribute>
            <xsl:attribute name="name">Einhaltung der Methodik zur Modellierung von Schematron-Regeln</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M13"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">Schematron-ContextDependencyEndetBeiKlasseOderEigenschaft</xsl:attribute>
            <xsl:attribute name="name">Einhaltung der Methodik zur Modellierung von Schematron-Regeln</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M14"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">Schematron-SchematronRegelHatSpezifikation</xsl:attribute>
            <xsl:attribute name="name">Einhaltung der Methodik zur Modellierung von Schematron-Regeln</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M15"/>
         <svrl:active-pattern>
            <xsl:attribute name="documents">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">Schematron-EingeschränktesElementVonSchematronContextErreichbar</xsl:attribute>
            <xsl:attribute name="name">Einhaltung der Methodik zur Modellierung von Schematron-Regeln</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M16"/>
      </svrl:schematron-output>
   </xsl:template>
   <!--SCHEMATRON PATTERNS-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">XÖV-Prüfanweisungen: Schematron</svrl:text>
   <xsl:include xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                href="xgenerator-library.xgen-core.xsl"/>
   <xsl:include xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                href="xgenerator-library.uml-access-layer.xsl"/>
   <xsl:include xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                href="xoev-profil.profile-access-layer.xsl"/>
   <xsl:include xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                href="xoev-profil.helpers.xsl"/>
   <xsl:include xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                href="xoev-profil.schematron.helpers.xsl"/>
   <!--PATTERN Schematron-SchematronRuleSetHatKeineEigenschaftenEinhaltung der Methodik zur Modellierung von Schematron-Regeln-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Einhaltung der Methodik zur Modellierung von Schematron-Regeln</svrl:text>
   <!--RULE -->
   <xsl:template match="                 uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:schRuleSet(.) and ownedAttribute] |                 uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:schRuleSet(.) and ownedAttribute]"
                 priority="1000"
                 mode="M11">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">SchematronRuleSetHatKeineEigenschaften</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Ein Schematron Rule Set (UML-Klasse mit dem Stereotyp schRuleSet) hat keine UML-Eigenschaften, sondern ausschließlich UML-Zusicherungen. Die Klasse <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M11"/>
   <xsl:template match="@*|node()" priority="-2" mode="M11">
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>
   <!--PATTERN Schematron-SchematronRuleSetHatMindestensEinenContextEinhaltung der Methodik zur Modellierung von Schematron-Regeln-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Einhaltung der Methodik zur Modellierung von Schematron-Regeln</svrl:text>
   <!--RULE -->
   <xsl:template match="                 uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:schRuleSet(.) and not(xoev:dependencies-by-client(.)[xoev:schContext(.)])] |                 uml:Model/packagedElement[xoev:xsdXModel(.)]//nestedClassifier[xoev:schRuleSet(.) and not(xoev:dependencies-by-client(.)[xoev:schContext(.)])]"
                 priority="1000"
                 mode="M12">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">SchematronRuleSetHatMindestensEinenContext</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Ein Schematron Rule Set (UML-Klasse mit dem Stereotyp schRuleSet) muss mindestens einen Fachkontext haben (von der UML-Klasse ausgehende UML-Abhängigkeitsbeziehung mit dem Stereotyp schContext). Die Klasse <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M12"/>
   <xsl:template match="@*|node()" priority="-2" mode="M12">
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>
   <!--PATTERN Schematron-ContextDependencyBeginntBeiRuleSetEinhaltung der Methodik zur Modellierung von Schematron-Regeln-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Einhaltung der Methodik zur Modellierung von Schematron-Regeln</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[xoev:schContext(.) and uml:resolve-client(.)[not(xoev:schRuleSet(.))]]"
                 priority="1000"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">ContextDependencyBeginntBeiRuleSet</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Eine Schematron Fachkontext-Beziehung (UML-Abhängigkeitsbeziehung mit dem Stereotyp schContext) muss bei einem Rule Set (UML-Klasse mit dem Stereotyp schRuleSet) beginnen. <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M13"/>
   <xsl:template match="@*|node()" priority="-2" mode="M13">
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>
   <!--PATTERN Schematron-ContextDependencyEndetBeiKlasseOderEigenschaftEinhaltung der Methodik zur Modellierung von Schematron-Regeln-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Einhaltung der Methodik zur Modellierung von Schematron-Regeln</svrl:text>
   <!--RULE -->
   <xsl:template match="                 uml:Model/packagedElement[xoev:xsdXModel(.)]//packagedElement[                 xoev:schContext(.) and uml:resolve-supplier(.)[not(uml:is-Class(.) or uml:is-Property(.))]]"
                 priority="1000"
                 mode="M14">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">ContextDependencyEndetBeiKlasseOderEigenschaft</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Eine Schematron Fachkontext-Beziehung (UML-Abhängigkeitsbeziehung mit dem Stereotyp schContext) muss bei einer UML-Klasse oder -Eigenschaft enden. <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M14"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M14"/>
   <xsl:template match="@*|node()" priority="-2" mode="M14">
      <xsl:apply-templates select="*" mode="M14"/>
   </xsl:template>
   <!--PATTERN Schematron-SchematronRegelHatSpezifikationEinhaltung der Methodik zur Modellierung von Schematron-Regeln-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Einhaltung der Methodik zur Modellierung von Schematron-Regeln</svrl:text>
   <!--RULE -->
   <xsl:template match="                 uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedRule[not(specification/body or specification/@value)]"
                 priority="1000"
                 mode="M15">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false()">
               <xsl:attribute name="id">SchematronRegelHatSpezifikation</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Eine Geschäftsregel (UML-Zusicherung) muss eine Spezifikation besitzen. Die Regel <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M15"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M15"/>
   <xsl:template match="@*|node()" priority="-2" mode="M15">
      <xsl:apply-templates select="*" mode="M15"/>
   </xsl:template>
   <!--PATTERN Schematron-EingeschränktesElementVonSchematronContextErreichbarEinhaltung der Methodik zur Modellierung von Schematron-Regeln-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Einhaltung der Methodik zur Modellierung von Schematron-Regeln</svrl:text>
   <!--RULE -->
   <xsl:template match="uml:Model/packagedElement[xoev:xsdXModel(.)]//ownedRule"
                 priority="1000"
                 mode="M16">
      <xsl:variable name="rule" select="."/>
      <xsl:variable name="owner" select="$rule/parent::*"/>
      <xsl:variable name="contexts"
                    select="                     $owner[xoev:schRuleSet(.)]/xoev:dependencies-by-client(.)[xoev:schContext(.)]/uml:resolve-supplier(.),                     $owner[not(xoev:schRuleSet(.))]"/>
      <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="                     every $context in $contexts                         satisfies                         (some $constrained-element-in-message-trees in ($rule/uml:resolve-constrainedElement(.), $context)[1]/(xoev-sch:message-nodes-by-id(@xmi:id), xoev-sch:message-nodes-by-type-id(@xmi:id))                             satisfies xoev-sch:id-path-from-constrained-element-to-context(                             $constrained-element-in-message-trees,                             $context/(xoev-sch:message-nodes-by-id(@xmi:id), xoev-sch:message-nodes-by-type-id(@xmi:id))[1]) = '' or                             xoev-sch:id-path-from-constrained-element-to-context(                             $constrained-element-in-message-trees,                             $context/(xoev-sch:message-nodes-by-id(@xmi:id), xoev-sch:message-nodes-by-type-id(@xmi:id))[1])[                             not(starts-with(., '#null#'))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="every $context in $contexts satisfies (some $constrained-element-in-message-trees in ($rule/uml:resolve-constrainedElement(.), $context)[1]/(xoev-sch:message-nodes-by-id(@xmi:id), xoev-sch:message-nodes-by-type-id(@xmi:id)) satisfies xoev-sch:id-path-from-constrained-element-to-context( $constrained-element-in-message-trees, $context/(xoev-sch:message-nodes-by-id(@xmi:id), xoev-sch:message-nodes-by-type-id(@xmi:id))[1]) = '' or xoev-sch:id-path-from-constrained-element-to-context( $constrained-element-in-message-trees, $context/(xoev-sch:message-nodes-by-id(@xmi:id), xoev-sch:message-nodes-by-type-id(@xmi:id))[1])[ not(starts-with(., '#null#'))])">
               <xsl:attribute name="id">EingeschränktesElementVonSchematronContextErreichbar</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>Ein in einer Geschäftsregel (UML-Zusicherung) eingeschränktes Element muss vom Fachkontext der Regel aus erreichbar sein. Die Regel <xsl:text/>
                  <xsl:value-of select="xgen:model-path(.)"/>
                  <xsl:text/> verletzt diese Vorgabe."/&gt;</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M16"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M16"/>
   <xsl:template match="@*|node()" priority="-2" mode="M16">
      <xsl:apply-templates select="*" mode="M16"/>
   </xsl:template>
</xsl:stylesheet>
