<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xmi="http://www.omg.org/spec/XMI/20131001" xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library" xmlns:xoev="http://www.xoev.de/de/xoev-profil/3_0_0" xmlns:xoev-sch="http://www.xoev.de/de/xoev-profil/schematron/3_0_0" xmlns:uml="http://www.eclipse.org/uml2/5.0.0/UML" xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" version="3.0" xmlns:sch="http://purl.oclc.org/dsdl/schematron" exclude-result-prefixes="xsl xmi xgen xoev xoev-sch uml xd">

    <xsl:template match="/" mode="xoev:default">
        <xsl:call-template name="xgen:result-document">
            <xsl:with-param name="local-path">
                <xsl:value-of select="concat($xoev:my-xmodel/xoev:xoevStandard(.)/@nameTechnisch, '-schematron.sch')"/>
            </xsl:with-param>
            <xsl:with-param name="content">
                <sch:schema queryBinding="xslt2">
                    <xsl:call-template name="xoev-sch:xsd-namespaces"/>
                    <sch:pattern>
                        <xsl:value-of select="xgen:unescaped-xml('&#xa;      ')"/>

                        <xsl:comment>Abstrakte Regeln</xsl:comment>
                        <xsl:value-of select="xgen:unescaped-xml('&#xa;      ')"/>
                        <xsl:apply-templates select="$uml:root-model//packagedElement[xoev:xsdXModel(.)]//(packagedElement, nestedClassifier)[ownedRule]" mode="xoev-sch:abstract-rule-block">
                            <xsl:sort select="@name"/>
                        </xsl:apply-templates>

                        <xsl:comment>Konkrete Regeln</xsl:comment>
                        <xsl:call-template name="xoev-sch:concrete-rules"/>

                    </sch:pattern>
                </sch:schema>
                <!-- Ausgaben für QS-Zwecke: -->
                <!-- <xsl:sequence select="$xoev-sch:message-trees"/>-->
                <!-- <xsl:sequence select="$xoev-sch:rules-and-contexts"></xsl:sequence>-->
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="xoev-sch:xsd-namespaces" as="element()*">
        <xsl:variable name="namespaces">
            <namespaces>
                <xsl:for-each select="$xoev:my-xmodel//packagedElement[xoev:xsdSchema(.)]">
                    <namespace prefix="{xoev:getPrefix(.)}" uri="{xoev:getNamespace(.)}"/>
                    <xsl:for-each select="xoev:package-with-imports-and-includes(.)/import[@kind = 'direct']">
                        <namespace prefix="{@prefix}" uri="{@namespace}"/>
                    </xsl:for-each>
                </xsl:for-each>
                <xsl:for-each select="$uml:root-model//packagedElement[xoev:xsdSchema(.)]">
                    <namespace prefix="{xoev:getPrefix(.)}" uri="{xoev:getNamespace(.)}"/>
                    <xsl:for-each select="xoev:package-with-imports-and-includes(.)/import[@kind = 'direct']">
                        <namespace prefix="{@prefix}" uri="{@namespace}"/>
                    </xsl:for-each>
                </xsl:for-each>
            </namespaces>
        </xsl:variable>
        <xsl:for-each select="$namespaces//namespace[not(@prefix = preceding-sibling::namespace/@prefix)]">
            <xsl:sort select="@prefix"/>
            <sch:ns prefix="{@prefix}" uri="{@uri}"/>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="packagedElement | nestedClassifier" mode="xoev-sch:abstract-rule-block">
        <xsl:if test="ownedRule[xoev-sch:rule-has-path(.)]">
            <xsl:comment select="
                    concat(' ', xgen:model-path(.),
                    if (xoev:schRuleSet(.)) then
                        ' (schRuleSet) '
                    else
                        ' ')"/>
        </xsl:if>
        <xsl:apply-templates select="ownedRule[xoev-sch:rule-has-path(.)]" mode="xoev-sch:abstract-rule">
            <xsl:sort select="@name"/>
        </xsl:apply-templates>
    </xsl:template>

    <xsl:function name="xoev-sch:rule-has-path" as="xs:boolean">
        <xsl:param name="rule" as="element()"/>
        <xsl:sequence select="$xoev-sch:rules-and-contexts//rule[@name = $rule/@name]/not(empty(context/full-paths/path))"/>
    </xsl:function>

    <xsl:template match="ownedRule" mode="xoev-sch:abstract-rule">
        <sch:rule id="{concat('rule-',@name)}" abstract="true">
            <sch:assert id="{@name}" test="{(specification/body, specification/@value)[1]}">
                <xsl:for-each select="ownedComment/body/xoev:clean-text(.)[. != '']">
                    <xsl:sort select="."/>
                    <xsl:value-of select="."/>
                </xsl:for-each>
            </sch:assert>
        </sch:rule>
    </xsl:template>

    <xsl:template name="xoev-sch:concrete-rules" as="element()*">
        <xsl:for-each select="distinct-values($xoev-sch:rules-and-contexts//full-paths/path/text())">
            <xsl:variable name="path" select="."/>
            <sch:rule context="{.}">
                <xsl:for-each select="$xoev-sch:rules-and-contexts//rule[context/full-paths/path = $path]">
                    <xsl:sort select="@name"/>
                    <sch:extends rule="{concat('rule-',@name)}"/>
                </xsl:for-each>
            </sch:rule>
        </xsl:for-each>
    </xsl:template>

</xsl:stylesheet>
