<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xmi="http://www.omg.org/spec/XMI/20131001" xmlns:xgen="http://www.xoev.de/de/xgenerator/framework/1/library" xmlns:xoev="http://www.xoev.de/de/xoev-profil/3_0_0" xmlns:uml="http://www.eclipse.org/uml2/5.0.0/UML" xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" version="3.0" exclude-result-prefixes="xsl xmi xgen xoev uml xd">

    <xsl:template match="/" mode="xoev:default">
        <!-- Bei Deployment (xsdXModel.deployment = true) werden ausschließlich die xsdSchema-Pakete des eigenen Modells
             in XML Schema-Definitionen überführt. Andernfalls (xsdXModel.deployment = false) werden auch die xsdSchema-Pakete
             der externen Modelle (ausgenommen der XÖV-Adapter) in die Generierung einbezogen, damit die eigenen XML Schema-Definitionen
             vollständig unter Einbeziehung der lokal vorliegenden externen XML Schema-Definitionen validiert werden können. -->
        <xsl:choose>
            <xsl:when test="$xoev:my-xmodel/xoev:xsdXModel(.)/@deployment = 'true'">
                <xsl:apply-templates select="$xoev:my-xmodel//packagedElement[xoev:xsdSchema(.)]" mode="xoev:schema-file"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="
                        //packagedElement[xoev:xsdSchema(.) and not(some $p in ancestor::packagedElement
                            satisfies xoev:xoevAdapter($p))]" mode="xoev:schema-file"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="
                xoev:xsdXModel($xoev:my-xmodel)/@namespace[. != ''] and
                not(some $p in $xoev:my-xmodel//packagedElement[xoev:xsdSchema(.)]
                    satisfies xoev:xsdSchema($p)/@namespace != xoev:xsdXModel($xoev:my-xmodel)/@namespace)">
            <xsl:apply-templates select="$xoev:my-xmodel" mode="xoev:aggregierendes-schema"/>
        </xsl:if>
    </xsl:template>

    <xsl:template match="packagedElement" mode="xoev:aggregierendes-schema">
        <xsl:variable name="name-conflict" as="xs:boolean" select="
                not(empty($uml:root-model//packagedElement/xoev:xsdSchema(.)/@schemaFile[tokenize(., '\.')[1] = $xoev:my-xmodel/xoev:xoevStandard(.)/@nameTechnisch]))"/>
        <xsl:call-template name="xgen:result-document">
            <xsl:with-param name="local-path">
                <xsl:value-of select="
                        concat(xoev:xoevStandard(.)/@nameTechnisch, if ($name-conflict) then
                            '-aggregiert'
                        else
                            '', '.xsd')"/>
            </xsl:with-param>
            <xsl:with-param name="content">
                <xs:schema targetNamespace="{xoev:xsdXModel(.)/@namespace}" version="{xoev:xoevVersionStandard(.)/@version}" elementFormDefault="{xoev:xsdXModel(.)/@elementFormDefault}" attributeFormDefault="unqualified">
                    <xsl:for-each select="descendant::packagedElement[xoev:xsdSchema(.)]">
                        <xsl:sort select="xoev:xsdSchema(.)/@schemaFile"/>
                        <xs:include schemaLocation="{xoev:xsdSchema(.)/@schemaFile}"/>
                    </xsl:for-each>
                </xs:schema>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="packagedElement" mode="xoev:schema-file">
        <xsl:call-template name="xgen:result-document">
            <xsl:with-param name="local-path" select="xoev:xsdSchema(.)/@schemaFile"/>
            <xsl:with-param name="content">
                <xsl:apply-templates select="." mode="xoev:schema"/>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="packagedElement" mode="xoev:schema">
        <xsl:variable name="schema" select="."/>
        <xs:schema targetNamespace="{xoev:getNamespace(.)}" version="{(xoev:xsdSchema(.)/@version, ancestor::packagedElement/xoev:xoevVersionStandard(.)/@version)[1]}" elementFormDefault="{(xoev:xsdSchema(.)/@elementFormDefault[. != 'default'], ancestor::packagedElement/xoev:xsdXModel(.)/@elementFormDefault)[1]}" attributeFormDefault="unqualified">

            <xsl:namespace name="{xoev:getPrefix(.)}" select="xoev:getNamespace(.)"/>
            <xsl:for-each select="xoev:package-with-imports-and-includes(.)/import[@kind = 'direct']">
                <xsl:sort select="@prefix"/>
                <xsl:namespace name="{@prefix}" select="@namespace"/>
            </xsl:for-each>

            <xsl:apply-templates select="." mode="xoev:annotation"/>

            <xsl:for-each select="xoev:package-with-imports-and-includes(.)/include[@kind = 'direct']">
                <xsl:sort select="@schemaFile"/>
                <xs:include schemaLocation="{@schemaFile}"/>
            </xsl:for-each>
            <xsl:for-each select="xoev:package-with-imports-and-includes(.)/import[@kind = 'direct']">
                <xsl:sort select="@schemaLocation"/>
                <xs:import schemaLocation="{@schemaLocation}" namespace="{@namespace}"/>
            </xsl:for-each>

            <xsl:apply-templates select="descendant::packagedElement[xoev:xsdGlobalAttribute(.) and not(xoev:xsdDraft(.))]" mode="xoev:attribute">
                <xsl:sort select="@name"/>
            </xsl:apply-templates>

            <xsl:apply-templates select="descendant::packagedElement[xoev:xsdGroup(.) and not(xoev:xsdDraft(.))]" mode="xoev:group">
                <xsl:sort select="@name"/>
            </xsl:apply-templates>
            <xsl:apply-templates select="descendant::packagedElement[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)) and not(xoev:xsdDraft(.))]" mode="xoev:type">
                <xsl:sort select="xoev:type-name(.)"/>
            </xsl:apply-templates>
            <xsl:variable name="code-typen-mit-codelisten-zuordnung-zu-diesem-schema" select="
                    $xoev:my-xmodel/descendant::packagedElement[
                    xoev:usages-by-client(.)[xoev:xoevCodeTyp1(.)]
                    and
                    not(xoev:usages-by-client(.)/xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentyp = 'false')
                    and
                    (xoev:usages-by-client(.)/xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentypXSD = $schema/@xmi:id
                    or
                    empty(xoev:usages-by-client(.)/xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentypXSD[. != ''])
                    and
                    ancestor::packagedElement[xoev:xsdSchema(.)]/@xmi:id = $schema/@xmi:id)]"/>
            <xsl:for-each select="$code-typen-mit-codelisten-zuordnung-zu-diesem-schema">
                <xsl:sort select="xoev:name-codelisten-simple-type(.)"/>
                <xsl:variable name="name" select="xoev:name-codelisten-simple-type(.)"/>
                <xsl:apply-templates select="xoev:getCodelistenversion(.)" mode="xoev:codelist-type">
                    <xsl:with-param name="name" select="$name"/>
                    <xsl:with-param name="usage" select="xoev:usages-by-client(.)"/>
                </xsl:apply-templates>
            </xsl:for-each>
            <xsl:apply-templates select="descendant::packagedElement[(xoev:xsdGlobalElement(.) or xoev:xsdGlobalElementAndNamedType(.)) and not(xoev:xsdMessage(.)) and not(xoev:xsdDraft(.))]" mode="xoev:element">
                <xsl:sort select="xoev:global-element-name(.)"/>
            </xsl:apply-templates>
            <xsl:apply-templates select="descendant::packagedElement[xoev:xsdMessage(.) and not(xoev:xsdDraft(.))]" mode="xoev:element">
                <xsl:sort select="tokenize(@name, '\.')[last()]"/>
            </xsl:apply-templates>
        </xs:schema>
    </xsl:template>

    <xsl:function name="xoev:getCodeliste" as="element()">
        <xsl:param name="code-typ" as="element()"/>
        <xsl:sequence select="$code-typ/xoev:getCodelistenversion(.)/xoev:dependencies-by-client(.)/uml:resolve-supplier(.)"/>
    </xsl:function>

    <xsl:function name="xoev:getCodelistenversion" as="element()">
        <xsl:param name="code-typ" as="element()"/>
        <xsl:sequence select="$code-typ/xoev:usages-by-client(.)/uml:resolve-supplier(.)"/>
    </xsl:function>

    <xsl:function name="xoev:name-codelisten-simple-type" as="xs:string">
        <xsl:param name="code-typ" as="element()"/>
        <xsl:sequence select="$code-typ/(xoev:usages-by-client(.)/xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentypName[. != ''], xoev:getCodeliste(.)/xoev:xoevCodeliste(.)/@nameTechnisch)[1]"/>
    </xsl:function>

    <xsl:template match="packagedElement" mode="xoev:group">
        <xsl:element name="{if (empty(xoev:elements(.))) then 'xs:attributeGroup' else 'xs:group'}">
            <xsl:attribute name="name" select="@name"/>
            <xsl:apply-templates select="." mode="xoev:content-model"/>
            <xsl:apply-templates select="xoev:attributes(.)" mode="xoev:attribute"/>
        </xsl:element>
    </xsl:template>

    <xsl:function name="xoev:getMemberTypes" as="xs:string*">
        <xsl:param name="union" as="element()"/>
        <xsl:for-each select="xoev:dependencies-by-client($union)[xoev:xsdUnionMember(.)]">
            <xsl:sort select="xoev:qualified-type-name(uml:resolve-supplier(.), $union, false())"/>
            <xsl:sequence select="xoev:qualified-type-name(uml:resolve-supplier(.), $union, false())"/>
        </xsl:for-each>
    </xsl:function>

    <xsl:template match="packagedElement | nestedClassifier" mode="xoev:codelist-type">
        <xsl:param name="name" as="xs:string?" required="no"/>
        <xsl:param name="usage" as="element()?" required="no"/>
        <xs:simpleType>
            <xsl:if test="xoev:xsdNamedType(.) or $name">
                <xsl:attribute name="name" select="($name, @name)[1]"/>
            </xsl:if>
            <xsl:apply-templates select=".[not(empty($name))]" mode="xoev:annotation"/>
            <xs:restriction>
                <xsl:choose>
                    <xsl:when test="uml:is-Enumeration(.) and generalization">
                        <xsl:attribute name="base" select="xoev:qualified-type-name(uml:resolve-general(generalization), ., false())"/>
                    </xsl:when>
                    <xsl:when test="uml:is-Enumeration(.) and xoev:xsdCodeList(.)/(base, @base)">
                        <xsl:attribute name="base" select="xoev:qualified-type-name(xoev:resolve-base(xoev:xsdCodeList(.)), ., false())"/>
                    </xsl:when>
                    <xsl:when test="$usage/xoev:xoevCodeTyp1(.)/xoev:resolve-typDesCodeElements(.)">
                        <xsl:attribute name="base" select="xoev:qualified-type-name(xoev:resolve-typDesCodeElements($usage/xoev:xoevCodeTyp1(.)), ., false())"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:attribute name="base">xs:token</xsl:attribute>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:variable name="code-spalte" select="
                        ($usage/xoev:xoevCodeTyp1(.)/@genutzteCodeSpalte/xoev:ids-to-elements(., root()),
                        ownedAttribute[xoev:xoevCodelistenspalte(.)/@empfohleneCodeSpalte = 'true'],
                        ownedAttribute[xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true'])[1]"/>
                <xsl:variable name="whiteList" select="$usage/xoev:xoevCodeTyp1(.)/@whiteList"/>
                <xsl:variable name="blackList" select="$usage/xoev:xoevCodeTyp1(.)/@blackList"/>
                <xsl:apply-templates select="
                        if ($whiteList != '') then
                            xoev:ids-to-elements(tokenize($whiteList, ' '), root())
                        else
                            $uml:root-model/descendant::packagedElement[uml:is-InstanceSpecification(.) and @classifier = current()/@xmi:id and not(@xmi:id = tokenize($blackList, ' ')) and
                            not(xoev:xoevCodelisteneintragDeprecated(.))]" mode="xoev:codelist-instance">
                    <xsl:with-param name="code-spalte" select="$code-spalte"/>
                    <xsl:sort select="slot[uml:resolve-definingFeature(.)/@xmi:id = $code-spalte/@xmi:id]/value/@value"/>
                </xsl:apply-templates>
            </xs:restriction>
        </xs:simpleType>
    </xsl:template>

    <xsl:template match="packagedElement | nestedClassifier" mode="xoev:type">
        <xsl:variable name="xoev-code" select="
                root()/descendant::packagedElement[
                xoev:xoevDatentyp(.)/@kennung = 'urn:xoev-de:kosit:xoev:datentyp:code']"/>
        <xsl:variable name="codelistenversion" select="xoev:usages-by-client(.)/uml:resolve-supplier(.)"/>
        <xsl:variable name="codeliste" select="$codelistenversion/xoev:dependencies-by-client(.)/uml:resolve-supplier(.)"/>
        <xsl:choose>
            <xsl:when test="xoev:usages-by-client(.)[xoev:xoevCodeTyp1(.) or xoev:xoevCodeTyp2(.)]">
                <xs:complexType>
                    <xsl:if test="xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)">
                        <xsl:attribute name="name" select="xoev:type-name(.)"/>
                    </xsl:if>
                    <xsl:if test="@isAbstract = 'true'">
                        <xsl:attribute name="abstract">true</xsl:attribute>
                    </xsl:if>
                    <xsl:apply-templates select=".[xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)]" mode="xoev:annotation"/>
                    <xs:complexContent>
                        <xs:restriction base="{xoev:qualified-type-name($xoev-code,., false())}">
                            <xs:sequence>
                                <xs:element name="code">
                                    <xsl:if test="not((ancestor::packagedElement/xoev:xsdSchema(.)/@elementFormDefault[. != 'default'], ancestor::packagedElement/xoev:xsdXModel(.)/@elementFormDefault)[1] = 'unqualified')">
                                        <xsl:attribute name="form">unqualified</xsl:attribute>
                                    </xsl:if>
                                    <xsl:if test="xoev:usages-by-client(.)[not(xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentyp = 'false')]">
                                        <xsl:variable name="code-typ-1" select="xoev:usages-by-client(.)/xoev:xoevCodeTyp1(.)"/>
                                        <xsl:variable name="clv-name" select="xoev:name-codelisten-simple-type(.)"/>
                                        <xsl:variable name="clv-xsd" select="
                                                (xoev:ids-to-elements($code-typ-1/@benannterCodelistenDatentypXSD[. != ''], root()),
                                                ancestor::packagedElement[xoev:xsdSchema(.)])[1]"/>
                                        <xsl:attribute name="type" select="concat(xoev:qualified-prefix($clv-xsd, .), ':', $clv-name)"/>
                                    </xsl:if>
                                    <xsl:choose>
                                        <xsl:when test="xoev:usages-by-client(.)/xoev:xoevCodeTyp2(.)/xoev:resolve-typDesCodeElements(.)">
                                            <xsl:attribute name="type" select="xoev:qualified-type-name(xoev:resolve-typDesCodeElements(xoev:usages-by-client(.)/xoev:xoevCodeTyp2(.)), ., false())"/>
                                        </xsl:when>
                                        <xsl:when test="xoev:usages-by-client(.)/xoev:xoevCodeTyp2(.)">
                                            <xsl:attribute name="type">xs:token</xsl:attribute>
                                        </xsl:when>
                                    </xsl:choose>
                                    <xsl:if test="xoev:usages-by-client(.)[xoev:xoevCodeTyp1(.)/@benannterCodelistenDatentyp = 'false']">
                                        <xsl:apply-templates select="$codelistenversion" mode="xoev:codelist-type">
                                            <xsl:with-param name="usage" select="xoev:usages-by-client(.)[xoev:xoevCodeTyp1(.)]"/>
                                        </xsl:apply-templates>
                                    </xsl:if>
                                </xs:element>
                                <xsl:if test="not((xoev:usages-by-client(.)/(xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.))/@nameElement, 'keineNutzung')[1] = 'keineNutzung')">
                                    <xs:element name="name" type="xs:normalizedString">
                                        <xsl:if test="not((ancestor::packagedElement/xoev:xsdSchema(.)/@elementFormDefault[. != 'default'], ancestor::packagedElement/xoev:xsdXModel(.)/@elementFormDefault)[1] = 'unqualified')">
                                            <xsl:attribute name="form">unqualified</xsl:attribute>
                                        </xsl:if>
                                        <xsl:if test="xoev:usages-by-client(.)/(xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.))/@nameElement = 'optional'">
                                            <xsl:attribute name="minOccurs">0</xsl:attribute>
                                        </xsl:if>
                                    </xs:element>
                                </xsl:if>
                            </xs:sequence>
                            <xs:attribute name="listURI" type="xs:anyURI" use="optional" fixed="{$codeliste/xoev:xoevCodeliste(.)/@kennung}"/>
                            <xs:attribute name="listVersionID" type="xs:normalizedString" use="optional" fixed="{$codelistenversion/xoev:xoevVersionCodeliste(.)/@version}"/>
                        </xs:restriction>
                    </xs:complexContent>
                </xs:complexType>
            </xsl:when>
            <xsl:when test="xoev:usages-by-client(.) and not(xoev:xoevCodeTyp4(.))">
                <xs:complexType>
                    <xsl:if test="xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)">
                        <xsl:attribute name="name" select="xoev:type-name(.)"/>
                    </xsl:if>
                    <xsl:if test="@isAbstract = 'true'">
                        <xsl:attribute name="abstract">true</xsl:attribute>
                    </xsl:if>
                    <xsl:apply-templates select=".[xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)]" mode="xoev:annotation"/>
                    <xsl:variable name="xoev-code" select="
                            root()/descendant::packagedElement[
                            xoev:xoevDatentyp(.)/@kennung = 'urn:xoev-de:kosit:xoev:datentyp:code']"/>
                    <xsl:variable name="codeliste" select="xoev:usages-by-client(.)/uml:resolve-supplier(.)"/>
                    <xs:complexContent>
                        <xs:restriction base="{xoev:qualified-type-name($xoev-code,., false())}">
                            <xs:sequence>
                                <xs:element name="code" type="{if(xoev:usages-by-client(.)/xoev:xoevCodeTyp3(.)/xoev:resolve-typDesCodeElements(.)) then 
                                    xoev:qualified-type-name(xoev:resolve-typDesCodeElements(xoev:usages-by-client(.)/xoev:xoevCodeTyp3(.)), ., false()) else 'xs:token'}">
                                    <xsl:if test="not((ancestor::packagedElement/xoev:xsdSchema(.)/@elementFormDefault[. != 'default'], ancestor::packagedElement/xoev:xsdXModel(.)/@elementFormDefault)[1] = 'unqualified')">
                                        <xsl:attribute name="form">unqualified</xsl:attribute>
                                    </xsl:if>
                                </xs:element>
                                <xsl:if test="not((xoev:usages-by-client(.)/xoev:xoevCodeTyp3(.)/@nameElement, 'keineNutzung')[1] = 'keineNutzung')">
                                    <xs:element name="name" type="xs:normalizedString">
                                        <xsl:if test="not((ancestor::packagedElement/xoev:xsdSchema(.)/@elementFormDefault[. != 'default'], ancestor::packagedElement/xoev:xsdXModel(.)/@elementFormDefault)[1] = 'unqualified')">
                                            <xsl:attribute name="form">unqualified</xsl:attribute>
                                        </xsl:if>
                                        <xsl:if test="xoev:usages-by-client(.)/xoev:xoevCodeTyp3(.)/@nameElement = 'optional'">
                                            <xsl:attribute name="minOccurs">0</xsl:attribute>
                                        </xsl:if>
                                    </xs:element>
                                </xsl:if>
                            </xs:sequence>
                            <xs:attribute name="listURI" type="xs:anyURI" use="optional" fixed="{$codeliste/xoev:xoevCodeliste(.)/@kennung}"/>
                            <xs:attribute name="listVersionID" type="xs:normalizedString" use="required"/>
                        </xs:restriction>
                    </xs:complexContent>
                </xs:complexType>
            </xsl:when>
            <xsl:when test="xoev:xoevCodeTyp4(.)">
                <xs:complexType>
                    <xsl:if test="xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)">
                        <xsl:attribute name="name" select="xoev:type-name(.)"/>
                    </xsl:if>
                    <xsl:if test="@isAbstract = 'true'">
                        <xsl:attribute name="abstract">true</xsl:attribute>
                    </xsl:if>
                    <xsl:apply-templates select=".[xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)]" mode="xoev:annotation"/>
                    <xsl:variable name="xoev-code" select="
                            root()/descendant::packagedElement[
                            xoev:xoevDatentyp(.)/@kennung = 'urn:xoev-de:kosit:xoev:datentyp:code']"/>
                    <xs:complexContent>
                        <xs:restriction base="{xoev:qualified-type-name($xoev-code,., false())}">
                            <xs:sequence>
                                <xs:element name="code" type="{if(xoev:xoevCodeTyp4(.)/xoev:resolve-typDesCodeElements(.)) then xoev:qualified-type-name(xoev:resolve-typDesCodeElements(xoev:xoevCodeTyp4(.)), ., false()) else 'xs:token'}">
                                    <xsl:if test="not((ancestor::packagedElement/xoev:xsdSchema(.)/@elementFormDefault[. != 'default'], ancestor::packagedElement/xoev:xsdXModel(.)/@elementFormDefault)[1] = 'unqualified')">
                                        <xsl:attribute name="form">unqualified</xsl:attribute>
                                    </xsl:if>
                                </xs:element>
                                <xsl:if test="not((xoev:xoevCodeTyp4(.)/@nameElement, 'keineNutzung')[1] = 'keineNutzung')">
                                    <xs:element name="name" type="xs:normalizedString">
                                        <xsl:if test="not((ancestor::packagedElement/xoev:xsdSchema(.)/@elementFormDefault[. != 'default'], ancestor::packagedElement/xoev:xsdXModel(.)/@elementFormDefault)[1] = 'unqualified')">
                                            <xsl:attribute name="form">unqualified</xsl:attribute>
                                        </xsl:if>
                                        <xsl:if test="xoev:xoevCodeTyp4(.)/@nameElement = 'optional'">
                                            <xsl:attribute name="minOccurs">0</xsl:attribute>
                                        </xsl:if>
                                    </xs:element>
                                </xsl:if>
                            </xs:sequence>
                            <xs:attribute name="listURI" type="xs:anyURI" use="required"/>
                            <xs:attribute name="listVersionID" type="xs:normalizedString" use="required"/>
                        </xs:restriction>
                    </xs:complexContent>
                </xs:complexType>
            </xsl:when>
            <xsl:when test="uml:is-Class(.) and xoev:xoevVersionCodeliste(.)">
                <xsl:apply-templates select="." mode="xoev:codelist-type"/>
            </xsl:when>
            <xsl:when test="
                    ownedLiteral or
                    (xoev:topmost-parent(.)/parent::packagedElement/@name = 'W3C Data Types' or xoev:xsdUnion(.)) and
                    not(xoev:attributes(.)) and not(some $p in xoev:allParents(.)
                        satisfies xoev:attributes($p))">
                <xs:simpleType>
                    <xsl:if test="xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)">
                        <xsl:attribute name="name" select="xoev:type-name(.)"/>
                    </xsl:if>
                    <xsl:apply-templates select="." mode="xoev:annotation"/>
                    <xsl:choose>
                        <xsl:when test="ownedLiteral">
                            <xs:restriction>
                                <xsl:choose>
                                    <xsl:when test="generalization">
                                        <xsl:attribute name="base" select="xoev:qualified-type-name(uml:resolve-general(generalization), ., false())"/>
                                    </xsl:when>
                                    <xsl:when test="xoev:xsdCodeList(.)/(base, @base)">
                                        <xsl:attribute name="base" select="xoev:qualified-type-name(xoev:resolve-base(xoev:xsdCodeList(.)), ., false())"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:attribute name="base">xs:token</xsl:attribute>
                                    </xsl:otherwise>
                                </xsl:choose>
                                <xsl:apply-templates select="." mode="xoev:enumeration"/>
                            </xs:restriction>
                        </xsl:when>
                        <xsl:when test="xoev:xsdUnion(.)">
                            <xs:union memberTypes="{string-join(for $m in xoev:getMemberTypes(.) return $m, ' ')}"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:if test="generalization">
                                <xsl:if test="xoev:xsdRestriction(generalization)">
                                    <xs:restriction base="{xoev:qualified-type-name(uml:resolve-general(generalization),., false())}">
                                        <xsl:if test="xoev:xsdRestriction(generalization)/@enumeration">
                                            <xsl:apply-templates select="xoev:enumeration-by-name(xoev:xsdRestriction(generalization)/@enumeration, root(.))" mode="xoev:enumeration"/>
                                        </xsl:if>
                                        <xsl:for-each select="xoev:xsdRestriction(generalization)/@fractionDigits">
                                            <xs:fractionDigits value="{.}"/>
                                        </xsl:for-each>
                                        <xsl:for-each select="xoev:xsdRestriction(generalization)/@length">
                                            <xs:length value="{.}"/>
                                        </xsl:for-each>
                                        <xsl:for-each select="xoev:xsdRestriction(generalization)/@maxExclusive">
                                            <xs:maxExclusive value="{.}"/>
                                        </xsl:for-each>
                                        <xsl:for-each select="xoev:xsdRestriction(generalization)/@maxInclusive">
                                            <xs:maxInclusive value="{.}"/>
                                        </xsl:for-each>
                                        <xsl:for-each select="xoev:xsdRestriction(generalization)/@maxLength">
                                            <xs:maxLength value="{.}"/>
                                        </xsl:for-each>
                                        <xsl:for-each select="xoev:xsdRestriction(generalization)/@minExclusive">
                                            <xs:minExclusive value="{.}"/>
                                        </xsl:for-each>
                                        <xsl:for-each select="xoev:xsdRestriction(generalization)/@minInclusive">
                                            <xs:minInclusive value="{.}"/>
                                        </xsl:for-each>
                                        <xsl:for-each select="xoev:xsdRestriction(generalization)/@minLength">
                                            <xs:minLength value="{.}"/>
                                        </xsl:for-each>
                                        <xsl:for-each select="xoev:xsdRestriction(generalization)/@pattern">
                                            <xs:pattern value="{xgen:unescaped-xml(.)}"/>
                                        </xsl:for-each>
                                        <xsl:for-each select="xoev:xsdRestriction(generalization)/@totalDigits">
                                            <xs:totalDigits value="{.}"/>
                                        </xsl:for-each>
                                        <xsl:for-each select="xoev:xsdRestriction(generalization)/@whitespace">
                                            <xs:whiteSpace value="{.}"/>
                                        </xsl:for-each>
                                    </xs:restriction>
                                </xsl:if>
                            </xsl:if>
                        </xsl:otherwise>
                    </xsl:choose>
                </xs:simpleType>
            </xsl:when>
            <xsl:when test="generalization[xoev:xsdRestriction(.)]">
                <xs:complexType>
                    <xsl:if test="xoev:xsdMixedContents(.)">
                        <xsl:attribute name="mixed">true</xsl:attribute>
                    </xsl:if>
                    <xsl:if test="xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)">
                        <xsl:attribute name="name" select="xoev:type-name(.)"/>
                    </xsl:if>
                    <xsl:if test="@isAbstract = 'true'">
                        <xsl:attribute name="abstract">true</xsl:attribute>
                    </xsl:if>
                    <xsl:apply-templates select=".[xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)]" mode="xoev:annotation"/>
                    <xsl:choose>
                        <xsl:when test="xoev:topmost-parent(.)/parent::packagedElement/@name = 'W3C Data Types'">
                            <xs:simpleContent>
                                <xs:restriction base="{xoev:qualified-type-name(uml:resolve-general(generalization), ., false())}">
                                    <xsl:apply-templates select="xoev:enumeration-by-name(xoev:xsdRestriction(generalization)/@enumeration, root(.))" mode="xoev:enumeration"/>
                                    <xsl:apply-templates select="xoev:attributes(.)" mode="xoev:attribute"/>
                                </xs:restriction>
                            </xs:simpleContent>
                        </xsl:when>
                        <xsl:otherwise>
                            <xs:complexContent>
                                <xs:restriction base="{xoev:qualified-type-name(uml:resolve-general(generalization), ., false())}">
                                    <xsl:apply-templates select="." mode="xoev:content-model"/>
                                    <xsl:apply-templates select="xoev:attributes(.)" mode="xoev:attribute"/>
                                    <xsl:apply-templates select=".[xoev:xsdWithAnyAttribute(.)]" mode="xoev:anyAttribute"/>
                                </xs:restriction>
                            </xs:complexContent>
                        </xsl:otherwise>
                    </xsl:choose>
                </xs:complexType>
            </xsl:when>
            <xsl:when test="generalization">
                <xs:complexType>
                    <xsl:if test="xoev:xsdMixedContents(.)">
                        <xsl:attribute name="mixed">true</xsl:attribute>
                    </xsl:if>
                    <xsl:if test="xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)">
                        <xsl:attribute name="name" select="xoev:type-name(.)"/>
                    </xsl:if>
                    <xsl:if test="@isAbstract = 'true'">
                        <xsl:attribute name="abstract">true</xsl:attribute>
                    </xsl:if>
                    <xsl:apply-templates select=".[xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)]" mode="xoev:annotation"/>
                    <xsl:choose>
                        <xsl:when test="xoev:topmost-parent(.)/parent::packagedElement/@name = 'W3C Data Types'">
                            <xs:simpleContent>
                                <xsl:variable name="generalType" select="uml:resolve-general(generalization)"/>
                                <xs:extension base="{xoev:qualified-type-name($generalType, ., false())}">
                                    <xsl:apply-templates select="xoev:attributes(.)" mode="xoev:attribute"/>
                                    <xsl:apply-templates select=".[xoev:xsdWithAnyAttribute(.)]" mode="xoev:anyAttribute"/>
                                </xs:extension>
                            </xs:simpleContent>
                        </xsl:when>
                        <xsl:otherwise>
                            <xs:complexContent>
                                <xsl:variable name="generalType" select="uml:resolve-general(generalization)"/>
                                <xs:extension base="{xoev:qualified-type-name($generalType, ., false())}">
                                    <xsl:apply-templates select="." mode="xoev:content-model"/>
                                    <xsl:apply-templates select="xoev:attributes(.)" mode="xoev:attribute"/>
                                    <xsl:apply-templates select=".[xoev:xsdWithAnyAttribute(.)]" mode="xoev:anyAttribute"/>
                                </xs:extension>
                            </xs:complexContent>
                        </xsl:otherwise>
                    </xsl:choose>
                </xs:complexType>
            </xsl:when>
            <xsl:otherwise>
                <xs:complexType>
                    <xsl:if test="xoev:xsdMixedContents(.)">
                        <xsl:attribute name="mixed">true</xsl:attribute>
                    </xsl:if>
                    <xsl:if test="xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)">
                        <xsl:attribute name="name" select="xoev:type-name(.)"/>
                    </xsl:if>
                    <xsl:if test="@isAbstract = 'true'">
                        <xsl:attribute name="abstract">true</xsl:attribute>
                    </xsl:if>
                    <xsl:apply-templates select=".[xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)]" mode="xoev:annotation"/>
                    <xsl:apply-templates select="." mode="xoev:content-model"/>
                    <xsl:apply-templates select="xoev:attributes(.)" mode="xoev:attribute"/>
                    <xsl:apply-templates select=".[xoev:xsdWithAnyAttribute(.)]" mode="xoev:anyAttribute"/>
                </xs:complexType>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="packagedElement | nestedClassifier" mode="xoev:anyAttribute">
        <xs:anyAttribute namespace="{xoev:xsdWithAnyAttribute(.)/@namespace}" processContents="{xoev:xsdWithAnyAttribute(.)/@processContents}"/>
    </xsl:template>

    <xsl:template match="packagedElement | nestedClassifier" mode="xoev:enumeration">
        <xsl:for-each select="ownedLiteral[not(xoev:xoevCodelisteneintrag(.)/@obsolet = 'true') and not(xoev:xsdDraft(.))]">
            <xsl:sort select="lower-case(@name)"/>
            <xs:enumeration value="{@name}">
                <xsl:apply-templates select="." mode="xoev:annotation"/>
            </xs:enumeration>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="packagedElement" mode="xoev:codelist-instance">
        <xsl:param name="code-spalte" as="element()" required="yes"/>
        <xs:enumeration value="{slot[uml:resolve-definingFeature(.)/@xmi:id = $code-spalte/@xmi:id]/value/@value/normalize-space(.)}">
            <xs:annotation>
                <xs:appinfo>
                    <xsl:for-each select="slot[not(uml:resolve-definingFeature(.)/@xmi:id = $code-spalte/@xmi:id)]">
                        <xsl:element name="{uml:resolve-definingFeature(.)/@name}">
                            <xsl:value-of select="normalize-space(value/@value)"/>
                        </xsl:element>
                    </xsl:for-each>
                </xs:appinfo>
            </xs:annotation>
        </xs:enumeration>
    </xsl:template>

    <xsl:template match="element(*)" mode="xoev:content-model">
        <xsl:choose>
            <xsl:when test="xoev:xsdAnyContents(.)">
                <xs:sequence>
                    <xsl:for-each select="xoev:xsdModelGroup(.)/@minOccurs[. != '']">
                        <xsl:attribute name="minOccurs" select="."/>
                    </xsl:for-each>
                    <xsl:for-each select="xoev:xsdModelGroup(.)/@maxOccurs[. != '']">
                        <xsl:attribute name="maxOccurs" select="."/>
                    </xsl:for-each>
                    <xs:any minOccurs="{xoev:xsdAnyContents(.)/@minOccurs}" maxOccurs="{xoev:xsdAnyContents(.)/@maxOccurs}" namespace="{xoev:xsdAnyContents(.)/@namespace}" processContents="{xoev:xsdAnyContents(.)/@processContents}"/>
                </xs:sequence>
            </xsl:when>
            <xsl:when test="xoev:elements(.) and xoev:xsdChoice(.)">
                <xs:choice>
                    <xsl:for-each select="xoev:xsdModelGroup(.)/@minOccurs[. != '']">
                        <xsl:attribute name="minOccurs" select="."/>
                    </xsl:for-each>
                    <xsl:for-each select="xoev:xsdModelGroup(.)/@maxOccurs[. != '']">
                        <xsl:attribute name="maxOccurs" select="."/>
                    </xsl:for-each>
                    <xsl:apply-templates select="xoev:elements(.)" mode="xoev:element"/>
                </xs:choice>
            </xsl:when>
            <xsl:when test="xoev:elements(.) and xoev:xsdAll(.)">
                <xs:all>
                    <xsl:for-each select="xoev:xsdModelGroup(.)/@minOccurs[. != '']">
                        <xsl:attribute name="minOccurs" select="."/>
                    </xsl:for-each>
                    <xsl:for-each select="xoev:xsdModelGroup(.)/@maxOccurs[. != '']">
                        <xsl:attribute name="maxOccurs" select="."/>
                    </xsl:for-each>
                    <xsl:apply-templates select="xoev:elements(.)" mode="xoev:element"/>
                </xs:all>
            </xsl:when>
            <xsl:when test="xoev:elements(.)">
                <xs:sequence>
                    <xsl:for-each select="xoev:xsdModelGroup(.)/@minOccurs[. != '']">
                        <xsl:attribute name="minOccurs" select="."/>
                    </xsl:for-each>
                    <xsl:for-each select="xoev:xsdModelGroup(.)/@maxOccurs[. != '']">
                        <xsl:attribute name="maxOccurs" select="."/>
                    </xsl:for-each>
                    <xsl:apply-templates select="xoev:elements(.)" mode="xoev:element"/>
                </xs:sequence>
            </xsl:when>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="ownedAttribute" mode="xoev:element">
        <xsl:choose>
            <xsl:when test="xoev:xsdLocalStructure(.) and xoev:xsdAnyContents(uml:resolve-type(.))">
                <xsl:variable name="xsdAnyContents" select="xoev:xsdAnyContents(uml:resolve-type(.))"/>
                <xs:any minOccurs="{($xsdAnyContents/@minOccurs,'0')[1]}" maxOccurs="{($xsdAnyContents/@maxOccurs,'unbounded')[1]}">
                    <xsl:for-each select="$xsdAnyContents/@namespace">
                        <xsl:attribute name="namespace" select="."/>
                    </xsl:for-each>
                    <xsl:attribute name="processContents" select="$xsdAnyContents/@processContents"/>
                </xs:any>
            </xsl:when>
            <xsl:when test="xoev:xsdLocalStructure(.) and xoev:xsdChoice(uml:resolve-type(.))">
                <xs:choice>
                    <xsl:for-each select="uml:resolve-type(.)/xoev:xsdModelGroup(.)/@minOccurs[. != '']">
                        <xsl:attribute name="minOccurs" select="."/>
                    </xsl:for-each>
                    <xsl:for-each select="uml:resolve-type(.)/xoev:xsdModelGroup(.)/@maxOccurs[. != '']">
                        <xsl:attribute name="maxOccurs" select="."/>
                    </xsl:for-each>
                    <xsl:apply-templates select="." mode="xoev:element-content"/>
                </xs:choice>
            </xsl:when>
            <xsl:when test="xoev:xsdLocalStructure(.)">
                <xs:sequence>
                    <xsl:for-each select="uml:resolve-type(.)/xoev:xsdModelGroup(.)/@minOccurs[. != '']">
                        <xsl:attribute name="minOccurs" select="."/>
                    </xsl:for-each>
                    <xsl:for-each select="uml:resolve-type(.)/xoev:xsdModelGroup(.)/@maxOccurs[. != '']">
                        <xsl:attribute name="maxOccurs" select="."/>
                    </xsl:for-each>
                    <xsl:apply-templates select="." mode="xoev:element-content"/>
                </xs:sequence>
            </xsl:when>
            <xsl:when test="uml:resolve-type(.)/xoev:xsdGroup(.)">
                <xs:group>
                    <xsl:for-each select="uml:resolve-type(.)/xoev:xsdModelGroup(.)/@minOccurs[. != '']">
                        <xsl:attribute name="minOccurs" select="."/>
                    </xsl:for-each>
                    <xsl:for-each select="uml:resolve-type(.)/xoev:xsdModelGroup(.)/@maxOccurs[. != '']">
                        <xsl:attribute name="maxOccurs" select="."/>
                    </xsl:for-each>
                    <xsl:apply-templates select="." mode="xoev:element-content"/>
                </xs:group>
            </xsl:when>
            <xsl:otherwise>
                <xs:element>
                    <xsl:apply-templates select="." mode="xoev:element-content"/>
                </xs:element>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="ownedAttribute" mode="xoev:element-content">
        <xsl:choose>
            <xsl:when test="xoev:is-ref(.) or uml:resolve-type(.)/xoev:xsdGroup(.)">
                <xsl:attribute name="ref" select="xoev:qualified-type-name(uml:resolve-type(.), ., true())"/>
            </xsl:when>
            <xsl:when test="xoev:xsdLocalStructure(.)"/>
            <xsl:otherwise>
                <xsl:attribute name="name" select="@name"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="xoev:lowerBound(.) != 1">
            <xsl:attribute name="minOccurs">
                <xsl:value-of select="xoev:lowerBound(.)"/>
            </xsl:attribute>
        </xsl:if>
        <xsl:if test="not(empty(xoev:upperBound(.)[. != 1]))">
            <xsl:attribute name="maxOccurs">
                <xsl:value-of select="
                        if (xoev:upperBound(.) = -1) then
                            'unbounded'
                        else
                            xoev:upperBound(.)"/>
            </xsl:attribute>
        </xsl:if>
        <xsl:if test="xoev:xsdElement(.)/@nillable">
            <xsl:attribute name="nillable">true</xsl:attribute>
        </xsl:if>
        <xsl:apply-templates select="." mode="xoev:default"/>
        <xsl:if test="not(xoev:is-ref(.)) and not(xoev:xsdLocalStructure(.)) and not(xoev:xsdGroup(.))">
            <xsl:if test="uml:resolve-type(.)/parent::packagedElement/@name = 'W3C Data Types' or uml:resolve-type(.)[xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)]">
                <xsl:attribute name="type" select="xoev:qualified-type-name(uml:resolve-type(.), ., false())"/>
            </xsl:if>
            <xsl:if test="xoev:xsdElement(.) and not(xoev:xsdElement(.)/@form = 'default')">
                <xsl:attribute name="form" select="xoev:xsdElement(.)/@form"/>
            </xsl:if>
        </xsl:if>
        <xsl:apply-templates select="." mode="xoev:annotation"/>
        <xsl:if test="
            not(uml:resolve-type(.)/xoev:isReferenceableByName(.) or xoev:is-ref(.) or xoev:xsdLocalStructure(.))">
            <xsl:apply-templates select="uml:resolve-type(.)" mode="xoev:type"/>
        </xsl:if>
        <xsl:if test="xoev:xsdLocalStructure(.)">
            <xsl:apply-templates select="xoev:elements(uml:resolve-type(.))" mode="xoev:element"/>
        </xsl:if>
        <xsl:apply-templates select="(., uml:resolve-association(.))/xoev:dependencies-by-client(.)[xoev:xsdUnique(.)]" mode="xoev:unique-constraint">
            <xsl:sort select="@name"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="(., uml:resolve-association(.))/xoev:dependencies-by-client(.)[xoev:xsdKey(.)]" mode="xoev:key-constraint">
            <xsl:sort select="@name"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="(., uml:resolve-association(.))/xoev:dependencies-by-client(.)[xoev:xsdKeyref(.)]" mode="xoev:keyref-constraint">
            <xsl:sort select="@name"/>
        </xsl:apply-templates>
    </xsl:template>

    <xsl:template match="ownedAttribute" mode="xoev:attribute">
        <xsl:choose>
            <xsl:when test="xoev:is-ref(.) and uml:resolve-type(.)[xoev:xsdGlobalAttribute(.)]">
                <xs:attribute ref="{xoev:qualified-type-name(uml:resolve-type(.),.,true())}">

                    <xsl:apply-templates select="." mode="xoev:attribute-use"/>
                    <xsl:apply-templates select="." mode="xoev:default"/>
                    <xsl:apply-templates select="." mode="xoev:annotation"/>

                </xs:attribute>
            </xsl:when>
            <xsl:when test="xoev:is-ref(.)">
                <xs:attributeGroup ref="{xoev:qualified-type-name(uml:resolve-type(.),.,true())}">
                    <xsl:apply-templates select="." mode="xoev:default"/>
                    <xsl:apply-templates select="." mode="xoev:annotation"/>
                </xs:attributeGroup>
            </xsl:when>
            <xsl:otherwise>
                <xs:attribute name="{@name}">

                    <xsl:choose>
                        <xsl:when test="
                                uml:resolve-type(.)[xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)] and xoev:topmost-parent(uml:resolve-type(.))/parent::packagedElement/@name = 'W3C Data Types' or
                                uml:resolve-type(.)/parent::packagedElement/@name = 'W3C Data Types'">
                            <xsl:attribute name="type" select="xoev:qualified-type-name(uml:resolve-type(.), ., false())"/>
                        </xsl:when>
                        <xsl:when test="uml:resolve-type(.)[xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)]">
                            <xsl:attribute name="type">xs:IDREF</xsl:attribute>
                        </xsl:when>
                    </xsl:choose>

                    <xsl:apply-templates select="." mode="xoev:attribute-use"/>
                    <xsl:apply-templates select="." mode="xoev:default"/>
                    <xsl:apply-templates select="." mode="xoev:annotation"/>
                    <xsl:if test="not(uml:resolve-type(.)[xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)]) and not(uml:resolve-type(.)/parent::packagedElement/@name = 'W3C Data Types')">
                        <xsl:apply-templates select="uml:resolve-type(.)" mode="xoev:type"/>
                    </xsl:if>
                </xs:attribute>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="ownedAttribute" mode="xoev:attribute-use">
        <xsl:choose>
            <xsl:when test="lowerValue/@value = 1 or not(lowerValue)">
                <xsl:attribute name="use">required</xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
                <xsl:attribute name="use">optional</xsl:attribute>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="ownedAttribute" mode="xoev:default">
        <xsl:variable name="default-value" select="defaultValue/(@value, body, uml:resolve-instance(.)/@name)[1]"/>
        <xsl:choose>
            <xsl:when test="$default-value and not($default-value = '') and @isReadOnly = 'true'">
                <xsl:attribute name="fixed" select="$default-value"/>
            </xsl:when>
            <xsl:when test="$default-value and not($default-value = '')">
                <xsl:attribute name="default" select="$default-value"/>
            </xsl:when>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="packagedElement" mode="xoev:element">
        <xsl:variable name="globalElementType" select="
                uml:resolve-supplier(xoev:dependencies-by-client(.)[xoev:xsdGlobalElementType(.)]),
                if (xoev:xsdGlobalElementAndNamedType(.)) then
                    .
                else
                    ()"/>
        <xsl:choose>
            <xsl:when test="$globalElementType">
                <xs:element name="{xoev:global-element-name(.)}" type="{xoev:qualified-type-name($globalElementType,.,false())}">
                    <xsl:apply-templates select="." mode="xoev:annotation"/>
                </xs:element>
            </xsl:when>
            <xsl:otherwise>
                <xsl:element name="xs:element">
                    <xsl:attribute name="name" select="xoev:global-element-name(.)"/>
                    <xsl:if test="xoev:xsdElement(.)/@form">
                        <xsl:attribute name="form" select="xoev:xsdElement(.)/@form"/>
                    </xsl:if>
                    <xsl:apply-templates select="." mode="xoev:annotation"/>
                    <xsl:apply-templates select="." mode="xoev:type"/>
                    <xsl:apply-templates select="(., uml:resolve-association(.))/xoev:dependencies-by-client(.)[xoev:xsdUnique(.)]" mode="xoev:unique-constraint">
                        <xsl:sort select="@name"/>
                    </xsl:apply-templates>
                    <xsl:apply-templates select="(., uml:resolve-association(.))/xoev:dependencies-by-client(.)[xoev:xsdKey(.)]" mode="xoev:key-constraint">
                        <xsl:sort select="@name"/>
                    </xsl:apply-templates>
                    <xsl:apply-templates select="(., uml:resolve-association(.))/xoev:dependencies-by-client(.)[xoev:xsdKeyref(.)]" mode="xoev:keyref-constraint">
                        <xsl:sort select="@name"/>
                    </xsl:apply-templates>
                </xsl:element>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="packagedElement | nestedClassifier" mode="xoev:attribute">
        <xsl:variable name="globalAttributeType" select="uml:resolve-supplier(xoev:dependencies-by-client(.)[xoev:xsdGlobalAttributeType(.)])"/>
        <xsl:choose>
            <xsl:when test="$globalAttributeType[xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.) or parent::packagedElement/@name = 'W3C Data Types']">
                <xs:attribute name="{@name}" type="{xoev:qualified-type-name(uml:resolve-supplier(xoev:dependencies-by-client(.)[xoev:xsdGlobalAttributeType(.)]),.,false())}">
                    <xsl:apply-templates select="." mode="xoev:default"/>
                    <xsl:apply-templates select="." mode="xoev:annotation"/>
                </xs:attribute>
            </xsl:when>
            <xsl:otherwise>
                <xsl:element name="xs:attribute">
                    <xsl:attribute name="name" select="@name"/>
                    <xsl:apply-templates select="." mode="xoev:default"/>
                    <xsl:apply-templates select="." mode="xoev:annotation"/>
                    <xsl:apply-templates select="$globalAttributeType" mode="xoev:type"/>
                </xsl:element>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="packagedElement" mode="xoev:default">
        <xsl:for-each select="xoev:xsdGlobalAttribute(.)/@defaultwert[. != '']">
            <xsl:attribute name="default" select="."/>
        </xsl:for-each>
        <xsl:for-each select="xoev:xsdGlobalAttribute(.)/@fixedwert[. != '']">
            <xsl:attribute name="fixed" select="."/>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="element(*)" mode="xoev:appinfo-xoevCodeliste">
        <xsl:variable name="cl" select="."/>
        <xsl:for-each select="xoev:xoevCodeliste(.)">
            <codeliste>
                <xsl:for-each select="xoev:metadatenelement-in-genutzter-sprache(nameLang, $cl)">
                    <nameLang>
                        <xsl:apply-templates select="." mode="xoev:metadatenwert"/>
                    </nameLang>
                </xsl:for-each>
                <xsl:for-each select="xoev:metadatenelement-in-genutzter-sprache(nameKurz, $cl)">
                    <nameKurz>
                        <xsl:apply-templates select="." mode="xoev:metadatenwert"/>
                    </nameKurz>
                </xsl:for-each>
                <xsl:for-each select="@nameTechnisch[. != '']">
                    <nameTechnisch>
                        <xsl:value-of select="."/>
                    </nameTechnisch>
                </xsl:for-each>
                <xsl:for-each select="@kennung[. != '']">
                    <kennung>
                        <xsl:value-of select="."/>
                    </kennung>
                </xsl:for-each>
                <xsl:for-each select="xoev:metadatenelement-in-genutzter-sprache(beschreibung, $cl)">
                    <beschreibung>
                        <xsl:apply-templates select="." mode="xoev:metadatenwert">
                            <xsl:with-param name="clean">true</xsl:with-param>
                        </xsl:apply-templates>
                    </beschreibung>
                </xsl:for-each>
                <xsl:for-each select="xoev:metadatenelement-in-genutzter-sprache(herausgebernameLang, $cl)">
                    <herausgebernameLang>
                        <xsl:apply-templates select="." mode="xoev:metadatenwert"/>
                    </herausgebernameLang>
                </xsl:for-each>
                <xsl:for-each select="xoev:metadatenelement-in-genutzter-sprache(herausgebernameKurz, $cl)">
                    <herausgebernameKurz>
                        <xsl:apply-templates select="." mode="xoev:metadatenwert"/>
                    </herausgebernameKurz>
                </xsl:for-each>
            </codeliste>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="element(*)" mode="xoev:appinfo-xoevVersionCodeliste">
        <xsl:variable name="vcl" select="."/>
        <xsl:for-each select="xoev:xoevVersionCodeliste(.)">
            <versionCodeliste>
                <xsl:for-each select="@version[. != '']">
                    <version>
                        <xsl:value-of select="."/>
                    </version>
                </xsl:for-each>
                <xsl:for-each select="xoev:metadatenelement-in-genutzter-sprache(beschreibung, $vcl)">
                    <beschreibung>
                        <xsl:apply-templates select="." mode="xoev:metadatenwert"/>
                    </beschreibung>
                </xsl:for-each>
                <xsl:for-each select="bezugsort[. != '']">
                    <bezugsort>
                        <xsl:value-of select="."/>
                    </bezugsort>
                </xsl:for-each>
                <xsl:for-each select="@datumGueltigkeitAb[. != '']">
                    <datumGueltigkeitAb>
                        <xsl:value-of select="."/>
                    </datumGueltigkeitAb>
                </xsl:for-each>
                <xsl:for-each select="@versionXOEVHandbuch[. != '']">
                    <versionXOEVHandbuch>
                        <xsl:value-of select="."/>
                    </versionXOEVHandbuch>
                </xsl:for-each>
                <xsl:for-each select="@versionCodelistenHandbuch[. != '']">
                    <versionCodelistenHandbuch>
                        <xsl:value-of select="."/>
                    </versionCodelistenHandbuch>
                </xsl:for-each>
                <xsl:for-each select="xoev:metadatenelement-in-genutzter-sprache(aenderungZurVorversion, $vcl)">
                    <aenderungZurVorversion>
                        <xsl:apply-templates select="." mode="xoev:metadatenwert"/>
                    </aenderungZurVorversion>
                </xsl:for-each>
            </versionCodeliste>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="element(*)" mode="xoev:appinfo-whiteListBlackList">
        <xsl:variable name="code-spalte" select="
                ((xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.))/@genutzteCodeSpalte/xoev:ids-to-elements(., root()),
                uml:resolve-supplier(.)/ownedAttribute[xoev:xoevCodelistenspalte(.)/@empfohleneCodeSpalte = 'true'],
                uml:resolve-supplier(.)/ownedAttribute[xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true'])[1]"/>
        <xsl:variable name="whiteList" select="xoev:xoevCodeTyp1(.)/@whiteList"/>
        <xsl:variable name="blackList" select="xoev:xoevCodeTyp1(.)/@blackList"/>
        <xsl:element name="{if ($whiteList[. != '']) then
            'whiteList'
            else
            'blackList'}">
            <xsl:for-each select="
                    xoev:ids-to-elements(tokenize(
                    if ($whiteList[. != '']) then
                        $whiteList
                    else
                        $blackList, ' '), root())">
                <code>
                    <xsl:value-of select="slot[uml:resolve-definingFeature(.)/@xmi:id = $code-spalte/@xmi:id]/value/@value"/>
                </code>
            </xsl:for-each>
        </xsl:element>
    </xsl:template>

    <xsl:template match="element(*)" mode="xoev:appinfo-xoevCodelistenspalten">
        <xsl:for-each select="xoev:xoevCodelistenspalten(.)">
            <codelistenspalten>
                <xsl:for-each select="@codeSpalte[. != '']">
                    <codeSpalte>
                        <xsl:value-of select="."/>
                    </codeSpalte>
                </xsl:for-each>
                <xsl:for-each select="@ersteBeschreibungsspalte[. != '']">
                    <ersteBeschreibungsspalte>
                        <xsl:value-of select="."/>
                    </ersteBeschreibungsspalte>
                </xsl:for-each>
                <xsl:for-each select="@zweiteBeschreibungsspalte[. != '']">
                    <zweiteBeschreibungsspalte>
                        <xsl:value-of select="."/>
                    </zweiteBeschreibungsspalte>
                </xsl:for-each>
            </codelistenspalten>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="element(*)" mode="xoev:appinfo-xoevCodelistenspalte">
        <codelistenspalten>
            <xsl:for-each select="ownedAttribute">
                <xsl:element name="{@name}">
                    <xsl:for-each select="xoev:xoevCodelistenspalte(.)/@spaltennameLang[. != '']">
                        <spaltennameLang>
                            <xsl:value-of select="."/>
                        </spaltennameLang>
                    </xsl:for-each>
                    <datentyp>
                        <xsl:value-of select="(xoev:xoevCodelistenspalte(.)/@datentyp, 'string')[1]"/>
                    </datentyp>
                    <xsl:for-each select="xoev:xoevCodelistenspalte(.)/@sprache[. != '']">
                        <sprache>
                            <xsl:value-of select="."/>
                        </sprache>
                    </xsl:for-each>
                    <codeSpalte>
                        <xsl:value-of select="xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true'"/>
                    </codeSpalte>
                    <verwendung>
                        <xsl:value-of select="(xoev:xoevCodelistenspalte(.)/@verwendung, 'required')[1]"/>
                    </verwendung>
                    <empfohleneCodeSpalte>
                        <xsl:value-of select="xoev:xoevCodelistenspalte(.)/@empfohleneCodeSpalte = 'true'"/>
                    </empfohleneCodeSpalte>
                </xsl:element>
            </xsl:for-each>
        </codelistenspalten>
    </xsl:template>

    <xsl:template match="element(*)" mode="xoev:appinfo-genutzte-code-spalte">
        <xsl:variable name="code-spalte" select="
                ((xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.))/@genutzteCodeSpalte/xoev:ids-to-elements(., root())/@name,
                xoev:xoevCodeTyp3(.)/@genutzteCodeSpalte,
                uml:resolve-supplier(.)/ownedAttribute[xoev:xoevCodelistenspalte(.)/@empfohleneCodeSpalte = 'true']/@name,
                uml:resolve-supplier(.)/ownedAttribute[xoev:xoevCodelistenspalte(.)/@codeSpalte = 'true']/@name)[1]"/>
        <xsl:if test="$code-spalte[. != '']">
            <genutzteCodeSpalte>
                <xsl:value-of select="$code-spalte"/>
            </genutzteCodeSpalte>
        </xsl:if>
    </xsl:template>

    <xsl:template match="element(*)" mode="xoev:appinfo-genutzte-name-spalte">
        <genutzteBeschreibungsspalte>
            <xsl:value-of select="((xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.))/@genutzteBeschreibungsspalte/xoev:ids-to-elements(., root())/@name, xoev:xoevCodeTyp3(.)/@genutzteBeschreibungsspalte)[1]"/>
        </genutzteBeschreibungsspalte>
    </xsl:template>

    <xsl:template match="element(*)" mode="xoev:annotation">
        <xsl:variable name="currentElement" select="."/>
        <xsl:variable name="appinfo" as="element()">
            <xs:appinfo>
                <xsl:apply-templates select="xoev:usages-by-client(.)[xoev:xoevCodeTyp1(.) or xoev:xoevCodeTyp2(.)]/uml:resolve-supplier(.)/xoev:dependencies-by-client(.)/uml:resolve-supplier(.)" mode="xoev:appinfo-xoevCodeliste"/>
                <xsl:apply-templates select="xoev:usages-by-client(.)[not($currentElement/xoev:xoevCodeTyp4(.)) and not(xoev:xoevCodeTyp1(.) or xoev:xoevCodeTyp2(.))]/uml:resolve-supplier(.)" mode="xoev:appinfo-xoevCodeliste"/>
                <xsl:apply-templates select="xoev:usages-by-client(.)[xoev:xoevCodeTyp1(.) or xoev:xoevCodeTyp2(.)]/uml:resolve-supplier(.)" mode="xoev:appinfo-xoevVersionCodeliste"/>
                <xsl:apply-templates select="xoev:usages-by-client(.)[(xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.))/(@whiteList, @blackList)[. != '']]" mode="xoev:appinfo-whiteListBlackList"/>
                <xsl:apply-templates select="xoev:usages-by-client(.)[xoev:xoevCodeTyp1(.) or xoev:xoevCodeTyp2(.)]/uml:resolve-supplier(.)" mode="xoev:appinfo-xoevCodelistenspalte"/>
                <xsl:apply-templates select="xoev:usages-by-client(.)" mode="xoev:appinfo-genutzte-code-spalte"/>
                <xsl:apply-templates select="xoev:usages-by-client(.)[not(empty((xoev:xoevCodeTyp1(.), xoev:xoevCodeTyp2(.), xoev:xoevCodeTyp3(.))/@genutzteNameSpalte))]" mode="xoev:appinfo-genutzte-name-spalte"/>

                <xsl:apply-templates select=".[xoev:xoevVersionCodeliste(.) and uml:is-Class(.)]/xoev:dependencies-by-client(.)/uml:resolve-supplier(.)" mode="xoev:appinfo-xoevCodeliste"/>
                <xsl:apply-templates select=".[xoev:xoevVersionCodeliste(.) and uml:is-Class(.)]" mode="xoev:appinfo-xoevVersionCodeliste"/>
                <xsl:apply-templates select=".[xoev:xoevVersionCodeliste(.) and uml:is-Class(.)]" mode="xoev:appinfo-xoevCodelistenspalte"/>

                <xsl:apply-templates select="xoev:codelist-by-uri($currentElement/ownedAttribute[@name = 'listURI']/defaultValue/(@value, body)[1], .)[ancestor::packagedElement[xoev:xsdXModel(.)]/@xmi:id = $currentElement/ancestor::packagedElement[xoev:xsdXModel(.)]/@xmi:id]" mode="xoev:appinfo-xoevCodeliste"/>
                <xsl:apply-templates select="xoev:codelist-by-uri($currentElement/ownedAttribute[@name = 'listURI']/defaultValue/(@value, body)[1], .)[ancestor::packagedElement[xoev:xsdXModel(.)]/@xmi:id = $currentElement/ancestor::packagedElement[xoev:xsdXModel(.)]/@xmi:id]" mode="xoev:appinfo-xoevVersionCodeliste"/>
                <xsl:apply-templates select="xoev:codelist-by-uri($currentElement/ownedAttribute[@name = 'listURI']/defaultValue/(@value, body)[1], .)[ancestor::packagedElement[xoev:xsdXModel(.)]/@xmi:id = $currentElement/ancestor::packagedElement[xoev:xsdXModel(.)]/@xmi:id]" mode="xoev:appinfo-xoevCodelistenspalten"/>
                <xsl:apply-templates select=".[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)) and not(uml:is-Class(.))]" mode="xoev:appinfo-xoevCodeliste"/>
                <xsl:apply-templates select=".[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)) and not(uml:is-Class(.))]" mode="xoev:appinfo-xoevVersionCodeliste"/>
                <xsl:apply-templates select=".[(xoev:xsdNamedType(.) or xoev:xsdGlobalElementAndNamedType(.)) and not(uml:is-Class(.))]" mode="xoev:appinfo-xoevCodelistenspalten"/>

                <xsl:for-each select="xoev:xoevDatentyp(.)">
                    <datentyp>
                        <xsl:for-each select="@nameLang[. != '']">
                            <nameLang>
                                <xsl:value-of select="."/>
                            </nameLang>
                        </xsl:for-each>
                        <xsl:for-each select="@nameKurz[. != '']">
                            <nameKurz>
                                <xsl:value-of select="."/>
                            </nameKurz>
                        </xsl:for-each>
                        <xsl:for-each select="@nameTechnisch[. != '']">
                            <nameTechnisch>
                                <xsl:value-of select="."/>
                            </nameTechnisch>
                        </xsl:for-each>
                        <xsl:for-each select="@kennung[. != '']">
                            <kennung>
                                <xsl:value-of select="."/>
                            </kennung>
                        </xsl:for-each>
                        <xsl:for-each select="@herausgebernameLang[. != '']">
                            <herausgebernameLang>
                                <xsl:value-of select="."/>
                            </herausgebernameLang>
                        </xsl:for-each>
                        <xsl:for-each select="@herausgebernameKurz[. != '']">
                            <herausgebernameKurz>
                                <xsl:value-of select="."/>
                            </herausgebernameKurz>
                        </xsl:for-each>
                        <xsl:for-each select="@externeWebsite[. != '']">
                            <externeWebsite>
                                <xsl:value-of select="."/>
                            </externeWebsite>
                        </xsl:for-each>
                    </datentyp>
                </xsl:for-each>
                <xsl:for-each select="xoev:xoevVersionDatentyp(.)">
                    <versionDatentyp>
                        <xsl:for-each select="@version[. != '']">
                            <version>
                                <xsl:value-of select="."/>
                            </version>
                        </xsl:for-each>
                        <xsl:for-each select="@beschreibung[. != '']">
                            <beschreibung>
                                <xsl:value-of select="."/>
                            </beschreibung>
                        </xsl:for-each>
                        <xsl:for-each select="@lizenz[. != '']">
                            <lizenz>
                                <xsl:value-of select="."/>
                            </lizenz>
                        </xsl:for-each>
                        <xsl:for-each select="@bezugsort[. != '']">
                            <bezugsort>
                                <xsl:value-of select="."/>
                            </bezugsort>
                        </xsl:for-each>
                        <xsl:for-each select="@aenderungZurVorversion[. != '']">
                            <aenderungZurVorversion>
                                <xsl:value-of select="."/>
                            </aenderungZurVorversion>
                        </xsl:for-each>
                    </versionDatentyp>
                </xsl:for-each>
                <xsl:for-each select="ancestor::packagedElement/xoev:xoevStandard(.)[xoev:xsdSchema($currentElement)]">
                    <standard>
                        <nameLang>
                            <xsl:value-of select="@nameLang"/>
                        </nameLang>
                        <nameKurz>
                            <xsl:value-of select="@nameKurz"/>
                        </nameKurz>
                        <nameTechnisch>
                            <xsl:value-of select="@nameTechnisch"/>
                        </nameTechnisch>
                        <kennung>
                            <xsl:value-of select="@kennung"/>
                        </kennung>
                        <beschreibung>
                            <xsl:value-of select="@beschreibung/xgen:unescaped-xml(.)"/>
                        </beschreibung>
                    </standard>
                </xsl:for-each>
                <xsl:for-each select="ancestor::packagedElement/xoev:xoevVersionStandard(.)[xoev:xsdSchema($currentElement)]">
                    <versionStandard>
                        <version>
                            <xsl:value-of select="@version"/>
                        </version>
                        <xsl:for-each select="@beschreibung[. != '']">
                            <beschreibung>
                                <xsl:value-of select="xgen:unescaped-xml(xoev:clean-text(.))"/>
                            </beschreibung>
                        </xsl:for-each>
                        <versionXOEVProfil>
                            <xsl:value-of select="$xoev:version"/>
                        </versionXOEVProfil>
                        <versionXOEVHandbuch>
                            <xsl:value-of select="@versionXOEVHandbuch"/>
                        </versionXOEVHandbuch>
                        <versionXGenerator>
                            <xsl:value-of select="@versionXGenerator"/>
                        </versionXGenerator>
                        <versionModellierungswerkzeug>
                            <xsl:value-of select="@versionModellierungswerkzeug"/>
                        </versionModellierungswerkzeug>
                        <nameModellierungswerkzeug>
                            <xsl:value-of select="@nameModellierungswerkzeug"/>
                        </nameModellierungswerkzeug>
                    </versionStandard>
                </xsl:for-each>
                <xsl:for-each select="xoev:xoevCodelisteneintrag(.)/@wertErsteBeschreibungsspalte[. != '']">
                    <wertErsteBeschreibungsspalte>
                        <xsl:choose>
                            <xsl:when test="starts-with(replace(., ' ', ''), '&lt;para>')">
                                <xsl:value-of select="xoev:clean-text(.)"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="normalize-space(.)"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </wertErsteBeschreibungsspalte>
                </xsl:for-each>
                <xsl:for-each select="xoev:xoevCodelisteneintrag(.)/@wertZweiteBeschreibungsspalte[. != '']">
                    <wertZweiteBeschreibungsspalte>
                        <xsl:choose>
                            <xsl:when test="starts-with(replace(., ' ', ''), '&lt;para>')">
                                <xsl:value-of select="xoev:clean-text(.)"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="normalize-space(.)"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </wertZweiteBeschreibungsspalte>
                </xsl:for-each>
                <xsl:for-each select="xoev:xsdMessage(.)/@autor">
                    <autor>
                        <xsl:value-of select="."/>
                    </autor>
                </xsl:for-each>
                <xsl:for-each select="xoev:xsdMessage(.)/@leser">
                    <leser>
                        <xsl:value-of select="."/>
                    </leser>
                </xsl:for-each>
                <xsl:for-each select="xoev:xsdMessage(.)/rechtsgrundlagen">
                    <xsl:sort select="."/>
                    <rechtsgrundlage>
                        <xsl:value-of select="."/>
                    </rechtsgrundlage>
                </xsl:for-each>
                <xsl:for-each select="xoev:xsdTitled(.)/@title[not(. = '')]">
                    <title>
                        <xsl:value-of select="xoev:clean-text(.)"/>
                    </title>
                </xsl:for-each>
                <xsl:for-each select="xoev:xsdWithImplementationHint(.)/@implementationHint">
                    <implementationHint>
                        <xsl:value-of select="xoev:clean-text(.)"/>
                    </implementationHint>
                </xsl:for-each>
            </xs:appinfo>
        </xsl:variable>
        <xsl:variable name="documentation" as="element()*">
            <xsl:apply-templates select="." mode="xoev:documentation"/>
        </xsl:variable>

        <xsl:if test="$appinfo/* or $documentation">
            <xs:annotation>
                <xsl:sequence select="$appinfo[*], $documentation"/>
            </xs:annotation>
        </xsl:if>
    </xsl:template>

    <xsl:template match="element(*)" mode="xoev:documentation">
        <!-- Ausnahme bei der Prüfung auf leere Strings (da ein leerer Comment schnell unbemerkt erzeugt werden kann): -->
        <xsl:if test="
                not(some $c in ownedComment/body
                    satisfies xoev:clean-text($c) = '[nd]')">
            <xsl:choose>
                <xsl:when test="ownedComment/body[xoev:clean-text(.) != '']">
                    <xsl:for-each select="ownedComment/body[xoev:clean-text(.) != '']">
                        <xsl:sort select="."/>
                        <xs:documentation>
                            <xsl:value-of select="xoev:clean-text(.)"/>
                        </xs:documentation>
                    </xsl:for-each>
                </xsl:when>
                <xsl:when test="uml:is-Property(.)">
                    <xsl:choose>
                        <xsl:when test="
                                not(uml:resolve-type(.)/xoev:isReferenceableByName(.)) and not(some $c in uml:resolve-type(.)/ownedComment/body
                                    satisfies xoev:clean-text(.) = '[nd]') and uml:resolve-type(.)/ownedComment/body[xoev:clean-text(.) != '']">
                            <xsl:for-each select="uml:resolve-type(.)/ownedComment/body[xoev:clean-text(.) != '']">
                                <xsl:sort select="."/>
                                <xs:documentation>
                                    <xsl:value-of select="xoev:clean-text(.)"/>
                                </xs:documentation>
                            </xsl:for-each>
                        </xsl:when>
                        <xsl:when test="uml:resolve-general(../generalization[xoev:xsdRestriction(.)])/ancestor::packagedElement[xoev:xsdXModel(.)]/@xmi:id != $xoev:my-xmodel/@xmi:id">

                            <xsl:variable name="genutztes-externes-modell" select="uml:resolve-general(../generalization[xoev:xsdRestriction(.)])/ancestor::packagedElement[xoev:xsdXModel(.)]"/>

                            <xsl:variable name="import-bezeichnung" select="$xoev:my-xmodel/packagedElement[uml:resolve-supplier(.)/@xmi:id = $genutztes-externes-modell/@xmi:id]/xoev:xsdXModelImport(.)/@bezeichnung"/>

                            <xsl:variable name="current-property" select="."/>

                            <xsl:variable name="basiseigenschaft" select="uml:resolve-general(../generalization[xoev:xsdRestriction(.)])/ownedAttribute[@name = $current-property/@name]"/>

                            <xs:documentation>Dokumentation aus <xsl:value-of select="$import-bezeichnung"/>:</xs:documentation>
                            <xsl:apply-templates select="$basiseigenschaft" mode="xoev:documentation"/>
                        </xsl:when>
                    </xsl:choose>
                </xsl:when>
            </xsl:choose>
        </xsl:if>
    </xsl:template>

    <xsl:template match="packagedElement" mode="xoev:unique-constraint">
        <xs:unique name="{@name}">
            <xsl:apply-templates select="." mode="xoev:annotation"/>
            <xs:selector xpath="{xoev:xsdUnique(.)/@selector}"/>
            <xsl:for-each select="xoev:xsdUnique(.)/fields">
                <xsl:sort select="."/>
                <xs:field xpath="{.}"/>
            </xsl:for-each>
        </xs:unique>
    </xsl:template>

    <xsl:template match="packagedElement" mode="xoev:key-constraint">
        <xs:key name="{@name}">
            <xsl:apply-templates select="." mode="xoev:annotation"/>
            <xs:selector xpath="{xoev:xsdKey(.)/@selector}"/>
            <xsl:for-each select="xoev:xsdKey(.)/fields">
                <xsl:sort select="."/>
                <xs:field xpath="{.}"/>
            </xsl:for-each>
        </xs:key>
    </xsl:template>

    <xsl:template match="packagedElement" mode="xoev:keyref-constraint">
        <xs:keyref name="{@name}" refer="{xoev:xsdKeyref(.)/@refer}">
            <xsl:apply-templates select="." mode="xoev:annotation"/>
            <xs:selector xpath="{xoev:xsdKeyref(.)/@selector}"/>
            <xsl:for-each select="xoev:xsdKeyref(.)/fields">
                <xsl:sort select="."/>
                <xs:field xpath="{.}"/>
            </xsl:for-each>
        </xs:keyref>
    </xsl:template>

</xsl:stylesheet>
